module Test.Data.Function where

import qualified Data.Function.HT.Private as FuncHT

import Test.QuickCheck (NonNegative(NonNegative), quickCheck)


nest :: (Eq a) => NonNegative Int -> (a -> a) -> a -> Bool
nest (NonNegative n) f x =
   FuncHT.nest n f x == FuncHT.nest1 n f x &&
   FuncHT.nest n f x == FuncHT.nest2 n f x

powerAssociative :: Eq a =>
   (a -> a -> a) -> a -> a -> NonNegative Integer -> Bool
powerAssociative op a0 a (NonNegative n) =
   FuncHT.powerAssociative op a0 a n == FuncHT.powerAssociativeList op a0 a n &&
   FuncHT.powerAssociative op a0 a n == FuncHT.powerAssociativeNaive op a0 a n


tests :: [(String, IO ())]
tests =
   ("nest",
      quickCheck (flip nest succ :: NonNegative Int -> Integer -> Bool)) :
   ("powerAssociative",
      quickCheck (powerAssociative (+) ::
         Integer -> Integer -> NonNegative Integer -> Bool)) :
   []
