{-# LANGUAGE ForeignFunctionInterface #-}

#include <bindings.dsl.h>
#include <nettle/salsa20.h>

module Bindings.Nettle.Cipher.Salsa20 where
#strict_import

#num SALSA20_BLOCK_SIZE
#num SALSA20_MIN_KEY_SIZE
#num SALSA20_MAX_KEY_SIZE
#num SALSA20_KEY_SIZE
#num SALSA20_IV_SIZE

#starttype struct salsa20_ctx
#stoptype

#ccall salsa20_set_key , Ptr <struct salsa20_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall salsa20_set_iv , Ptr <struct salsa20_ctx> -> Ptr CUChar -> IO ()
#ccall salsa20_crypt , Ptr <struct salsa20_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()
#ccall salsa20r12_crypt , Ptr <struct salsa20_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()

