<?php
//============================================================+
// File name   : unicode_data.php
// Begin       : 2008-01-01
// Last Update : 2008-07-21
// License     : GNU LGPL (http://www.gnu.org/copyleft/lesser.html)
// 	----------------------------------------------------------------------------
//  Copyright (C) 2002-2008  Nicola Asuni - Tecnick.com S.r.l.
//
// 	This program is free software: you can redistribute it and/or modify
// 	it under the terms of the GNU Lesser General Public License as published by
// 	the Free Software Foundation, either version 2.1 of the License, or
// 	(at your option) any later version.
//
// 	This program is distributed in the hope that it will be useful,
// 	but WITHOUT ANY WARRANTY; without even the implied warranty of
// 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// 	GNU Lesser General Public License for more details.
//
// 	You should have received a copy of the GNU Lesser General Public License
// 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// 	See LICENSE.TXT file for more information.
//  ----------------------------------------------------------------------------
//
// Description : Unicode Include file for TCPDF.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com s.r.l.
//               Via Della Pace, 11
//               09044 Quartucciu (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//============================================================+
// THANKS TO
// Efthimios Mavrogeorgiadis
// Saleh AlMatrafe

/**
 * Unicode Include file for TCPDF.
 * @author Nicola Asuni
 * @copyright 2004-2008 Nicola Asuni - Tecnick.com S.r.l (www.tecnick.com) Via Della Pace, 11 - 09044 - Quartucciu (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @package com.tecnick.tcpdf
 * @link http://www.tcpdf.org
 * @license http://www.gnu.org/copyleft/lesser.html LGPL
 * @since 2.1.000 (2008-01-08)
*/

/**
* Left-to-Right Mark
*/
define("K_LRM", 8206);
/**
* Right-to-Left Mark
*/
define("K_RLM", 8207);
/**
* Left-to-Right Embedding
*/
define("K_LRE", 8234);
/**
* Right-to-Left Embedding
*/
define("K_RLE", 8235);
/**
* Pop Directional Format
*/
define("K_PDF", 8236);
/**
* Left-to-Right Override
*/
define("K_LRO", 8237);
/**
* Right-to-Left Override
*/
define("K_RLO", 8238);

/*
 * Pattern to test RTL (Righ-To-Left) strings using regular expressions.
 */
if (!defined("K_RE_PATTERN_RTL"))
define("K_RE_PATTERN_RTL", "/(
	  \xD6\xBE																							# R
	| \xD7[\x80\x83\x86\x90-\xAA\xB0-\xB4]									# R
	| \xDF[\x80-\xAA\xB4\xB5\xBA]														# R
	| \xE2\x80\x8F																					# R
	| \xEF\xAC[\x9D\x9F\xA0-\xA8\xAA-\xB6\xB8-\xBC\xBE]			# R
	| \xEF\xAD[\x80\x81\x83\x84\x86-\x8F]										# R
	| \xF0\x90\xA0[\x80-\x85\x88\x8A-\xB5\xB7\xB8\xBC\xBF]	# R
	| \xF0\x90\xA4[\x80-\x99]																# R
	| \xF0\x90\xA8[\x80\x90-\x93\x95-\x97\x99-\xB3]					# R
	| \xF0\x90\xA9[\x80-\x87\x90-\x98]											# R
	| \xE2\x80[\xAB\xAE]																		# RLE & RLO
	)/x");
/*
 * Pattern to test Arabic strings using regular expressions.
 * source: http://www.w3.org/International/questions/qa-forms-utf-8
 */
if (!defined("K_RE_PATTERN_ARABIC"))
define("K_RE_PATTERN_ARABIC", "/(
			  \xD8[\x80-\x83\x8B\x8D\x9B\x9E\x9F\xA1-\xBA]	# AL
			| \xD9[\x80-\x8A\xAD-\xAF\xB1-\xBF]							# AL
			| \xDA[\x80-\xBF]																# AL
			| \xDB[\x80-\x95\x9D\xA5\xA6\xAE\xAF\xBA-\xBF]	# AL
			| \xDC[\x80-\x8D\x90\x92-\xAF]									# AL
			| \xDD[\x8D-\xAD]																# AL
			| \xDE[\x80-\xA5\xB1]														# AL
			| \xEF\xAD[\x90-\xBF]														# AL
			| \xEF\xAE[\x80-\xB1]														# AL
			| \xEF\xAF[\x93-\xBF]														# AL
			| \xEF[\xB0-\xB3][\x80-\xBF]										# AL
			| \xEF\xB4[\x80-\xBD]														# AL
			| \xEF\xB5[\x90-\xBF]														# AL
			| \xEF\xB6[\x80-\x8F\x92-\xBF]									# AL
			| \xEF\xB7[\x80-\x87\xB0-\xBC]									# AL
			| \xEF\xB9[\xB0-\xB4\xB6-\xBF]									# AL
			| \xEF\xBA[\x80-\xBF]														# AL
			| \xEF\xBB[\x80-\xBC]														# AL
			| \xD9[\xA0-\xA9\xAB\xAC]												# AN
			)/x");
/**
 * Array of unicode types
 */
$unicode = array(
	0			=>	'BN',
	1			=>	'BN',
	2			=>	'BN',
	3			=>	'BN',
	4			=>	'BN',
	5			=>	'BN',
	6			=>	'BN',
	7			=>	'BN',
	8			=>	'BN',
	9			=>	'S',
	10		=>	'B',
	11		=>	'S',
	12		=>	'WS',
	13		=>	'B',
	14		=>	'BN',
	15		=>	'BN',
	16		=>	'BN',
	17		=>	'BN',
	18		=>	'BN',
	19		=>	'BN',
	20		=>	'BN',
	21		=>	'BN',
	22		=>	'BN',
	23		=>	'BN',
	24		=>	'BN',
	25		=>	'BN',
	26		=>	'BN',
	27		=>	'BN',
	28		=>	'B',
	29		=>	'B',
	30		=>	'B',
	31		=>	'S',
	32		=>	'WS',
	33		=>	'ON',
	34		=>	'ON',
	35		=>	'ET',
	36		=>	'ET',
	37		=>	'ET',
	38		=>	'ON',
	39		=>	'ON',
	40		=>	'ON',
	41		=>	'ON',
	42		=>	'ON',
	43		=>	'ES',
	44		=>	'CS',
	45		=>	'ES',
	46		=>	'CS',
	47		=>	'CS',
	48		=>	'EN',
	49		=>	'EN',
	50		=>	'EN',
	51		=>	'EN',
	52		=>	'EN',
	53		=>	'EN',
	54		=>	'EN',
	55		=>	'EN',
	56		=>	'EN',
	57		=>	'EN',
	58		=>	'CS',
	59		=>	'ON',
	60		=>	'ON',
	61		=>	'ON',
	62		=>	'ON',
	63		=>	'ON',
	64		=>	'ON',
	65		=>	'L',
	66		=>	'L',
	67		=>	'L',
	68		=>	'L',
	69		=>	'L',
	70		=>	'L',
	71		=>	'L',
	72		=>	'L',
	73		=>	'L',
	74		=>	'L',
	75		=>	'L',
	76		=>	'L',
	77		=>	'L',
	78		=>	'L',
	79		=>	'L',
	80		=>	'L',
	81		=>	'L',
	82		=>	'L',
	83		=>	'L',
	84		=>	'L',
	85		=>	'L',
	86		=>	'L',
	87		=>	'L',
	88		=>	'L',
	89		=>	'L',
	90		=>	'L',
	91		=>	'ON',
	92		=>	'ON',
	93		=>	'ON',
	94		=>	'ON',
	95		=>	'ON',
	96		=>	'ON',
	97		=>	'L',
	98		=>	'L',
	99		=>	'L',
	100		=>	'L',
	101		=>	'L',
	102		=>	'L',
	103		=>	'L',
	104		=>	'L',
	105		=>	'L',
	106		=>	'L',
	107		=>	'L',
	108		=>	'L',
	109		=>	'L',
	110		=>	'L',
	111		=>	'L',
	112		=>	'L',
	113		=>	'L',
	114		=>	'L',
	115		=>	'L',
	116		=>	'L',
	117		=>	'L',
	118		=>	'L',
	119		=>	'L',
	120		=>	'L',
	121		=>	'L',
	122		=>	'L',
	123		=>	'ON',
	124		=>	'ON',
	125		=>	'ON',
	126		=>	'ON',
	127		=>	'BN',
	128		=>	'BN',
	129		=>	'BN',
	130		=>	'BN',
	131		=>	'BN',
	132		=>	'BN',
	133		=>	'B',
	134		=>	'BN',
	135		=>	'BN',
	136		=>	'BN',
	137		=>	'BN',
	138		=>	'BN',
	139		=>	'BN',
	140		=>	'BN',
	141		=>	'BN',
	142		=>	'BN',
	143		=>	'BN',
	144		=>	'BN',
	145		=>	'BN',
	146		=>	'BN',
	147		=>	'BN',
	148		=>	'BN',
	149		=>	'BN',
	150		=>	'BN',
	151		=>	'BN',
	152		=>	'BN',
	153		=>	'BN',
	154		=>	'BN',
	155		=>	'BN',
	156		=>	'BN',
	157		=>	'BN',
	158		=>	'BN',
	159		=>	'BN',
	160		=>	'CS',
	161		=>	'ON',
	162		=>	'ET',
	163		=>	'ET',
	164		=>	'ET',
	165		=>	'ET',
	166		=>	'ON',
	167		=>	'ON',
	168		=>	'ON',
	169		=>	'ON',
	170		=>	'L',
	171		=>	'ON',
	172		=>	'ON',
	173		=>	'BN',
	174		=>	'ON',
	175		=>	'ON',
	176		=>	'ET',
	177		=>	'ET',
	178		=>	'EN',
	179		=>	'EN',
	180		=>	'ON',
	181		=>	'L',
	182		=>	'ON',
	183		=>	'ON',
	184		=>	'ON',
	185		=>	'EN',
	186		=>	'L',
	187		=>	'ON',
	188		=>	'ON',
	189		=>	'ON',
	190		=>	'ON',
	191		=>	'ON',
	192		=>	'L',
	193		=>	'L',
	194		=>	'L',
	195		=>	'L',
	196		=>	'L',
	197		=>	'L',
	198		=>	'L',
	199		=>	'L',
	200		=>	'L',
	201		=>	'L',
	202		=>	'L',
	203		=>	'L',
	204		=>	'L',
	205		=>	'L',
	206		=>	'L',
	207		=>	'L',
	208		=>	'L',
	209		=>	'L',
	210		=>	'L',
	211		=>	'L',
	212		=>	'L',
	213		=>	'L',
	214		=>	'L',
	215		=>	'ON',
	216		=>	'L',
	217		=>	'L',
	218		=>	'L',
	219		=>	'L',
	220		=>	'L',
	221		=>	'L',
	222		=>	'L',
	223		=>	'L',
	224		=>	'L',
	225		=>	'L',
	226		=>	'L',
	227		=>	'L',
	228		=>	'L',
	229		=>	'L',
	230		=>	'L',
	231		=>	'L',
	232		=>	'L',
	233		=>	'L',
	234		=>	'L',
	235		=>	'L',
	236		=>	'L',
	237		=>	'L',
	238		=>	'L',
	239		=>	'L',
	240		=>	'L',
	241		=>	'L',
	242		=>	'L',
	243		=>	'L',
	244		=>	'L',
	245		=>	'L',
	246		=>	'L',
	247		=>	'ON',
	248		=>	'L',
	249		=>	'L',
	250		=>	'L',
	251		=>	'L',
	252		=>	'L',
	253		=>	'L',
	254		=>	'L',
	255		=>	'L',
	256		=>	'L',
	257		=>	'L',
	258		=>	'L',
	259		=>	'L',
	260		=>	'L',
	261		=>	'L',
	262		=>	'L',
	263		=>	'L',
	264		=>	'L',
	265		=>	'L',
	266		=>	'L',
	267		=>	'L',
	268		=>	'L',
	269		=>	'L',
	270		=>	'L',
	271		=>	'L',
	272		=>	'L',
	273		=>	'L',
	274		=>	'L',
	275		=>	'L',
	276		=>	'L',
	277		=>	'L',
	278		=>	'L',
	279		=>	'L',
	280		=>	'L',
	281		=>	'L',
	282		=>	'L',
	283		=>	'L',
	284		=>	'L',
	285		=>	'L',
	286		=>	'L',
	287		=>	'L',
	288		=>	'L',
	289		=>	'L',
	290		=>	'L',
	291		=>	'L',
	292		=>	'L',
	293		=>	'L',
	294		=>	'L',
	295		=>	'L',
	296		=>	'L',
	297		=>	'L',
	298		=>	'L',
	299		=>	'L',
	300		=>	'L',
	301		=>	'L',
	302		=>	'L',
	303		=>	'L',
	304		=>	'L',
	305		=>	'L',
	306		=>	'L',
	307		=>	'L',
	308		=>	'L',
	309		=>	'L',
	310		=>	'L',
	311		=>	'L',
	312		=>	'L',
	313		=>	'L',
	314		=>	'L',
	315		=>	'L',
	316		=>	'L',
	317		=>	'L',
	318		=>	'L',
	319		=>	'L',
	320		=>	'L',
	321		=>	'L',
	322		=>	'L',
	323		=>	'L',
	324		=>	'L',
	325		=>	'L',
	326		=>	'L',
	327		=>	'L',
	328		=>	'L',
	329		=>	'L',
	330		=>	'L',
	331		=>	'L',
	332		=>	'L',
	333		=>	'L',
	334		=>	'L',
	335		=>	'L',
	336		=>	'L',
	337		=>	'L',
	338		=>	'L',
	339		=>	'L',
	340		=>	'L',
	341		=>	'L',
	342		=>	'L',
	343		=>	'L',
	344		=>	'L',
	345		=>	'L',
	346		=>	'L',
	347		=>	'L',
	348		=>	'L',
	349		=>	'L',
	350		=>	'L',
	351		=>	'L',
	352		=>	'L',
	353		=>	'L',
	354		=>	'L',
	355		=>	'L',
	356		=>	'L',
	357		=>	'L',
	358		=>	'L',
	359		=>	'L',
	360		=>	'L',
	361		=>	'L',
	362		=>	'L',
	363		=>	'L',
	364		=>	'L',
	365		=>	'L',
	366		=>	'L',
	367		=>	'L',
	368		=>	'L',
	369		=>	'L',
	370		=>	'L',
	371		=>	'L',
	372		=>	'L',
	373		=>	'L',
	374		=>	'L',
	375		=>	'L',
	376		=>	'L',
	377		=>	'L',
	378		=>	'L',
	379		=>	'L',
	380		=>	'L',
	381		=>	'L',
	382		=>	'L',
	383		=>	'L',
	384		=>	'L',
	385		=>	'L',
	386		=>	'L',
	387		=>	'L',
	388		=>	'L',
	389		=>	'L',
	390		=>	'L',
	391		=>	'L',
	392		=>	'L',
	393		=>	'L',
	394		=>	'L',
	395		=>	'L',
	396		=>	'L',
	397		=>	'L',
	398		=>	'L',
	399		=>	'L',
	400		=>	'L',
	401		=>	'L',
	402		=>	'L',
	403		=>	'L',
	404		=>	'L',
	405		=>	'L',
	406		=>	'L',
	407		=>	'L',
	408		=>	'L',
	409		=>	'L',
	410		=>	'L',
	411		=>	'L',
	412		=>	'L',
	413		=>	'L',
	414		=>	'L',
	415		=>	'L',
	416		=>	'L',
	417		=>	'L',
	418		=>	'L',
	419		=>	'L',
	420		=>	'L',
	421		=>	'L',
	422		=>	'L',
	423		=>	'L',
	424		=>	'L',
	425		=>	'L',
	426		=>	'L',
	427		=>	'L',
	428		=>	'L',
	429		=>	'L',
	430		=>	'L',
	431		=>	'L',
	432		=>	'L',
	433		=>	'L',
	434		=>	'L',
	435		=>	'L',
	436		=>	'L',
	437		=>	'L',
	438		=>	'L',
	439		=>	'L',
	440		=>	'L',
	441		=>	'L',
	442		=>	'L',
	443		=>	'L',
	444		=>	'L',
	445		=>	'L',
	446		=>	'L',
	447		=>	'L',
	448		=>	'L',
	449		=>	'L',
	450		=>	'L',
	451		=>	'L',
	452		=>	'L',
	453		=>	'L',
	454		=>	'L',
	455		=>	'L',
	456		=>	'L',
	457		=>	'L',
	458		=>	'L',
	459		=>	'L',
	460		=>	'L',
	461		=>	'L',
	462		=>	'L',
	463		=>	'L',
	464		=>	'L',
	465		=>	'L',
	466		=>	'L',
	467		=>	'L',
	468		=>	'L',
	469		=>	'L',
	470		=>	'L',
	471		=>	'L',
	472		=>	'L',
	473		=>	'L',
	474		=>	'L',
	475		=>	'L',
	476		=>	'L',
	477		=>	'L',
	478		=>	'L',
	479		=>	'L',
	480		=>	'L',
	481		=>	'L',
	482		=>	'L',
	483		=>	'L',
	484		=>	'L',
	485		=>	'L',
	486		=>	'L',
	487		=>	'L',
	488		=>	'L',
	489		=>	'L',
	490		=>	'L',
	491		=>	'L',
	492		=>	'L',
	493		=>	'L',
	494		=>	'L',
	495		=>	'L',
	496		=>	'L',
	497		=>	'L',
	498		=>	'L',
	499		=>	'L',
	500		=>	'L',
	501		=>	'L',
	502		=>	'L',
	503		=>	'L',
	504		=>	'L',
	505		=>	'L',
	506		=>	'L',
	507		=>	'L',
	508		=>	'L',
	509		=>	'L',
	510		=>	'L',
	511		=>	'L',
	512		=>	'L',
	513		=>	'L',
	514		=>	'L',
	515		=>	'L',
	516		=>	'L',
	517		=>	'L',
	518		=>	'L',
	519		=>	'L',
	520		=>	'L',
	521		=>	'L',
	522		=>	'L',
	523		=>	'L',
	524		=>	'L',
	525		=>	'L',
	526		=>	'L',
	527		=>	'L',
	528		=>	'L',
	529		=>	'L',
	530		=>	'L',
	531		=>	'L',
	532		=>	'L',
	533		=>	'L',
	534		=>	'L',
	535		=>	'L',
	536		=>	'L',
	537		=>	'L',
	538		=>	'L',
	539		=>	'L',
	540		=>	'L',
	541		=>	'L',
	542		=>	'L',
	543		=>	'L',
	544		=>	'L',
	545		=>	'L',
	546		=>	'L',
	547		=>	'L',
	548		=>	'L',
	549		=>	'L',
	550		=>	'L',
	551		=>	'L',
	552		=>	'L',
	553		=>	'L',
	554		=>	'L',
	555		=>	'L',
	556		=>	'L',
	557		=>	'L',
	558		=>	'L',
	559		=>	'L',
	560		=>	'L',
	561		=>	'L',
	562		=>	'L',
	563		=>	'L',
	564		=>	'L',
	565		=>	'L',
	566		=>	'L',
	567		=>	'L',
	568		=>	'L',
	569		=>	'L',
	570		=>	'L',
	571		=>	'L',
	572		=>	'L',
	573		=>	'L',
	574		=>	'L',
	575		=>	'L',
	576		=>	'L',
	577		=>	'L',
	578		=>	'L',
	579		=>	'L',
	580		=>	'L',
	581		=>	'L',
	582		=>	'L',
	583		=>	'L',
	584		=>	'L',
	585		=>	'L',
	586		=>	'L',
	587		=>	'L',
	588		=>	'L',
	589		=>	'L',
	590		=>	'L',
	591		=>	'L',
	592		=>	'L',
	593		=>	'L',
	594		=>	'L',
	595		=>	'L',
	596		=>	'L',
	597		=>	'L',
	598		=>	'L',
	599		=>	'L',
	600		=>	'L',
	601		=>	'L',
	602		=>	'L',
	603		=>	'L',
	604		=>	'L',
	605		=>	'L',
	606		=>	'L',
	607		=>	'L',
	608		=>	'L',
	609		=>	'L',
	610		=>	'L',
	611		=>	'L',
	612		=>	'L',
	613		=>	'L',
	614		=>	'L',
	615		=>	'L',
	616		=>	'L',
	617		=>	'L',
	618		=>	'L',
	619		=>	'L',
	620		=>	'L',
	621		=>	'L',
	622		=>	'L',
	623		=>	'L',
	624		=>	'L',
	625		=>	'L',
	626		=>	'L',
	627		=>	'L',
	628		=>	'L',
	629		=>	'L',
	630		=>	'L',
	631		=>	'L',
	632		=>	'L',
	633		=>	'L',
	634		=>	'L',
	635		=>	'L',
	636		=>	'L',
	637		=>	'L',
	638		=>	'L',
	639		=>	'L',
	640		=>	'L',
	641		=>	'L',
	642		=>	'L',
	643		=>	'L',
	644		=>	'L',
	645		=>	'L',
	646		=>	'L',
	647		=>	'L',
	648		=>	'L',
	649		=>	'L',
	650		=>	'L',
	651		=>	'L',
	652		=>	'L',
	653		=>	'L',
	654		=>	'L',
	655		=>	'L',
	656		=>	'L',
	657		=>	'L',
	658		=>	'L',
	659		=>	'L',
	660		=>	'L',
	661		=>	'L',
	662		=>	'L',
	663		=>	'L',
	664		=>	'L',
	665		=>	'L',
	666		=>	'L',
	667		=>	'L',
	668		=>	'L',
	669		=>	'L',
	670		=>	'L',
	671		=>	'L',
	672		=>	'L',
	673		=>	'L',
	674		=>	'L',
	675		=>	'L',
	676		=>	'L',
	677		=>	'L',
	678		=>	'L',
	679		=>	'L',
	680		=>	'L',
	681		=>	'L',
	682		=>	'L',
	683		=>	'L',
	684		=>	'L',
	685		=>	'L',
	686		=>	'L',
	687		=>	'L',
	688		=>	'L',
	689		=>	'L',
	690		=>	'L',
	691		=>	'L',
	692		=>	'L',
	693		=>	'L',
	694		=>	'L',
	695		=>	'L',
	696		=>	'L',
	697		=>	'ON',
	698		=>	'ON',
	699		=>	'L',
	700		=>	'L',
	701		=>	'L',
	702		=>	'L',
	703		=>	'L',
	704		=>	'L',
	705		=>	'L',
	706		=>	'ON',
	707		=>	'ON',
	708		=>	'ON',
	709		=>	'ON',
	710		=>	'ON',
	711		=>	'ON',
	712		=>	'ON',
	713		=>	'ON',
	714		=>	'ON',
	715		=>	'ON',
	716		=>	'ON',
	717		=>	'ON',
	718		=>	'ON',
	719		=>	'ON',
	720		=>	'L',
	721		=>	'L',
	722		=>	'ON',
	723		=>	'ON',
	724		=>	'ON',
	725		=>	'ON',
	726		=>	'ON',
	727		=>	'ON',
	728		=>	'ON',
	729		=>	'ON',
	730		=>	'ON',
	731		=>	'ON',
	732		=>	'ON',
	733		=>	'ON',
	734		=>	'ON',
	735		=>	'ON',
	736		=>	'L',
	737		=>	'L',
	738		=>	'L',
	739		=>	'L',
	740		=>	'L',
	741		=>	'ON',
	742		=>	'ON',
	743		=>	'ON',
	744		=>	'ON',
	745		=>	'ON',
	746		=>	'ON',
	747		=>	'ON',
	748		=>	'ON',
	749		=>	'ON',
	750		=>	'L',
	751		=>	'ON',
	752		=>	'ON',
	753		=>	'ON',
	754		=>	'ON',
	755		=>	'ON',
	756		=>	'ON',
	757		=>	'ON',
	758		=>	'ON',
	759		=>	'ON',
	760		=>	'ON',
	761		=>	'ON',
	762		=>	'ON',
	763		=>	'ON',
	764		=>	'ON',
	765		=>	'ON',
	766		=>	'ON',
	767		=>	'ON',
	768		=>	'NSM',
	769		=>	'NSM',
	770		=>	'NSM',
	771		=>	'NSM',
	772		=>	'NSM',
	773		=>	'NSM',
	774		=>	'NSM',
	775		=>	'NSM',
	776		=>	'NSM',
	777		=>	'NSM',
	778		=>	'NSM',
	779		=>	'NSM',
	780		=>	'NSM',
	781		=>	'NSM',
	782		=>	'NSM',
	783		=>	'NSM',
	784		=>	'NSM',
	785		=>	'NSM',
	786		=>	'NSM',
	787		=>	'NSM',
	788		=>	'NSM',
	789		=>	'NSM',
	790		=>	'NSM',
	791		=>	'NSM',
	792		=>	'NSM',
	793		=>	'NSM',
	794		=>	'NSM',
	795		=>	'NSM',
	796		=>	'NSM',
	797		=>	'NSM',
	798		=>	'NSM',
	799		=>	'NSM',
	800		=>	'NSM',
	801		=>	'NSM',
	802		=>	'NSM',
	803		=>	'NSM',
	804		=>	'NSM',
	805		=>	'NSM',
	806		=>	'NSM',
	807		=>	'NSM',
	808		=>	'NSM',
	809		=>	'NSM',
	810		=>	'NSM',
	811		=>	'NSM',
	812		=>	'NSM',
	813		=>	'NSM',
	814		=>	'NSM',
	815		=>	'NSM',
	816		=>	'NSM',
	817		=>	'NSM',
	818		=>	'NSM',
	819		=>	'NSM',
	820		=>	'NSM',
	821		=>	'NSM',
	822		=>	'NSM',
	823		=>	'NSM',
	824		=>	'NSM',
	825		=>	'NSM',
	826		=>	'NSM',
	827		=>	'NSM',
	828		=>	'NSM',
	829		=>	'NSM',
	830		=>	'NSM',
	831		=>	'NSM',
	832		=>	'NSM',
	833		=>	'NSM',
	834		=>	'NSM',
	835		=>	'NSM',
	836		=>	'NSM',
	837		=>	'NSM',
	838		=>	'NSM',
	839		=>	'NSM',
	840		=>	'NSM',
	841		=>	'NSM',
	842		=>	'NSM',
	843		=>	'NSM',
	844		=>	'NSM',
	845		=>	'NSM',
	846		=>	'NSM',
	847		=>	'NSM',
	848		=>	'NSM',
	849		=>	'NSM',
	850		=>	'NSM',
	851		=>	'NSM',
	852		=>	'NSM',
	853		=>	'NSM',
	854		=>	'NSM',
	855		=>	'NSM',
	856		=>	'NSM',
	857		=>	'NSM',
	858		=>	'NSM',
	859		=>	'NSM',
	860		=>	'NSM',
	861		=>	'NSM',
	862		=>	'NSM',
	863		=>	'NSM',
	864		=>	'NSM',
	865		=>	'NSM',
	866		=>	'NSM',
	867		=>	'NSM',
	868		=>	'NSM',
	869		=>	'NSM',
	870		=>	'NSM',
	871		=>	'NSM',
	872		=>	'NSM',
	873		=>	'NSM',
	874		=>	'NSM',
	875		=>	'NSM',
	876		=>	'NSM',
	877		=>	'NSM',
	878		=>	'NSM',
	879		=>	'NSM',
	884		=>	'ON',
	885		=>	'ON',
	890		=>	'L',
	891		=>	'L',
	892		=>	'L',
	893		=>	'L',
	894		=>	'ON',
	900		=>	'ON',
	901		=>	'ON',
	902		=>	'L',
	903		=>	'ON',
	904		=>	'L',
	905		=>	'L',
	906		=>	'L',
	908		=>	'L',
	910		=>	'L',
	911		=>	'L',
	912		=>	'L',
	913		=>	'L',
	914		=>	'L',
	915		=>	'L',
	916		=>	'L',
	917		=>	'L',
	918		=>	'L',
	919		=>	'L',
	920		=>	'L',
	921		=>	'L',
	922		=>	'L',
	923		=>	'L',
	924		=>	'L',
	925		=>	'L',
	926		=>	'L',
	927		=>	'L',
	928		=>	'L',
	929		=>	'L',
	931		=>	'L',
	932		=>	'L',
	933		=>	'L',
	934		=>	'L',
	935		=>	'L',
	936		=>	'L',
	937		=>	'L',
	938		=>	'L',
	939		=>	'L',
	940		=>	'L',
	941		=>	'L',
	942		=>	'L',
	943		=>	'L',
	944		=>	'L',
	945		=>	'L',
	946		=>	'L',
	947		=>	'L',
	948		=>	'L',
	949		=>	'L',
	950		=>	'L',
	951		=>	'L',
	952		=>	'L',
	953		=>	'L',
	954		=>	'L',
	955		=>	'L',
	956		=>	'L',
	957		=>	'L',
	958		=>	'L',
	959		=>	'L',
	960		=>	'L',
	961		=>	'L',
	962		=>	'L',
	963		=>	'L',
	964		=>	'L',
	965		=>	'L',
	966		=>	'L',
	967		=>	'L',
	968		=>	'L',
	969		=>	'L',
	970		=>	'L',
	971		=>	'L',
	972		=>	'L',
	973		=>	'L',
	974		=>	'L',
	976		=>	'L',
	977		=>	'L',
	978		=>	'L',
	979		=>	'L',
	980		=>	'L',
	981		=>	'L',
	982		=>	'L',
	983		=>	'L',
	984		=>	'L',
	985		=>	'L',
	986		=>	'L',
	987		=>	'L',
	988		=>	'L',
	989		=>	'L',
	990		=>	'L',
	991		=>	'L',
	992		=>	'L',
	993		=>	'L',
	994		=>	'L',
	995		=>	'L',
	996		=>	'L',
	997		=>	'L',
	998		=>	'L',
	999		=>	'L',
	1000		=>	'L',
	1001		=>	'L',
	1002		=>	'L',
	1003		=>	'L',
	1004		=>	'L',
	1005		=>	'L',
	1006		=>	'L',
	1007		=>	'L',
	1008		=>	'L',
	1009		=>	'L',
	1010		=>	'L',
	1011		=>	'L',
	1012		=>	'L',
	1013		=>	'L',
	1014		=>	'ON',
	1015		=>	'L',
	1016		=>	'L',
	1017		=>	'L',
	1018		=>	'L',
	1019		=>	'L',
	1020		=>	'L',
	1021		=>	'L',
	1022		=>	'L',
	1023		=>	'L',
	1024		=>	'L',
	1025		=>	'L',
	1026		=>	'L',
	1027		=>	'L',
	1028		=>	'L',
	1029		=>	'L',
	1030		=>	'L',
	1031		=>	'L',
	1032		=>	'L',
	1033		=>	'L',
	1034		=>	'L',
	1035		=>	'L',
	1036		=>	'L',
	1037		=>	'L',
	1038		=>	'L',
	1039		=>	'L',
	1040		=>	'L',
	1041		=>	'L',
	1042		=>	'L',
	1043		=>	'L',
	1044		=>	'L',
	1045		=>	'L',
	1046		=>	'L',
	1047		=>	'L',
	1048		=>	'L',
	1049		=>	'L',
	1050		=>	'L',
	1051		=>	'L',
	1052		=>	'L',
	1053		=>	'L',
	1054		=>	'L',
	1055		=>	'L',
	1056		=>	'L',
	1057		=>	'L',
	1058		=>	'L',
	1059		=>	'L',
	1060		=>	'L',
	1061		=>	'L',
	1062		=>	'L',
	1063		=>	'L',
	1064		=>	'L',
	1065		=>	'L',
	1066		=>	'L',
	1067		=>	'L',
	1068		=>	'L',
	1069		=>	'L',
	1070		=>	'L',
	1071		=>	'L',
	1072		=>	'L',
	1073		=>	'L',
	1074		=>	'L',
	1075		=>	'L',
	1076		=>	'L',
	1077		=>	'L',
	1078		=>	'L',
	1079		=>	'L',
	1080		=>	'L',
	1081		=>	'L',
	1082		=>	'L',
	1083		=>	'L',
	1084		=>	'L',
	1085		=>	'L',
	1086		=>	'L',
	1087		=>	'L',
	1088		=>	'L',
	1089		=>	'L',
	1090		=>	'L',
	1091		=>	'L',
	1092		=>	'L',
	1093		=>	'L',
	1094		=>	'L',
	1095		=>	'L',
	1096		=>	'L',
	1097		=>	'L',
	1098		=>	'L',
	1099		=>	'L',
	1100		=>	'L',
	1101		=>	'L',
	1102		=>	'L',
	1103		=>	'L',
	1104		=>	'L',
	1105		=>	'L',
	1106		=>	'L',
	1107		=>	'L',
	1108		=>	'L',
	1109		=>	'L',
	1110		=>	'L',
	1111		=>	'L',
	1112		=>	'L',
	1113		=>	'L',
	1114		=>	'L',
	1115		=>	'L',
	1116		=>	'L',
	1117		=>	'L',
	1118		=>	'L',
	1119		=>	'L',
	1120		=>	'L',
	1121		=>	'L',
	1122		=>	'L',
	1123		=>	'L',
	1124		=>	'L',
	1125		=>	'L',
	1126		=>	'L',
	1127		=>	'L',
	1128		=>	'L',
	1129		=>	'L',
	1130		=>	'L',
	1131		=>	'L',
	1132		=>	'L',
	1133		=>	'L',
	1134		=>	'L',
	1135		=>	'L',
	1136		=>	'L',
	1137		=>	'L',
	1138		=>	'L',
	1139		=>	'L',
	1140		=>	'L',
	1141		=>	'L',
	1142		=>	'L',
	1143		=>	'L',
	1144		=>	'L',
	1145		=>	'L',
	1146		=>	'L',
	1147		=>	'L',
	1148		=>	'L',
	1149		=>	'L',
	1150		=>	'L',
	1151		=>	'L',
	1152		=>	'L',
	1153		=>	'L',
	1154		=>	'L',
	1155		=>	'NSM',
	1156		=>	'NSM',
	1157		=>	'NSM',
	1158		=>	'NSM',
	1160		=>	'NSM',
	1161		=>	'NSM',
	1162		=>	'L',
	1163		=>	'L',
	1164		=>	'L',
	1165		=>	'L',
	1166		=>	'L',
	1167		=>	'L',
	1168		=>	'L',
	1169		=>	'L',
	1170		=>	'L',
	1171		=>	'L',
	1172		=>	'L',
	1173		=>	'L',
	1174		=>	'L',
	1175		=>	'L',
	1176		=>	'L',
	1177		=>	'L',
	1178		=>	'L',
	1179		=>	'L',
	1180		=>	'L',
	1181		=>	'L',
	1182		=>	'L',
	1183		=>	'L',
	1184		=>	'L',
	1185		=>	'L',
	1186		=>	'L',
	1187		=>	'L',
	1188		=>	'L',
	1189		=>	'L',
	1190		=>	'L',
	1191		=>	'L',
	1192		=>	'L',
	1193		=>	'L',
	1194		=>	'L',
	1195		=>	'L',
	1196		=>	'L',
	1197		=>	'L',
	1198		=>	'L',
	1199		=>	'L',
	1200		=>	'L',
	1201		=>	'L',
	1202		=>	'L',
	1203		=>	'L',
	1204		=>	'L',
	1205		=>	'L',
	1206		=>	'L',
	1207		=>	'L',
	1208		=>	'L',
	1209		=>	'L',
	1210		=>	'L',
	1211		=>	'L',
	1212		=>	'L',
	1213		=>	'L',
	1214		=>	'L',
	1215		=>	'L',
	1216		=>	'L',
	1217		=>	'L',
	1218		=>	'L',
	1219		=>	'L',
	1220		=>	'L',
	1221		=>	'L',
	1222		=>	'L',
	1223		=>	'L',
	1224		=>	'L',
	1225		=>	'L',
	1226		=>	'L',
	1227		=>	'L',
	1228		=>	'L',
	1229		=>	'L',
	1230		=>	'L',
	1231		=>	'L',
	1232		=>	'L',
	1233		=>	'L',
	1234		=>	'L',
	1235		=>	'L',
	1236		=>	'L',
	1237		=>	'L',
	1238		=>	'L',
	1239		=>	'L',
	1240		=>	'L',
	1241		=>	'L',
	1242		=>	'L',
	1243		=>	'L',
	1244		=>	'L',
	1245		=>	'L',
	1246		=>	'L',
	1247		=>	'L',
	1248		=>	'L',
	1249		=>	'L',
	1250		=>	'L',
	1251		=>	'L',
	1252		=>	'L',
	1253		=>	'L',
	1254		=>	'L',
	1255		=>	'L',
	1256		=>	'L',
	1257		=>	'L',
	1258		=>	'L',
	1259		=>	'L',
	1260		=>	'L',
	1261		=>	'L',
	1262		=>	'L',
	1263		=>	'L',
	1264		=>	'L',
	1265		=>	'L',
	1266		=>	'L',
	1267		=>	'L',
	1268		=>	'L',
	1269		=>	'L',
	1270		=>	'L',
	1271		=>	'L',
	1272		=>	'L',
	1273		=>	'L',
	1274		=>	'L',
	1275		=>	'L',
	1276		=>	'L',
	1277		=>	'L',
	1278		=>	'L',
	1279		=>	'L',
	1280		=>	'L',
	1281		=>	'L',
	1282		=>	'L',
	1283		=>	'L',
	1284		=>	'L',
	1285		=>	'L',
	1286		=>	'L',
	1287		=>	'L',
	1288		=>	'L',
	1289		=>	'L',
	1290		=>	'L',
	1291		=>	'L',
	1292		=>	'L',
	1293		=>	'L',
	1294		=>	'L',
	1295		=>	'L',
	1296		=>	'L',
	1297		=>	'L',
	1298		=>	'L',
	1299		=>	'L',
	1329		=>	'L',
	1330		=>	'L',
	1331		=>	'L',
	1332		=>	'L',
	1333		=>	'L',
	1334		=>	'L',
	1335		=>	'L',
	1336		=>	'L',
	1337		=>	'L',
	1338		=>	'L',
	1339		=>	'L',
	1340		=>	'L',
	1341		=>	'L',
	1342		=>	'L',
	1343		=>	'L',
	1344		=>	'L',
	1345		=>	'L',
	1346		=>	'L',
	1347		=>	'L',
	1348		=>	'L',
	1349		=>	'L',
	1350		=>	'L',
	1351		=>	'L',
	1352		=>	'L',
	1353		=>	'L',
	1354		=>	'L',
	1355		=>	'L',
	1356		=>	'L',
	1357		=>	'L',
	1358		=>	'L',
	1359		=>	'L',
	1360		=>	'L',
	1361		=>	'L',
	1362		=>	'L',
	1363		=>	'L',
	1364		=>	'L',
	1365		=>	'L',
	1366		=>	'L',
	1369		=>	'L',
	1370		=>	'L',
	1371		=>	'L',
	1372		=>	'L',
	1373		=>	'L',
	1374		=>	'L',
	1375		=>	'L',
	1377		=>	'L',
	1378		=>	'L',
	1379		=>	'L',
	1380		=>	'L',
	1381		=>	'L',
	1382		=>	'L',
	1383		=>	'L',
	1384		=>	'L',
	1385		=>	'L',
	1386		=>	'L',
	1387		=>	'L',
	1388		=>	'L',
	1389		=>	'L',
	1390		=>	'L',
	1391		=>	'L',
	1392		=>	'L',
	1393		=>	'L',
	1394		=>	'L',
	1395		=>	'L',
	1396		=>	'L',
	1397		=>	'L',
	1398		=>	'L',
	1399		=>	'L',
	1400		=>	'L',
	1401		=>	'L',
	1402		=>	'L',
	1403		=>	'L',
	1404		=>	'L',
	1405		=>	'L',
	1406		=>	'L',
	1407		=>	'L',
	1408		=>	'L',
	1409		=>	'L',
	1410		=>	'L',
	1411		=>	'L',
	1412		=>	'L',
	1413		=>	'L',
	1414		=>	'L',
	1415		=>	'L',
	1417		=>	'L',
	1418		=>	'ON',
	1425		=>	'NSM',
	1426		=>	'NSM',
	1427		=>	'NSM',
	1428		=>	'NSM',
	1429		=>	'NSM',
	1430		=>	'NSM',
	1431		=>	'NSM',
	1432		=>	'NSM',
	1433		=>	'NSM',
	1434		=>	'NSM',
	1435		=>	'NSM',
	1436		=>	'NSM',
	1437		=>	'NSM',
	1438		=>	'NSM',
	1439		=>	'NSM',
	1440		=>	'NSM',
	1441		=>	'NSM',
	1442		=>	'NSM',
	1443		=>	'NSM',
	1444		=>	'NSM',
	1445		=>	'NSM',
	1446		=>	'NSM',
	1447		=>	'NSM',
	1448		=>	'NSM',
	1449		=>	'NSM',
	1450		=>	'NSM',
	1451		=>	'NSM',
	1452		=>	'NSM',
	1453		=>	'NSM',
	1454		=>	'NSM',
	1455		=>	'NSM',
	1456		=>	'NSM',
	1457		=>	'NSM',
	1458		=>	'NSM',
	1459		=>	'NSM',
	1460		=>	'NSM',
	1461		=>	'NSM',
	1462		=>	'NSM',
	1463		=>	'NSM',
	1464		=>	'NSM',
	1465		=>	'NSM',
	1466		=>	'NSM',
	1467		=>	'NSM',
	1468		=>	'NSM',
	1469		=>	'NSM',
	1470		=>	'R',
	1471		=>	'NSM',
	1472		=>	'R',
	1473		=>	'NSM',
	1474		=>	'NSM',
	1475		=>	'R',
	1476		=>	'NSM',
	1477		=>	'NSM',
	1478		=>	'R',
	1479		=>	'NSM',
	1488		=>	'R',
	1489		=>	'R',
	1490		=>	'R',
	1491		=>	'R',
	1492		=>	'R',
	1493		=>	'R',
	1494		=>	'R',
	1495		=>	'R',
	1496		=>	'R',
	1497		=>	'R',
	1498		=>	'R',
	1499		=>	'R',
	1500		=>	'R',
	1501		=>	'R',
	1502		=>	'R',
	1503		=>	'R',
	1504		=>	'R',
	1505		=>	'R',
	1506		=>	'R',
	1507		=>	'R',
	1508		=>	'R',
	1509		=>	'R',
	1510		=>	'R',
	1511		=>	'R',
	1512		=>	'R',
	1513		=>	'R',
	1514		=>	'R',
	1520		=>	'R',
	1521		=>	'R',
	1522		=>	'R',
	1523		=>	'R',
	1524		=>	'R',
	1536		=>	'AL',
	1537		=>	'AL',
	1538		=>	'AL',
	1539		=>	'AL',
	1547		=>	'AL',
	1548		=>	'CS',
	1549		=>	'AL',
	1550		=>	'ON',
	1551		=>	'ON',
	1552		=>	'NSM',
	1553		=>	'NSM',
	1554		=>	'NSM',
	1555		=>	'NSM',
	1556		=>	'NSM',
	1557		=>	'NSM',
	1563		=>	'AL',
	1566		=>	'AL',
	1567		=>	'AL',
	1569		=>	'AL',
	1570		=>	'AL',
	1571		=>	'AL',
	1572		=>	'AL',
	1573		=>	'AL',
	1574		=>	'AL',
	1575		=>	'AL',
	1576		=>	'AL',
	1577		=>	'AL',
	1578		=>	'AL',
	1579		=>	'AL',
	1580		=>	'AL',
	1581		=>	'AL',
	1582		=>	'AL',
	1583		=>	'AL',
	1584		=>	'AL',
	1585		=>	'AL',
	1586		=>	'AL',
	1587		=>	'AL',
	1588		=>	'AL',
	1589		=>	'AL',
	1590		=>	'AL',
	1591		=>	'AL',
	1592		=>	'AL',
	1593		=>	'AL',
	1594		=>	'AL',
	1600		=>	'AL',
	1601		=>	'AL',
	1602		=>	'AL',
	1603		=>	'AL',
	1604		=>	'AL',
	1605		=>	'AL',
	1606		=>	'AL',
	1607		=>	'AL',
	1608		=>	'AL',
	1609		=>	'AL',
	1610		=>	'AL',
	1611		=>	'NSM',
	1612		=>	'NSM',
	1613		=>	'NSM',
	1614		=>	'NSM',
	1615		=>	'NSM',
	1616		=>	'NSM',
	1617		=>	'NSM',
	1618		=>	'NSM',
	1619		=>	'NSM',
	1620		=>	'NSM',
	1621		=>	'NSM',
	1622		=>	'NSM',
	1623		=>	'NSM',
	1624		=>	'NSM',
	1625		=>	'NSM',
	1626		=>	'NSM',
	1627		=>	'NSM',
	1628		=>	'NSM',
	1629		=>	'NSM',
	1630		=>	'NSM',
	1632		=>	'AN',
	1633		=>	'AN',
	1634		=>	'AN',
	1635		=>	'AN',
	1636		=>	'AN',
	1637		=>	'AN',
	1638		=>	'AN',
	1639		=>	'AN',
	1640		=>	'AN',
	1641		=>	'AN',
	1642		=>	'ET',
	1643		=>	'AN',
	1644		=>	'AN',
	1645		=>	'AL',
	1646		=>	'AL',
	1647		=>	'AL',
	1648		=>	'NSM',
	1649		=>	'AL',
	1650		=>	'AL',
	1651		=>	'AL',
	1652		=>	'AL',
	1653		=>	'AL',
	1654		=>	'AL',
	1655		=>	'AL',
	1656		=>	'AL',
	1657		=>	'AL',
	1658		=>	'AL',
	1659		=>	'AL',
	1660		=>	'AL',
	1661		=>	'AL',
	1662		=>	'AL',
	1663		=>	'AL',
	1664		=>	'AL',
	1665		=>	'AL',
	1666		=>	'AL',
	1667		=>	'AL',
	1668		=>	'AL',
	1669		=>	'AL',
	1670		=>	'AL',
	1671		=>	'AL',
	1672		=>	'AL',
	1673		=>	'AL',
	1674		=>	'AL',
	1675		=>	'AL',
	1676		=>	'AL',
	1677		=>	'AL',
	1678		=>	'AL',
	1679		=>	'AL',
	1680		=>	'AL',
	1681		=>	'AL',
	1682		=>	'AL',
	1683		=>	'AL',
	1684		=>	'AL',
	1685		=>	'AL',
	1686		=>	'AL',
	1687		=>	'AL',
	1688		=>	'AL',
	1689		=>	'AL',
	1690		=>	'AL',
	1691		=>	'AL',
	1692		=>	'AL',
	1693		=>	'AL',
	1694		=>	'AL',
	1695		=>	'AL',
	1696		=>	'AL',
	1697		=>	'AL',
	1698		=>	'AL',
	1699		=>	'AL',
	1700		=>	'AL',
	1701		=>	'AL',
	1702		=>	'AL',
	1703		=>	'AL',
	1704		=>	'AL',
	1705		=>	'AL',
	1706		=>	'AL',
	1707		=>	'AL',
	1708		=>	'AL',
	1709		=>	'AL',
	1710		=>	'AL',
	1711		=>	'AL',
	1712		=>	'AL',
	1713		=>	'AL',
	1714		=>	'AL',
	1715		=>	'AL',
	1716		=>	'AL',
	1717		=>	'AL',
	1718		=>	'AL',
	1719		=>	'AL',
	1720		=>	'AL',
	1721		=>	'AL',
	1722		=>	'AL',
	1723		=>	'AL',
	1724		=>	'AL',
	1725		=>	'AL',
	1726		=>	'AL',
	1727		=>	'AL',
	1728		=>	'AL',
	1729		=>	'AL',
	1730		=>	'AL',
	1731		=>	'AL',
	1732		=>	'AL',
	1733		=>	'AL',
	1734		=>	'AL',
	1735		=>	'AL',
	1736		=>	'AL',
	1737		=>	'AL',
	1738		=>	'AL',
	1739		=>	'AL',
	1740		=>	'AL',
	1741		=>	'AL',
	1742		=>	'AL',
	1743		=>	'AL',
	1744		=>	'AL',
	1745		=>	'AL',
	1746		=>	'AL',
	1747		=>	'AL',
	1748		=>	'AL',
	1749		=>	'AL',
	1750		=>	'NSM',
	1751		=>	'NSM',
	1752		=>	'NSM',
	1753		=>	'NSM',
	1754		=>	'NSM',
	1755		=>	'NSM',
	1756		=>	'NSM',
	1757		=>	'AL',
	1758		=>	'NSM',
	1759		=>	'NSM',
	1760		=>	'NSM',
	1761		=>	'NSM',
	1762		=>	'NSM',
	1763		=>	'NSM',
	1764		=>	'NSM',
	1765		=>	'AL',
	1766		=>	'AL',
	1767		=>	'NSM',
	1768		=>	'NSM',
	1769		=>	'ON',
	1770		=>	'NSM',
	1771		=>	'NSM',
	1772		=>	'NSM',
	1773		=>	'NSM',
	1774		=>	'AL',
	1775		=>	'AL',
	1776		=>	'EN',
	1777		=>	'EN',
	1778		=>	'EN',
	1779		=>	'EN',
	1780		=>	'EN',
	1781		=>	'EN',
	1782		=>	'EN',
	1783		=>	'EN',
	1784		=>	'EN',
	1785		=>	'EN',
	1786		=>	'AL',
	1787		=>	'AL',
	1788		=>	'AL',
	1789		=>	'AL',
	1790		=>	'AL',
	1791		=>	'AL',
	1792		=>	'AL',
	1793		=>	'AL',
	1794		=>	'AL',
	1795		=>	'AL',
	1796		=>	'AL',
	1797		=>	'AL',
	1798		=>	'AL',
	1799		=>	'AL',
	1800		=>	'AL',
	1801		=>	'AL',
	1802		=>	'AL',
	1803		=>	'AL',
	1804		=>	'AL',
	1805		=>	'AL',
	1807		=>	'BN',
	1808		=>	'AL',
	1809		=>	'NSM',
	1810		=>	'AL',
	1811		=>	'AL',
	1812		=>	'AL',
	1813		=>	'AL',
	1814		=>	'AL',
	1815		=>	'AL',
	1816		=>	'AL',
	1817		=>	'AL',
	1818		=>	'AL',
	1819		=>	'AL',
	1820		=>	'AL',
	1821		=>	'AL',
	1822		=>	'AL',
	1823		=>	'AL',
	1824		=>	'AL',
	1825		=>	'AL',
	1826		=>	'AL',
	1827		=>	'AL',
	1828		=>	'AL',
	1829		=>	'AL',
	1830		=>	'AL',
	1831		=>	'AL',
	1832		=>	'AL',
	1833		=>	'AL',
	1834		=>	'AL',
	1835		=>	'AL',
	1836		=>	'AL',
	1837		=>	'AL',
	1838		=>	'AL',
	1839		=>	'AL',
	1840		=>	'NSM',
	1841		=>	'NSM',
	1842		=>	'NSM',
	1843		=>	'NSM',
	1844		=>	'NSM',
	1845		=>	'NSM',
	1846		=>	'NSM',
	1847		=>	'NSM',
	1848		=>	'NSM',
	1849		=>	'NSM',
	1850		=>	'NSM',
	1851		=>	'NSM',
	1852		=>	'NSM',
	1853		=>	'NSM',
	1854		=>	'NSM',
	1855		=>	'NSM',
	1856		=>	'NSM',
	1857		=>	'NSM',
	1858		=>	'NSM',
	1859		=>	'NSM',
	1860		=>	'NSM',
	1861		=>	'NSM',
	1862		=>	'NSM',
	1863		=>	'NSM',
	1864		=>	'NSM',
	1865		=>	'NSM',
	1866		=>	'NSM',
	1869		=>	'AL',
	1870		=>	'AL',
	1871		=>	'AL',
	1872		=>	'AL',
	1873		=>	'AL',
	1874		=>	'AL',
	1875		=>	'AL',
	1876		=>	'AL',
	1877		=>	'AL',
	1878		=>	'AL',
	1879		=>	'AL',
	1880		=>	'AL',
	1881		=>	'AL',
	1882		=>	'AL',
	1883		=>	'AL',
	1884		=>	'AL',
	1885		=>	'AL',
	1886		=>	'AL',
	1887		=>	'AL',
	1888		=>	'AL',
	1889		=>	'AL',
	1890		=>	'AL',
	1891		=>	'AL',
	1892		=>	'AL',
	1893		=>	'AL',
	1894		=>	'AL',
	1895		=>	'AL',
	1896		=>	'AL',
	1897		=>	'AL',
	1898		=>	'AL',
	1899		=>	'AL',
	1900		=>	'AL',
	1901		=>	'AL',
	1920		=>	'AL',
	1921		=>	'AL',
	1922		=>	'AL',
	1923		=>	'AL',
	1924		=>	'AL',
	1925		=>	'AL',
	1926		=>	'AL',
	1927		=>	'AL',
	1928		=>	'AL',
	1929		=>	'AL',
	1930		=>	'AL',
	1931		=>	'AL',
	1932		=>	'AL',
	1933		=>	'AL',
	1934		=>	'AL',
	1935		=>	'AL',
	1936		=>	'AL',
	1937		=>	'AL',
	1938		=>	'AL',
	1939		=>	'AL',
	1940		=>	'AL',
	1941		=>	'AL',
	1942		=>	'AL',
	1943		=>	'AL',
	1944		=>	'AL',
	1945		=>	'AL',
	1946		=>	'AL',
	1947		=>	'AL',
	1948		=>	'AL',
	1949		=>	'AL',
	1950		=>	'AL',
	1951		=>	'AL',
	1952		=>	'AL',
	1953		=>	'AL',
	1954		=>	'AL',
	1955		=>	'AL',
	1956		=>	'AL',
	1957		=>	'AL',
	1958		=>	'NSM',
	1959		=>	'NSM',
	1960		=>	'NSM',
	1961		=>	'NSM',
	1962		=>	'NSM',
	1963		=>	'NSM',
	1964		=>	'NSM',
	1965		=>	'NSM',
	1966		=>	'NSM',
	1967		=>	'NSM',
	1968		=>	'NSM',
	1969		=>	'AL',
	1984		=>	'R',
	1985		=>	'R',
	1986		=>	'R',
	1987		=>	'R',
	1988		=>	'R',
	1989		=>	'R',
	1990		=>	'R',
	1991		=>	'R',
	1992		=>	'R',
	1993		=>	'R',
	1994		=>	'R',
	1995		=>	'R',
	1996		=>	'R',
	1997		=>	'R',
	1998		=>	'R',
	1999		=>	'R',
	2000		=>	'R',
	2001		=>	'R',
	2002		=>	'R',
	2003		=>	'R',
	2004		=>	'R',
	2005		=>	'R',
	2006		=>	'R',
	2007		=>	'R',
	2008		=>	'R',
	2009		=>	'R',
	2010		=>	'R',
	2011		=>	'R',
	2012		=>	'R',
	2013		=>	'R',
	2014		=>	'R',
	2015		=>	'R',
	2016		=>	'R',
	2017		=>	'R',
	2018		=>	'R',
	2019		=>	'R',
	2020		=>	'R',
	2021		=>	'R',
	2022		=>	'R',
	2023		=>	'R',
	2024		=>	'R',
	2025		=>	'R',
	2026		=>	'R',
	2036		=>	'R',
	2037		=>	'R',
	2042		=>	'R',
	8207		=>	'R',
	65136		=>	'AL',
	65137		=>	'AL',
	65138		=>	'AL',
	65139		=>	'AL',
	65140		=>	'AL',
	65142		=>	'AL',
	65143		=>	'AL',
	65144		=>	'AL',
	65145		=>	'AL',
	65146		=>	'AL',
	65147		=>	'AL',
	65148		=>	'AL',
	65149		=>	'AL',
	65150		=>	'AL',
	65151		=>	'AL',
	65152		=>	'AL',
	65153		=>	'AL',
	65154		=>	'AL',
	65155		=>	'AL',
	65156		=>	'AL',
	65157		=>	'AL',
	65158		=>	'AL',
	65159		=>	'AL',
	65160		=>	'AL',
	65161		=>	'AL',
	65162		=>	'AL',
	65163		=>	'AL',
	65164		=>	'AL',
	65165		=>	'AL',
	65166		=>	'AL',
	65167		=>	'AL',
	65168		=>	'AL',
	65169		=>	'AL',
	65170		=>	'AL',
	65171		=>	'AL',
	65172		=>	'AL',
	65173		=>	'AL',
	65174		=>	'AL',
	65175		=>	'AL',
	65176		=>	'AL',
	65177		=>	'AL',
	65178		=>	'AL',
	65179		=>	'AL',
	65180		=>	'AL',
	65181		=>	'AL',
	65182		=>	'AL',
	65183		=>	'AL',
	65184		=>	'AL',
	65185		=>	'AL',
	65186		=>	'AL',
	65187		=>	'AL',
	65188		=>	'AL',
	65189		=>	'AL',
	65190		=>	'AL',
	65191		=>	'AL',
	65192		=>	'AL',
	65193		=>	'AL',
	65194		=>	'AL',
	65195		=>	'AL',
	65196		=>	'AL',
	65197		=>	'AL',
	65198		=>	'AL',
	65199		=>	'AL',
	65200		=>	'AL',
	65201		=>	'AL',
	65202		=>	'AL',
	65203		=>	'AL',
	65204		=>	'AL',
	65205		=>	'AL',
	65206		=>	'AL',
	65207		=>	'AL',
	65208		=>	'AL',
	65209		=>	'AL',
	65210		=>	'AL',
	65211		=>	'AL',
	65212		=>	'AL',
	65213		=>	'AL',
	65214		=>	'AL',
	65215		=>	'AL',
	65216		=>	'AL',
	65217		=>	'AL',
	65218		=>	'AL',
	65219		=>	'AL',
	65220		=>	'AL',
	65221		=>	'AL',
	65222		=>	'AL',
	65223		=>	'AL',
	65224		=>	'AL',
	65225		=>	'AL',
	65226		=>	'AL',
	65227		=>	'AL',
	65228		=>	'AL',
	65229		=>	'AL',
	65230		=>	'AL',
	65231		=>	'AL',
	65232		=>	'AL',
	65233		=>	'AL',
	65234		=>	'AL',
	65235		=>	'AL',
	65236		=>	'AL',
	65237		=>	'AL',
	65238		=>	'AL',
	65239		=>	'AL',
	65240		=>	'AL',
	65241		=>	'AL',
	65242		=>	'AL',
	65243		=>	'AL',
	65244		=>	'AL',
	65245		=>	'AL',
	65246		=>	'AL',
	65247		=>	'AL',
	65248		=>	'AL',
	65249		=>	'AL',
	65250		=>	'AL',
	65251		=>	'AL',
	65252		=>	'AL',
	65253		=>	'AL',
	65254		=>	'AL',
	65255		=>	'AL',
	65256		=>	'AL',
	65257		=>	'AL',
	65258		=>	'AL',
	65259		=>	'AL',
	65260		=>	'AL',
	65261		=>	'AL',
	65262		=>	'AL',
	65263		=>	'AL',
	65264		=>	'AL',
	65265		=>	'AL',
	65266		=>	'AL',
	65267		=>	'AL',
	65268		=>	'AL',
	65269		=>	'AL',
	65270		=>	'AL',
	65271		=>	'AL',
	65272		=>	'AL',
	65273		=>	'AL',
	65274		=>	'AL',
	65275		=>	'AL',
	65276		=>	'AL',
	67584		=>	'R',
	67585		=>	'R',
	67586		=>	'R',
	67587		=>	'R',
	67588		=>	'R',
	67589		=>	'R',
	67592		=>	'R',
	67594		=>	'R',
	67595		=>	'R',
	67596		=>	'R',
	67597		=>	'R',
	67598		=>	'R',
	67599		=>	'R',
	67600		=>	'R',
	67601		=>	'R',
	67602		=>	'R',
	67603		=>	'R',
	67604		=>	'R',
	67605		=>	'R',
	67606		=>	'R',
	67607		=>	'R',
	67608		=>	'R',
	67609		=>	'R',
	67610		=>	'R',
	67611		=>	'R',
	67612		=>	'R',
	67613		=>	'R',
	67614		=>	'R',
	67615		=>	'R',
	67616		=>	'R',
	67617		=>	'R',
	67618		=>	'R',
	67619		=>	'R',
	67620		=>	'R',
	67621		=>	'R',
	67622		=>	'R',
	67623		=>	'R',
	67624		=>	'R',
	67625		=>	'R',
	67626		=>	'R',
	67627		=>	'R',
	67628		=>	'R',
	67629		=>	'R',
	67630		=>	'R',
	67631		=>	'R',
	67632		=>	'R',
	67633		=>	'R',
	67634		=>	'R',
	67635		=>	'R',
	67636		=>	'R',
	67637		=>	'R',
	67639		=>	'R',
	67640		=>	'R',
	67644		=>	'R',
	67647		=>	'R',
	67840		=>	'R',
	67841		=>	'R',
	67842		=>	'R',
	67843		=>	'R',
	67844		=>	'R',
	67845		=>	'R',
	67846		=>	'R',
	67847		=>	'R',
	67848		=>	'R',
	67849		=>	'R',
	67850		=>	'R',
	67851		=>	'R',
	67852		=>	'R',
	67853		=>	'R',
	67854		=>	'R',
	67855		=>	'R',
	67856		=>	'R',
	67857		=>	'R',
	67858		=>	'R',
	67859		=>	'R',
	67860		=>	'R',
	67861		=>	'R',
	67862		=>	'R',
	67863		=>	'R',
	67864		=>	'R',
	67865		=>	'R',
	68096		=>	'R',
	68112		=>	'R',
	68113		=>	'R',
	68114		=>	'R',
	68115		=>	'R',
	68117		=>	'R',
	68118		=>	'R',
	68119		=>	'R',
	68121		=>	'R',
	68122		=>	'R',
	68123		=>	'R',
	68124		=>	'R',
	68125		=>	'R',
	68126		=>	'R',
	68127		=>	'R',
	68128		=>	'R',
	68129		=>	'R',
	68130		=>	'R',
	68131		=>	'R',
	68132		=>	'R',
	68133		=>	'R',
	68134		=>	'R',
	68135		=>	'R',
	68136		=>	'R',
	68137		=>	'R',
	68138		=>	'R',
	68139		=>	'R',
	68140		=>	'R',
	68141		=>	'R',
	68142		=>	'R',
	68143		=>	'R',
	68144		=>	'R',
	68145		=>	'R',
	68146		=>	'R',
	68147		=>	'R',
	68160		=>	'R',
	68161		=>	'R',
	68162		=>	'R',
	68163		=>	'R',
	68164		=>	'R',
	68165		=>	'R',
	68166		=>	'R',
	68167		=>	'R',
	68176		=>	'R',
	68177		=>	'R',
	68178		=>	'R',
	68179		=>	'R',
	68180		=>	'R',
	68181		=>	'R',
	68182		=>	'R',
	68183		=>	'R',
	68184		=>	'R'
);


/**
 * Mirror unicode characters.
 * For information on bidi mirroring, see UAX #9: Bidirectional Algorithm,
 * at http://www.unicode.org/unicode/reports/tr9/
 */
$unicode_mirror = array(
0x0028 => 0x0029,
0x0029 => 0x0028,
0x003C => 0x003E,
0x003E => 0x003C,
0x005B => 0x005D,
0x005D => 0x005B,
0x007B => 0x007D,
0x007D => 0x007B,
0x00AB => 0x00BB,
0x00BB => 0x00AB,
0x0F3A => 0x0F3B,
0x0F3B => 0x0F3A,
0x0F3C => 0x0F3D,
0x0F3D => 0x0F3C,
0x169B => 0x169C,
0x169C => 0x169B,
0x2018 => 0x2019,
0x2019 => 0x2018,
0x201C => 0x201D,
0x201D => 0x201C,
0x2039 => 0x203A,
0x203A => 0x2039,
0x2045 => 0x2046,
0x2046 => 0x2045,
0x207D => 0x207E,
0x207E => 0x207D,
0x208D => 0x208E,
0x208E => 0x208D,
0x2208 => 0x220B,
0x2209 => 0x220C,
0x220A => 0x220D,
0x220B => 0x2208,
0x220C => 0x2209,
0x220D => 0x220A,
0x2215 => 0x29F5,
0x223C => 0x223D,
0x223D => 0x223C,
0x2243 => 0x22CD,
0x2252 => 0x2253,
0x2253 => 0x2252,
0x2254 => 0x2255,
0x2255 => 0x2254,
0x2264 => 0x2265,
0x2265 => 0x2264,
0x2266 => 0x2267,
0x2267 => 0x2266,
0x2268 => 0x2269,
0x2269 => 0x2268,
0x226A => 0x226B,
0x226B => 0x226A,
0x226E => 0x226F,
0x226F => 0x226E,
0x2270 => 0x2271,
0x2271 => 0x2270,
0x2272 => 0x2273,
0x2273 => 0x2272,
0x2274 => 0x2275,
0x2275 => 0x2274,
0x2276 => 0x2277,
0x2277 => 0x2276,
0x2278 => 0x2279,
0x2279 => 0x2278,
0x227A => 0x227B,
0x227B => 0x227A,
0x227C => 0x227D,
0x227D => 0x227C,
0x227E => 0x227F,
0x227F => 0x227E,
0x2280 => 0x2281,
0x2281 => 0x2280,
0x2282 => 0x2283,
0x2283 => 0x2282,
0x2284 => 0x2285,
0x2285 => 0x2284,
0x2286 => 0x2287,
0x2287 => 0x2286,
0x2288 => 0x2289,
0x2289 => 0x2288,
0x228A => 0x228B,
0x228B => 0x228A,
0x228F => 0x2290,
0x2290 => 0x228F,
0x2291 => 0x2292,
0x2292 => 0x2291,
0x2298 => 0x29B8,
0x22A2 => 0x22A3,
0x22A3 => 0x22A2,
0x22A6 => 0x2ADE,
0x22A8 => 0x2AE4,
0x22A9 => 0x2AE3,
0x22AB => 0x2AE5,
0x22B0 => 0x22B1,
0x22B1 => 0x22B0,
0x22B2 => 0x22B3,
0x22B3 => 0x22B2,
0x22B4 => 0x22B5,
0x22B5 => 0x22B4,
0x22B6 => 0x22B7,
0x22B7 => 0x22B6,
0x22C9 => 0x22CA,
0x22CA => 0x22C9,
0x22CB => 0x22CC,
0x22CC => 0x22CB,
0x22CD => 0x2243,
0x22D0 => 0x22D1,
0x22D1 => 0x22D0,
0x22D6 => 0x22D7,
0x22D7 => 0x22D6,
0x22D8 => 0x22D9,
0x22D9 => 0x22D8,
0x22DA => 0x22DB,
0x22DB => 0x22DA,
0x22DC => 0x22DD,
0x22DD => 0x22DC,
0x22DE => 0x22DF,
0x22DF => 0x22DE,
0x22E0 => 0x22E1,
0x22E1 => 0x22E0,
0x22E2 => 0x22E3,
0x22E3 => 0x22E2,
0x22E4 => 0x22E5,
0x22E5 => 0x22E4,
0x22E6 => 0x22E7,
0x22E7 => 0x22E6,
0x22E8 => 0x22E9,
0x22E9 => 0x22E8,
0x22EA => 0x22EB,
0x22EB => 0x22EA,
0x22EC => 0x22ED,
0x22ED => 0x22EC,
0x22F0 => 0x22F1,
0x22F1 => 0x22F0,
0x22F2 => 0x22FA,
0x22F3 => 0x22FB,
0x22F4 => 0x22FC,
0x22F6 => 0x22FD,
0x22F7 => 0x22FE,
0x22FA => 0x22F2,
0x22FB => 0x22F3,
0x22FC => 0x22F4,
0x22FD => 0x22F6,
0x22FE => 0x22F7,
0x2308 => 0x2309,
0x2309 => 0x2308,
0x230A => 0x230B,
0x230B => 0x230A,
0x2329 => 0x232A,
0x232A => 0x2329,
0x2768 => 0x2769,
0x2769 => 0x2768,
0x276A => 0x276B,
0x276B => 0x276A,
0x276C => 0x276D,
0x276D => 0x276C,
0x276E => 0x276F,
0x276F => 0x276E,
0x2770 => 0x2771,
0x2771 => 0x2770,
0x2772 => 0x2773,
0x2773 => 0x2772,
0x2774 => 0x2775,
0x2775 => 0x2774,
0x27C3 => 0x27C4,
0x27C4 => 0x27C3,
0x27C5 => 0x27C6,
0x27C6 => 0x27C5,
0x27D5 => 0x27D6,
0x27D6 => 0x27D5,
0x27DD => 0x27DE,
0x27DE => 0x27DD,
0x27E2 => 0x27E3,
0x27E3 => 0x27E2,
0x27E4 => 0x27E5,
0x27E5 => 0x27E4,
0x27E6 => 0x27E7,
0x27E7 => 0x27E6,
0x27E8 => 0x27E9,
0x27E9 => 0x27E8,
0x27EA => 0x27EB,
0x27EB => 0x27EA,
0x2983 => 0x2984,
0x2984 => 0x2983,
0x2985 => 0x2986,
0x2986 => 0x2985,
0x2987 => 0x2988,
0x2988 => 0x2987,
0x2989 => 0x298A,
0x298A => 0x2989,
0x298B => 0x298C,
0x298C => 0x298B,
0x298D => 0x2990,
0x298E => 0x298F,
0x298F => 0x298E,
0x2990 => 0x298D,
0x2991 => 0x2992,
0x2992 => 0x2991,
0x2993 => 0x2994,
0x2994 => 0x2993,
0x2995 => 0x2996,
0x2996 => 0x2995,
0x2997 => 0x2998,
0x2998 => 0x2997,
0x29B8 => 0x2298,
0x29C0 => 0x29C1,
0x29C1 => 0x29C0,
0x29C4 => 0x29C5,
0x29C5 => 0x29C4,
0x29CF => 0x29D0,
0x29D0 => 0x29CF,
0x29D1 => 0x29D2,
0x29D2 => 0x29D1,
0x29D4 => 0x29D5,
0x29D5 => 0x29D4,
0x29D8 => 0x29D9,
0x29D9 => 0x29D8,
0x29DA => 0x29DB,
0x29DB => 0x29DA,
0x29F5 => 0x2215,
0x29F8 => 0x29F9,
0x29F9 => 0x29F8,
0x29FC => 0x29FD,
0x29FD => 0x29FC,
0x2A2B => 0x2A2C,
0x2A2C => 0x2A2B,
0x2A2D => 0x2A2E,
0x2A2E => 0x2A2D,
0x2A34 => 0x2A35,
0x2A35 => 0x2A34,
0x2A3C => 0x2A3D,
0x2A3D => 0x2A3C,
0x2A64 => 0x2A65,
0x2A65 => 0x2A64,
0x2A79 => 0x2A7A,
0x2A7A => 0x2A79,
0x2A7D => 0x2A7E,
0x2A7E => 0x2A7D,
0x2A7F => 0x2A80,
0x2A80 => 0x2A7F,
0x2A81 => 0x2A82,
0x2A82 => 0x2A81,
0x2A83 => 0x2A84,
0x2A84 => 0x2A83,
0x2A8B => 0x2A8C,
0x2A8C => 0x2A8B,
0x2A91 => 0x2A92,
0x2A92 => 0x2A91,
0x2A93 => 0x2A94,
0x2A94 => 0x2A93,
0x2A95 => 0x2A96,
0x2A96 => 0x2A95,
0x2A97 => 0x2A98,
0x2A98 => 0x2A97,
0x2A99 => 0x2A9A,
0x2A9A => 0x2A99,
0x2A9B => 0x2A9C,
0x2A9C => 0x2A9B,
0x2AA1 => 0x2AA2,
0x2AA2 => 0x2AA1,
0x2AA6 => 0x2AA7,
0x2AA7 => 0x2AA6,
0x2AA8 => 0x2AA9,
0x2AA9 => 0x2AA8,
0x2AAA => 0x2AAB,
0x2AAB => 0x2AAA,
0x2AAC => 0x2AAD,
0x2AAD => 0x2AAC,
0x2AAF => 0x2AB0,
0x2AB0 => 0x2AAF,
0x2AB3 => 0x2AB4,
0x2AB4 => 0x2AB3,
0x2ABB => 0x2ABC,
0x2ABC => 0x2ABB,
0x2ABD => 0x2ABE,
0x2ABE => 0x2ABD,
0x2ABF => 0x2AC0,
0x2AC0 => 0x2ABF,
0x2AC1 => 0x2AC2,
0x2AC2 => 0x2AC1,
0x2AC3 => 0x2AC4,
0x2AC4 => 0x2AC3,
0x2AC5 => 0x2AC6,
0x2AC6 => 0x2AC5,
0x2ACD => 0x2ACE,
0x2ACE => 0x2ACD,
0x2ACF => 0x2AD0,
0x2AD0 => 0x2ACF,
0x2AD1 => 0x2AD2,
0x2AD2 => 0x2AD1,
0x2AD3 => 0x2AD4,
0x2AD4 => 0x2AD3,
0x2AD5 => 0x2AD6,
0x2AD6 => 0x2AD5,
0x2ADE => 0x22A6,
0x2AE3 => 0x22A9,
0x2AE4 => 0x22A8,
0x2AE5 => 0x22AB,
0x2AEC => 0x2AED,
0x2AED => 0x2AEC,
0x2AF7 => 0x2AF8,
0x2AF8 => 0x2AF7,
0x2AF9 => 0x2AFA,
0x2AFA => 0x2AF9,
0x2E02 => 0x2E03,
0x2E03 => 0x2E02,
0x2E04 => 0x2E05,
0x2E05 => 0x2E04,
0x2E09 => 0x2E0A,
0x2E0A => 0x2E09,
0x2E0C => 0x2E0D,
0x2E0D => 0x2E0C,
0x2E1C => 0x2E1D,
0x2E1D => 0x2E1C,
0x3008 => 0x3009,
0x3009 => 0x3008,
0x300A => 0x300B,
0x300B => 0x300A,
0x300C => 0x300D,
0x300D => 0x300C,
0x300E => 0x300F,
0x300F => 0x300E,
0x3010 => 0x3011,
0x3011 => 0x3010,
0x3014 => 0x3015,
0x3015 => 0x3014,
0x3016 => 0x3017,
0x3017 => 0x3016,
0x3018 => 0x3019,
0x3019 => 0x3018,
0x301A => 0x301B,
0x301B => 0x301A,
0x301D => 0x301E,
0x301E => 0x301D,
0xFE59 => 0xFE5A,
0xFE5A => 0xFE59,
0xFE5B => 0xFE5C,
0xFE5C => 0xFE5B,
0xFE5D => 0xFE5E,
0xFE5E => 0xFE5D,
0xFE64 => 0xFE65,
0xFE65 => 0xFE64,
0xFF08 => 0xFF09,
0xFF09 => 0xFF08,
0xFF1C => 0xFF1E,
0xFF1E => 0xFF1C,
0xFF3B => 0xFF3D,
0xFF3D => 0xFF3B,
0xFF5B => 0xFF5D,
0xFF5D => 0xFF5B,
0xFF5F => 0xFF60,
0xFF60 => 0xFF5F,
0xFF62 => 0xFF63,
0xFF63 => 0xFF62);

/**
 * Arabic shape subtitutions
 * char code => isolated, final, initial, medial
 */
$unicode_arlet = array(
	1569	=>	array(65152),
	1570	=>	array(65153, 65154, 65153, 65154),
	1571	=>	array(65155, 65156, 65155, 65156),
	1572	=>	array(65157, 65158),
	1573	=>	array(65159, 65160, 65159, 65160),
	1574	=>	array(65161, 65162, 65163, 65164),
	1575	=>	array(65165, 65166, 65165, 65166),
	1576	=>	array(65167, 65168, 65169, 65170),
	1577	=>	array(65171, 65172),
	1578	=>	array(65173, 65174, 65175, 65176),
	1579	=>	array(65177, 65178, 65179, 65180),
	1580	=>	array(65181, 65182, 65183, 65184),
	1581	=>	array(65185, 65186, 65187, 65188),
	1582	=>	array(65189, 65190, 65191, 65192),
	1583	=>	array(65193, 65194, 65193, 65194),
	1584	=>	array(65195, 65196, 65195, 65196),
	1585	=>	array(65197, 65198, 65197, 65198),
	1586	=>	array(65199, 65200, 65199, 65200),
	1587	=>	array(65201, 65202, 65203, 65204),
	1588	=>	array(65205, 65206, 65207, 65208),
	1589	=>	array(65209, 65210, 65211, 65212),
	1590	=>	array(65213, 65214, 65215, 65216),
	1591	=>	array(65217, 65218, 65219, 65220),
	1592	=>	array(65221, 65222, 65223, 65224),
	1593	=>	array(65225, 65226, 65227, 65228),
	1594	=>	array(65229, 65230, 65231, 65232),
	1601	=>	array(65233, 65234, 65235, 65236),
	1602	=>	array(65237, 65238, 65239, 65240),
	1603	=>	array(65241, 65242, 65243, 65244),
	1604	=>	array(65245, 65246, 65247, 65248),
	1605	=>	array(65249, 65250, 65251, 65252),
	1606	=>	array(65253, 65254, 65255, 65256),
	1607	=>	array(65257, 65258, 65259, 65260),
	1608	=>	array(65261, 65262, 65261, 65262),
	1609	=>	array(65263, 65264, 64488, 64489),
	1610	=>	array(65265, 65266, 65267, 65268),
	1649	=>	array(64336, 64337),
	1655	=>	array(64477),
	1657	=>	array(64358, 64359, 64360, 64361),
	1658	=>	array(64350, 64351, 64352, 64353),
	1659	=>	array(64338, 64339, 64340, 64341),
	1662	=>	array(64342, 64343, 64344, 64345),
	1663	=>	array(64354, 64355, 64356, 64357),
	1664	=>	array(64346, 64347, 64348, 64349),
	1667	=>	array(64374, 64375, 64376, 64377),
	1668	=>	array(64370, 64371, 64372, 64373),
	1670	=>	array(64378, 64379, 64380, 64381),
	1671	=>	array(64382, 64383, 64384, 64385),
	1672	=>	array(64392, 64393),
	1676	=>	array(64388, 64389),
	1677	=>	array(64386, 64387),
	1678	=>	array(64390, 64391),
	1681	=>	array(64396, 64397),
	1688	=>	array(64394, 64395, 64394, 64395),
	1700	=>	array(64362, 64363, 64364, 64365),
	1702	=>	array(64366, 64367, 64368, 64369),
	1705	=>	array(64398, 64399, 64400, 64401),
	1709	=>	array(64467, 64468, 64469, 64470),
	1711	=>	array(64402, 64403, 64404, 64405),
	1713	=>	array(64410, 64411, 64412, 64413),
	1715	=>	array(64406, 64407, 64408, 64409),
	1722	=>	array(64414, 64415),
	1723	=>	array(64416, 64417, 64418, 64419),
	1726	=>	array(64426, 64427, 64428, 64429),
	1728	=>	array(64420, 64421),
	1729	=>	array(64422, 64423, 64424, 64425),
	1733	=>	array(64480, 64481),
	1734	=>	array(64473, 64474),
	1735	=>	array(64471, 64472),
	1736	=>	array(64475, 64476),
	1737	=>	array(64482, 64483),
	1739	=>	array(64478, 64479),
	1740	=>	array(64508, 64509, 64510, 64511),
	1744	=>	array(64484, 64485, 64486, 64487),
	1746	=>	array(64430, 64431),
	1747	=>	array(64432, 64433)
);

/**
 * Arabic laa letter
 * char code => isolated, final, initial, medial
 */
$laa_array = array (
	1570  => array(65269, 65270, 65269, 65270),
	1571  => array(65271, 65272, 65271, 65272),
	1573  => array(65273, 65274, 65273, 65274),
	1575  => array(65275, 65276, 65275, 65276)
);

/**
 * Array of character substitutions for sequences of two diacritics symbols starting with SHADDA (0651 HEX, 1617 DEC).
 * Combining characters that can occur with Shadda (U0651) are placed in UE586-UE594.
 * Putting the combining mark and shadda in the same glyph allows us to avoid the two marks overlapping each other in an illegible manner.
 * second NSM char code => substitution char
 */
$diacritics = array (
	1612 => 64606, // Shadda + Dammatan
	1613 => 64607, // Shadda + Kasratan
	1614 => 64608, // Shadda + Fatha
	1615 => 64609, // Shadda + Damma
	1616 => 64610  // Shadda + Kasra
);

//============================================================+
// END OF FILE
//============================================================+
?>