(defun fib (n &optional (init1 3) (init2 3) (max 32))
   (let ((fibtab (make-array max)) )
      (setf (aref fibtab 0) init1)
      (setf (aref fibtab 1) init2)
      (dotimes (i (- max 2))
	 (setf (aref fibtab (+ 2 i))
		(+ (aref fibtab i) (aref fibtab (1+ i))))
	)
      (dotimes (i max)
	 (format t "fib(~d)=~d~%" i (aref fibtab i)))
    ))
