!{\src2tex{textfont=tt}}
!!****m* etsf_split/etsf_io_split_init
!! NAME
!!  etsf_io_split_init
!!
!! FUNCTION
!!    This routine is used to set the dimensions from a split defintion. It
!!    copies to @dims%my_<something> the size of associated arrays in
!!    @split_definition.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * split_definition <type(etsf_split)> = 
!!     give for each associated array the number of elements (given by the size)
!!     and the values of these elements in a splitted file.
!! SIDE EFFECTS
!! * dims <type(etsf_dims)> = 
!!     will be changed according to the @split argument. For each allocated array
!!     in @split, their corresponding dimension will be put to the array size ;
!!     else, the none-split value is used.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_split_init(dims, split_definition)

  !Arguments ------------------------------------
  type(etsf_dims), intent(inout) :: dims
  type(etsf_split), intent(in) :: split_definition

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_split_init'


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_split_init : enter'
!ENDDEBUG

  if (associated(split_definition%my_kpoints)) then
    dims%my_number_of_kpoints = &
      & size(split_definition%my_kpoints)
  else
    dims%my_number_of_kpoints = &
      & dims%number_of_kpoints
  end if
  if (associated(split_definition%my_grid_points_vector3)) then
    dims%my_number_of_grid_points_vect3 = &
      & size(split_definition%my_grid_points_vector3)
  else
    dims%my_number_of_grid_points_vect3 = &
      & dims%number_of_grid_points_vector3
  end if
  if (associated(split_definition%my_spins)) then
    dims%my_number_of_spins = &
      & size(split_definition%my_spins)
  else
    dims%my_number_of_spins = &
      & dims%number_of_spins
  end if
  if (associated(split_definition%my_grid_points_vector1)) then
    dims%my_number_of_grid_points_vect1 = &
      & size(split_definition%my_grid_points_vector1)
  else
    dims%my_number_of_grid_points_vect1 = &
      & dims%number_of_grid_points_vector1
  end if
  if (associated(split_definition%my_grid_points_vector2)) then
    dims%my_number_of_grid_points_vect2 = &
      & size(split_definition%my_grid_points_vector2)
  else
    dims%my_number_of_grid_points_vect2 = &
      & dims%number_of_grid_points_vector2
  end if
  if (associated(split_definition%my_coefficients)) then
    dims%my_max_number_of_coefficients = &
      & size(split_definition%my_coefficients)
  else
    dims%my_max_number_of_coefficients = &
      & dims%max_number_of_coefficients
  end if
  if (associated(split_definition%my_components)) then
    dims%my_number_of_components = &
      & size(split_definition%my_components)
  else
    dims%my_number_of_components = &
      & dims%number_of_components
  end if
  if (associated(split_definition%my_states)) then
    dims%my_max_number_of_states = &
      & size(split_definition%my_states)
  else
    dims%my_max_number_of_states = &
      & dims%max_number_of_states
  end if


!DEBUG
!write (*,*) 'etsf_io_split_init : exit'
!ENDDEBUG

end subroutine etsf_io_split_init
!!***
