!{\src2tex{textfont=tt}}
!!****m* etsf_electrons/etsf_io_electrons_copy
!! NAME
!!  etsf_io_electrons_copy
!!
!! FUNCTION
!!    This routine copy all variable of a group from one file @ncid_from to another
!!    @ncid_to. If a variable is missing in the source file, this does not raise an
!!    error, it is simply skipped. But if a variable in the destination file is not
!!    defined, this will raise an error.
!!
!!    The copy is done per variable. This means that memory occupation is reduced
!!    during the copy.
!!
!!    Normally, copies are pristine copies. But if optional argument @split is
!!    given, then the read values are copied to the specified locations in split
!!    arrays. In that case, the destination variable must have a compatible definition
!!    with the split values.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid_to = 
!!     integer returned by an 'open' NetCDF call. This id must have write access
!!     granted. It will be modified by the routine. The file must be in write
!!     mode (see etsf_io_low_set_write_mode()).
!! * ncid_from = 
!!     integer returned by an 'open' NetCDF call. This id must have read access
!!     granted. It will be left untouched.
!! * dims <type(etsf_dims)> = 
!!     these dimensions correspond to the source_file ones and are used to allocate
!!     temporary arrays in memory during the copy.
!! * split <type(etsf_split)> = (optional) 
!!     if this argument is given, the values in the split definition (e.g. my_kpoints)
!!     are used to put the data in the destination file in a bigger array at the right
!!     placed.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_electrons_copy(ncid_to, ncid_from, dims, lstat, error_data, &
  & split)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid_to
  integer, intent(in) :: ncid_from
  type(etsf_dims), intent(in) :: dims
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data
  type(etsf_split), optional, intent(in) :: split

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_electrons_copy'
  type(etsf_split) :: my_split
  integer,allocatable :: varids(:,:)
  integer :: nvarids
  integer,allocatable :: start(:)
  integer,allocatable :: count(:)
  integer :: len
  integer :: istart
  integer :: idim1,idim2,idim3,idim4,idim5,idim6,idim7,idim8
  integer,allocatable :: istop(:)
  integer,allocatable :: jstart(:)
  integer,allocatable :: jend(:)
  type(etsf_electrons) :: folder


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_electrons_copy : enter'
!ENDDEBUG

  lstat = .false.
  call etsf_io_low_set_write_mode(ncid_to, lstat, error_data = error_data)
  if (.not. lstat) return
  
  allocate(varids(2,9))
  nvarids = 1
  
  ! Variable 'number_of_electrons'
  !  allocate and read data
  allocate(folder%number_of_electrons)
  call etsf_io_low_read_var(ncid_from, "number_of_electrons", &
                          & folder%number_of_electrons, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%number_of_electrons)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    call etsf_io_low_write_var(ncid_to, "number_of_electrons", &
                             & folder%number_of_electrons, lstat, &
                             & error_data = error_data, ncvarid = varids(2, nvarids))
    if (.not. lstat) then
      deallocate(folder%number_of_electrons)
      deallocate(varids)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%number_of_electrons)
  
  lstat = .true.
  ! Variable 'exchange_functional'
  !  allocate and read data
  allocate(folder%exchange_functional)
  call etsf_io_low_read_var(ncid_from, "exchange_functional", &
                          & folder%exchange_functional, dims%character_string_length, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%exchange_functional)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    call etsf_io_low_write_var(ncid_to, "exchange_functional", &
                             & folder%exchange_functional, dims%character_string_length, lstat, &
                             & error_data = error_data, ncvarid = varids(2, nvarids))
    if (.not. lstat) then
      deallocate(folder%exchange_functional)
      deallocate(varids)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%exchange_functional)
  
  lstat = .true.
  ! Variable 'correlation_functional'
  !  allocate and read data
  allocate(folder%correlation_functional)
  call etsf_io_low_read_var(ncid_from, "correlation_functional", &
                          & folder%correlation_functional, dims%character_string_length, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%correlation_functional)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    call etsf_io_low_write_var(ncid_to, "correlation_functional", &
                             & folder%correlation_functional, dims%character_string_length, lstat, &
                             & error_data = error_data, ncvarid = varids(2, nvarids))
    if (.not. lstat) then
      deallocate(folder%correlation_functional)
      deallocate(varids)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%correlation_functional)
  
  lstat = .true.
  ! Variable 'fermi_energy'
  !  allocate and read data
  allocate(folder%fermi_energy)
  call etsf_io_low_read_var(ncid_from, "fermi_energy", &
                          & folder%fermi_energy, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%fermi_energy)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    call etsf_io_low_write_var(ncid_to, "fermi_energy", &
                             & folder%fermi_energy, lstat, &
                             & error_data = error_data, ncvarid = varids(2, nvarids))
    if (.not. lstat) then
      deallocate(folder%fermi_energy)
      deallocate(varids)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%fermi_energy)
  
  lstat = .true.
  ! Variable 'smearing_scheme'
  !  allocate and read data
  allocate(folder%smearing_scheme)
  call etsf_io_low_read_var(ncid_from, "smearing_scheme", &
                          & folder%smearing_scheme, dims%character_string_length, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%smearing_scheme)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    call etsf_io_low_write_var(ncid_to, "smearing_scheme", &
                             & folder%smearing_scheme, dims%character_string_length, lstat, &
                             & error_data = error_data, ncvarid = varids(2, nvarids))
    if (.not. lstat) then
      deallocate(folder%smearing_scheme)
      deallocate(varids)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%smearing_scheme)
  
  lstat = .true.
  ! Variable 'smearing_width'
  !  allocate and read data
  allocate(folder%smearing_width)
  call etsf_io_low_read_var(ncid_from, "smearing_width", &
                          & folder%smearing_width, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%smearing_width)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    call etsf_io_low_write_var(ncid_to, "smearing_width", &
                             & folder%smearing_width, lstat, &
                             & error_data = error_data, ncvarid = varids(2, nvarids))
    if (.not. lstat) then
      deallocate(folder%smearing_width)
      deallocate(varids)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%smearing_width)
  
  lstat = .true.
  ! Variable 'number_of_states'
  !  allocate and read data
  allocate(folder%number_of_states%data1D( &
    & dims%my_number_of_spins * &
    & dims%my_number_of_kpoints))
  call etsf_io_low_read_var(ncid_from, "number_of_states", &
                          & folder%number_of_states%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%number_of_states%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(2), count(2))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(2))
      istart   = 1
      len      = 1
      if (.not. associated(split%my_spins)) then
        istop(2)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(2) = size(split%my_spins)
        count(2) = 1
      end if
      if (.not. associated(split%my_kpoints)) then
        istop(1)  = 1
        len = len * dims%my_number_of_kpoints
      else
        istop(1) = size(split%my_kpoints)
        count(1) = 1
      end if
      do idim2 = 1, istop(2), 1
        if (associated(split%my_spins)) then
          start(2)  = split%my_spins(idim2)
        end if
        do idim1 = 1, istop(1), 1
          if (associated(split%my_kpoints)) then
            start(1)  = split%my_kpoints(idim1)
          end if
          call etsf_io_low_write_var(ncid_to, "number_of_states", &
                                   & folder%number_of_states%data1D(istart:istart + len - 1), &
                                   & lstat, error_data = error_data, &
                                   & start = start, count = count, ncvarid = varids(2, nvarids))
          if (.not. lstat) then
            deallocate(folder%number_of_states%data1D)
            deallocate(start, count, istop)
            deallocate(varids)
            call etsf_io_low_error_update(error_data, my_name)
            return
          end if
          istart = istart + len
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "number_of_states", &
                               & folder%number_of_states%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%number_of_states%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%number_of_states%data1D)
  
  lstat = .true.
  ! Variable 'eigenvalues'
  !  allocate and read data
  allocate(folder%eigenvalues%data1D( &
    & dims%my_number_of_spins * &
    & dims%my_number_of_kpoints * &
    & dims%my_max_number_of_states))
  call etsf_io_low_read_var(ncid_from, "eigenvalues", &
                          & folder%eigenvalues%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%eigenvalues%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(3), count(3))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(3))
      istart   = 1
      len      = 1
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      if (.not. associated(split%my_kpoints)) then
        istop(2)  = 1
        len = len * dims%my_number_of_kpoints
      else
        istop(2) = size(split%my_kpoints)
        count(2) = 1
      end if
      if (.not. associated(split%my_states)) then
        istop(1)  = 1
        len = len * dims%my_max_number_of_states
      else
        istop(1) = size(split%my_states)
        count(1) = 1
      end if
      do idim3 = 1, istop(3), 1
        if (associated(split%my_spins)) then
          start(3)  = split%my_spins(idim3)
        end if
        do idim2 = 1, istop(2), 1
          if (associated(split%my_kpoints)) then
            start(2)  = split%my_kpoints(idim2)
          end if
          do idim1 = 1, istop(1), 1
            if (associated(split%my_states)) then
              start(1)  = split%my_states(idim1)
            end if
            call etsf_io_low_write_var(ncid_to, "eigenvalues", &
                                     & folder%eigenvalues%data1D(istart:istart + len - 1), &
                                     & lstat, error_data = error_data, &
                                     & start = start, count = count, ncvarid = varids(2, nvarids))
            if (.not. lstat) then
              deallocate(folder%eigenvalues%data1D)
              deallocate(start, count, istop)
              deallocate(varids)
              call etsf_io_low_error_update(error_data, my_name)
              return
            end if
            istart = istart + len
          end do
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "eigenvalues", &
                               & folder%eigenvalues%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%eigenvalues%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%eigenvalues%data1D)
  
  lstat = .true.
  ! Variable 'occupations'
  !  allocate and read data
  allocate(folder%occupations%data1D( &
    & dims%my_number_of_spins * &
    & dims%my_number_of_kpoints * &
    & dims%my_max_number_of_states))
  call etsf_io_low_read_var(ncid_from, "occupations", &
                          & folder%occupations%data1D, lstat, &
                          & error_data = error_data, ncvarid = varids(1, nvarids))
  if (.not. lstat .and. error_data%access_mode_id /= ERROR_MODE_INQ) then
    deallocate(folder%occupations%data1D)
    deallocate(varids)
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !  write data and deallocate (if read succeed)
  if (lstat) then
    if (present(split)) then
      ! We use the split definition to write to appropriated locations.
      allocate(start(3), count(3))
      count(:) = 0
      start(:) = 1
      ! For each dimension, set the do loop boundaries,
      ! and the array boundaries.
      allocate(istop(3))
      istart   = 1
      len      = 1
      if (.not. associated(split%my_spins)) then
        istop(3)  = 1
        len = len * dims%my_number_of_spins
      else
        istop(3) = size(split%my_spins)
        count(3) = 1
      end if
      if (.not. associated(split%my_kpoints)) then
        istop(2)  = 1
        len = len * dims%my_number_of_kpoints
      else
        istop(2) = size(split%my_kpoints)
        count(2) = 1
      end if
      if (.not. associated(split%my_states)) then
        istop(1)  = 1
        len = len * dims%my_max_number_of_states
      else
        istop(1) = size(split%my_states)
        count(1) = 1
      end if
      do idim3 = 1, istop(3), 1
        if (associated(split%my_spins)) then
          start(3)  = split%my_spins(idim3)
        end if
        do idim2 = 1, istop(2), 1
          if (associated(split%my_kpoints)) then
            start(2)  = split%my_kpoints(idim2)
          end if
          do idim1 = 1, istop(1), 1
            if (associated(split%my_states)) then
              start(1)  = split%my_states(idim1)
            end if
            call etsf_io_low_write_var(ncid_to, "occupations", &
                                     & folder%occupations%data1D(istart:istart + len - 1), &
                                     & lstat, error_data = error_data, &
                                     & start = start, count = count, ncvarid = varids(2, nvarids))
            if (.not. lstat) then
              deallocate(folder%occupations%data1D)
              deallocate(start, count, istop)
              deallocate(varids)
              call etsf_io_low_error_update(error_data, my_name)
              return
            end if
            istart = istart + len
          end do
        end do
      end do
      deallocate(start, count, istop)
    else
      ! No split information, we copy everything in the same shape.
      call etsf_io_low_write_var(ncid_to, "occupations", &
                               & folder%occupations%data1D, lstat, &
                               & error_data = error_data, ncvarid = varids(2, nvarids))
      if (.not. lstat) then
        deallocate(folder%occupations%data1D)
        deallocate(varids)
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
    nvarids = nvarids + 1
  end if
  deallocate(folder%occupations%data1D)
  
  lstat = .true.
  
  ! We copy all the attributes (ETSF and non-ETSF) of the group variables.
  call etsf_io_low_set_define_mode(ncid_to, lstat, error_data = error_data)
  if (.not. lstat) nvarids = 0
  do len = 1, nvarids - 1, 1
    call etsf_io_low_copy_all_att(ncid_from, ncid_to, varids(1, len), varids(2, len), &
                                & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      exit
    end if
  end do
  deallocate(varids)

!DEBUG
!write (*,*) 'etsf_io_electrons_copy : exit'
!ENDDEBUG

end subroutine etsf_io_electrons_copy
!!***
