If you are contributing a pull request to change the game's C++ code, please review the [style guide](http://endless-sky.github.io/styleguide/styleguide.xml) and try to mimic the style that the existing code uses.

The [issues page](https://github.com/endless-sky/endless-sky/issues) here on GitHub is for tracking bugs and feature requests. When posting a new issue, please:

* Check to make sure it's not a duplicate of an existing issue.
* Create a separate "issue" for each bug you are reporting and each feature you are requesting.
* Do not use the issues page for things other than bug reports and feature requests.

Once you've posted an issue, I'll assign it a label. GitHub does not allow anyone who does not have commit access to the repository to assign labels.

If you believe your issue has been resolved, you can close the issue yourself. I won't close an issue unless it has been idle for a few weeks, to avoid having me mark something as fixed when the original poster does not think their request has been fully addressed.

If an issue is a bug and it has been fixed in the code, it may be helpful to leave it "open" until an official release that fixes the bug has been made, so that other people encountering the same bug will see that it has already been reported.

The labels I assign to issues are:

* bug: Anything where the game is not behaving as intended.
* documentation: Something missing or incorrect in the game documentation.
* balance: A ship or weapon that seems too powerful or useless, or a mission that seems to easy or hard.
* mechanics: A question of whether the game mechanics should be altered.
* enhancement: A request for new functionality in the game engine itself.
* content: A suggestion for new content that could be created without changing the game code.
* question: A question of how something works, or a support question.
* unlikely: An enhancement or other change that I consider lowest priority or too large or difficult.
* unconfirmed: More information is needed to be sure this bug is really a bug.
* wontfix: A change that I definitely do not think should be made.
