#ifndef FILE_R_HPP_
#define FILE_R_HPP_

//============================================================================
// Name        :
// Author      : Avi
// Revision    : $Revision: #5 $
//
// Copyright 2009- ECMWF.
// This software is licensed under the terms of the Apache Licence version 2.0
// which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
// In applying this licence, ECMWF does not waive the privileges and immunities
// granted to it by virtue of its status as an intergovernmental organisation
// nor does it submit to any jurisdiction.
//
// Description : This class is used as a helper class for file utilities
//============================================================================

#include <fstream>
#include <string>

namespace ecf {

class File_r {
public:
    explicit File_r(const std::string& file_name);
    ~File_r();

    bool ok() const { return (fp_) ? true : false; }
    std::streamoff pos() { return fp_.tellg(); }
    //  deepcode ignore MissingOpenCheckOnFile: check called externally
    void setPos(std::streamoff pos) { fp_.seekg(pos, fp_.beg); }
    bool good() const { return fp_.good(); }
    void getline(std::string& line) { std::getline(fp_, line); }
    const std::string& file_name() const { return file_name_; }

private:
    File_r(const File_r&)                  = delete;
    const File_r& operator=(const File_r&) = delete;

    std::string file_name_;
    std::ifstream fp_;
};

} // namespace ecf

#endif
