/*
	Copyright (c) 2010 by Dennis Schridde

	This file is part of dovecot-metadata.

	dovecot-metadata is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	dovecot-metadata is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with dovecot-metadata.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef DOVECOT_METADATA_GLOBAL_H
#define DOVECOT_METADATA_GLOBAL_H

/*
	the dovecot include system needs its own special care:
	* include lib.h first, always
	* reset all the symbols we use by including metadata-config.h.in,
		since dovecot's internal config.h leaks through their public headers
*/
#include "lib.h"

#define ATTR_NONNULL(...) __attribute__((__nonnull__(__VA_ARGS__)))

/*
	= error values =
	< 0 is always an error
	0 means success or no-more-data
	> 0 means more-data-available

	= return types =
	void can never have errors

	== logical functions ==
	return bool and cannot have errors

	== functions returning pointers ==
	NULL is an error, everything else not

	== data handling functions ==
	bool is a continous function which cannot have errors
	int is any function which can have errors
*/

#endif
