﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.IO;
using System.Text;

namespace Microsoft.Diagnostics.NETCore.Client
{
    internal static class BinaryWriterExtensions
    {
        public static void WriteString(this BinaryWriter @this, string value)
        {
            if (@this is null)
            {
                throw new ArgumentNullException(nameof(@this));
            };

            @this.Write(value != null ? (value.Length + 1) : 0);
            if (value != null)
            {
                @this.Write(Encoding.Unicode.GetBytes(value + '\0'));
            }
        }

    }
}
