import { useState, useEffect } from 'react'
import createDotnetRuntime from '@microsoft/dotnet-runtime'

let dotnetRuntimePromise = undefined;
let meaningFunction = undefined;

async function createRuntime() {
    try {
        const response = await fetch('dotnet.wasm');
        const arrayBuffer = await response.arrayBuffer();
        return createDotnetRuntime({
            configSrc: "./mono-config.json",
            disableDotnet6Compatibility: true,
            locateFile: (path, prefix) => {
                return '/' + path;
            },
            instantiateWasm: async (imports, successCallback) => {
                try {
                    const arrayBufferResult = await WebAssembly.instantiate(arrayBuffer, imports);
                    successCallback(arrayBufferResult.instance);
                } catch (err) {
                    console.error(err);
                    throw err;
                }
            }
        });
    } catch (err) {
        console.error(err);
        throw err;
    }
}

async function dotnetMeaning() {
    if (!dotnetRuntimePromise) {
        dotnetRuntimePromise = createRuntime();
    }
    const { getAssemblyExports } = await dotnetRuntimePromise;
    const exports = await getAssemblyExports("Wasm.Browser.NextJs.Sample.dll");
    return exports.Sample.Test.Main();
}

export default function DeepThought() {
    const [meaning, setCount] = useState(undefined);

    useEffect(async () => {
        const meaning = await dotnetMeaning();
        setCount(meaning);
    }, []);

    if (!meaning) {
        return (<div>DeepThought is thinking ....</div>);
    }
    return (<div>Answer to the Ultimate Question of Life, the Universe, and Everything is : {meaning}!</div>);
};
