// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

#ifndef __PAL_RISCV64_ASMCONSTANTS_H__
#define __PAL_RISCV64_ASMCONSTANTS_H__

// https://github.com/riscv-non-isa/riscv-elf-psabi-doc/blob/3f81fae0412bb9ad4002a4ade508be7aa5e1599b/riscv-dwarf.adoc
// https://github.com/riscv-non-isa/riscv-elf-psabi-doc/blob/442ae19a2846bca37c6416f2d347fe74bb0b0dba/riscv-cc.adoc

#error "TODO-RISCV64: review this when other files are ported in this directory"

#define CONTEXT_RISCV64   0x04000000L

#define CONTEXT_CONTROL_BIT (0)
#define CONTEXT_INTEGER_BIT (1)
#define CONTEXT_FLOATING_POINT_BIT (2)
#define CONTEXT_DEBUG_REGISTERS_BIT (3)

#define CONTEXT_CONTROL (CONTEXT_RISCV64 | (1L << CONTEXT_CONTROL_BIT))
#define CONTEXT_INTEGER (CONTEXT_RISCV64 | (1 << CONTEXT_INTEGER_BIT))
#define CONTEXT_FLOATING_POINT  (CONTEXT_RISCV64 | (1 << CONTEXT_FLOATING_POINT_BIT))
#define CONTEXT_DEBUG_REGISTERS (CONTEXT_RISCV64 | (1 << CONTEXT_DEBUG_REGISTERS_BIT))

#define CONTEXT_FULL (CONTEXT_CONTROL | CONTEXT_INTEGER | CONTEXT_FLOATING_POINT)

#define SIZEOF_RISCV64_INTR 8
#define SIZEOF_RISCV64_FPR 8

#define CONTEXT_X0           0 // hardwired zero
#define CONTEXT_X1           CONTEXT_X0 + SIZEOF_RISCV64_INTR
#define CONTEXT_X2           CONTEXT_X1 + SIZEOF_RISCV64_INTR
#define CONTEXT_X3           CONTEXT_X2 + SIZEOF_RISCV64_INTR
#define CONTEXT_X4           CONTEXT_X3 + SIZEOF_RISCV64_INTR
#define CONTEXT_X5           CONTEXT_X4 + SIZEOF_RISCV64_INTR
#define CONTEXT_X6           CONTEXT_X5 + SIZEOF_RISCV64_INTR
#define CONTEXT_X7           CONTEXT_X6 + SIZEOF_RISCV64_INTR
#define CONTEXT_X8           CONTEXT_X7 + SIZEOF_RISCV64_INTR
#define CONTEXT_X9           CONTEXT_X8 + SIZEOF_RISCV64_INTR
#define CONTEXT_X10          CONTEXT_X9 + SIZEOF_RISCV64_INTR
#define CONTEXT_X11          CONTEXT_X10 + SIZEOF_RISCV64_INTR
#define CONTEXT_X12          CONTEXT_X11 + SIZEOF_RISCV64_INTR
#define CONTEXT_X13          CONTEXT_X12 + SIZEOF_RISCV64_INTR
#define CONTEXT_X14          CONTEXT_X13 + SIZEOF_RISCV64_INTR
#define CONTEXT_X15          CONTEXT_X14 + SIZEOF_RISCV64_INTR
#define CONTEXT_X16          CONTEXT_X15 + SIZEOF_RISCV64_INTR
#define CONTEXT_X17          CONTEXT_X16 + SIZEOF_RISCV64_INTR
#define CONTEXT_X18          CONTEXT_X17 + SIZEOF_RISCV64_INTR
#define CONTEXT_X19          CONTEXT_X18 + SIZEOF_RISCV64_INTR
#define CONTEXT_X20          CONTEXT_X19 + SIZEOF_RISCV64_INTR
#define CONTEXT_X21          CONTEXT_X20 + SIZEOF_RISCV64_INTR
#define CONTEXT_X22          CONTEXT_X21 + SIZEOF_RISCV64_INTR
#define CONTEXT_X23          CONTEXT_X22 + SIZEOF_RISCV64_INTR
#define CONTEXT_X24          CONTEXT_X23 + SIZEOF_RISCV64_INTR
#define CONTEXT_X25          CONTEXT_X24 + SIZEOF_RISCV64_INTR
#define CONTEXT_X26          CONTEXT_X25 + SIZEOF_RISCV64_INTR
#define CONTEXT_X27          CONTEXT_X26 + SIZEOF_RISCV64_INTR
#define CONTEXT_X28          CONTEXT_X27 + SIZEOF_RISCV64_INTR
#define CONTEXT_X29          CONTEXT_X28 + SIZEOF_RISCV64_INTR
#define CONTEXT_X30          CONTEXT_X29 + SIZEOF_RISCV64_INTR
#define CONTEXT_X31          CONTEXT_X30 + SIZEOF_RISCV64_INTR

#define CONTEXT_Pc           CONTEXT_X31 + SIZEOF_RISCV64_INTR
#define CONTEXT_FPU_OFFSET   CONTEXT_Pc + SIZEOF_RISCV64_INTR
#define CONTEXT_Sp           CONTEXT_X2
#define CONTEXT_Tp           CONTEXT_X4
#define CONTEXT_Fp           CONTEXT_X8

#define CONTEXT_F0           0
#define CONTEXT_F1           CONTEXT_F1 + SIZEOF_RISCV64_FPR
#define CONTEXT_F2           CONTEXT_F2 + SIZEOF_RISCV64_FPR
#define CONTEXT_F3           CONTEXT_F2 + SIZEOF_RISCV64_FPR
#define CONTEXT_F4           CONTEXT_F3 + SIZEOF_RISCV64_FPR
#define CONTEXT_F5           CONTEXT_F4 + SIZEOF_RISCV64_FPR
#define CONTEXT_F6           CONTEXT_F5 + SIZEOF_RISCV64_FPR
#define CONTEXT_F7           CONTEXT_F6 + SIZEOF_RISCV64_FPR
#define CONTEXT_F8           CONTEXT_F7 + SIZEOF_RISCV64_FPR
#define CONTEXT_F9           CONTEXT_F8 + SIZEOF_RISCV64_FPR
#define CONTEXT_F10          CONTEXT_F9 + SIZEOF_RISCV64_FPR
#define CONTEXT_F11          CONTEXT_F10 + SIZEOF_RISCV64_FPR
#define CONTEXT_F12          CONTEXT_F11 + SIZEOF_RISCV64_FPR
#define CONTEXT_F13          CONTEXT_F12 + SIZEOF_RISCV64_FPR
#define CONTEXT_F14          CONTEXT_F13 + SIZEOF_RISCV64_FPR
#define CONTEXT_F15          CONTEXT_F14 + SIZEOF_RISCV64_FPR
#define CONTEXT_F16          CONTEXT_F15 + SIZEOF_RISCV64_FPR
#define CONTEXT_F17          CONTEXT_F16 + SIZEOF_RISCV64_FPR
#define CONTEXT_F18          CONTEXT_F17 + SIZEOF_RISCV64_FPR
#define CONTEXT_F19          CONTEXT_F18 + SIZEOF_RISCV64_FPR
#define CONTEXT_F20          CONTEXT_F19 + SIZEOF_RISCV64_FPR
#define CONTEXT_F21          CONTEXT_F20 + SIZEOF_RISCV64_FPR
#define CONTEXT_F22          CONTEXT_F21 + SIZEOF_RISCV64_FPR
#define CONTEXT_F23          CONTEXT_F22 + SIZEOF_RISCV64_FPR
#define CONTEXT_F24          CONTEXT_F23 + SIZEOF_RISCV64_FPR
#define CONTEXT_F25          CONTEXT_F24 + SIZEOF_RISCV64_FPR
#define CONTEXT_F26          CONTEXT_F25 + SIZEOF_RISCV64_FPR
#define CONTEXT_F27          CONTEXT_F26 + SIZEOF_RISCV64_FPR
#define CONTEXT_F28          CONTEXT_F27 + SIZEOF_RISCV64_FPR
#define CONTEXT_F29          CONTEXT_F28 + SIZEOF_RISCV64_FPR
#define CONTEXT_F30          CONTEXT_F29 + SIZEOF_RISCV64_FPR
#define CONTEXT_F31          CONTEXT_F30 + SIZEOF_RISCV64_FPR

#define CONTEXT_FLOAT_CONTROL_OFFSET  CONTEXT_F31+SIZEOF_RISCV64_FPR
#define CONTEXT_Size         ((CONTEXT_FPU_OFFSET + 8 + 8 + 0xf) & ~0xf)

#endif
