/* dockmanager-settings.c generated by valac 0.11.6, the Vala compiler
 * generated from dockmanager-settings.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <gio/gio.h>
#include <libdesktop-agnostic/vfs.h>
#include <gdk/gdk.h>


#define DOCK_MANAGER_TYPE_ABSTRACT_TILE_OBJECT (dock_manager_abstract_tile_object_get_type ())
#define DOCK_MANAGER_ABSTRACT_TILE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCK_MANAGER_TYPE_ABSTRACT_TILE_OBJECT, DockManagerAbstractTileObject))
#define DOCK_MANAGER_ABSTRACT_TILE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCK_MANAGER_TYPE_ABSTRACT_TILE_OBJECT, DockManagerAbstractTileObjectClass))
#define DOCK_MANAGER_IS_ABSTRACT_TILE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCK_MANAGER_TYPE_ABSTRACT_TILE_OBJECT))
#define DOCK_MANAGER_IS_ABSTRACT_TILE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCK_MANAGER_TYPE_ABSTRACT_TILE_OBJECT))
#define DOCK_MANAGER_ABSTRACT_TILE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCK_MANAGER_TYPE_ABSTRACT_TILE_OBJECT, DockManagerAbstractTileObjectClass))

typedef struct _DockManagerAbstractTileObject DockManagerAbstractTileObject;
typedef struct _DockManagerAbstractTileObjectClass DockManagerAbstractTileObjectClass;
typedef struct _DockManagerAbstractTileObjectPrivate DockManagerAbstractTileObjectPrivate;

#define DOCK_MANAGER_TYPE_HELPER_TILE_OBJECT (dock_manager_helper_tile_object_get_type ())
#define DOCK_MANAGER_HELPER_TILE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCK_MANAGER_TYPE_HELPER_TILE_OBJECT, DockManagerHelperTileObject))
#define DOCK_MANAGER_HELPER_TILE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCK_MANAGER_TYPE_HELPER_TILE_OBJECT, DockManagerHelperTileObjectClass))
#define DOCK_MANAGER_IS_HELPER_TILE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCK_MANAGER_TYPE_HELPER_TILE_OBJECT))
#define DOCK_MANAGER_IS_HELPER_TILE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCK_MANAGER_TYPE_HELPER_TILE_OBJECT))
#define DOCK_MANAGER_HELPER_TILE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCK_MANAGER_TYPE_HELPER_TILE_OBJECT, DockManagerHelperTileObjectClass))

typedef struct _DockManagerHelperTileObject DockManagerHelperTileObject;
typedef struct _DockManagerHelperTileObjectClass DockManagerHelperTileObjectClass;
typedef struct _DockManagerHelperTileObjectPrivate DockManagerHelperTileObjectPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DOCK_MANAGER_TYPE_HELPER_INFO (dock_manager_helper_info_get_type ())
typedef struct _DockManagerHelperInfo DockManagerHelperInfo;

#define DOCK_MANAGER_TYPE_PREFERENCES_BIN (dock_manager_preferences_bin_get_type ())
#define DOCK_MANAGER_PREFERENCES_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCK_MANAGER_TYPE_PREFERENCES_BIN, DockManagerPreferencesBin))
#define DOCK_MANAGER_PREFERENCES_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCK_MANAGER_TYPE_PREFERENCES_BIN, DockManagerPreferencesBinClass))
#define DOCK_MANAGER_IS_PREFERENCES_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCK_MANAGER_TYPE_PREFERENCES_BIN))
#define DOCK_MANAGER_IS_PREFERENCES_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCK_MANAGER_TYPE_PREFERENCES_BIN))
#define DOCK_MANAGER_PREFERENCES_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCK_MANAGER_TYPE_PREFERENCES_BIN, DockManagerPreferencesBinClass))

typedef struct _DockManagerPreferencesBin DockManagerPreferencesBin;
typedef struct _DockManagerPreferencesBinClass DockManagerPreferencesBinClass;
typedef struct _DockManagerPreferencesBinPrivate DockManagerPreferencesBinPrivate;

#define DOCK_MANAGER_TYPE_SEARCH_ENTRY (dock_manager_search_entry_get_type ())
#define DOCK_MANAGER_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCK_MANAGER_TYPE_SEARCH_ENTRY, DockManagerSearchEntry))
#define DOCK_MANAGER_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCK_MANAGER_TYPE_SEARCH_ENTRY, DockManagerSearchEntryClass))
#define DOCK_MANAGER_IS_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCK_MANAGER_TYPE_SEARCH_ENTRY))
#define DOCK_MANAGER_IS_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCK_MANAGER_TYPE_SEARCH_ENTRY))
#define DOCK_MANAGER_SEARCH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCK_MANAGER_TYPE_SEARCH_ENTRY, DockManagerSearchEntryClass))

typedef struct _DockManagerSearchEntry DockManagerSearchEntry;
typedef struct _DockManagerSearchEntryClass DockManagerSearchEntryClass;

#define DOCK_MANAGER_TYPE_TILE_VIEW (dock_manager_tile_view_get_type ())
#define DOCK_MANAGER_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCK_MANAGER_TYPE_TILE_VIEW, DockManagerTileView))
#define DOCK_MANAGER_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCK_MANAGER_TYPE_TILE_VIEW, DockManagerTileViewClass))
#define DOCK_MANAGER_IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCK_MANAGER_TYPE_TILE_VIEW))
#define DOCK_MANAGER_IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCK_MANAGER_TYPE_TILE_VIEW))
#define DOCK_MANAGER_TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCK_MANAGER_TYPE_TILE_VIEW, DockManagerTileViewClass))

typedef struct _DockManagerTileView DockManagerTileView;
typedef struct _DockManagerTileViewClass DockManagerTileViewClass;

#define DOCK_MANAGER_TYPE_DAEMON_INTERFACE (dock_manager_daemon_interface_get_type ())
#define DOCK_MANAGER_DAEMON_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCK_MANAGER_TYPE_DAEMON_INTERFACE, DockManagerDaemonInterface))
#define DOCK_MANAGER_IS_DAEMON_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCK_MANAGER_TYPE_DAEMON_INTERFACE))
#define DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DOCK_MANAGER_TYPE_DAEMON_INTERFACE, DockManagerDaemonInterfaceIface))

typedef struct _DockManagerDaemonInterface DockManagerDaemonInterface;
typedef struct _DockManagerDaemonInterfaceIface DockManagerDaemonInterfaceIface;

#define DOCK_MANAGER_PREFERENCES_BIN_TYPE_HELPER_FILTER_TYPE (dock_manager_preferences_bin_helper_filter_type_get_type ())
#define __g_list_free__dock_manager_helper_info_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__dock_manager_helper_info_free0_ (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _DockManagerAbstractTileObject {
	GObject parent_instance;
	DockManagerAbstractTileObjectPrivate * priv;
};

struct _DockManagerAbstractTileObjectClass {
	GObjectClass parent_class;
	void (*active_changed) (DockManagerAbstractTileObject* self);
};

struct _DockManagerHelperTileObject {
	DockManagerAbstractTileObject parent_instance;
	DockManagerHelperTileObjectPrivate * priv;
};

struct _DockManagerHelperTileObjectClass {
	DockManagerAbstractTileObjectClass parent_class;
};

struct _DockManagerHelperTileObjectPrivate {
	GtkButton* help_button;
	GtkButton* uninstall_button;
	gchar* _helper_path;
};

struct _DockManagerHelperInfo {
	gchar* path;
	gchar* name;
	gchar* description;
	gchar* icon_name;
	gchar* app_name;
	gchar* dbus_name;
	gboolean app_available;
	gboolean enabled;
	gboolean running;
};

struct _DockManagerPreferencesBin {
	GtkVBox parent_instance;
	DockManagerPreferencesBinPrivate * priv;
};

struct _DockManagerPreferencesBinClass {
	GtkVBoxClass parent_class;
};

struct _DockManagerDaemonInterfaceIface {
	GTypeInterface parent_iface;
	DockManagerHelperInfo* (*get_all_helpers) (DockManagerDaemonInterface* self, int* result_length1, GError** error);
	void (*enable_helper) (DockManagerDaemonInterface* self, const gchar* path, GError** error);
	void (*disable_helper) (DockManagerDaemonInterface* self, const gchar* path, GError** error);
	void (*restart_all) (DockManagerDaemonInterface* self, GError** error);
	void (*install_helper) (DockManagerDaemonInterface* self, const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*install_helper_finish) (DockManagerDaemonInterface* self, GAsyncResult* _res_, GError** error);
	void (*show_preferences) (DockManagerDaemonInterface* self, GError** error);
	void (*embed_preferences) (DockManagerDaemonInterface* self, gint64 xid, GHashTable* hints, GError** error);
};

struct _DockManagerPreferencesBinPrivate {
	GtkScrolledWindow* scroll;
	GtkComboBox* combobox;
	DockManagerSearchEntry* search_entry;
	DockManagerTileView* tile_view;
	GList* all_helpers;
	DockManagerDaemonInterface* dbus_interface;
};

typedef enum  {
	DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_USABLE = 0,
	DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_ENABLED,
	DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_DISABLED,
	DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_ALL,
	DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_N_TYPES
} DockManagerPreferencesBinHelperFilterType;


extern gint64 dock_manager_EMBED_XID;
gint64 dock_manager_EMBED_XID = (gint64) 0;
extern gboolean dock_manager_NO_INSTALL;
gboolean dock_manager_NO_INSTALL = FALSE;
static gpointer dock_manager_helper_tile_object_parent_class = NULL;
static gpointer dock_manager_preferences_bin_parent_class = NULL;

GType dock_manager_abstract_tile_object_get_type (void) G_GNUC_CONST;
GType dock_manager_helper_tile_object_get_type (void) G_GNUC_CONST;
#define DOCK_MANAGER_HELPER_TILE_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DOCK_MANAGER_TYPE_HELPER_TILE_OBJECT, DockManagerHelperTileObjectPrivate))
enum  {
	DOCK_MANAGER_HELPER_TILE_OBJECT_DUMMY_PROPERTY,
	DOCK_MANAGER_HELPER_TILE_OBJECT_HELPER_PATH
};
GType dock_manager_helper_info_get_type (void) G_GNUC_CONST;
DockManagerHelperInfo* dock_manager_helper_info_dup (const DockManagerHelperInfo* self);
void dock_manager_helper_info_free (DockManagerHelperInfo* self);
void dock_manager_helper_info_copy (const DockManagerHelperInfo* self, DockManagerHelperInfo* dest);
void dock_manager_helper_info_destroy (DockManagerHelperInfo* self);
DockManagerHelperTileObject* dock_manager_helper_tile_object_new (DockManagerHelperInfo* hi);
DockManagerHelperTileObject* dock_manager_helper_tile_object_construct (GType object_type, DockManagerHelperInfo* hi);
void dock_manager_helper_tile_object_update_state (DockManagerHelperTileObject* self, gboolean enabled, gboolean running);
void dock_manager_abstract_tile_object_set_enabled (DockManagerAbstractTileObject* self, gboolean value);
void dock_manager_abstract_tile_object_set_sub_description_text (DockManagerAbstractTileObject* self, const gchar* value);
const gchar* dock_manager_helper_tile_object_get_helper_path (DockManagerHelperTileObject* self);
static void dock_manager_helper_tile_object_set_helper_path (DockManagerHelperTileObject* self, const gchar* value);
static GObject * dock_manager_helper_tile_object_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dock_manager_abstract_tile_object_set_sub_description_title (DockManagerAbstractTileObject* self, const gchar* value);
void dock_manager_abstract_tile_object_add_user_button (DockManagerAbstractTileObject* self, GtkButton* button);
static void _lambda0_ (DockManagerHelperTileObject* self);
static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self);
void dock_manager_abstract_tile_object_set_add_button_tooltip (DockManagerAbstractTileObject* self, const gchar* value);
void dock_manager_abstract_tile_object_set_remove_button_tooltip (DockManagerAbstractTileObject* self, const gchar* value);
static void dock_manager_helper_tile_object_finalize (GObject* obj);
static void _vala_dock_manager_helper_tile_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dock_manager_helper_tile_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dock_manager_preferences_bin_get_type (void) G_GNUC_CONST;
GType dock_manager_search_entry_get_type (void) G_GNUC_CONST;
GType dock_manager_tile_view_get_type (void) G_GNUC_CONST;
DockManagerDaemonInterface* dock_manager_daemon_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dock_manager_daemon_interface_get_type (void) G_GNUC_CONST;
#define DOCK_MANAGER_PREFERENCES_BIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DOCK_MANAGER_TYPE_PREFERENCES_BIN, DockManagerPreferencesBinPrivate))
enum  {
	DOCK_MANAGER_PREFERENCES_BIN_DUMMY_PROPERTY
};
static GType dock_manager_preferences_bin_helper_filter_type_get_type (void) G_GNUC_UNUSED;
static void _dock_manager_helper_info_free0_ (gpointer var);
static void _g_list_free__dock_manager_helper_info_free0_ (GList* self);
static DockManagerPreferencesBin* dock_manager_preferences_bin_new (void);
static DockManagerPreferencesBin* dock_manager_preferences_bin_construct (GType object_type);
void dock_manager_preferences_bin_run (DockManagerPreferencesBin* self);
#define DOCK_MANAGER_DBUS_UNIQUE_NAME "net.launchpad.DockManager.Daemon"
#define DOCK_MANAGER_DBUS_OBJECT_PATH_NAME "/net/launchpad/DockManager/Daemon"
#define DOCK_MANAGER_DBUS_INTERFACE_NAME "net.launchpad.DockManager.Daemon"
static void dock_manager_preferences_bin_helper_changed (DockManagerPreferencesBin* self, const gchar* path, gboolean enabled, gboolean running);
static void _dock_manager_preferences_bin_helper_changed_dock_manager_daemon_interface_helper_state_changed (DockManagerDaemonInterface* _sender, const gchar* path, gboolean enabled, gboolean running, gpointer self);
DockManagerHelperInfo* dock_manager_daemon_interface_get_all_helpers (DockManagerDaemonInterface* self, int* result_length1, GError** error);
static gint _lambda2_ (DockManagerHelperInfo* a, DockManagerHelperInfo* b);
static gint __lambda2__gcompare_func (gconstpointer a, gconstpointer b);
static void dock_manager_preferences_bin_update_helpers (DockManagerPreferencesBin* self);
static void _vala_DockManagerHelperInfo_array_free (DockManagerHelperInfo* array, gint array_length);
void dock_manager_tile_view_clear (DockManagerTileView* self);
const gchar* dock_manager_search_entry_get_text (DockManagerSearchEntry* self);
void dock_manager_tile_view_append_tile (DockManagerTileView* self, DockManagerAbstractTileObject* tile_obj);
static void _lambda3_ (DockManagerAbstractTileObject* tile_obj, DockManagerPreferencesBin* self);
gboolean dock_manager_abstract_tile_object_get_enabled (DockManagerAbstractTileObject* self);
void dock_manager_daemon_interface_enable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error);
void dock_manager_daemon_interface_disable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error);
static void __lambda3__dock_manager_abstract_tile_object_active_changed (DockManagerAbstractTileObject* _sender, gpointer self);
GList* dock_manager_tile_view_get_tiles (DockManagerTileView* self);
gint dock_manager_preferences_bin_main (gchar** argv, int argv_length1);
static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self);
static gboolean _lambda4_ (void);
static gboolean __lambda4__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static GObject * dock_manager_preferences_bin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _dock_manager_preferences_bin_update_helpers_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
DockManagerSearchEntry* dock_manager_search_entry_new (void);
DockManagerSearchEntry* dock_manager_search_entry_construct (GType object_type);
void dock_manager_search_entry_set_search_timeout (DockManagerSearchEntry* self, gint value);
static void _lambda5_ (DockManagerPreferencesBin* self);
static void __lambda5__dock_manager_search_entry_search (DockManagerSearchEntry* _sender, const gchar* text, gpointer self);
static void _lambda6_ (DockManagerPreferencesBin* self);
static void __lambda6__dock_manager_search_entry_clear (DockManagerSearchEntry* _sender, gpointer self);
DockManagerTileView* dock_manager_tile_view_new (void);
DockManagerTileView* dock_manager_tile_view_construct (GType object_type);
static void dock_manager_preferences_bin_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry DOCK_MANAGER_options[3] = {{"embed-xid", 'x', 0, G_OPTION_ARG_INT64, &dock_manager_EMBED_XID, "Window XID where the GUI will be embedded.", ""}, {"no-install", 'i', 0, G_OPTION_ARG_NONE, &dock_manager_NO_INSTALL, "Don't display the install button.", ""}, {NULL}};

DockManagerHelperTileObject* dock_manager_helper_tile_object_construct (GType object_type, DockManagerHelperInfo* hi) {
	DockManagerHelperTileObject * self = NULL;
	self = (DockManagerHelperTileObject*) g_object_new (object_type, "name", (*hi).name, "description", (*hi).description, "icon", (*hi).icon_name, "helper-path", (*hi).path, NULL);
	return self;
}


DockManagerHelperTileObject* dock_manager_helper_tile_object_new (DockManagerHelperInfo* hi) {
	return dock_manager_helper_tile_object_construct (DOCK_MANAGER_TYPE_HELPER_TILE_OBJECT, hi);
}


void dock_manager_helper_tile_object_update_state (DockManagerHelperTileObject* self, gboolean enabled, gboolean running) {
	g_return_if_fail (self != NULL);
	dock_manager_abstract_tile_object_set_enabled ((DockManagerAbstractTileObject*) self, enabled);
	if (!enabled) {
		dock_manager_abstract_tile_object_set_sub_description_text ((DockManagerAbstractTileObject*) self, "Disabled");
	} else {
		const gchar* _tmp0_ = NULL;
		if (running) {
			_tmp0_ = "Running";
		} else {
			_tmp0_ = "Enabled";
		}
		dock_manager_abstract_tile_object_set_sub_description_text ((DockManagerAbstractTileObject*) self, _tmp0_);
	}
}


const gchar* dock_manager_helper_tile_object_get_helper_path (DockManagerHelperTileObject* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_helper_path;
	return result;
}


static void dock_manager_helper_tile_object_set_helper_path (DockManagerHelperTileObject* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_helper_path);
	self->priv->_helper_path = _tmp1_;
	g_object_notify ((GObject *) self, "helper-path");
}


static void _lambda0_ (DockManagerHelperTileObject* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* id;
	gchar* _tmp7_ = NULL;
	gchar* address;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_path_get_basename (self->priv->_helper_path);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_tmp5_ = g_strdup (_tmp4_[0]);
	id = (_tmp6_ = _tmp5_, _tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL), _g_free0 (_tmp1_), _tmp6_);
	_tmp7_ = g_strdup_printf ("http://wiki.go-docky.com/index.php?title=%s_Helper", id);
	address = _tmp7_;
	_tmp8_ = g_strdup_printf ("xdg-open %s", address);
	_tmp9_ = _tmp8_;
	g_spawn_command_line_async (_tmp9_, &_inner_error_);
	_g_free0 (_tmp9_);
	if (_inner_error_ != NULL) {
		_g_free0 (address);
		_g_free0 (id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (address);
	_g_free0 (id);
}


static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda0_ (self);
}


static GObject * dock_manager_helper_tile_object_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DockManagerHelperTileObject * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkImage* _tmp6_ = NULL;
	GtkImage* _tmp7_;
	parent_class = G_OBJECT_CLASS (dock_manager_helper_tile_object_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DOCK_MANAGER_HELPER_TILE_OBJECT (obj);
	dock_manager_abstract_tile_object_set_sub_description_title ((DockManagerAbstractTileObject*) self, "Status");
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_str_has_prefix (self->priv->_helper_path, _tmp0_);
	if (_tmp1_) {
		GtkButton* _tmp2_ = NULL;
		GtkButton* _tmp3_;
		_tmp2_ = (GtkButton*) gtk_button_new_with_label ("Uninstall");
		_tmp3_ = g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->uninstall_button);
		self->priv->uninstall_button = _tmp3_;
		dock_manager_abstract_tile_object_add_user_button ((DockManagerAbstractTileObject*) self, self->priv->uninstall_button);
	}
	_tmp4_ = (GtkButton*) gtk_button_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->help_button);
	self->priv->help_button = _tmp5_;
	_tmp6_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_HELP, GTK_ICON_SIZE_SMALL_TOOLBAR);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	gtk_button_set_image (self->priv->help_button, (GtkWidget*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) self->priv->help_button, "About this helper");
	g_signal_connect_object (self->priv->help_button, "clicked", (GCallback) __lambda0__gtk_button_clicked, self, 0);
	dock_manager_abstract_tile_object_add_user_button ((DockManagerAbstractTileObject*) self, self->priv->help_button);
	dock_manager_abstract_tile_object_set_add_button_tooltip ((DockManagerAbstractTileObject*) self, "Enable this helper");
	dock_manager_abstract_tile_object_set_remove_button_tooltip ((DockManagerAbstractTileObject*) self, "Disable this helper");
	return obj;
}


static void dock_manager_helper_tile_object_class_init (DockManagerHelperTileObjectClass * klass) {
	dock_manager_helper_tile_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DockManagerHelperTileObjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dock_manager_helper_tile_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dock_manager_helper_tile_object_set_property;
	G_OBJECT_CLASS (klass)->constructor = dock_manager_helper_tile_object_constructor;
	G_OBJECT_CLASS (klass)->finalize = dock_manager_helper_tile_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCK_MANAGER_HELPER_TILE_OBJECT_HELPER_PATH, g_param_spec_string ("helper-path", "helper-path", "helper-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dock_manager_helper_tile_object_instance_init (DockManagerHelperTileObject * self) {
	self->priv = DOCK_MANAGER_HELPER_TILE_OBJECT_GET_PRIVATE (self);
}


static void dock_manager_helper_tile_object_finalize (GObject* obj) {
	DockManagerHelperTileObject * self;
	self = DOCK_MANAGER_HELPER_TILE_OBJECT (obj);
	_g_object_unref0 (self->priv->help_button);
	_g_object_unref0 (self->priv->uninstall_button);
	_g_free0 (self->priv->_helper_path);
	G_OBJECT_CLASS (dock_manager_helper_tile_object_parent_class)->finalize (obj);
}


GType dock_manager_helper_tile_object_get_type (void) {
	static volatile gsize dock_manager_helper_tile_object_type_id__volatile = 0;
	if (g_once_init_enter (&dock_manager_helper_tile_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DockManagerHelperTileObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dock_manager_helper_tile_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DockManagerHelperTileObject), 0, (GInstanceInitFunc) dock_manager_helper_tile_object_instance_init, NULL };
		GType dock_manager_helper_tile_object_type_id;
		dock_manager_helper_tile_object_type_id = g_type_register_static (DOCK_MANAGER_TYPE_ABSTRACT_TILE_OBJECT, "DockManagerHelperTileObject", &g_define_type_info, 0);
		g_once_init_leave (&dock_manager_helper_tile_object_type_id__volatile, dock_manager_helper_tile_object_type_id);
	}
	return dock_manager_helper_tile_object_type_id__volatile;
}


static void _vala_dock_manager_helper_tile_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DockManagerHelperTileObject * self;
	self = DOCK_MANAGER_HELPER_TILE_OBJECT (object);
	switch (property_id) {
		case DOCK_MANAGER_HELPER_TILE_OBJECT_HELPER_PATH:
		g_value_set_string (value, dock_manager_helper_tile_object_get_helper_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dock_manager_helper_tile_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DockManagerHelperTileObject * self;
	self = DOCK_MANAGER_HELPER_TILE_OBJECT (object);
	switch (property_id) {
		case DOCK_MANAGER_HELPER_TILE_OBJECT_HELPER_PATH:
		dock_manager_helper_tile_object_set_helper_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GType dock_manager_preferences_bin_helper_filter_type_get_type (void) {
	static volatile gsize dock_manager_preferences_bin_helper_filter_type_type_id__volatile = 0;
	if (g_once_init_enter (&dock_manager_preferences_bin_helper_filter_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_USABLE, "DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_USABLE", "usable"}, {DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_ENABLED, "DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_ENABLED", "enabled"}, {DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_DISABLED, "DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_DISABLED", "disabled"}, {DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_ALL, "DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_ALL", "all"}, {DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_N_TYPES, "DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_N_TYPES", "n-types"}, {0, NULL, NULL}};
		GType dock_manager_preferences_bin_helper_filter_type_type_id;
		dock_manager_preferences_bin_helper_filter_type_type_id = g_enum_register_static ("DockManagerPreferencesBinHelperFilterType", values);
		g_once_init_leave (&dock_manager_preferences_bin_helper_filter_type_type_id__volatile, dock_manager_preferences_bin_helper_filter_type_type_id);
	}
	return dock_manager_preferences_bin_helper_filter_type_type_id__volatile;
}


static void _dock_manager_helper_info_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dock_manager_helper_info_free (var), NULL));
}


static void _g_list_free__dock_manager_helper_info_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _dock_manager_helper_info_free0_, NULL);
	g_list_free (self);
}


static DockManagerPreferencesBin* dock_manager_preferences_bin_construct (GType object_type) {
	DockManagerPreferencesBin * self = NULL;
	self = (DockManagerPreferencesBin*) g_object_new (object_type, "spacing", 6, NULL);
	return self;
}


static DockManagerPreferencesBin* dock_manager_preferences_bin_new (void) {
	return dock_manager_preferences_bin_construct (DOCK_MANAGER_TYPE_PREFERENCES_BIN);
}


static void _dock_manager_preferences_bin_helper_changed_dock_manager_daemon_interface_helper_state_changed (DockManagerDaemonInterface* _sender, const gchar* path, gboolean enabled, gboolean running, gpointer self) {
	dock_manager_preferences_bin_helper_changed (self, path, enabled, running);
}


static gpointer _dock_manager_helper_info_dup0 (gpointer self) {
	return self ? dock_manager_helper_info_dup (self) : NULL;
}


static gint _lambda2_ (DockManagerHelperInfo* a, DockManagerHelperInfo* b) {
	gint result = 0;
	DockManagerHelperInfo* hi1;
	DockManagerHelperInfo* hi2;
	gint _tmp0_;
	hi1 = (DockManagerHelperInfo*) a;
	hi2 = (DockManagerHelperInfo*) b;
	_tmp0_ = g_strcmp0 ((*hi1).name, (*hi2).name);
	result = _tmp0_;
	return result;
}


static gint __lambda2__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = _lambda2_ (a, b);
	return result;
}


static void _vala_DockManagerHelperInfo_array_free (DockManagerHelperInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dock_manager_helper_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


void dock_manager_preferences_bin_run (DockManagerPreferencesBin* self) {
	DBusGConnection* _tmp0_ = NULL;
	DBusGConnection* connection;
	DockManagerDaemonInterface* _tmp1_;
	gint _tmp2_;
	DockManagerHelperInfo* _tmp3_ = NULL;
	DockManagerHelperInfo* helpers;
	gint helpers_length1;
	gint _helpers_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	connection = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch0_dbus_gerror;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = dock_manager_daemon_interface_dbus_proxy_new (connection, DOCK_MANAGER_DBUS_UNIQUE_NAME, DOCK_MANAGER_DBUS_OBJECT_PATH_NAME);
	_g_object_unref0 (self->priv->dbus_interface);
	self->priv->dbus_interface = _tmp1_;
	g_signal_connect_object (self->priv->dbus_interface, "helper-state-changed", (GCallback) _dock_manager_preferences_bin_helper_changed_dock_manager_daemon_interface_helper_state_changed, self, 0);
	_tmp3_ = dock_manager_daemon_interface_get_all_helpers (self->priv->dbus_interface, &_tmp2_, &_inner_error_);
	helpers = _tmp3_;
	helpers_length1 = _tmp2_;
	_helpers_size_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_dbus_g_connection_unref0 (connection);
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch0_dbus_gerror;
		}
		_dbus_g_connection_unref0 (connection);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		DockManagerHelperInfo* helper_collection;
		int helper_collection_length1;
		int helper_it;
		helper_collection = helpers;
		helper_collection_length1 = helpers_length1;
		for (helper_it = 0; helper_it < helpers_length1; helper_it = helper_it + 1) {
			DockManagerHelperInfo _tmp4_;
			DockManagerHelperInfo* helper;
			helper = (_tmp4_ = helper_collection[helper_it], &_tmp4_);
			{
				DockManagerHelperInfo* _tmp5_;
				_tmp5_ = _dock_manager_helper_info_dup0 (helper);
				self->priv->all_helpers = g_list_append (self->priv->all_helpers, _tmp5_);
			}
		}
	}
	self->priv->all_helpers = g_list_sort (self->priv->all_helpers, __lambda2__gcompare_func);
	dock_manager_preferences_bin_update_helpers (self);
	helpers = (_vala_DockManagerHelperInfo_array_free (helpers, helpers_length1), NULL);
	_dbus_g_connection_unref0 (connection);
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("dockmanager-settings.vala:196: %s", err->message);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda3_ (DockManagerAbstractTileObject* tile_obj, DockManagerPreferencesBin* self) {
	DockManagerAbstractTileObject* _tmp0_;
	DockManagerHelperTileObject* _tmp1_;
	DockManagerHelperTileObject* helper_tile_obj;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (tile_obj != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = tile_obj, DOCK_MANAGER_IS_HELPER_TILE_OBJECT (_tmp0_) ? ((DockManagerHelperTileObject*) _tmp0_) : NULL));
	helper_tile_obj = _tmp1_;
	_tmp2_ = dock_manager_abstract_tile_object_get_enabled ((DockManagerAbstractTileObject*) helper_tile_obj);
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = dock_manager_helper_tile_object_get_helper_path (helper_tile_obj);
		dock_manager_daemon_interface_enable_helper (self->priv->dbus_interface, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (helper_tile_obj);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = dock_manager_helper_tile_object_get_helper_path (helper_tile_obj);
		dock_manager_daemon_interface_disable_helper (self->priv->dbus_interface, _tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (helper_tile_obj);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (helper_tile_obj);
}


static void __lambda3__dock_manager_abstract_tile_object_active_changed (DockManagerAbstractTileObject* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static void dock_manager_preferences_bin_update_helpers (DockManagerPreferencesBin* self) {
	gint _tmp0_;
	DockManagerPreferencesBinHelperFilterType filter;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* search_filter;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	dock_manager_tile_view_clear (self->priv->tile_view);
	_tmp0_ = gtk_combo_box_get_active (self->priv->combobox);
	filter = (DockManagerPreferencesBinHelperFilterType) _tmp0_;
	_tmp1_ = dock_manager_search_entry_get_text (self->priv->search_entry);
	_tmp2_ = g_strdup (_tmp1_);
	search_filter = _tmp2_;
	{
		GList* helper_collection;
		GList* helper_it;
		helper_collection = self->priv->all_helpers;
		for (helper_it = helper_collection; helper_it != NULL; helper_it = helper_it->next) {
			DockManagerHelperInfo* helper;
			helper = (DockManagerHelperInfo*) helper_it->data;
			{
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				DockManagerHelperTileObject* _tmp11_ = NULL;
				DockManagerHelperTileObject* h_tile;
				if (filter == DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_USABLE) {
					_tmp3_ = !(*helper).app_available;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					continue;
				}
				if (filter == DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_ENABLED) {
					_tmp4_ = !(*helper).enabled;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					continue;
				}
				if (filter == DOCK_MANAGER_PREFERENCES_BIN_HELPER_FILTER_TYPE_DISABLED) {
					_tmp5_ = (*helper).enabled;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					continue;
				}
				if (search_filter != NULL) {
					_tmp6_ = g_strcmp0 (search_filter, "") != 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					GRegex* _tmp7_ = NULL;
					GRegex* r;
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_;
					_tmp7_ = g_regex_new (search_filter, G_REGEX_CASELESS, 0, &_inner_error_);
					r = _tmp7_;
					if (_inner_error_ != NULL) {
						_g_free0 (search_filter);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp9_ = g_regex_match (r, (*helper).description, 0, NULL);
					if (!_tmp9_) {
						gboolean _tmp10_;
						_tmp10_ = g_regex_match (r, (*helper).name, 0, NULL);
						_tmp8_ = !_tmp10_;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						_g_regex_unref0 (r);
						continue;
					}
					_g_regex_unref0 (r);
				}
				_tmp11_ = dock_manager_helper_tile_object_new (helper);
				h_tile = _tmp11_;
				dock_manager_helper_tile_object_update_state (h_tile, (*helper).enabled, (*helper).running);
				dock_manager_tile_view_append_tile (self->priv->tile_view, (DockManagerAbstractTileObject*) h_tile);
				g_signal_connect_object ((DockManagerAbstractTileObject*) h_tile, "active-changed", (GCallback) __lambda3__dock_manager_abstract_tile_object_active_changed, self, 0);
				_g_object_unref0 (h_tile);
			}
		}
	}
	_g_free0 (search_filter);
}


static void dock_manager_preferences_bin_helper_changed (DockManagerPreferencesBin* self, const gchar* path, gboolean enabled, gboolean running) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GList* _tmp4_ = NULL;
	GList* tiles;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (enabled) {
		_tmp0_ = "enabled";
	} else {
		_tmp0_ = "disabled";
	}
	if (running) {
		_tmp1_ = "running";
	} else {
		_tmp1_ = "stopped";
	}
	_tmp2_ = g_path_get_basename (path);
	_tmp3_ = _tmp2_;
	g_debug ("dockmanager-settings.vala:253: %s is now %s, [%s]", _tmp3_, _tmp0_, _tmp1_);
	_g_free0 (_tmp3_);
	{
		GList* helper_collection;
		GList* helper_it;
		helper_collection = self->priv->all_helpers;
		for (helper_it = helper_collection; helper_it != NULL; helper_it = helper_it->next) {
			DockManagerHelperInfo* helper;
			helper = (DockManagerHelperInfo*) helper_it->data;
			{
				if (g_strcmp0 ((*helper).path, path) == 0) {
					(*helper).enabled = enabled;
					(*helper).running = running;
				}
			}
		}
	}
	_tmp4_ = dock_manager_tile_view_get_tiles (self->priv->tile_view);
	tiles = _tmp4_;
	{
		GList* to_collection;
		GList* to_it;
		to_collection = tiles;
		for (to_it = to_collection; to_it != NULL; to_it = to_it->next) {
			DockManagerAbstractTileObject* to;
			to = (DockManagerAbstractTileObject*) to_it->data;
			{
				DockManagerAbstractTileObject* _tmp5_;
				DockManagerHelperTileObject* _tmp6_;
				DockManagerHelperTileObject* helper_tile;
				const gchar* _tmp7_ = NULL;
				_tmp6_ = _g_object_ref0 ((_tmp5_ = to, DOCK_MANAGER_IS_HELPER_TILE_OBJECT (_tmp5_) ? ((DockManagerHelperTileObject*) _tmp5_) : NULL));
				helper_tile = _tmp6_;
				_tmp7_ = dock_manager_helper_tile_object_get_helper_path (helper_tile);
				if (g_strcmp0 (path, _tmp7_) == 0) {
					dock_manager_helper_tile_object_update_state (helper_tile, enabled, running);
					_g_object_unref0 (helper_tile);
					break;
				}
				_g_object_unref0 (helper_tile);
			}
		}
	}
	_g_list_free0 (tiles);
}


static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self) {
	gtk_main_quit ();
}


static gboolean _lambda4_ (void) {
	gboolean result = FALSE;
	gtk_main_quit ();
	result = FALSE;
	return result;
}


static gboolean __lambda4__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = _lambda4_ ();
	return result;
}


gint dock_manager_preferences_bin_main (gchar** argv, int argv_length1) {
	gint result = 0;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* context;
	GOptionGroup* _tmp1_ = NULL;
	DockManagerPreferencesBin* _tmp2_ = NULL;
	DockManagerPreferencesBin* prefs_bin;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (" - Dockmanager-settings Options");
	context = _tmp0_;
	g_option_context_add_main_entries (context, DOCK_MANAGER_options, NULL);
	_tmp1_ = gtk_get_option_group (FALSE);
	g_option_context_add_group (context, _tmp1_);
	g_option_context_parse (context, &argv_length1, &argv, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	gtk_init (&argv_length1, &argv);
	desktop_agnostic_vfs_init (&_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	_tmp2_ = dock_manager_preferences_bin_new ();
	prefs_bin = g_object_ref_sink (_tmp2_);
	gtk_widget_show ((GtkWidget*) prefs_bin);
	if (dock_manager_EMBED_XID == 0) {
		GtkWindow* _tmp3_ = NULL;
		GtkWindow* window;
		_tmp3_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
		window = g_object_ref_sink (_tmp3_);
		gtk_window_set_title (window, "Dockmanager preferences");
		gtk_container_add ((GtkContainer*) window, (GtkWidget*) prefs_bin);
		gtk_window_set_default_size (window, 400, 450);
		gtk_container_set_border_width ((GtkContainer*) window, (guint) 12);
		g_signal_connect ((GtkObject*) window, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
		gtk_widget_show ((GtkWidget*) window);
		_g_object_unref0 (window);
	} else {
		GtkPlug* _tmp4_ = NULL;
		GtkPlug* plug;
		_tmp4_ = (GtkPlug*) gtk_plug_new ((GdkNativeWindow) 0);
		plug = g_object_ref_sink (_tmp4_);
		g_signal_connect ((GtkWidget*) plug, "delete-event", (GCallback) __lambda4__gtk_widget_delete_event, NULL);
		gtk_container_add ((GtkContainer*) plug, (GtkWidget*) prefs_bin);
		gtk_plug_construct (plug, (GdkNativeWindow) dock_manager_EMBED_XID);
		gtk_widget_show ((GtkWidget*) plug);
		_g_object_unref0 (plug);
	}
	gtk_main ();
	desktop_agnostic_vfs_shutdown (&_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (prefs_bin);
		goto __catch1_g_error;
	}
	_g_object_unref0 (prefs_bin);
	goto __finally1;
	__catch1_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("dockmanager-settings.vala:327: %s", err->message);
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return dock_manager_preferences_bin_main (argv, argc);
}


static void _dock_manager_preferences_bin_update_helpers_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	dock_manager_preferences_bin_update_helpers (self);
}


static void _lambda5_ (DockManagerPreferencesBin* self) {
	dock_manager_preferences_bin_update_helpers (self);
}


static void __lambda5__dock_manager_search_entry_search (DockManagerSearchEntry* _sender, const gchar* text, gpointer self) {
	_lambda5_ (self);
}


static void _lambda6_ (DockManagerPreferencesBin* self) {
	dock_manager_preferences_bin_update_helpers (self);
}


static void __lambda6__dock_manager_search_entry_clear (DockManagerSearchEntry* _sender, gpointer self) {
	_lambda6_ (self);
}


static GObject * dock_manager_preferences_bin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DockManagerPreferencesBin * self;
	GList* _tmp0_;
	GtkHBox* _tmp1_ = NULL;
	GtkHBox* hbox;
	GtkComboBox* _tmp2_ = NULL;
	GtkComboBox* _tmp3_;
	DockManagerSearchEntry* _tmp4_ = NULL;
	DockManagerSearchEntry* _tmp5_;
	GtkScrolledWindow* _tmp7_ = NULL;
	GtkScrolledWindow* _tmp8_;
	DockManagerTileView* _tmp9_ = NULL;
	DockManagerTileView* _tmp10_;
	parent_class = G_OBJECT_CLASS (dock_manager_preferences_bin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DOCK_MANAGER_PREFERENCES_BIN (obj);
	_tmp0_ = NULL;
	__g_list_free__dock_manager_helper_info_free0_0 (self->priv->all_helpers);
	self->priv->all_helpers = _tmp0_;
	_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkComboBox*) gtk_combo_box_new_text ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->combobox);
	self->priv->combobox = _tmp3_;
	gtk_combo_box_append_text (self->priv->combobox, "Usable");
	gtk_combo_box_append_text (self->priv->combobox, "Enabled");
	gtk_combo_box_append_text (self->priv->combobox, "Disabled");
	gtk_combo_box_append_text (self->priv->combobox, "All");
	gtk_combo_box_set_active (self->priv->combobox, 0);
	g_signal_connect_object (self->priv->combobox, "changed", (GCallback) _dock_manager_preferences_bin_update_helpers_gtk_combo_box_changed, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->combobox, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) hbox, FALSE, TRUE, (guint) 0);
	_tmp4_ = dock_manager_search_entry_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp5_;
	dock_manager_search_entry_set_search_timeout (self->priv->search_entry, 100);
	g_signal_connect_object (self->priv->search_entry, "search", (GCallback) __lambda5__dock_manager_search_entry_search, self, 0);
	g_signal_connect_object (self->priv->search_entry, "clear", (GCallback) __lambda6__dock_manager_search_entry_clear, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->search_entry, TRUE, TRUE, (guint) 0);
	if (dock_manager_NO_INSTALL == FALSE) {
		GtkButton* _tmp6_ = NULL;
		GtkButton* button;
		_tmp6_ = (GtkButton*) gtk_button_new_with_label ("Install");
		button = g_object_ref_sink (_tmp6_);
		gtk_widget_set_sensitive ((GtkWidget*) button, FALSE);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) button, FALSE, TRUE, (guint) 0);
		_g_object_unref0 (button);
	}
	gtk_widget_show_all ((GtkWidget*) hbox);
	_tmp7_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->scroll);
	self->priv->scroll = _tmp8_;
	gtk_scrolled_window_set_policy (self->priv->scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp9_ = dock_manager_tile_view_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->tile_view);
	self->priv->tile_view = _tmp10_;
	gtk_widget_show ((GtkWidget*) self->priv->tile_view);
	gtk_scrolled_window_add_with_viewport (self->priv->scroll, (GtkWidget*) self->priv->tile_view);
	gtk_widget_show ((GtkWidget*) self->priv->scroll);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->scroll, TRUE, TRUE, (guint) 0);
	dock_manager_preferences_bin_run (self);
	_g_object_unref0 (hbox);
	return obj;
}


static void dock_manager_preferences_bin_class_init (DockManagerPreferencesBinClass * klass) {
	dock_manager_preferences_bin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DockManagerPreferencesBinPrivate));
	G_OBJECT_CLASS (klass)->constructor = dock_manager_preferences_bin_constructor;
	G_OBJECT_CLASS (klass)->finalize = dock_manager_preferences_bin_finalize;
}


static void dock_manager_preferences_bin_instance_init (DockManagerPreferencesBin * self) {
	self->priv = DOCK_MANAGER_PREFERENCES_BIN_GET_PRIVATE (self);
}


static void dock_manager_preferences_bin_finalize (GObject* obj) {
	DockManagerPreferencesBin * self;
	self = DOCK_MANAGER_PREFERENCES_BIN (obj);
	_g_object_unref0 (self->priv->scroll);
	_g_object_unref0 (self->priv->combobox);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->tile_view);
	__g_list_free__dock_manager_helper_info_free0_0 (self->priv->all_helpers);
	_g_object_unref0 (self->priv->dbus_interface);
	G_OBJECT_CLASS (dock_manager_preferences_bin_parent_class)->finalize (obj);
}


GType dock_manager_preferences_bin_get_type (void) {
	static volatile gsize dock_manager_preferences_bin_type_id__volatile = 0;
	if (g_once_init_enter (&dock_manager_preferences_bin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DockManagerPreferencesBinClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dock_manager_preferences_bin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DockManagerPreferencesBin), 0, (GInstanceInitFunc) dock_manager_preferences_bin_instance_init, NULL };
		GType dock_manager_preferences_bin_type_id;
		dock_manager_preferences_bin_type_id = g_type_register_static (GTK_TYPE_VBOX, "DockManagerPreferencesBin", &g_define_type_info, 0);
		g_once_init_leave (&dock_manager_preferences_bin_type_id__volatile, dock_manager_preferences_bin_type_id);
	}
	return dock_manager_preferences_bin_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



