// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: policy.proto

package moby_buildkit_v1_sourcepolicy

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// PolicyAction defines the action to take when a source is matched
type PolicyAction int32

const (
	PolicyAction_ALLOW   PolicyAction = 0
	PolicyAction_DENY    PolicyAction = 1
	PolicyAction_CONVERT PolicyAction = 2
)

var PolicyAction_name = map[int32]string{
	0: "ALLOW",
	1: "DENY",
	2: "CONVERT",
}

var PolicyAction_value = map[string]int32{
	"ALLOW":   0,
	"DENY":    1,
	"CONVERT": 2,
}

func (x PolicyAction) String() string {
	return proto.EnumName(PolicyAction_name, int32(x))
}

func (PolicyAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ac3b897852294d6a, []int{0}
}

// AttrMatch defines the condition to match a source attribute
type AttrMatch int32

const (
	AttrMatch_EQUAL    AttrMatch = 0
	AttrMatch_NOTEQUAL AttrMatch = 1
	AttrMatch_MATCHES  AttrMatch = 2
)

var AttrMatch_name = map[int32]string{
	0: "EQUAL",
	1: "NOTEQUAL",
	2: "MATCHES",
}

var AttrMatch_value = map[string]int32{
	"EQUAL":    0,
	"NOTEQUAL": 1,
	"MATCHES":  2,
}

func (x AttrMatch) String() string {
	return proto.EnumName(AttrMatch_name, int32(x))
}

func (AttrMatch) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ac3b897852294d6a, []int{1}
}

// Match type is used to determine how a rule source is matched
type MatchType int32

const (
	// WILDCARD is the default matching type.
	// It may first attempt to due an exact match but will follow up with a wildcard match
	// For something more powerful, use REGEX
	MatchType_WILDCARD MatchType = 0
	// EXACT treats the source identifier as a litteral string match
	MatchType_EXACT MatchType = 1
	// REGEX treats the source identifier as a regular expression
	// With regex matching you can also use match groups to replace values in the destination identifier
	MatchType_REGEX MatchType = 2
)

var MatchType_name = map[int32]string{
	0: "WILDCARD",
	1: "EXACT",
	2: "REGEX",
}

var MatchType_value = map[string]int32{
	"WILDCARD": 0,
	"EXACT":    1,
	"REGEX":    2,
}

func (x MatchType) String() string {
	return proto.EnumName(MatchType_name, int32(x))
}

func (MatchType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ac3b897852294d6a, []int{2}
}

// Rule defines the action(s) to take when a source is matched
type Rule struct {
	Action   PolicyAction `protobuf:"varint,1,opt,name=action,proto3,enum=moby.buildkit.v1.sourcepolicy.PolicyAction" json:"action,omitempty"`
	Selector *Selector    `protobuf:"bytes,2,opt,name=selector,proto3" json:"selector,omitempty"`
	Updates  *Update      `protobuf:"bytes,3,opt,name=updates,proto3" json:"updates,omitempty"`
}

func (m *Rule) Reset()         { *m = Rule{} }
func (m *Rule) String() string { return proto.CompactTextString(m) }
func (*Rule) ProtoMessage()    {}
func (*Rule) Descriptor() ([]byte, []int) {
	return fileDescriptor_ac3b897852294d6a, []int{0}
}
func (m *Rule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Rule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Rule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Rule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule.Merge(m, src)
}
func (m *Rule) XXX_Size() int {
	return m.Size()
}
func (m *Rule) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule.DiscardUnknown(m)
}

var xxx_messageInfo_Rule proto.InternalMessageInfo

func (m *Rule) GetAction() PolicyAction {
	if m != nil {
		return m.Action
	}
	return PolicyAction_ALLOW
}

func (m *Rule) GetSelector() *Selector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *Rule) GetUpdates() *Update {
	if m != nil {
		return m.Updates
	}
	return nil
}

// Update contains updates to the matched build step after rule is applied
type Update struct {
	Identifier string            `protobuf:"bytes,1,opt,name=identifier,proto3" json:"identifier,omitempty"`
	Attrs      map[string]string `protobuf:"bytes,2,rep,name=attrs,proto3" json:"attrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Update) Reset()         { *m = Update{} }
func (m *Update) String() string { return proto.CompactTextString(m) }
func (*Update) ProtoMessage()    {}
func (*Update) Descriptor() ([]byte, []int) {
	return fileDescriptor_ac3b897852294d6a, []int{1}
}
func (m *Update) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Update) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Update.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Update) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Update.Merge(m, src)
}
func (m *Update) XXX_Size() int {
	return m.Size()
}
func (m *Update) XXX_DiscardUnknown() {
	xxx_messageInfo_Update.DiscardUnknown(m)
}

var xxx_messageInfo_Update proto.InternalMessageInfo

func (m *Update) GetIdentifier() string {
	if m != nil {
		return m.Identifier
	}
	return ""
}

func (m *Update) GetAttrs() map[string]string {
	if m != nil {
		return m.Attrs
	}
	return nil
}

// Selector identifies a source to match a policy to
type Selector struct {
	Identifier string `protobuf:"bytes,1,opt,name=identifier,proto3" json:"identifier,omitempty"`
	// MatchType is the type of match to perform on the source identifier
	MatchType   MatchType         `protobuf:"varint,2,opt,name=match_type,json=matchType,proto3,enum=moby.buildkit.v1.sourcepolicy.MatchType" json:"match_type,omitempty"`
	Constraints []*AttrConstraint `protobuf:"bytes,3,rep,name=constraints,proto3" json:"constraints,omitempty"`
}

func (m *Selector) Reset()         { *m = Selector{} }
func (m *Selector) String() string { return proto.CompactTextString(m) }
func (*Selector) ProtoMessage()    {}
func (*Selector) Descriptor() ([]byte, []int) {
	return fileDescriptor_ac3b897852294d6a, []int{2}
}
func (m *Selector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Selector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Selector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Selector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Selector.Merge(m, src)
}
func (m *Selector) XXX_Size() int {
	return m.Size()
}
func (m *Selector) XXX_DiscardUnknown() {
	xxx_messageInfo_Selector.DiscardUnknown(m)
}

var xxx_messageInfo_Selector proto.InternalMessageInfo

func (m *Selector) GetIdentifier() string {
	if m != nil {
		return m.Identifier
	}
	return ""
}

func (m *Selector) GetMatchType() MatchType {
	if m != nil {
		return m.MatchType
	}
	return MatchType_WILDCARD
}

func (m *Selector) GetConstraints() []*AttrConstraint {
	if m != nil {
		return m.Constraints
	}
	return nil
}

// AttrConstraint defines a constraint on a source attribute
type AttrConstraint struct {
	Key       string    `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value     string    `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Condition AttrMatch `protobuf:"varint,3,opt,name=condition,proto3,enum=moby.buildkit.v1.sourcepolicy.AttrMatch" json:"condition,omitempty"`
}

func (m *AttrConstraint) Reset()         { *m = AttrConstraint{} }
func (m *AttrConstraint) String() string { return proto.CompactTextString(m) }
func (*AttrConstraint) ProtoMessage()    {}
func (*AttrConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_ac3b897852294d6a, []int{3}
}
func (m *AttrConstraint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttrConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttrConstraint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AttrConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttrConstraint.Merge(m, src)
}
func (m *AttrConstraint) XXX_Size() int {
	return m.Size()
}
func (m *AttrConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_AttrConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_AttrConstraint proto.InternalMessageInfo

func (m *AttrConstraint) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *AttrConstraint) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *AttrConstraint) GetCondition() AttrMatch {
	if m != nil {
		return m.Condition
	}
	return AttrMatch_EQUAL
}

// Policy is the list of rules the policy engine will perform
type Policy struct {
	Version int64   `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Rules   []*Rule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (m *Policy) Reset()         { *m = Policy{} }
func (m *Policy) String() string { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()    {}
func (*Policy) Descriptor() ([]byte, []int) {
	return fileDescriptor_ac3b897852294d6a, []int{4}
}
func (m *Policy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Policy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Policy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Policy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy.Merge(m, src)
}
func (m *Policy) XXX_Size() int {
	return m.Size()
}
func (m *Policy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy proto.InternalMessageInfo

func (m *Policy) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *Policy) GetRules() []*Rule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func init() {
	proto.RegisterEnum("moby.buildkit.v1.sourcepolicy.PolicyAction", PolicyAction_name, PolicyAction_value)
	proto.RegisterEnum("moby.buildkit.v1.sourcepolicy.AttrMatch", AttrMatch_name, AttrMatch_value)
	proto.RegisterEnum("moby.buildkit.v1.sourcepolicy.MatchType", MatchType_name, MatchType_value)
	proto.RegisterType((*Rule)(nil), "moby.buildkit.v1.sourcepolicy.Rule")
	proto.RegisterType((*Update)(nil), "moby.buildkit.v1.sourcepolicy.Update")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.sourcepolicy.Update.AttrsEntry")
	proto.RegisterType((*Selector)(nil), "moby.buildkit.v1.sourcepolicy.Selector")
	proto.RegisterType((*AttrConstraint)(nil), "moby.buildkit.v1.sourcepolicy.AttrConstraint")
	proto.RegisterType((*Policy)(nil), "moby.buildkit.v1.sourcepolicy.Policy")
}

func init() { proto.RegisterFile("policy.proto", fileDescriptor_ac3b897852294d6a) }

var fileDescriptor_ac3b897852294d6a = []byte{
	// 516 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x93, 0xcd, 0x6e, 0xd3, 0x40,
	0x10, 0xc7, 0xbd, 0x4e, 0xf3, 0xe1, 0x49, 0x14, 0x59, 0x2b, 0x0e, 0x16, 0x12, 0x56, 0x14, 0x84,
	0x88, 0x82, 0x30, 0x6d, 0xb8, 0x14, 0x2e, 0xc8, 0x38, 0x6e, 0x41, 0x4a, 0x13, 0xd8, 0xa6, 0xb4,
	0x1c, 0x10, 0x72, 0x9c, 0x45, 0x58, 0x75, 0x6c, 0xcb, 0x5e, 0x47, 0xf2, 0x8d, 0x47, 0xe0, 0x39,
	0x78, 0x0e, 0x0e, 0x1c, 0xcb, 0x8d, 0x23, 0x4a, 0x5e, 0x04, 0xed, 0x3a, 0x4e, 0xc3, 0xa5, 0xce,
	0xc9, 0x3b, 0xe3, 0xf9, 0xfd, 0xe7, 0x63, 0x67, 0xa1, 0x15, 0x85, 0xbe, 0xe7, 0x66, 0x46, 0x14,
	0x87, 0x2c, 0xc4, 0x0f, 0x16, 0xe1, 0x2c, 0x33, 0x66, 0xa9, 0xe7, 0xcf, 0xaf, 0x3d, 0x66, 0x2c,
	0x8f, 0x8c, 0x24, 0x4c, 0x63, 0x97, 0xe6, 0x41, 0xdd, 0xdf, 0x08, 0x0e, 0x48, 0xea, 0x53, 0x6c,
	0x41, 0xcd, 0x71, 0x99, 0x17, 0x06, 0x1a, 0xea, 0xa0, 0x5e, 0x7b, 0xf0, 0xc4, 0xb8, 0x13, 0x34,
	0xde, 0x89, 0x8f, 0x29, 0x10, 0xb2, 0x41, 0xb1, 0x05, 0x8d, 0x84, 0xfa, 0xd4, 0x65, 0x61, 0xac,
	0xc9, 0x1d, 0xd4, 0x6b, 0x0e, 0x1e, 0x97, 0xc8, 0x9c, 0x6f, 0xc2, 0xc9, 0x16, 0xc4, 0xaf, 0xa0,
	0x9e, 0x46, 0x73, 0x87, 0xd1, 0x44, 0xab, 0x08, 0x8d, 0x47, 0x25, 0x1a, 0x17, 0x22, 0x9a, 0x14,
	0x54, 0xf7, 0x07, 0x82, 0x5a, 0xee, 0xc3, 0x3a, 0x80, 0x37, 0xa7, 0x01, 0xf3, 0xbe, 0x78, 0x34,
	0x16, 0x9d, 0x29, 0x64, 0xc7, 0x83, 0x4f, 0xa0, 0xea, 0x30, 0x16, 0x27, 0x9a, 0xdc, 0xa9, 0xf4,
	0x9a, 0x83, 0xc3, 0xbd, 0x32, 0x19, 0x26, 0x47, 0xec, 0x80, 0xc5, 0x19, 0xc9, 0xf1, 0xfb, 0xc7,
	0x00, 0xb7, 0x4e, 0xac, 0x42, 0xe5, 0x9a, 0x66, 0x9b, 0x74, 0xfc, 0x88, 0xef, 0x41, 0x75, 0xe9,
	0xf8, 0x29, 0x15, 0x53, 0x51, 0x48, 0x6e, 0xbc, 0x94, 0x8f, 0x51, 0xf7, 0x27, 0x82, 0x46, 0x31,
	0x84, 0xd2, 0x72, 0x4f, 0x01, 0x16, 0x0e, 0x73, 0xbf, 0x7e, 0x66, 0x59, 0x94, 0x6b, 0xb5, 0x07,
	0xbd, 0x92, 0x9a, 0xcf, 0x38, 0x30, 0xcd, 0x22, 0x4a, 0x94, 0x45, 0x71, 0xc4, 0x13, 0x68, 0xba,
	0x61, 0x90, 0xb0, 0xd8, 0xf1, 0x02, 0xc6, 0xe7, 0xcc, 0xbb, 0x7f, 0x5a, 0xa2, 0xc4, 0x3b, 0xb4,
	0xb6, 0x14, 0xd9, 0x55, 0xe8, 0x7e, 0x43, 0xd0, 0xfe, 0xff, 0xff, 0xbe, 0x53, 0xc0, 0x27, 0xa0,
	0xb8, 0x61, 0x30, 0xf7, 0xc4, 0xf2, 0x55, 0xf6, 0xea, 0x89, 0x67, 0x12, 0x7d, 0x91, 0x5b, 0xb4,
	0xfb, 0x09, 0x6a, 0xf9, 0x52, 0x62, 0x0d, 0xea, 0x4b, 0x1a, 0x27, 0xc5, 0x32, 0x57, 0x48, 0x61,
	0xe2, 0x17, 0x50, 0x8d, 0x53, 0x9f, 0x16, 0xf7, 0xfd, 0xb0, 0x24, 0x0f, 0x7f, 0x19, 0x24, 0x27,
	0xfa, 0x87, 0xd0, 0xda, 0xdd, 0x79, 0xac, 0x40, 0xd5, 0x1c, 0x8d, 0x26, 0x97, 0xaa, 0x84, 0x1b,
	0x70, 0x30, 0xb4, 0xc7, 0x1f, 0x55, 0x84, 0x9b, 0x50, 0xb7, 0x26, 0xe3, 0x0f, 0x36, 0x99, 0xaa,
	0x72, 0xff, 0x08, 0x94, 0x6d, 0xa1, 0x3c, 0xdc, 0x7e, 0x7f, 0x61, 0x8e, 0x54, 0x09, 0xb7, 0xa0,
	0x31, 0x9e, 0x4c, 0x73, 0x4b, 0x20, 0x67, 0xe6, 0xd4, 0x7a, 0x63, 0x9f, 0xab, 0x72, 0xff, 0x19,
	0x28, 0xdb, 0xfb, 0xe2, 0x71, 0x97, 0x6f, 0x47, 0x43, 0xcb, 0x24, 0x43, 0x55, 0x12, 0x02, 0x57,
	0xa6, 0x35, 0x55, 0x11, 0x3f, 0x12, 0xfb, 0xd4, 0xbe, 0x52, 0xe5, 0xd7, 0xda, 0xaf, 0x95, 0x8e,
	0x6e, 0x56, 0x3a, 0xfa, 0xbb, 0xd2, 0xd1, 0xf7, 0xb5, 0x2e, 0xdd, 0xac, 0x75, 0xe9, 0xcf, 0x5a,
	0x97, 0x66, 0x35, 0xf1, 0xfe, 0x9f, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0xae, 0x7a, 0xeb, 0x6c,
	0x0f, 0x04, 0x00, 0x00,
}

func (m *Rule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Rule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Rule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Updates != nil {
		{
			size, err := m.Updates.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPolicy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Selector != nil {
		{
			size, err := m.Selector.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPolicy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Action != 0 {
		i = encodeVarintPolicy(dAtA, i, uint64(m.Action))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Update) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Update) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Update) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Attrs) > 0 {
		for k := range m.Attrs {
			v := m.Attrs[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintPolicy(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintPolicy(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintPolicy(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Identifier) > 0 {
		i -= len(m.Identifier)
		copy(dAtA[i:], m.Identifier)
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Identifier)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Selector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Selector) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Selector) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for iNdEx := len(m.Constraints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Constraints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.MatchType != 0 {
		i = encodeVarintPolicy(dAtA, i, uint64(m.MatchType))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Identifier) > 0 {
		i -= len(m.Identifier)
		copy(dAtA[i:], m.Identifier)
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Identifier)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AttrConstraint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttrConstraint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttrConstraint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Condition != 0 {
		i = encodeVarintPolicy(dAtA, i, uint64(m.Condition))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Policy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Policy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Policy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for iNdEx := len(m.Rules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Version != 0 {
		i = encodeVarintPolicy(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintPolicy(dAtA []byte, offset int, v uint64) int {
	offset -= sovPolicy(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Rule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Action != 0 {
		n += 1 + sovPolicy(uint64(m.Action))
	}
	if m.Selector != nil {
		l = m.Selector.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	if m.Updates != nil {
		l = m.Updates.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	return n
}

func (m *Update) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Identifier)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if len(m.Attrs) > 0 {
		for k, v := range m.Attrs {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovPolicy(uint64(len(k))) + 1 + len(v) + sovPolicy(uint64(len(v)))
			n += mapEntrySize + 1 + sovPolicy(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Selector) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Identifier)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if m.MatchType != 0 {
		n += 1 + sovPolicy(uint64(m.MatchType))
	}
	if len(m.Constraints) > 0 {
		for _, e := range m.Constraints {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	return n
}

func (m *AttrConstraint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if m.Condition != 0 {
		n += 1 + sovPolicy(uint64(m.Condition))
	}
	return n
}

func (m *Policy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovPolicy(uint64(m.Version))
	}
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	return n
}

func sovPolicy(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPolicy(x uint64) (n int) {
	return sovPolicy(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Rule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Rule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Rule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= PolicyAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Selector == nil {
				m.Selector = &Selector{}
			}
			if err := m.Selector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Updates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Updates == nil {
				m.Updates = &Update{}
			}
			if err := m.Updates.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Update) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Update: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Update: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Identifier", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Identifier = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attrs == nil {
				m.Attrs = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPolicy
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPolicy
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthPolicy
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthPolicy
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPolicy
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthPolicy
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthPolicy
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipPolicy(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthPolicy
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Attrs[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Selector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Selector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Selector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Identifier", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Identifier = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MatchType", wireType)
			}
			m.MatchType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MatchType |= MatchType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constraints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Constraints = append(m.Constraints, &AttrConstraint{})
			if err := m.Constraints[len(m.Constraints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttrConstraint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttrConstraint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttrConstraint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Condition", wireType)
			}
			m.Condition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Condition |= AttrMatch(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Policy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Policy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Policy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &Rule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPolicy(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPolicy
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupPolicy
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthPolicy
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthPolicy        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPolicy          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupPolicy = fmt.Errorf("proto: unexpected end of group")
)
