/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include "din.h"
#include "listeners.h"
#include "beat2value.h"
#include "delay.h"
#include "keyboard_keyboard.h"
#include "fft.h"
#include "ui_list.h"

extern fft fft0;

void wave_listener::edited (curve_editor* ed, int i) {

  extern din din0;
  extern keyboard_keyboard keybd2;
  
  switch (which) {
    case DIN_BOARD:
      din0.wavsol.update ();
      break;
    case KEYBOARD_KEYBOARD:
      keybd2.update_waveform ();
      break;
    case DRONE:
      din0.update_drone_solvers ();
      break;
  }

  if (ed->fft_enabled) {
    fft0.go (ed->curveinfo[i].curve);
  }

  if (ed->samples_enabled) {
    ed->cs.render (ed->curveinfo[i].curve);
  }

}

drone_listener::drone_listener (din* dd) : d (dd) {}

void drone_listener::edited (curve_editor* ed, int i) {
  d->update_drone_solvers ();
}

beat2value_listener::beat2value_listener (beat2value* bv) : beat2value0 (bv) {}

void beat2value_listener::edited (curve_editor* ed, int i) {
  beat2value0->curve_edited ();
}

void morse_code_listener::edited (curve_editor* ed, int i) {}

void delay_listener::edited (curve_editor* ed, int i) {
  sol->update ();
  float dx = 1./(dly->nsamples - 1), x = -dx;
  sol->operator()(x, dx, dly->nsamples, result);
}

attack_listener::attack_listener (keyboard_keyboard* kk) : k (kk) {}

void attack_listener::edited (curve_editor* ed, int i) {
  k->update_attack ();
}

decay_listener::decay_listener (keyboard_keyboard* kk) : k (kk) {}

void decay_listener::edited (curve_editor* ed, int i) {
  k->update_decay ();
}

void velocity_listener::edited (curve_editor* ed, int i) {

  k->velsol.update ();

}
