/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __textboard
#define __textboard

#include <vector>
#include <string>
#include <fstream>
#include "viewwin.h"

struct text {
  std::string txt; // actual text
  float wx, wy;
  int vx, vy; // view coords
  float r, g, b; // color
  int state;
  enum {permanent, temporary};

  int type;
  enum {hlabel=0, vlabel=1, none};

  text (const std::string& t, float xx, float yy, float rr=0.5, float gg=0.5, float bb=0.5, int s = text::temporary, int y = text::none) : txt(t), wx(xx), wy (yy), r(rr), g(gg), b(bb), state (s), type (y) {}

};

struct basic_editor;

struct textboard {
  std::vector<text> texts;
  void draw ();
  void add (const text& t) { texts.push_back (t);}
  void erase (const std::string& s);
  void clear ();
  void refresh (basic_editor* b);
  void load (std::ifstream& file);
  void save (std::ofstream& file);
};

#endif
