/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include "scalelist.h"
#include "scale_info.h"
#include "console.h"
#include "tokenizer.h"
#include "utils.h"
#include "ansi_color_codes.h"

#include <fstream>
#include <iostream>
using namespace std;

bool scale_info::set_tonic (float s) {

  tonic = s;
  lo_tonic = tonic / 2.;
  hi_tonic = tonic * 2.;
  return true;

}

bool scale_info::set_scale (const string& n) {

  // scale exists?
  extern scalelist scalelst;
  scale r;
  if (scalelst.get (n, r) == false) return false;

  // scale exists
  name = r.name;
  num_ranges = r.num_notes - 1;
  last_range = num_ranges - 1;

  // load notes
  notes.resize (r.num_notes);
  tokenizer tz (r.notes);
  for (int i = 0; i < r.num_notes; ++i) tz >> notes[i];

  // load custom tuning if it exists
  if (load_custom_tuning() == false) { // no, load default tuning
    extern map<string, float> INTERVALS;
    intervals = INTERVALS;
  }

  return true;

}

bool scale_info::load_custom_tuning () {

  extern string dotdin;
  string filename = dotdin + name + ".intervals";

  ifstream file (filename.c_str(), ios::in);
  if (!file) {
    cout << FAIL << "!!! couldnt load custom tuning from: " << filename << "; will use defaults. +++" << ENDL;
    return false;
  }

  string ignore;

  int n;
  file >> ignore >> n;

  for (int i = 0; i < n; ++i) {
    string c;
    float f;
    file >> c >> f;
    intervals [c] = f;
  }

  return true;


}

void scale_info::save_custom_tuning () {

  extern string dotdin;
  string filename = dotdin + name + ".intervals";
  ofstream file (filename.c_str(), ios::out);
  if (!file) {
    cout << "!!! could not save custom tuning in " << filename << " !!!" << endl;
    return;
  }

  file << "num_intervals " << intervals.size () << endl;
  for (map<string, float>::iterator i = intervals.begin(), j = intervals.end(); i != j; ++i) {
    pair<string, float> p = *i;
    file << p.first << ' ' << p.second << endl;
  }

}
