/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __font_editor
#define __font_editor

#include "viewwin.h"
#include "ui.h"
#include "point.h"
#include "line.h"
#include "help.h"
#include "curve_editor.h"
#include "glyph.h"
#include "font.h"
#include <map>

struct line_hit {
  int l; // line?
  int v; // vertex?
  line_hit () {
    l = v = -1; // invalid
  }
  line_hit (int ll, int vv) : l(ll), v(vv) {}
  bool operator() () {
    return ( (l > -1) && (v > -1));
  }
};

struct font_editor : curve_editor {

  font& fn;

  int nchars;
  std::string name;

  std::map<char, glyph> glyphs;
  std::vector<char> chars;
  glyph gl;
  std::vector<line> lines;
  int ichar;

  std::vector< point<float> > scratch_points;

  line_hit cur, ins, del;
  bool moving;

  void prep_edit ();
  void prep_save ();
  void edit_char (int i);
  void save_char (int i);

  font_editor (font& f, const std::string& settingsf, const std::string& helpf = "~/.din/font_editor.help");
  virtual ~font_editor ();

  void save_font ();


  bool handle_input ();
  void draw ();
  void draw_lines ();
  void draw_scratch_line ();

  line_hit hittest ();

  void move ();

  void leave ();

};
#endif
