/* -*- Mode: C++; tab-width: 4 -*- */
/* vi: set ts=4 sw=4 noexpandtab: */

/*
 * Copyright (C) 2010 Florian Weimer <fw@deneb.enyo.de>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef DIAGNOSTICS__EXTENSIONS__STACKTRACE__SIGNAL__INCLUDE_GUARD
#define DIAGNOSTICS__EXTENSIONS__STACKTRACE__SIGNAL__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/extensions/stacktrace/namespace.hpp>

#include <signal.h>

DIAGNOSTICS_NAMESPACE_BEGIN;
STACKTRACE_NAMESAPCE_BEGIN;
namespace POSIX {

class Sigset {
  sigset_t sigset;

public:
  Sigset()
  {
    Empty();
  }

  Sigset &Empty()
  {
    sigemptyset(&sigset);
    return *this;
  }

  Sigset &Fill()
  {
    sigfillset(&sigset);
    return *this;
  }

  Sigset &Add(int sig)
  {
    sigaddset(&sigset, sig);
    return *this;
  }


  Sigset &Delete(int sig)
  {
    sigdelset(&sigset, sig);
    return *this;
  }

  sigset_t *GetRaw()
  {
    return &sigset;
  }

  const sigset_t *GetRaw() const
  {
    return &sigset;
  }
};

class SaveSigProcMask {
  sigset_t saved;

  SaveSigProcMask(const SaveSigProcMask &);
  SaveSigProcMask &operator=(const SaveSigProcMask &);

public:
  SaveSigProcMask()
  {
    sigprocmask(0, 0, &saved);
  }

  SaveSigProcMask(const Sigset &block)
  {
    sigprocmask(SIG_BLOCK, block.GetRaw(), &saved);
  }

  const sigset_t &Saved() const
  {
    return saved;
  }

  ~SaveSigProcMask()
  {
    sigprocmask(SIG_SETMASK, &saved, 0);
  }
};

} // Enyo::POSIX
STACKTRACE_NAMESAPCE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

