/*
    Copyright (C) 2008-2010 Stefan Haller

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef WALLPAPERS_H
#define WALLPAPERS_H

#include <config.h>
#include <glib.h>

#include "../misc/xml.h"

extern GPtrArray * wallpapers;


void init_filters(const gchar * filter_string);
void free_filters();

void add_wallpaper(GPtrArray * array, const gchar * filename);
void clear_wallpapers(GPtrArray * array);

void browse_directory(GPtrArray * array, const gchar * dirname, gboolean subfolders);
void scan_files(struct file_node * node);

#endif
