# 圖片檢視器|deepin-image-viewer|

## 概述


圖片檢視器是一款小巧的圖片查看應用軟體。外觀時尚、性能流暢，支援多種圖片格式，隨時想看就看，實用又快捷。

## 使用入門

透過以下方式執行或關閉圖片檢視器，或者建立圖片檢視器的捷徑。

### 執行圖片檢視器

1. 單擊任務欄上的啟動器圖示 ![deepin_launcher](../common/deepin_launcher.svg) ，進入啟動器介面。
2. 上下滾動滑鼠滾輪瀏覽或透過搜尋，找到圖片檢視器 ![viewer](../common/deepin_image_viewer.svg)單擊執行。
3. 右鍵單擊 ![viewer](../common/deepin_image_viewer.svg)，您可以：
 - 單擊 **建立桌面捷徑**，在桌面建立捷徑。
 - 單擊 **釘選到Dock**，將應用程式固定到Dock。
 - 單擊 **開機啟動**，將應用程式添加到開機啟動項，在電腦開機時自動執行該應用。


### 關閉圖片檢視器

- 在圖片檢視器介面單擊  ![icon](../common/close_icon.svg)，關閉圖片檢視器。
- 在任務欄右鍵單擊 ![viewer](../common/deepin_image_viewer.svg)，選擇 **全部關閉** 來關閉圖片檢視器。
- 在圖片檢視器介面單擊 ![icon_menu](../common/icon_menu.svg)，選擇 **離開** 來關閉圖片檢視器。

### 查看快捷鍵

在圖片檢視器介面上，使用快捷鍵 **Ctrl + Shift + ?** 打開快捷鍵預覽介面。

![1|hotkey](fig/d_hotkey.png)

## 圖片檢視

### 開啟圖片
採用以下任一方式開啟圖片。
- 右擊圖片，選擇用圖片檢視工具開啟圖片。
- 設定圖片檢視器為預設的圖片查看程式後，雙擊圖片開啟。
- 執行圖片檢視器後，單擊 **開啟圖片**，選擇文件開啟。
- 執行圖片檢視器後，拖動圖片到圖片檢視器介面，開啟圖片。
- 直接拖動圖片到圖片檢視器圖示上，開啟圖片。

> ![tips](../common/tips.svg)竅門：您可以在控制中心中將圖片檢視器設定為預設的圖片檢視程式，具體操作請參閱 [預設程式設定](dman:///dde#預設程式設定)。

圖片檢視器支援查看BMP、ICO、JPG/JPE/JPEG、PNG、TGA、TIF/TIFF、XPM、GIF、WEBP、CR2、NEF、DNG、RAF、MEF、MRW、XBM、SVG、ORF、MNG等多種格式的圖片。

### 介面介紹

![1|main](fig/d_main.png)

| 圖示                                                   | 名稱       | 說明                   |
| ------------------------------------------------------ | ---------- | ---------------------- |
| ![previous](../common/previous.svg)                    | 上一張     | 顯示上一張圖片。       |
| ![next](../common/next.svg)                            | 下一張     | 顯示下一張圖片。       |
| ![adapt_image](../common/adaptimage.svg)               | 1:1檢視    | 圖片按照實際尺寸顯示。 |
| ![adapt_screen](../common/adaptscreen.svg)             | 適應視窗   | 圖片適應視窗尺寸顯示。 |
| ![ocr](../common/ocr.svg)             | 識別文字 | 識別圖片中的文字。 |
| ![clockwise_rotation](../common/clockwiserotation.svg) | 順時針旋轉 | 圖片順時針旋轉90度。   |
| ![contrarotate](../common/contrarotate.svg)            | 逆時針旋轉 | 圖片逆時針旋轉90度。   |
| ![delete](../common/delete.svg)                        | 刪除       | 刪除目前圖片。         |


> ![notes](../common/notes.svg)說明：如果開啟的是系統圖片，旋轉功能、刪除圖示處於置灰狀態，即不能使用該操作。

### 顯示/隱藏導航視窗

1. 在圖片檢視器介面上，單擊工具列上的 ![adaptimage](../common/adaptimage.svg) 按鈕或滾動滑鼠放大圖片且當圖片超出介面範圍時，介面上會出現導航視窗。

2. 拖動導航視窗內的方框，查看該區域的訊息。

3. 單擊導航視窗上的 **x** 按鈕或在右鍵選單中選擇 **隱藏導航視窗** 關閉導航視窗。

   關閉導航視窗後下次不會再顯示，需在右鍵選單中選擇 **顯示導航視窗** 開啟。

![1|main](fig/d_navigation.png)

### 列印圖片

1. 在圖片檢視器介面上，單擊滑鼠右鍵。
2. 選擇 **列印**。
3. 選擇一個印表機，根據需要設定列印屬性。
4. 選擇 **列印**，將圖片發送到印表機進行列印。

### 識別文字

1. 在圖片檢視器介面，單擊工具列上的按鈕 ![ocr](../common/ocr.svg) 或右鍵單擊圖片，選擇 **識別文字**，彈出圖文識別視窗，識別圖片中的文字。

3. 單擊文字區域可以編輯文字內容；在圖文識別視窗右下角，單擊複製按鈕 ![copy](../common/copy.svg) 將識別到的文字內容複製到剪貼簿；單擊下載按鈕 ![copy](../common/download.svg) 將識別到的文字內容儲存為TXT文件。

   ![ocr](fig/ocr.png)


### 重新命名

1. 在圖片檢視器介面上，單擊滑鼠右鍵。
2. 選擇 **重新命名**。
3. 在跳出視窗內，輸入圖片名稱，單擊 **確定** 完成修改。
>![notes](../common/notes.svg)說明：系統圖片不支援重新命名。

### 幻燈片秀

1. 在圖片檢視器介面上，單擊滑鼠右鍵。
2. 選擇 **幻燈片秀**，圖片將以幻燈片形式全螢幕播放。
3. 按下鍵盤上**Esc** 鍵退出播放。


### 複製圖片

1. 在圖片檢視器介面上，單擊滑鼠右鍵。
2. 選擇 **複製**。
3. 在桌面或者指定位置，單擊滑鼠右鍵。
4. 選擇 **貼上**，將圖片文件複製到該位置。

![0|copy](fig/d_copy.png)


### 旋轉圖片

1. 在圖片檢視器介面上，單擊滑鼠右鍵。
2. 選擇 **順時針旋轉/逆時針旋轉**。
3. 圖片將會順時針轉旋轉90°/逆時針旋轉90°。

![0|rotate](fig/d_rotate.png)


### 設定為桌布

1. 在圖片檢視器介面上，單擊滑鼠右鍵。
2. 選擇 **設定為桌布** 即可將目前圖片設定為桌布。

![0|wallpaper](fig/d_wallpaper.png)

### 開啟檔案位置
1. 在圖片檢視器介面上，單擊滑鼠右鍵。
2. 選擇 **開啟檔案位置**，定位該圖片的存儲位置。

### 查看圖片資訊

1. 在圖片檢視器介面上，單擊滑鼠右鍵。
2. 選擇 **圖片資訊** ，查看圖片詳細資訊。

![info](fig/d_info.png)
### 刪除圖片

透過以下任一方式刪除圖片：

- 單擊圖片檢視器介面上的 ![delete_press](../common/delete.svg) 圖示。
- 右鍵單擊圖片，選擇 **刪除**。
- 在圖片檢視器介面上，按下鍵盤的 **Delete** 鍵。

## 主選單

在主選單中，您可以切換視窗主題、查看說明手冊，了解圖片檢視器的更多訊息。

### 主題

視窗主題包含亮色主題、暗色主題和系統主題。

1. 在圖片檢視器介面，單擊  ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **主題**，選擇一個主題顏色。

### 說明

查看說明手冊，進一步了解和使用圖片檢視器。

1. 在圖片檢視器介面，單擊  ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **說明**。
3. 查看圖片檢視器的說明手冊。

### 關於

1. 在圖片檢視器介面，單擊  ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **關於**。
3. 查看圖片檢視器的版本和介紹。

### 離開

1. 在圖片檢視器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **離開**。   
