/*

Author:  Bob Dean
Copyright (c) 1999, 2000, 2001


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public Licensse as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#ifdef __cplusplus
	extern "C"
	{
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <stdarg.h>
#include <sys/shm.h>
#include <glib.h>
#include <math.h>
#include <dbsoundcard.h>
#include <dbchannel.h>
#include <dbdebug.h>
#include <dbaudiolib.h>

#include "prototypes.h"

		/* variables to access DBMix channels shared memory */
		extern  int shmid, sysshmid;
		extern dbfsd_data * sysdata;
		extern local_channel * local_channels;
		/* static local_channel * cue_channels; */
		extern local_channel * ch;

		extern int errno;
		extern int debug_level; /* declared in debug module */

		/*
		  DBAudio_Sample_Record - enable sample recording for current audio stream
		 */
		int DBAudio_Sampler_Record()
		{
			int err;

			err = SUCCESS;

			/* init channel sample control variables */
			ch->sampler_size = 0;
			ch->sampler_readoffset = 0;
			ch->sampler_startoffset = 0;

			/* set record */
			ch->sampler_state = SAMPLER_RECORD;

			return err;
		}


		/*
		  DBAudio_Sample_Stop - stop sample recording/playback for current audio stream
		 */
		int DBAudio_Sampler_Stop()
		{
			int err;

			err = SUCCESS;

			ch->sampler_state = SAMPLER_READY;

			return err;
		}

		/*
		  DBAudio_Sampler_Play_Loop - enable looping sample playback
		 */
		int DBAudio_Sampler_Loop()
		{
			int err;

			err = SUCCESS;

			/* if we are already playing a single sample, reset.
			 otherwise, start loop at current position in sample playback */
			/* Note that the loop state is not checked for, this will allow
               the user to easially restart the loop at the begining of the
               sample. Sometimes a neat DJ effect. */
			if (ch->sampler_state != SAMPLER_PLAY_SINGLE)
			{
				ch->sampler_readoffset = ch->sampler_startoffset;
			}

			ch->sampler_state = SAMPLER_PLAY_LOOP;

			return err;
		}


		/*
		  DBAudio_Sampler_Play_Single - enable a single sample playback
		 */
		int DBAudio_Sampler_Single()
		{
			int err;

			err = SUCCESS;

			/* sampler mode is not checked here, as it is assumed that 
               the User wants the single shot of a sample to override all others */
			ch->sampler_readoffset = ch->sampler_startoffset;
			ch->sampler_state = SAMPLER_PLAY_SINGLE;

			return err;
		}

		/*
		  DBAudio_Sample_Get_Offsets - get the start and end offsets within the
               sample buffer
		 */
		int DBAudio_Sampler_Get_Offsets(int * start_offset, int * end_offset)
		{
			int err;

			err = SUCCESS;

			/* convert char buffer offsets into number of samples */
			*start_offset = ch->sampler_startoffset / 4;
			*end_offset = ch->sampler_endoffset / 4;

			return err;
		}

		/*
		  DBAudio_Sample_Set-OFfsets - set the start and end offsets within the
                sample buffer
		 */
		int DBAudio_Sampler_Set_Offsets(int start_offset, int end_offset)
		{
			int err;

			err = SUCCESS;

			/* convert number of samples to char buffer indexes */
			start_offset *= 4;
			end_offset *= 4;
			
			if (start_offset > end_offset)
			{
				err = ERROR_BAD_PARAM;
				goto cleanup;
			}

			if (start_offset > ch->sampler_size)
			{
				err = ERROR_BAD_PARAM;
				goto cleanup;
			}

			ch->sampler_startoffset = start_offset;
			ch->sampler_endoffset = end_offset;

		cleanup:

			return err;
		}


		/*
		  DBAudio_Sampler_Get_Size - Get total number of samples in sample buffer
		 */
		int DBAudio_Sampler_Get_Size(int * size)
		{
			int err;

			err = SUCCESS;

			/* convert size of char buffer to number of samples */
			*size = ch->sampler_size / 4;

			return err;
		}

		/*
		  DBAudio_Sampler_Get_State - Get the current state of the sampler
		 */
	    sampler_state DBAudio_Sampler_Get_State()
		{
			return ch->sampler_state;
		}

		/*
		  DBAudio_Sample_Save - save sample using provided filename
		*/
		int DBAudio_Sampler_Save(char * filename)
		{
			int    err;
			int    fid;
			char   header[512];
			int    count;
			char * tempbuf;

			err = SUCCESS;
			fid = 0;

			/* open output file */
			if ((fid = open(filename,O_CREAT | O_WRONLY,0777)) == -1)
			{
				perror("DBAudiolib Sample Save: file creation failed.");
				err = -1;
				goto cleanup;
			}

/* 			Debug("\nSAVE SAMPLE HEADER: "); */
/* 			Debug("time:        %f",ch->sampler_time); */
/* 			Debug("bufsize:     %d",ch->sampler_bufsize); */
/* 			Debug("size:        %d",ch->sampler_size); */
/* 			Debug("readoffset:  %d",ch->sampler_readoffset); */
/* 			Debug("startoffset: %d",ch->sampler_startoffset); */
/* 			Debug("endoffset:   %d",ch->sampler_endoffset); */

			/* create header */
			sprintf(header,"%s %f %d %d %d %d %d %c",
					"DBMix ",
					ch->sampler_time,
					ch->sampler_bufsize,
					ch->sampler_size,
					ch->sampler_readoffset,
					ch->sampler_startoffset,
					ch->sampler_endoffset,
					'\0');

			/* write header */
			if ((err = write(fid,header,512)) == -1)
			{
				perror("DBAudiolib Sample Save: header write failed");
				goto cleanup;
			}
			
			count = 0;
			tempbuf = ch->sampler_buf;

			/* write sample */
			while (tempbuf < (ch->sampler_buf + ch->sampler_bufsize))
			{
				count = 4096;
				
				if ((err = write(fid,tempbuf,count)) == -1)
				{
					perror("DBAudiolib Sample Save: sample write failed");
					goto cleanup;
				}

				/* incr pointer by number of bytes written */
				tempbuf += err;
			}

			/* tell mixer that op is done */
			sysdata->sampler_op_flag = 0;

		cleanup:

			if (fid != 0)
			{
				close(fid);
			}

			return err;
		}


		/*
		  DBAudio_Sample_Load - load sample using provided filename
		 */
		int DBAudio_Sampler_Load(char * filename)
		{
			int    err;
			int    fid;
			char   header[512];
			char   dbmixname[128];
			char * tempbuf;
			int    count;
			int    num_left;
			
			err = SUCCESS;
			fid = 0;

			/* open output file */
			if ((fid = open(filename,O_RDONLY)) == -1)
			{
				err = -1;
				perror("DBAudiolib Sample Load: open failed");
				goto cleanup;
			}

			/* read header */
			if ((err = read(fid,header,512)) == -1)
			{
				perror("DBAudiolib Sample Load: header read failed.");
				goto cleanup;
			}

			/* parse header */
			sscanf(header,"%s %f %d %d %d %d %d",
				   dbmixname,
				   &(ch->sampler_time),
				   &(ch->sampler_bufsize),
				   &(ch->sampler_size),
				   &(ch->sampler_readoffset),
				   &(ch->sampler_startoffset),
				   &(ch->sampler_endoffset));

			count = 0;
			tempbuf = ch->sampler_buf;
			num_left = ch->sampler_bufsize;

			while (num_left > 0)
			{
				if (num_left > 4096)
				{
					count = 4096;
				}
				else
				{
					count = num_left;
				}

				if ((err = read(fid,tempbuf,count)) == -1)
				{
					perror("DBAudiolib Sample Load: read failed!!!");
					goto cleanup;
				}

				tempbuf += err;
				num_left -= err;
			}

			/* tell mixer that operation is done */
			sysdata->sampler_op_flag = 0;

			ch->sampler_state = SAMPLER_READY;

		cleanup:

			if (fid != 0)
			{
				close(fid);
			}

			return err;	
		}


#ifdef __cplusplus
	}
#endif
