/*
  xmms - DBMix output plugin

   Description: 
   ============
   This program is an output plugin for xmms v0.9 or greater.
   The plugin allows a data stream to be generated using xmms,
   an to be sent to the DBMix sound daemon for 
   Fourier/Additive Synthesis.  This allows a user may output multiple
   audio streams concurrently to the same audio device.
  

   Original Output Plugin code: (C) 1998-1999 Mikael Alm, Olle Hallnas,
                                Thomas Nillson and 4Front Technologies

   Modifications by Robert Michael S Dean, (c) 1999-2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "dbmixout.h"
#include <gtk/gtk.h>
#include <dbchannel.h>

static GtkWidget *dialog, *button, *label;

void dbmixout_about_close_cb(GtkWidget * w, gpointer data)
{
	gtk_widget_destroy(dialog);
}

void dbmix_about(void)
{
	char tempstr[1024];

	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), "About DBMix Output Plugin");
	gtk_container_border_width(GTK_CONTAINER(dialog), 5);

	sprintf(tempstr,
"DBMix Digital Audio Mixing System %s\n\n \
Based off of the OSS Output plugin for xmms by \n \
Mikael Alm, Olle Hallnas, Thomas Nillson and 4Front Technologies\n\n
All additional code to allow the plugin to work with\n \
DBMix %s\n\n
This program is free software; you can redistribute it and/or modify\n\
it under the terms of the GNU General Public License as published by\n\
the Free Software Foundation; either version 2 of the License, or\n\
(at your option) any later version.\n\
\n\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n\
\n\
You should have received a copy of the GNU General Public License\n\
along with this program; if not, write to the Free Software\n\
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,\n\
USA.",DBMIX_VERSION,DBMIX_COPYRIGHT);

	label = gtk_label_new(tempstr);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
	gtk_widget_show(label);

	button = gtk_button_new_with_label(" Close ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(dbmixout_about_close_cb), NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	gtk_widget_show(dialog);
	gtk_widget_grab_focus(button);
}
