.\" DO NOT MODIFY THIS FILE!  It was generated by help2man 1.40.4.
.TH DTEST "1" "July 2013" "dateutils 0.2.5" "User Commands"
.SH NAME
dtest - Compare dates or times
.SH SYNOPSIS
.B dtest
[\fIOPTION\fR]... \fIDATE/TIME1 OP DATE/TIME2\fR
.SH DESCRIPTION
dtest 0.2.5
.PP
Like test(1) but for dates.
.TP
\fB\-h\fR, \fB\-\-help\fR
Print help and exit
.TP
\fB\-V\fR, \fB\-\-version\fR
Print version and exit
.TP
\fB\-q\fR, \fB\-\-quiet\fR
Suppress message about date/time and duration
parser errors.
.TP
\fB\-i\fR, \fB\-\-input\-format\fR=\fISTRING\fR
Input format, can be used multiple times.
Each date/time will be passed to the input
format parsers in the order they are given, if a
date/time can be read successfully with a given
input format specifier string, that value will
be used.
.TP
\fB\-e\fR, \fB\-\-backslash\-escapes\fR
Enable interpretation of backslash escapes in the
output and input format specifier strings.
.IP
Group: op
.IP
Following operations are supported
.TP
\fB\-\-eq\fR
DATE/TIME1 is the same as DATE/TIME2
.TP
\fB\-\-ne\fR
DATE/TIME1 is not the same as DATE/TIME2
.TP
\fB\-\-gt\fR
DATE/TIME1 is newer than DATE/TIME2
.TP
\fB\-\-lt\fR
DATE/TIME1 is older than DATE/TIME2
.TP
\fB\-\-ge\fR
DATE/TIME1 is newer than or equals DATE/TIME2
.TP
\fB\-\-le\fR
DATE/TIME1 is older than or equals DATE/TIME2
.TP
\fB\-\-nt\fR
DATE/TIME1 is newer than DATE/TIME2
.TP
\fB\-\-ot\fR
DATE/TIME1 is older than DATE/TIME2
.TP
\fB\-\-cmp\fR
compare DATE/TIME1 to DATE/TIME2, return with 0 if
equal, 1 if left argument was newer and 2 if
right argument was newer
.SH EXAMPLES

  % dtest 2012-03-01 --gt 2012-03-02 || echo "false"
  false


  % dtest 2012-03-01 --ot 2012-03-02 && echo "true"
  true


  % dtest 2012-03-01 --cmp 2012-03-02; echo $?
  2


  % dtest 2012-03-02 --cmp 2012-03-02; echo $?
  0


  % dtest 2012-03-02 --cmp 2012-03-01; echo $?
  1


  % dtest 12:00:04 --gt 11:22:33 && echo "true"
  true


  % dtest 12:00:04 --lt 11:22:33 || echo "false"
  false


  % dtest 12:00:04 --cmp 11:22:33; echo "${?}"
  1


  % dtest --cmp 11:22:33 12:00:04; echo "${?}"
  2


  % dtest 2012-03-01T10:00:00 --gt 2012-03-02T00:00:00 || echo "false"
  false


  % dtest 2012-03-02T09:00:00 --ot 2012-03-02T10:00:00 && echo "true"
  true


  % dtest 2012-03-02T07:00:00 --cmp 2012-03-02T09:30:00; echo "${?}"
  2


  % dtest --cmp 2012-03-02T12:00:00 2012-03-02T09:30:00; echo "${?}"
  1


  % dtest 2012-03-02T07:00:00 --cmp 09:30:00; echo "${?}"
  3
.SH "FORMAT SPECS"

Format specs in dateutils are similar to posix' strftime().

However, due to a broader range of supported calendars dateutils must
employ different rules.

Date specs:
  %a  The abbreviated weekday name
  %A  The full weekday name
  %_a The weekday name shortened to a single character (MTWRFAS)
  %b  The abbreviated month name
  %B  The full month name
  %_b The month name shortened to a single character (FGHJKMNQUVXZ)
  %c  The count of the weekday within the month (range 00 to 05)
  %C  The count of the weekday within the year (range 00 to 53)
  %d  The day of the month, 2 digits (range 00 to 31)
  %D  The day of the year, 3 digits (range 000 to 366)
  %F  Equivalent to %Y-%m-%d (ymd's canonical format)
  %j  Equivalent to %D
  %m  The month in the current calendar (range 00 to 19)
  %Q  The quarter of the year (range Q1 to Q4)
  %q  The number of the quarter (range 01 to 04)
  %s  The number of seconds since the Epoch.
  %u  The weekday as number (range 01 to 07, Sunday being 07)
  %U  The week count, first day of week is Sun (range 00 to 53)
  %V  The ISO week count, first day of week is Mon (range 01 to 53)
  %w  The weekday as number (range 00 to 06, Sunday being 00)
  %W  The week count, first day of week is Mon (range 00 to 53)
  %y  The year without a century (range 00 to 99)
  %Y  The year including the century

  %Od The day as roman numerals
  %Om The month as roman numerals
  %Oy The two digit year as roman numerals
  %OY The year including the century as roman numerals

  %rs In time systems whose Epoch is different from the unix Epoch, this
      selects the number of seconds since then.
  %rY In calendars with years that don't coincide with the Gregorian
      years, this selects the calendar's year.

  %dth  The day of the month as an ordinal number, 1st, 2nd, 3rd, etc.
  %mth  The month of the year as an ordinal number, 1st, 2nd, 3rd, etc.

  %db The business day of the month (since last month's ultimo)
  %dB Number of business days until this month's ultimo

Time specs:
  %H  The hour of the day using a 24h clock, 2 digits (range 00 to 23)
  %I  The hour of the day using a 12h clock, 2 digits (range 01 to 12)
  %M  The minute (range 00 to 59)
  %N  The nanoseconds (range 000000000 to 999999999)
  %p  The string AM or PM, noon is PM and midnight is AM.
  %P  Like %p but in lowercase
  %S  The second (range 00 to 60, 60 is for leap seconds)
  %T  Equivalent to %H:%M:%S

General specs:
  %n  A newline character
  %t  A tab character
  %%  A literal % character

Modifiers:
  %O  Modifier to turn decimal numbers into Roman numerals
  %r  Modifier to turn units into real units
  th  Suffix.  Read and print ordinal numbers
  b   Treat date as business date

By design dates before 1601-01-01 are not supported.

For conformity here is a list of calendar spec names and their meaning:
  ymd   %Y-%m-%d
  ymcw  %Y-%m-%c-%w
  ywd   %rY-W%V-%u
  bizda %Y-%m-%db
.SH AUTHOR
Written by Sebastian Freundt <freundt@fresse.org>
.SH "REPORTING BUGS"
Report bugs to: https://github.com/hroptatyr/dateutils/issues
.SH "SEE ALSO"
The full documentation for
.B dtest
is maintained as a Texinfo manual.  If the
.B info
and
.B dtest
programs are properly installed at your site, the command
.IP
.B info (dateutils)dtest
.PP
should give you access to the complete manual.
