/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.LocationMap;

public class ExpressionLocation
implements SaxonLocator,
Serializable {
    private String systemId;
    private int lineNumber;
    private int columnNumber = -1;

    public ExpressionLocation() {
    }

    public ExpressionLocation(SourceLocator sourceLocator) {
        this.systemId = sourceLocator.getSystemId();
        this.lineNumber = sourceLocator.getLineNumber();
    }

    public ExpressionLocation(LocationProvider locationProvider, int n) {
        this.systemId = locationProvider.getSystemId(n);
        this.lineNumber = locationProvider.getLineNumber(n);
    }

    public ExpressionLocation(String string, int n, int n2) {
        this.systemId = string;
        this.lineNumber = n;
        this.columnNumber = n2;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void setPublicId(String string) {
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public void setColumnNumber(int n) {
        this.columnNumber = n;
    }

    public String getSystemId(int n) {
        return this.getSystemId();
    }

    public int getLineNumber(int n) {
        return this.getLineNumber();
    }

    public static SaxonLocator getSourceLocator(int n, LocationProvider locationProvider) {
        SaxonLocator saxonLocator;
        if (locationProvider instanceof LocationMap && n != 0) {
            ExpressionLocation expressionLocation = new ExpressionLocation();
            expressionLocation.setLineNumber(locationProvider.getLineNumber(n));
            expressionLocation.setSystemId(locationProvider.getSystemId(n));
            saxonLocator = expressionLocation;
        } else if (locationProvider instanceof SaxonLocator) {
            saxonLocator = (SaxonLocator)locationProvider;
        } else {
            return new InstructionDetails();
        }
        return saxonLocator;
    }

    public static String truncateURI(String string) {
        int n;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        while ((n = string2.indexOf(47)) >= 0 && n < string2.length() - 6) {
            string2 = string2.substring(n + 1);
        }
        return string2;
    }
}

