/*
 * Copyright © 2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *     Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 */

#ifndef COM_UBUNTU_CONNECTIVITY_NETWORKING_SERVICE_VPN_SERVICE
#define COM_UBUNTU_CONNECTIVITY_NETWORKING_SERVICE_VPN_SERVICE

#include <com/ubuntu/connectivity/networking/service.h>

namespace com {
namespace ubuntu {
namespace connectivity {
namespace networking {
namespace service {
namespace vpn {

/// @private
class
Service : public com::ubuntu::connectivity::networking::Service
{
public:
    typedef std::shared_ptr<Service> Ptr;
    virtual ~Service() = default;

    virtual const core::Property<std::shared_ptr<Link>> &establishedOver() = 0;

protected:
    Service() = default;
};

}
}
}
}
}
}

#endif
