/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *         building on original work by Thomas Nowotny <tnowotny@ucsd.edu>
 *
 * License: GPL-2+
 *
 * Initial version: 2009-03-31
 *
 */



#ifndef LIBCN_STANDALONE_ATTR_H
#define LIBCN_STANDALONE_ATTR_H

#include <vector>

#include "config.h"

using namespace std;
namespace CNRun {

class C_StandaloneAttributes {

    protected:
	C_StandaloneAttributes()
		{}
	C_StandaloneAttributes( size_t nvars)
		{
			V.resize( nvars),  V_next.resize( nvars);
		}

	vector<double>	V, V_next;

    friend class CModel;
    private:
	virtual void preadvance()
		{}
	void fixate()
		{  V = V_next;  }
};

}

#endif

// EOF
