/*
//
//  Copyright 1997-2009 Torsten Rohlfing
//
//  Copyright 2004-2011 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 2941 $
//
//  $LastChangedDate: 2011-03-04 10:31:31 -0800 (Fri, 04 Mar 2011) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#include "cmtkSafeCounterGCD.h"

unsigned int
cmtk::SafeCounterGCD::Get() const
{ 
  __block unsigned int result;
  dispatch_sync( this->m_Queue, ^{ result = this->m_Counter; } );
  return result;
}

unsigned int
cmtk::SafeCounterGCD::Increment()
{ 
  __block unsigned int result;
  dispatch_sync( this->m_Queue, ^{ result = ++(this->m_Counter); } );
  return result;
}

unsigned int
cmtk::SafeCounterGCD::Decrement()
{ 
  __block unsigned int result;
  dispatch_sync( this->m_Queue, ^{ result = --(this->m_Counter); } );
  return result;
}
