#
# Author:: John Keiser (<jkeiser@opscode.com>)
# Copyright:: Copyright (c) 2012 Opscode, Inc.
# License:: Apache License, Version 2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'chef/chef_fs/file_system/file_system_error'

class Chef
  module ChefFS
    module FileSystem
      class OperationFailedError < FileSystemError
        def initialize(operation, entry, cause = nil)
          super(entry, cause)
          @operation = operation
        end

        def message
          if cause && cause.is_a?(Net::HTTPExceptions) && cause.response.code == "400"
            "#{super} cause: #{cause.response.body}"
          else
            super
          end
        end

        attr_reader :operation
      end
    end
  end
end
