# cftime
Time-handling functionality from netcdf4-python

[![Build status](https://github.com/Unidata/cftime/workflows/cftime%20test/badge.svg)](https://github.com/Unidata/cftime/actions)
[![PyPI package](https://badge.fury.io/py/cftime.svg)](http://python.org/pypi/cftime)
[![Coverage Status](https://coveralls.io/repos/github/Unidata/cftime/badge.svg?branch=master)](https://coveralls.io/github/Unidata/cftime?branch=master)
[![Tag Status](https://img.shields.io/github/tag/UniData/cftime.svg)](https://github.com/Unidata/cftime/tags)
[![Release Status](https://img.shields.io/github/release/UniData/cftime.svg)](https://github.com/Unidata/cftime/releases)
[![Commits Status](https://img.shields.io/github/commits-since/UniData/cftime/latest.svg)](https://github.com/UniData/cftime/commits/master)
[![DOI](https://zenodo.org/badge/73107250.svg)](https://zenodo.org/badge/latestdoi/73107250)

## News
For details on the latest updates, see the [Changelog](https://github.com/Unidata/cftime/blob/master/Changelog).
 
9/18/2022:  Version 1.6.2 released.  strptime method added, fix for num2date failure on
empty integer array, date2num 'longdouble' keyword added. New wheel building workflow.

6/30/2022:  Version 1.6.1 released.  Fixes for numpy 1.23.0, updated CI/CD.

3/4/2022:  Version 1.6.0 released.  Big speed-ups for num2date, date2index bugfix for select != 'exact' when select='exact' works, fix for date2num with masked array inputs.

1/22/2022: Version 1.5.2 released (wheels for Apple M1 available on pypi for python 3.8,3.9 and 3.10). is_leap_year
function added (issue #259).

10/31/2021: Version 1.5.1.1 released (new binary wheels for python 3.10).

10/1/2021:  Version 1.5.1 released. Changed default behavior of ``proleptic_gregorian``
to has_year_zero=T (since it is allowed in ISO-8601 and CF does not specify the
year zero convention for this calendar). Raise warning message when trying
to create a calendar that is not supported by CF version 1.9 (no years < 1
allowed for 'standard'/'gregorian' or 'julian'  calendars).
Added support for "common_year" and "common_years" units for "noleap" 
and "365_day" calendars.
 
5/20/2021:  Version 1.5.0 released.  Includes support for astronomical year numbering
(including the year zero) for real-world calendars ('julian', 'gregorian'/'standard',
and 'proleptic_gregorian') using 'has_year_zero' `cftime.datetime` kwarg.
Added a 'change_calendar' `cftime.datetime` method to switch to another 
'real-world' calendar to enable comparison of instances with different calendars.
Some legacy classes and functions removed (`utime`, `JulianDayFromDate` and
`DateFromJulianDay`). The functionality of `JulianDayFromDate` and 
`DateFromJulianDay` is now available from the methods `cftime.datetime.toordinal`
and `cftime.datetime.fromordinal`.

2/2/2021:  Version 1.4.1 released. Restore use of calendar-specific subclasses
in `cftime.num2date`, `cftime.datetime.__add__`, and `cftime.datetime.__sub__`.
The use of this will be removed in a later release.
Add 'fromordinal' static method to create a cftime.datetime instance
from a julian day ordinal and calendar (inverse of 'toordinal').

2/1/2021:  Version 1.4.0 released.  License changed to MIT (GPL'ed code replaced).
Roundtrip accuracy improved for units other than microseconds. Added 
cftime.datetime.toordinal method, returns integer julian day number.

1/17/2021: Version 1.3.1 released.

11/16/2020:  Version 1.3.0 released. **API change**: The `cftime.datetime` constructor now creates 
 'calendar-aware' instances (default is `'standard'` calendar, if `calendar=''` or `None` the instance
 is not calendar aware and some methods, like `dayofwk`, `dayofyr`, `__add__` and `__sub__`, will not work)
 See discussion for issue [#198](https://github.com/Unidata/cftime/issues/198).
 The calendar specific sub-classes are now deprecated, but remain for now
 as stubs that just instantiate the base class and override `__repr__`.
 The default calendar in `cftime.date2num` has been changed from `'standard'` to `None`
 (the calendar associated with first input datetime object is used to define the calendar).

07/20/2020: Version 1.2.1 released.  Fixes a couple of regressions introduced in 1.2.0. See Changelog for details.

7/06/2020:  version 1.2.0 released. New microsecond accurate algorithm for date2num/num2date contributed by [spencerkclark](https://github.com/spencerkclark). Bugs fixed in masked array handling.

5/12/2020:  version 1.1.3 released.  Add isoformat method for compatibility with python datetime (issue #152).
 Make 'standard' default calendar for cftime.datetime so that dayofwk,dayofyr methods don't fail (issue #169).

4/20/2020:  version 1.1.2 released.  Code optimization, fix logic so `only_use_cftime_datetimes=False` works as 
 expected (issues [#158](https://github.com/Unidata/cftime/issues/158) and [#165](https://github.com/Unidata/cftime/issues/165)).

3/16/2020:  version 1.1.1 released.  Fix bug in microsecond formatting, ensure identical num2date results if input is an array of times, or a single scalar ([issue #143](https://github.com/Unidata/cftime/issues/143)).

2/12/2020:  version 1.1.0 released.  `cftime.datetime` instances are returned by default from `num2date`
(instead of returning python datetime instances where possible ([issue #136](https://github.com/Unidata/cftime/issues/136))).  `num2pydate`
convenience function added (always returns python datetime instances, [issue #134](https://github.com/Unidata/cftime/issues/134)). Fix for
fraction seconds in reference date string ([issue #140](https://github.com/Unidata/cftime/issues/140)). Added `daysinmonth` attribute 
([issue #137](https://github.com/Unidata/cftime/issues/137)).

10/25/2019:  version 1.0.4.2 released (fix for [issue #126](https://github.com/Unidata/cftime/issues/126)).

10/21/2019:  version 1.0.4 released.

12/05/2018:  version 1.0.3.4 released (just to fix a problem with the source 
tarball on pypi).

12/05/2018:  version 1.0.3.1 released.  Bugfix release (fixed issue with installation
when cython not installed, regression on 32-bit platforms, workaround for pandas 
compatibility).

12/01/2018:  version 1.0.3 released. Test coverage with coveralls.io, improved round-tripping accuracy for non-real world calendars (like `360_day`).

10/27/2018:  version 1.0.2 released. Improved accuracy (from approximately 1000 microseconds to 10 microseconds on x86
platforms). Refactored calendar calculations now allow for negative reference years. num2date function now more than an
order of magnitude faster. `months since` units now allowed, but only for `360_day` calendar.

08/15/2018:  version 1.0.1 released.

11/8/2016: `cftime` was split out of the [netcdf4-python](https://github.com/Unidata/netcdf4-python) package.

## Quick Start
* Clone GitHub repository (`git clone https://github.com/Unidata/cftime.git`), or get source tarball from [PyPI](https://pypi.python.org/pypi/cftime). Links to Windows and OS X precompiled binary packages are also available on [PyPI](https://pypi.python.org/pypi/cftime).

* Make sure [numpy](http://www.numpy.org/) and [Cython](http://cython.org/) are
  installed and you have [Python](https://www.python.org) 2.7 or newer.

* Run `python setup.py build`, then `python setup.py install` (with `sudo` if necessary).

* To run all the tests, execute `py.test`.

## Documentation
See the online [docs](http://unidata.github.io/cftime) for more details.
