// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "ListHeader.pypp.hpp"

namespace bp = boost::python;

struct ListHeader_wrapper : CEGUI::ListHeader, bp::wrapper< CEGUI::ListHeader > {

    ListHeader_wrapper(::CEGUI::String const & type, ::CEGUI::String const & name )
    : CEGUI::ListHeader( boost::ref(type), boost::ref(name) )
      , bp::wrapper< CEGUI::ListHeader >(){
        // constructor
    
    }

    virtual void beginInitialisation(  ) {
        if( bp::override func_beginInitialisation = this->get_override( "beginInitialisation" ) )
            func_beginInitialisation(  );
        else{
            this->CEGUI::Window::beginInitialisation(  );
        }
    }
    
    void default_beginInitialisation(  ) {
        CEGUI::Window::beginInitialisation( );
    }

    virtual void cloneChildWidgetsTo( ::CEGUI::Window & target ) const  {
        if( bp::override func_cloneChildWidgetsTo = this->get_override( "cloneChildWidgetsTo" ) )
            func_cloneChildWidgetsTo( boost::ref(target) );
        else{
            this->CEGUI::Window::cloneChildWidgetsTo( boost::ref(target) );
        }
    }
    
    void default_cloneChildWidgetsTo( ::CEGUI::Window & target ) const  {
        CEGUI::Window::cloneChildWidgetsTo( boost::ref(target) );
    }

    virtual void clonePropertiesTo( ::CEGUI::Window & target ) const  {
        if( bp::override func_clonePropertiesTo = this->get_override( "clonePropertiesTo" ) )
            func_clonePropertiesTo( boost::ref(target) );
        else{
            this->CEGUI::Window::clonePropertiesTo( boost::ref(target) );
        }
    }
    
    void default_clonePropertiesTo( ::CEGUI::Window & target ) const  {
        CEGUI::Window::clonePropertiesTo( boost::ref(target) );
    }

    virtual void destroy(  ) {
        if( bp::override func_destroy = this->get_override( "destroy" ) )
            func_destroy(  );
        else{
            this->CEGUI::Window::destroy(  );
        }
    }
    
    void default_destroy(  ) {
        CEGUI::Window::destroy( );
    }

    virtual void endInitialisation(  ) {
        if( bp::override func_endInitialisation = this->get_override( "endInitialisation" ) )
            func_endInitialisation(  );
        else{
            this->CEGUI::Window::endInitialisation(  );
        }
    }
    
    void default_endInitialisation(  ) {
        CEGUI::Window::endInitialisation( );
    }

    virtual void fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        if( bp::override func_fireEvent = this->get_override( "fireEvent" ) )
            func_fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        else{
            this->CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        }
    }
    
    void default_fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
    }

    virtual void getRenderingContext_impl( ::CEGUI::RenderingContext & ctx ) const  {
        if( bp::override func_getRenderingContext_impl = this->get_override( "getRenderingContext_impl" ) )
            func_getRenderingContext_impl( boost::ref(ctx) );
        else{
            this->CEGUI::Window::getRenderingContext_impl( boost::ref(ctx) );
        }
    }
    
    void default_getRenderingContext_impl( ::CEGUI::RenderingContext & ctx ) const  {
        CEGUI::Window::getRenderingContext_impl( boost::ref(ctx) );
    }

    virtual ::CEGUI::Rect getUnclippedInnerRect_impl(  ) const  {
        if( bp::override func_getUnclippedInnerRect_impl = this->get_override( "getUnclippedInnerRect_impl" ) )
            return func_getUnclippedInnerRect_impl(  );
        else{
            return this->CEGUI::Window::getUnclippedInnerRect_impl(  );
        }
    }
    
    ::CEGUI::Rect default_getUnclippedInnerRect_impl(  ) const  {
        return CEGUI::Window::getUnclippedInnerRect_impl( );
    }

    virtual void initialiseComponents(  ) {
        if( bp::override func_initialiseComponents = this->get_override( "initialiseComponents" ) )
            func_initialiseComponents(  );
        else{
            this->CEGUI::Window::initialiseComponents(  );
        }
    }
    
    void default_initialiseComponents(  ) {
        CEGUI::Window::initialiseComponents( );
    }

    virtual bool isHit( ::CEGUI::Vector2 const & position, bool const allow_disabled=false ) const  {
        if( bp::override func_isHit = this->get_override( "isHit" ) )
            return func_isHit( boost::ref(position), allow_disabled );
        else{
            return this->CEGUI::Window::isHit( boost::ref(position), allow_disabled );
        }
    }
    
    bool default_isHit( ::CEGUI::Vector2 const & position, bool const allow_disabled=false ) const  {
        return CEGUI::Window::isHit( boost::ref(position), allow_disabled );
    }

    virtual void performChildWindowLayout(  ) {
        if( bp::override func_performChildWindowLayout = this->get_override( "performChildWindowLayout" ) )
            func_performChildWindowLayout(  );
        else{
            this->CEGUI::Window::performChildWindowLayout(  );
        }
    }
    
    void default_performChildWindowLayout(  ) {
        CEGUI::Window::performChildWindowLayout( );
    }

    virtual void setLookNFeel( ::CEGUI::String const & look ) {
        if( bp::override func_setLookNFeel = this->get_override( "setLookNFeel" ) )
            func_setLookNFeel( boost::ref(look) );
        else{
            this->CEGUI::Window::setLookNFeel( boost::ref(look) );
        }
    }
    
    void default_setLookNFeel( ::CEGUI::String const & look ) {
        CEGUI::Window::setLookNFeel( boost::ref(look) );
    }

    virtual void setMargin( ::CEGUI::UBox const & margin ) {
        if( bp::override func_setMargin = this->get_override( "setMargin" ) )
            func_setMargin( boost::ref(margin) );
        else{
            this->CEGUI::Window::setMargin( boost::ref(margin) );
        }
    }
    
    void default_setMargin( ::CEGUI::UBox const & margin ) {
        CEGUI::Window::setMargin( boost::ref(margin) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
    }

    virtual void update( float elapsed ) {
        if( bp::override func_update = this->get_override( "update" ) )
            func_update( elapsed );
        else{
            this->CEGUI::Window::update( elapsed );
        }
    }
    
    void default_update( float elapsed ) {
        CEGUI::Window::update( elapsed );
    }

    virtual void writeXMLToStream( ::CEGUI::XMLSerializer & xml_stream ) const  {
        if( bp::override func_writeXMLToStream = this->get_override( "writeXMLToStream" ) )
            func_writeXMLToStream( boost::ref(xml_stream) );
        else{
            this->CEGUI::Window::writeXMLToStream( boost::ref(xml_stream) );
        }
    }
    
    void default_writeXMLToStream( ::CEGUI::XMLSerializer & xml_stream ) const  {
        CEGUI::Window::writeXMLToStream( boost::ref(xml_stream) );
    }

};

void register_ListHeader_class(){

    { //::CEGUI::ListHeader
        typedef bp::class_< ListHeader_wrapper, bp::bases< CEGUI::Window >, boost::noncopyable > ListHeader_exposer_t;
        ListHeader_exposer_t ListHeader_exposer = ListHeader_exposer_t( "ListHeader", "*!\n\
        \n\
           Base class for the multi column list header widget.\n\
        *\n", bp::init< CEGUI::String const &, CEGUI::String const & >(( bp::arg("type"), bp::arg("name") ), "*************************************************************************\n\
           Construction and Destruction\n\
        *************************************************************************\n\
        *!\n\
        \n\
           Constructor for the list header base class.\n\
        *\n") );
        bp::scope ListHeader_scope( ListHeader_exposer );
        { //::CEGUI::ListHeader::addColumn
        
            typedef void ( ::CEGUI::ListHeader::*addColumn_function_type )( ::CEGUI::String const &,::CEGUI::uint,::CEGUI::UDim const & ) ;
            
            ListHeader_exposer.def( 
                "addColumn"
                , addColumn_function_type( &::CEGUI::ListHeader::addColumn )
                , ( bp::arg("text"), bp::arg("id"), bp::arg("width") )
                , "*!\n\
               \n\
                  Add a new column segment to the end of the header.\n\
            \n\
               @param text\n\
                  String object holding the initial text for the new segment\n\
            \n\
               @param id\n\
                  Client specified ID code to be assigned to the new segment.\n\
            \n\
               @param width\n\
                  UDim describing the initial width of the new segment.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getColumnCount
        
            typedef ::CEGUI::uint ( ::CEGUI::ListHeader::*getColumnCount_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "getColumnCount"
                , getColumnCount_function_type( &::CEGUI::ListHeader::getColumnCount )
                , "*************************************************************************\n\
                  Accessor Methods\n\
               *************************************************************************\n\
               *!\n\
               \n\
                  Return the number of columns or segments attached to the header.\n\
            \n\
               @return\n\
                  uint value equal to the number of columns  segments currently in the header.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getColumnFromID
        
            typedef ::CEGUI::uint ( ::CEGUI::ListHeader::*getColumnFromID_function_type )( ::CEGUI::uint ) const;
            
            ListHeader_exposer.def( 
                "getColumnFromID"
                , getColumnFromID_function_type( &::CEGUI::ListHeader::getColumnFromID )
                , ( bp::arg("id") )
                , "*!\n\
               \n\
                  Return the zero based column index of the segment with the specified ID.\n\
            \n\
               @param id\n\
                  ID code of the segment whos column index is to be returned.\n\
            \n\
               @return\n\
                  Zero based column index of the first ListHeaderSegment whos ID matches  id.\n\
            \n\
               @exception  InvalidRequestException    thrown if no attached segment has the requested ID.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getColumnFromSegment
        
            typedef ::CEGUI::uint ( ::CEGUI::ListHeader::*getColumnFromSegment_function_type )( ::CEGUI::ListHeaderSegment const & ) const;
            
            ListHeader_exposer.def( 
                "getColumnFromSegment"
                , getColumnFromSegment_function_type( &::CEGUI::ListHeader::getColumnFromSegment )
                , ( bp::arg("segment") )
                , "*!\n\
               \n\
                  Return the zero based column index of the specified segment.\n\
            \n\
               @param segment\n\
                  ListHeaderSegment whos zero based index is to be returned.\n\
            \n\
               @return\n\
                  Zero based column index of the ListHeaderSegment  segment.\n\
            \n\
               @exception  InvalidRequestException    thrown if  segment is not attached to this ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getColumnWidth
        
            typedef ::CEGUI::UDim ( ::CEGUI::ListHeader::*getColumnWidth_function_type )( ::CEGUI::uint ) const;
            
            ListHeader_exposer.def( 
                "getColumnWidth"
                , getColumnWidth_function_type( &::CEGUI::ListHeader::getColumnWidth )
                , ( bp::arg("column") )
                , "*!\n\
               \n\
                  Return the width of the specified column.\n\
            \n\
               @param column\n\
                  Zero based column index of the segment whose width is to be returned.\n\
            \n\
               @return\n\
                  UDim describing the width of the ListHeaderSegment at the zero based\n\
                    column index specified by  column.\n\
            \n\
               @exception InvalidRequestException  thrown if  column is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getColumnWithText
        
            typedef ::CEGUI::uint ( ::CEGUI::ListHeader::*getColumnWithText_function_type )( ::CEGUI::String const & ) const;
            
            ListHeader_exposer.def( 
                "getColumnWithText"
                , getColumnWithText_function_type( &::CEGUI::ListHeader::getColumnWithText )
                , ( bp::arg("text") )
                , "*!\n\
               \n\
                  Return the zero based column index of the segment with the specified text.\n\
            \n\
               @param text\n\
                  String object containing the text to be searched for.\n\
            \n\
               @return\n\
                  Zero based column index of the segment with the specified text.\n\
            \n\
               @exception InvalidRequestException  thrown if no attached segments have the requested text.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getPixelOffsetToColumn
        
            typedef float ( ::CEGUI::ListHeader::*getPixelOffsetToColumn_function_type )( ::CEGUI::uint ) const;
            
            ListHeader_exposer.def( 
                "getPixelOffsetToColumn"
                , getPixelOffsetToColumn_function_type( &::CEGUI::ListHeader::getPixelOffsetToColumn )
                , ( bp::arg("column") )
                , "*!\n\
               \n\
                  Return the pixel offset to the ListHeaderSegment at the given zero based column index.\n\
            \n\
               @param column\n\
                  Zero based column index of the ListHeaderSegment whos pixel offset it to be returned.\n\
            \n\
               @return\n\
                  The number of pixels up-to the begining of the ListHeaderSegment located at zero based\
                  column\n\
                  index  column.\n\
            \n\
               @exception InvalidRequestException  thrown if  column is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getPixelOffsetToSegment
        
            typedef float ( ::CEGUI::ListHeader::*getPixelOffsetToSegment_function_type )( ::CEGUI::ListHeaderSegment const & ) const;
            
            ListHeader_exposer.def( 
                "getPixelOffsetToSegment"
                , getPixelOffsetToSegment_function_type( &::CEGUI::ListHeader::getPixelOffsetToSegment )
                , ( bp::arg("segment") )
                , "*!\n\
               \n\
                  Return the pixel offset to the given ListHeaderSegment.\n\
            \n\
               @param segment\n\
                  ListHeaderSegment object that the offset to is to be returned.\n\
            \n\
               @return\n\
                  The number of pixels up-to the begining of the ListHeaderSegment described by  segment.\n\
            \n\
               @exception InvalidRequestException  thrown if  segment is not attached to the ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getSegmentFromColumn
        
            typedef ::CEGUI::ListHeaderSegment & ( ::CEGUI::ListHeader::*getSegmentFromColumn_function_type )( ::CEGUI::uint ) const;
            
            ListHeader_exposer.def( 
                "getSegmentFromColumn"
                , getSegmentFromColumn_function_type( &::CEGUI::ListHeader::getSegmentFromColumn )
                , ( bp::arg("column") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return the ListHeaderSegment object for the specified column\n\
            \n\
               @param column\n\
                  zero based column index of the ListHeaderSegment to be returned.\n\
            \n\
               @return\n\
                  ListHeaderSegment object at the requested index.\n\
            \n\
               @exception InvalidRequestException  thrown if column is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getSegmentFromID
        
            typedef ::CEGUI::ListHeaderSegment & ( ::CEGUI::ListHeader::*getSegmentFromID_function_type )( ::CEGUI::uint ) const;
            
            ListHeader_exposer.def( 
                "getSegmentFromID"
                , getSegmentFromID_function_type( &::CEGUI::ListHeader::getSegmentFromID )
                , ( bp::arg("id") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return the ListHeaderSegment object with the specified ID.\n\
            \n\
               @param id\n\
                  id code of the ListHeaderSegment to be returned.\n\
            \n\
               @return\n\
                  ListHeaderSegment object with the ID  id.  If more than one segment has the same ID, only the\
                  first one will\n\
                  ever be returned.\n\
            \n\
               @exception  InvalidRequestException    thrown if no segment with the requested ID is attached.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getSegmentOffset
        
            typedef float ( ::CEGUI::ListHeader::*getSegmentOffset_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "getSegmentOffset"
                , getSegmentOffset_function_type( &::CEGUI::ListHeader::getSegmentOffset )
                , "*!\n\
               \n\
                  Return the current segment offset value.  This value is used to implement scrolling of the\
                  header segments within\n\
                  the ListHeader area.\n\
            \n\
               @return\n\
                  float value specifying the current segment offset value in whatever metrics system is active\
                  for the ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getSortColumn
        
            typedef ::CEGUI::uint ( ::CEGUI::ListHeader::*getSortColumn_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "getSortColumn"
                , getSortColumn_function_type( &::CEGUI::ListHeader::getSortColumn )
                , "*!\n\
               \n\
                  Return the zero based index of the current sort column.  There must be at least one\
                  segmentcolumn to successfully call this\n\
                  method.\n\
            \n\
               @return\n\
                  Zero based column index that is the current sort column.\n\
            \n\
               @exception  InvalidRequestException    thrown if there are no segments  columns in this\
               ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getSortDirection
        
            typedef ::CEGUI::ListHeaderSegment::SortDirection ( ::CEGUI::ListHeader::*getSortDirection_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "getSortDirection"
                , getSortDirection_function_type( &::CEGUI::ListHeader::getSortDirection )
                , "*!\n\
               \n\
                  Return the currently set sort direction.\n\
            \n\
               @return\n\
                  One of the ListHeaderSegment.SortDirection enumerated values specifying the current sort\
                  direction.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getSortSegment
        
            typedef ::CEGUI::ListHeaderSegment & ( ::CEGUI::ListHeader::*getSortSegment_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "getSortSegment"
                , getSortSegment_function_type( &::CEGUI::ListHeader::getSortSegment )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
               \n\
                  Return the ListHeaderSegment that is marked as being the 'sort key' segment.  There must be at\
                  least one segment\n\
                  to successfully call this method.\n\
            \n\
               @return\n\
                  ListHeaderSegment object which is the sort-key segment.\n\
            \n\
               @exception  InvalidRequestException    thrown if no segments are attached to the ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::getTotalSegmentsPixelExtent
        
            typedef float ( ::CEGUI::ListHeader::*getTotalSegmentsPixelExtent_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "getTotalSegmentsPixelExtent"
                , getTotalSegmentsPixelExtent_function_type( &::CEGUI::ListHeader::getTotalSegmentsPixelExtent )
                , "*!\n\
               \n\
                  Return the total pixel width of all attached segments.\n\
            \n\
               @return\n\
                  Sum of the pixel widths of all attached ListHeaderSegment objects.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::insertColumn
        
            typedef void ( ::CEGUI::ListHeader::*insertColumn_function_type )( ::CEGUI::String const &,::CEGUI::uint,::CEGUI::UDim const &,::CEGUI::uint ) ;
            
            ListHeader_exposer.def( 
                "insertColumn"
                , insertColumn_function_type( &::CEGUI::ListHeader::insertColumn )
                , ( bp::arg("text"), bp::arg("id"), bp::arg("width"), bp::arg("position") )
                , "*!\n\
               \n\
                  Insert a new column segment at the specified position.\n\
            \n\
               @param text\n\
                  String object holding the initial text for the new segment\n\
            \n\
               @param id\n\
                  Client specified ID code to be assigned to the new segment.\n\
            \n\
                @param width\n\
                    UDim describing the initial width of the new segment.\n\
            \n\
               @param position\n\
                  Zero based column index indicating the desired position for the new column.  If this is\
                  greater than\n\
                  the current number of columns, the new segment is added to the end if the header.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::insertColumn
        
            typedef void ( ::CEGUI::ListHeader::*insertColumn_function_type )( ::CEGUI::String const &,::CEGUI::uint,::CEGUI::UDim const &,::CEGUI::ListHeaderSegment const & ) ;
            
            ListHeader_exposer.def( 
                "insertColumn"
                , insertColumn_function_type( &::CEGUI::ListHeader::insertColumn )
                , ( bp::arg("text"), bp::arg("id"), bp::arg("width"), bp::arg("position") )
                , "*!\n\
               \n\
                  Insert a new column segment at the specified position.\n\
            \n\
               @param text\n\
                  String object holding the initial text for the new segment\n\
            \n\
               @param id\n\
                  Client specified ID code to be assigned to the new segment.\n\
            \n\
                @param width\n\
                    UDim describing the initial width of the new segment.\n\
            \n\
               @param position\n\
                  ListHeaderSegment object indicating the insert position for the new segment.  The new segment\
                  will be\n\
                  inserted before the segment indicated by  position.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if ListHeaderSegment  position is not attached to the\
               ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::isColumnDraggingEnabled
        
            typedef bool ( ::CEGUI::ListHeader::*isColumnDraggingEnabled_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "isColumnDraggingEnabled"
                , isColumnDraggingEnabled_function_type( &::CEGUI::ListHeader::isColumnDraggingEnabled )
                , "*!\n\
               \n\
                  Return whether the user may modify the order of the segments.\n\
            \n\
               @return\n\
                  true if the user may interactively modify the order of the column segments, false if they may\
                  not.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::isColumnSizingEnabled
        
            typedef bool ( ::CEGUI::ListHeader::*isColumnSizingEnabled_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "isColumnSizingEnabled"
                , isColumnSizingEnabled_function_type( &::CEGUI::ListHeader::isColumnSizingEnabled )
                , "*!\n\
               \n\
                  Return whether the user may size column segments.\n\
            \n\
               @return\n\
                  true if the user may interactively modify the width of column segments, false if they may\
                  not.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::isSortingEnabled
        
            typedef bool ( ::CEGUI::ListHeader::*isSortingEnabled_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "isSortingEnabled"
                , isSortingEnabled_function_type( &::CEGUI::ListHeader::isSortingEnabled )
                , "*!\n\
               \n\
                  Return whether user manipulation of the sort column & direction are enabled.\n\
            \n\
               @return\n\
                  true if the user may interactively modify the sort column and direction.  false if the user\
                  may not\n\
                  modify the sort column and direction (these can still be set programmatically).\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::moveColumn
        
            typedef void ( ::CEGUI::ListHeader::*moveColumn_function_type )( ::CEGUI::uint,::CEGUI::uint ) ;
            
            ListHeader_exposer.def( 
                "moveColumn"
                , moveColumn_function_type( &::CEGUI::ListHeader::moveColumn )
                , ( bp::arg("column"), bp::arg("position") )
                , "*!\n\
               \n\
                  Moves a column segment into a new position.\n\
            \n\
               @param column\n\
                  Zero based column index indicating the column segment to be moved.\n\
            \n\
               @param position\n\
                  Zero based column index indicating the new position for the segment.  If this is greater than\
                  the current number of segments,\n\
                  the segment is moved to the end of the header.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException thrown if  column is out of range for this ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::moveColumn
        
            typedef void ( ::CEGUI::ListHeader::*moveColumn_function_type )( ::CEGUI::uint,::CEGUI::ListHeaderSegment const & ) ;
            
            ListHeader_exposer.def( 
                "moveColumn"
                , moveColumn_function_type( &::CEGUI::ListHeader::moveColumn )
                , ( bp::arg("column"), bp::arg("position") )
                , "*!\n\
               \n\
                  Move a column segment to a new position.\n\
            \n\
               @param column\n\
                  Zero based column index indicating the column segment to be moved.\n\
            \n\
               @param position\n\
                  ListHeaderSegment object indicating the new position for the segment.  The segment at\
                  column\n\
                  will be moved behind segment  position (that is, segment  column will appear to the right of\n\
                  segment  position).\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException thrown if  column is out of range for this ListHeader, or if\
               position\n\
                  is not attached to this ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::moveSegment
        
            typedef void ( ::CEGUI::ListHeader::*moveSegment_function_type )( ::CEGUI::ListHeaderSegment const &,::CEGUI::uint ) ;
            
            ListHeader_exposer.def( 
                "moveSegment"
                , moveSegment_function_type( &::CEGUI::ListHeader::moveSegment )
                , ( bp::arg("segment"), bp::arg("position") )
                , "*!\n\
               \n\
                  Moves a segment into a new position.\n\
            \n\
               @param segment\n\
                  ListHeaderSegment object that is to be moved.\n\
            \n\
               @param position\n\
                  Zero based column index indicating the new position for the segment.  If this is greater than\
                  the current number of segments,\n\
                  the segment is moved to the end of the header.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException thrown if  segment is not attached to this ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::moveSegment
        
            typedef void ( ::CEGUI::ListHeader::*moveSegment_function_type )( ::CEGUI::ListHeaderSegment const &,::CEGUI::ListHeaderSegment const & ) ;
            
            ListHeader_exposer.def( 
                "moveSegment"
                , moveSegment_function_type( &::CEGUI::ListHeader::moveSegment )
                , ( bp::arg("segment"), bp::arg("position") )
                , "*!\n\
               \n\
                  Move a segment to a new position.\n\
            \n\
               @param segment\n\
                  ListHeaderSegment object that is to be moved.\n\
            \n\
               @param position\n\
                  ListHeaderSegment object indicating the new position for the segment.  The segment  segment\n\
                  will be moved behind segment  position (that is, segment  segment will appear to the right\
                  of\n\
                  segment  position).\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException thrown if either  segment or  position are not attached to\
               this ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::removeColumn
        
            typedef void ( ::CEGUI::ListHeader::*removeColumn_function_type )( ::CEGUI::uint ) ;
            
            ListHeader_exposer.def( 
                "removeColumn"
                , removeColumn_function_type( &::CEGUI::ListHeader::removeColumn )
                , ( bp::arg("column") )
                , "*!\n\
               \n\
                  Removes a column segment from the ListHeader.\n\
            \n\
               @param column\n\
                  Zero based column index indicating the segment to be removed.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  column is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::removeSegment
        
            typedef void ( ::CEGUI::ListHeader::*removeSegment_function_type )( ::CEGUI::ListHeaderSegment const & ) ;
            
            ListHeader_exposer.def( 
                "removeSegment"
                , removeSegment_function_type( &::CEGUI::ListHeader::removeSegment )
                , ( bp::arg("segment") )
                , "*!\n\
               \n\
                  Remove the specified segment from the ListHeader.\n\
            \n\
               @param segment\n\
                  ListHeaderSegment object that is to be removed from the ListHeader.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  segment is not attached to this ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::setColumnDraggingEnabled
        
            typedef void ( ::CEGUI::ListHeader::*setColumnDraggingEnabled_function_type )( bool ) ;
            
            ListHeader_exposer.def( 
                "setColumnDraggingEnabled"
                , setColumnDraggingEnabled_function_type( &::CEGUI::ListHeader::setColumnDraggingEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
               \n\
                  Set whether columns may be reordered by the user via drag and drop.\n\
            \n\
               @param setting\n\
                  - true to indicate the user may change the order of the column segments via drag and drop.\n\
                  - false to indicate the user may not change the column segment order.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::setColumnSizingEnabled
        
            typedef void ( ::CEGUI::ListHeader::*setColumnSizingEnabled_function_type )( bool ) ;
            
            ListHeader_exposer.def( 
                "setColumnSizingEnabled"
                , setColumnSizingEnabled_function_type( &::CEGUI::ListHeader::setColumnSizingEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
               \n\
                  Set whether columns may be sized by the user.\n\
            \n\
               @param setting\n\
                  - true to indicate that the user may interactively size segments.\n\
                  - false to indicate that the user may not interactively size segments.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::setColumnWidth
        
            typedef void ( ::CEGUI::ListHeader::*setColumnWidth_function_type )( ::CEGUI::uint,::CEGUI::UDim const & ) ;
            
            ListHeader_exposer.def( 
                "setColumnWidth"
                , setColumnWidth_function_type( &::CEGUI::ListHeader::setColumnWidth )
                , ( bp::arg("column"), bp::arg("width") )
                , "*!\n\
               \n\
                  Set the width of the specified column.\n\
            \n\
               @param column\n\
                  Zero based column index of the segment whose width is to be set.\n\
            \n\
               @param width\n\
                  UDim value specifying the new width to set for the ListHeaderSegment at the zero based\
                  column\n\
                  index specified by  column.\n\
            \n\
               @return\n\
                  Nothing\n\
            \n\
               @exception InvalidRequestException  thrown if  column is out of range.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::setSegmentOffset
        
            typedef void ( ::CEGUI::ListHeader::*setSegmentOffset_function_type )( float ) ;
            
            ListHeader_exposer.def( 
                "setSegmentOffset"
                , setSegmentOffset_function_type( &::CEGUI::ListHeader::setSegmentOffset )
                , ( bp::arg("offset") )
                , "*!\n\
               \n\
                  Set the current base segment offset.  (This implements scrolling of the header segments\
                  within\n\
                  the header area).\n\
            \n\
               @param offset\n\
                  New base offset for the first segment.  The segments will of offset to the left by the amount\
                  specified.\n\
                   offset should be specified using the active metrics system for the ListHeader.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::setSortColumn
        
            typedef void ( ::CEGUI::ListHeader::*setSortColumn_function_type )( ::CEGUI::uint ) ;
            
            ListHeader_exposer.def( 
                "setSortColumn"
                , setSortColumn_function_type( &::CEGUI::ListHeader::setSortColumn )
                , ( bp::arg("column") )
                , "*!\n\
               \n\
                  Set the column to be used as the sort column.\n\
            \n\
               @param column\n\
                  Zero based column index indicating the column to be sorted.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  column is out of range for this ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::setSortColumnFromID
        
            typedef void ( ::CEGUI::ListHeader::*setSortColumnFromID_function_type )( ::CEGUI::uint ) ;
            
            ListHeader_exposer.def( 
                "setSortColumnFromID"
                , setSortColumnFromID_function_type( &::CEGUI::ListHeader::setSortColumnFromID )
                , ( bp::arg("id") )
                , "*!\n\
               \n\
                  Set the column to to be used for sorting via its ID code.\n\
            \n\
               @param id\n\
                  ID code of the column segment that is to be used as the sort column.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if no segment with ID  id is attached to the\
               ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::setSortDirection
        
            typedef void ( ::CEGUI::ListHeader::*setSortDirection_function_type )( ::CEGUI::ListHeaderSegment::SortDirection ) ;
            
            ListHeader_exposer.def( 
                "setSortDirection"
                , setSortDirection_function_type( &::CEGUI::ListHeader::setSortDirection )
                , ( bp::arg("direction") )
                , "*!\n\
               \n\
                  Set the current sort direction.\n\
            \n\
               @param direction\n\
                  One of the ListHeaderSegment.SortDirection enumerated values indicating the sort direction to\
                  be used.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::setSortSegment
        
            typedef void ( ::CEGUI::ListHeader::*setSortSegment_function_type )( ::CEGUI::ListHeaderSegment const & ) ;
            
            ListHeader_exposer.def( 
                "setSortSegment"
                , setSortSegment_function_type( &::CEGUI::ListHeader::setSortSegment )
                , ( bp::arg("segment") )
                , "*!\n\
               \n\
                  Set the column segment to be used as the sort column.\n\
            \n\
               @param segment\n\
                  ListHeaderSegment object indicating the column to be sorted.\n\
            \n\
               @return\n\
                  Nothing.\n\
            \n\
               @exception InvalidRequestException  thrown if  segment is not attached to this ListHeader.\n\
               *\n" );
        
        }
        { //::CEGUI::ListHeader::setSortingEnabled
        
            typedef void ( ::CEGUI::ListHeader::*setSortingEnabled_function_type )( bool ) ;
            
            ListHeader_exposer.def( 
                "setSortingEnabled"
                , setSortingEnabled_function_type( &::CEGUI::ListHeader::setSortingEnabled )
                , ( bp::arg("setting") )
                , "*************************************************************************\n\
                  Manipulator Methods\n\
               *************************************************************************\n\
               *!\n\
               \n\
                  Set whether user manipulation of the sort column and direction is enabled.\n\
            \n\
               @param setting\n\
                  - true to allow interactive user manipulation of the sort column and direction.\n\
                  - false to disallow interactive user manipulation of the sort column and direction.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        ListHeader_exposer.add_static_property( "EventDragMoveSettingChanged"
                        , bp::make_getter( &CEGUI::ListHeader::EventDragMoveSettingChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventDragSizeSettingChanged"
                        , bp::make_getter( &CEGUI::ListHeader::EventDragSizeSettingChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventSegmentAdded"
                        , bp::make_getter( &CEGUI::ListHeader::EventSegmentAdded
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventSegmentClicked"
                        , bp::make_getter( &CEGUI::ListHeader::EventSegmentClicked
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventSegmentRemoved"
                        , bp::make_getter( &CEGUI::ListHeader::EventSegmentRemoved
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventSegmentRenderOffsetChanged"
                        , bp::make_getter( &CEGUI::ListHeader::EventSegmentRenderOffsetChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventSegmentSequenceChanged"
                        , bp::make_getter( &CEGUI::ListHeader::EventSegmentSequenceChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventSegmentSized"
                        , bp::make_getter( &CEGUI::ListHeader::EventSegmentSized
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventSortColumnChanged"
                        , bp::make_getter( &CEGUI::ListHeader::EventSortColumnChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventSortDirectionChanged"
                        , bp::make_getter( &CEGUI::ListHeader::EventSortDirectionChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventSortSettingChanged"
                        , bp::make_getter( &CEGUI::ListHeader::EventSortSettingChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.add_static_property( "EventSplitterDoubleClicked"
                        , bp::make_getter( &CEGUI::ListHeader::EventSplitterDoubleClicked
                                , bp::return_value_policy< bp::return_by_value >() ) );
        ListHeader_exposer.def_readonly( "MinimumSegmentPixelWidth", CEGUI::ListHeader::MinimumSegmentPixelWidth, "values\n" );
        ListHeader_exposer.def_readonly( "ScrollSpeed", CEGUI::ListHeader::ScrollSpeed, "values\n" );
        { //::CEGUI::Window::beginInitialisation
        
            typedef void ( ::CEGUI::Window::*beginInitialisation_function_type )(  ) ;
            typedef void ( ListHeader_wrapper::*default_beginInitialisation_function_type )(  ) ;
            
            ListHeader_exposer.def( 
                "beginInitialisation"
                , beginInitialisation_function_type(&::CEGUI::Window::beginInitialisation)
                , default_beginInitialisation_function_type(&ListHeader_wrapper::default_beginInitialisation) );
        
        }
        { //::CEGUI::Window::cloneChildWidgetsTo
        
            typedef void ( ::CEGUI::Window::*cloneChildWidgetsTo_function_type )( ::CEGUI::Window & ) const;
            typedef void ( ListHeader_wrapper::*default_cloneChildWidgetsTo_function_type )( ::CEGUI::Window & ) const;
            
            ListHeader_exposer.def( 
                "cloneChildWidgetsTo"
                , cloneChildWidgetsTo_function_type(&::CEGUI::Window::cloneChildWidgetsTo)
                , default_cloneChildWidgetsTo_function_type(&ListHeader_wrapper::default_cloneChildWidgetsTo)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::Window::clonePropertiesTo
        
            typedef void ( ::CEGUI::Window::*clonePropertiesTo_function_type )( ::CEGUI::Window & ) const;
            typedef void ( ListHeader_wrapper::*default_clonePropertiesTo_function_type )( ::CEGUI::Window & ) const;
            
            ListHeader_exposer.def( 
                "clonePropertiesTo"
                , clonePropertiesTo_function_type(&::CEGUI::Window::clonePropertiesTo)
                , default_clonePropertiesTo_function_type(&ListHeader_wrapper::default_clonePropertiesTo)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::Window::destroy
        
            typedef void ( ::CEGUI::Window::*destroy_function_type )(  ) ;
            typedef void ( ListHeader_wrapper::*default_destroy_function_type )(  ) ;
            
            ListHeader_exposer.def( 
                "destroy"
                , destroy_function_type(&::CEGUI::Window::destroy)
                , default_destroy_function_type(&ListHeader_wrapper::default_destroy) );
        
        }
        { //::CEGUI::Window::endInitialisation
        
            typedef void ( ::CEGUI::Window::*endInitialisation_function_type )(  ) ;
            typedef void ( ListHeader_wrapper::*default_endInitialisation_function_type )(  ) ;
            
            ListHeader_exposer.def( 
                "endInitialisation"
                , endInitialisation_function_type(&::CEGUI::Window::endInitialisation)
                , default_endInitialisation_function_type(&ListHeader_wrapper::default_endInitialisation) );
        
        }
        { //::CEGUI::EventSet::fireEvent
        
            typedef void ( ::CEGUI::EventSet::*fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            typedef void ( ListHeader_wrapper::*default_fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            
            ListHeader_exposer.def( 
                "fireEvent"
                , fireEvent_function_type(&::CEGUI::EventSet::fireEvent)
                , default_fireEvent_function_type(&ListHeader_wrapper::default_fireEvent)
                , ( bp::arg("name"), bp::arg("args"), bp::arg("eventNamespace")="" ) );
        
        }
        { //::CEGUI::Window::getRenderedStringParser
        
            typedef ::CEGUI::RenderedStringParser & ( ::CEGUI::Window::*getRenderedStringParser_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "getRenderedStringParser"
                , getRenderedStringParser_function_type(&::CEGUI::Window::getRenderedStringParser)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::Window::getRenderingContext_impl
        
            typedef void ( ::CEGUI::Window::*getRenderingContext_impl_function_type )( ::CEGUI::RenderingContext & ) const;
            typedef void ( ListHeader_wrapper::*default_getRenderingContext_impl_function_type )( ::CEGUI::RenderingContext & ) const;
            
            ListHeader_exposer.def( 
                "getRenderingContext_impl"
                , getRenderingContext_impl_function_type(&::CEGUI::Window::getRenderingContext_impl)
                , default_getRenderingContext_impl_function_type(&ListHeader_wrapper::default_getRenderingContext_impl)
                , ( bp::arg("ctx") ) );
        
        }
        { //::CEGUI::Window::getUnclippedInnerRect_impl
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getUnclippedInnerRect_impl_function_type )(  ) const;
            typedef ::CEGUI::Rect ( ListHeader_wrapper::*default_getUnclippedInnerRect_impl_function_type )(  ) const;
            
            ListHeader_exposer.def( 
                "getUnclippedInnerRect_impl"
                , getUnclippedInnerRect_impl_function_type(&::CEGUI::Window::getUnclippedInnerRect_impl)
                , default_getUnclippedInnerRect_impl_function_type(&ListHeader_wrapper::default_getUnclippedInnerRect_impl) );
        
        }
        { //::CEGUI::Window::initialiseComponents
        
            typedef void ( ::CEGUI::Window::*initialiseComponents_function_type )(  ) ;
            typedef void ( ListHeader_wrapper::*default_initialiseComponents_function_type )(  ) ;
            
            ListHeader_exposer.def( 
                "initialiseComponents"
                , initialiseComponents_function_type(&::CEGUI::Window::initialiseComponents)
                , default_initialiseComponents_function_type(&ListHeader_wrapper::default_initialiseComponents) );
        
        }
        { //::CEGUI::Window::isHit
        
            typedef bool ( ::CEGUI::Window::*isHit_function_type )( ::CEGUI::Vector2 const &,bool const ) const;
            typedef bool ( ListHeader_wrapper::*default_isHit_function_type )( ::CEGUI::Vector2 const &,bool const ) const;
            
            ListHeader_exposer.def( 
                "isHit"
                , isHit_function_type(&::CEGUI::Window::isHit)
                , default_isHit_function_type(&ListHeader_wrapper::default_isHit)
                , ( bp::arg("position"), bp::arg("allow_disabled")=(bool const)(false) ) );
        
        }
        { //::CEGUI::Window::performChildWindowLayout
        
            typedef void ( ::CEGUI::Window::*performChildWindowLayout_function_type )(  ) ;
            typedef void ( ListHeader_wrapper::*default_performChildWindowLayout_function_type )(  ) ;
            
            ListHeader_exposer.def( 
                "performChildWindowLayout"
                , performChildWindowLayout_function_type(&::CEGUI::Window::performChildWindowLayout)
                , default_performChildWindowLayout_function_type(&ListHeader_wrapper::default_performChildWindowLayout) );
        
        }
        { //::CEGUI::Window::setLookNFeel
        
            typedef void ( ::CEGUI::Window::*setLookNFeel_function_type )( ::CEGUI::String const & ) ;
            typedef void ( ListHeader_wrapper::*default_setLookNFeel_function_type )( ::CEGUI::String const & ) ;
            
            ListHeader_exposer.def( 
                "setLookNFeel"
                , setLookNFeel_function_type(&::CEGUI::Window::setLookNFeel)
                , default_setLookNFeel_function_type(&ListHeader_wrapper::default_setLookNFeel)
                , ( bp::arg("look") ) );
        
        }
        { //::CEGUI::Window::setMargin
        
            typedef void ( ::CEGUI::Window::*setMargin_function_type )( ::CEGUI::UBox const & ) ;
            typedef void ( ListHeader_wrapper::*default_setMargin_function_type )( ::CEGUI::UBox const & ) ;
            
            ListHeader_exposer.def( 
                "setMargin"
                , setMargin_function_type(&::CEGUI::Window::setMargin)
                , default_setMargin_function_type(&ListHeader_wrapper::default_setMargin)
                , ( bp::arg("margin") ) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ListHeader_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            ListHeader_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&ListHeader_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ListHeader_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            
            ListHeader_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&ListHeader_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("group"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::Window::update
        
            typedef void ( ::CEGUI::Window::*update_function_type )( float ) ;
            typedef void ( ListHeader_wrapper::*default_update_function_type )( float ) ;
            
            ListHeader_exposer.def( 
                "update"
                , update_function_type(&::CEGUI::Window::update)
                , default_update_function_type(&ListHeader_wrapper::default_update)
                , ( bp::arg("elapsed") ) );
        
        }
        { //::CEGUI::Window::writeXMLToStream
        
            typedef void ( ::CEGUI::Window::*writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            typedef void ( ListHeader_wrapper::*default_writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            ListHeader_exposer.def( 
                "writeXMLToStream"
                , writeXMLToStream_function_type(&::CEGUI::Window::writeXMLToStream)
                , default_writeXMLToStream_function_type(&ListHeader_wrapper::default_writeXMLToStream)
                , ( bp::arg("xml_stream") ) );
        
        }
    }

}
