(*:Name: Plot *)

(* :Title: Plot *)

(* :Author: Tom Wickham-Jones*)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 2.2 *)

(*:Summary:
	The package extends the Plot function to deal with singularities.	
*)

(* :History:
	Created summer 1993 by Tom Wickham-Jones.

	This package is described in the book
	Mathematica Graphics: Techniques and Applications.
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.

*)

(*:Warnings:
	The package adds rules to the Plot function.	
*)

BeginPackage[ "ExtendGraphics`Plot`"]




Begin["`Private`"]

If[ StringQ[ Plot::usage], 
	Plot::usage = 
		StringJoin[ Plot::usage, 
"Plot[ f, {x, xmin, x1, x2, .., xmax}] divides the plot range into various 
segments."]]
		

Unprotect[ Plot]

Plot[ f_, {x_, a_, lims__, b_}, opts___] :=
	Block[{ dfun, tmp, d},
		dfun = DisplayFunction /. {opts} /. Options[ Plot] ;
		d = (a - b) $MachineEpsilon 10 ;
		tmp = Partition[{ a, lims, b}, 2,1] ;
		tmp = Map[ (# + {d, -d})&, tmp] ;
		tmp = Map[ Plot[ f, Evaluate[Prepend[ #,x]],
                                  DisplayFunction -> Identity, opts]&, tmp] ;
		Show[ tmp, DisplayFunction -> dfun]
	]

End[]

EndPackage[]


(*:Examples:

Needs[ "ExtendGraphics`Plot`"]

Plot[ Tan[x], {x,0,Pi/2,Pi,3Pi/2,2Pi}]



*)


