{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetControlPoint: TAbstractCoordinateNode;
    procedure SetControlPoint(const Value: TAbstractCoordinateNode);
    function GetTessellation: Integer;
    procedure SetTessellation(const Value: Integer);
    function GetClosed: boolean;
    procedure SetClosed(const Value: boolean);
    function GetOrder: Integer;
    procedure SetOrder(const Value: Integer);
  public
    property ControlPoint: TAbstractCoordinateNode read GetControlPoint write SetControlPoint;
    property Tessellation: Integer read GetTessellation write SetTessellation;
    procedure SetWeight(const Value: array of Double);
    procedure SetWeight(const Value: TDoubleList);
    property Closed: boolean read GetClosed write SetClosed;
    procedure SetKnot(const Value: array of Double);
    procedure SetKnot(const Value: TDoubleList);
    property Order: Integer read GetOrder write SetOrder;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsCurveNode ----------------------------------------------- }

function TNurbsCurveNode.GetControlPoint: TAbstractCoordinateNode;
begin
  if FdControlPoint.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdControlPoint.Value)
  else
    Result := nil;
end;

procedure TNurbsCurveNode.SetControlPoint(const Value: TAbstractCoordinateNode);
begin
  FdControlPoint.Send(Value);
end;

function TNurbsCurveNode.GetTessellation: Integer;
begin
  Result := FdTessellation.Value;
end;

procedure TNurbsCurveNode.SetTessellation(const Value: Integer);
begin
  FdTessellation.Send(Value);
end;

procedure TNurbsCurveNode.SetWeight(const Value: array of Double);
begin
  FdWeight.Send(Value);
end;

procedure TNurbsCurveNode.SetWeight(const Value: TDoubleList);
begin
  FdWeight.Send(Value);
end;

function TNurbsCurveNode.GetClosed: boolean;
begin
  Result := FdClosed.Value;
end;

procedure TNurbsCurveNode.SetClosed(const Value: boolean);
begin
  FdClosed.Send(Value);
end;

procedure TNurbsCurveNode.SetKnot(const Value: array of Double);
begin
  FdKnot.Send(Value);
end;

procedure TNurbsCurveNode.SetKnot(const Value: TDoubleList);
begin
  FdKnot.Send(Value);
end;

function TNurbsCurveNode.GetOrder: Integer;
begin
  Result := FdOrder.Value;
end;

procedure TNurbsCurveNode.SetOrder(const Value: Integer);
begin
  FdOrder.Send(Value);
end;

{$endif read_implementation}
