/*
 * usage.c
 *
 * $Id: usage.c 23 2012-02-19 22:13:24Z diraison $
 *
 * This file is part of the btcheck project (c) 2008-2009 distributed
 * under the GNU GPLv3 license and created by Jean Diraison
 * <jean.diraison@ac-rennes.fr>
 *
 * URL: http://sourceforge.net/projects/btcheck/
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifndef PACKAGE_NAME
#define PACKAGE_NAME	"btcheck"
#endif
#ifndef VERSION
#define VERSION		"unknown"
#endif

void version()
{
	fprintf(stderr, PACKAGE_NAME " version " VERSION " (" CANONICAL_HOST ")\n");
	exit(EXIT_SUCCESS);
}

void usage(char *progname, int code)
{
	fprintf(stderr, "usage: %s [-h] [-V] [-v] [-q] [-z] [-n] [-i] [-l] file.torrent\n", progname);
	fprintf(stderr, "\t\t-h: show this help.\n");
	fprintf(stderr, "\t\t-V: show version number.\n");
	fprintf(stderr, "\t\t-v: verbose output.\n");
	fprintf(stderr, "\t\t-q: quiet, no output.\n");
	fprintf(stderr, "\t\t-z: fill missing data with zeros.\n");
	fprintf(stderr, "\t\t-n: do not check data (useful whith -i option and default with -l).\n");
	fprintf(stderr, "\t\t-i: show content informations of the given torrent file.\n");
	fprintf(stderr, "\t\t-l: list filenames in the given torrent file and don't check data.\n");
	exit(code);
}
