/*-
 * Copyright (c) 2004 Free (Olivier Beyssac)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#ifndef _UTILS_H
#define _UTILS_H

#include <signal.h>


#define savebufpos(svc, svl, buf, len) \
  do {               \
    svc = buf[len];  \
    svl = len;       \
    buf[len] = '\0'; \
  } while (0)
#define restorebuf(svc, svl, buf) buf[svl] = svc;


#define xsigaction(sa, signal, function) \
  do {                                   \
    sa.sa_flags = 0;                     \
    sigemptyset(&sa.sa_mask);            \
    sigaddset(&sa.sa_mask, signal);      \
    sa.sa_handler = function;            \
    sigaction(signal, &sa, NULL);        \
  } while(0)


/* Return a string converted to a long, -1 on failure */
long int xstrtol(const char *nptr);


/* Return a copy of the first n bytes of a string */
extern char *xstrndup(const char *s, const size_t size);


#endif /* _UTILS_H */
