/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import com.kreative.binpack.FPUtilities;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.StringCharacterIterator;
import java.util.BitSet;

public class BitOutputStream
extends OutputStream
implements Closeable,
DataOutput {
    private DataOutputStream out;
    private int bitpos;
    private int bittmp;
    private long bitswritten;

    public BitOutputStream(OutputStream out) {
        this.out = new DataOutputStream(out);
        this.bitpos = 0;
        this.bittmp = 0;
        this.bitswritten = 0L;
    }

    public boolean atBitBoundary(int multiple) {
        if (multiple < 0) {
            throw new IllegalArgumentException();
        }
        if (multiple == 0 || multiple == 1) {
            return true;
        }
        return this.bitswritten % (long)multiple == 0L;
    }

    public boolean atByteBoundary(int multiple) {
        if (multiple < 0) {
            throw new IllegalArgumentException();
        }
        if (multiple == 0) {
            return true;
        }
        if (multiple == 1) {
            return this.bitpos == 0;
        }
        return this.bitpos == 0 && (this.bitswritten >> 3) % (long)multiple == 0L;
    }

    public long bitsWritten() {
        return this.bitswritten;
    }

    public long bytesWritten() {
        return this.bitswritten >> 3;
    }

    public void writeBit(boolean bit) throws IOException {
        if (this.bitpos == 0) {
            this.bitpos = 128;
            this.bittmp = 0;
        }
        if (bit) {
            this.bittmp |= this.bitpos;
        }
        this.bitpos >>= 1;
        ++this.bitswritten;
        if (this.bitpos == 0) {
            this.out.writeByte(this.bittmp);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeBits(int n, BitSet bits) throws IOException {
        if (n >= 0) ** GOTO lbl4
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            this.writeBit(bits.get(--n));
lbl4:
            // 2 sources

            ** while (n > 0)
        }
lbl5:
        // 1 sources

    }

    public void writeBitsLE(int n, BitSet bits) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n != 0) {
            if (this.bitpos != 0 || (n & 7) != 0) {
                throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
            }
            int nb = (n >> 3) - 1;
            while (n > 0) {
                this.writeBit(bits.get(--n & 7 | nb - (n >> 3) << 3));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeInteger(int n, BigInteger i) throws IOException {
        if (n >= 0) ** GOTO lbl4
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            this.writeBit(i.testBit(--n));
lbl4:
            // 2 sources

            ** while (n > 0)
        }
lbl5:
        // 1 sources

    }

    public void writeIntegerLE(int n, BigInteger i) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n != 0) {
            if (this.bitpos != 0 || (n & 7) != 0) {
                throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
            }
            int nb = (n >> 3) - 1;
            while (n > 0) {
                this.writeBit(i.testBit(--n & 7 | nb - (n >> 3) << 3));
            }
        }
    }

    public void writeFloat(int n, MathContext mc, Number v) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int s = FPUtilities.optimalSignWidth(n);
        int e = FPUtilities.optimalExponentWidth(n);
        int m = FPUtilities.optimalMantissaWidth(n);
        this.writeFloat(s, e, m, mc, v);
    }

    public void writeFloatLE(int n, MathContext mc, Number v) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int s = FPUtilities.optimalSignWidth(n);
        int e = FPUtilities.optimalExponentWidth(n);
        int m = FPUtilities.optimalMantissaWidth(n);
        this.writeFloatLE(s, e, m, mc, v);
    }

    public void writeFloat(int s, int e, int m, MathContext mc, Number v) throws IOException {
        if (s < 0 || s > 1 || e < 0 || m < 0) {
            throw new IllegalArgumentException();
        }
        int b = FPUtilities.optimalBias(e);
        this.writeFloat(s, e, m, b, mc, v);
    }

    public void writeFloatLE(int s, int e, int m, MathContext mc, Number v) throws IOException {
        if (s < 0 || s > 1 || e < 0 || m < 0) {
            throw new IllegalArgumentException();
        }
        int b = FPUtilities.optimalBias(e);
        this.writeFloatLE(s, e, m, b, mc, v);
    }

    public void writeFloat(int s, int e, int m, int b, MathContext mc, Number v) throws IOException {
        if (s < 0 || s > 1 || e < 0 || m < 0) {
            throw new IllegalArgumentException();
        }
        BigInteger[] r = FPUtilities.encodeFloat(v, s, e, m, b, mc);
        this.writeInteger(s, r[0]);
        this.writeInteger(e, r[1]);
        this.writeInteger(m, r[2]);
    }

    public void writeFloatLE(int s, int e, int m, int b, MathContext mc, Number v) throws IOException {
        if (s < 0 || s > 1 || e < 0 || m < 0) {
            throw new IllegalArgumentException();
        }
        if (this.bitpos != 0 || (s + e + m & 7) != 0) {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
        BigInteger[] r = FPUtilities.encodeFloat(v, s, e, m, b, mc);
        BigInteger i = FPUtilities.joinFloat(r[0], r[1], r[2], s, e, m);
        this.writeIntegerLE(s + e + m, i);
    }

    @Override
    public void close() throws IOException {
        if (this.bitpos != 0) {
            this.out.writeByte(this.bittmp);
        }
        this.out.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bitpos == 0) {
            this.out.write(b);
            this.bitswritten += 8L;
        } else {
            int pos = 128;
            while (pos != 0) {
                this.writeBit((b & pos) != 0);
                pos >>>= 1;
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.bitpos == 0) {
            this.out.write(b);
            this.bitswritten += (long)b.length << 3;
        } else {
            byte[] byArray = b;
            int n = b.length;
            int n2 = 0;
            while (n2 < n) {
                byte bb = byArray[n2];
                int pos = 128;
                while (pos != 0) {
                    this.writeBit((bb & pos) != 0);
                    pos >>>= 1;
                }
                ++n2;
            }
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bitpos == 0) {
            this.out.write(b, off, len);
            this.bitswritten += (long)len << 3;
        } else {
            int i = 0;
            while (i < len) {
                int pos = 128;
                while (pos != 0) {
                    this.writeBit((b[off] & pos) != 0);
                    pos >>>= 1;
                }
                ++off;
                ++i;
            }
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeBoolean(v);
            this.bitswritten += 8L;
        } else {
            this.writeByte(v ? 1 : 0);
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeByte(v);
            this.bitswritten += 8L;
        } else {
            int pos = 128;
            while (pos != 0) {
                this.writeBit((v & pos) != 0);
                pos >>>= 1;
            }
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeShort(v);
            this.bitswritten += 16L;
        } else {
            int pos = 32768;
            while (pos != 0) {
                this.writeBit((v & pos) != 0);
                pos >>>= 1;
            }
        }
    }

    public void writeShortLE(int v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeShort(Short.reverseBytes((short)v));
            this.bitswritten += 16L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeChar(v);
            this.bitswritten += 16L;
        } else {
            int pos = 32768;
            while (pos != 0) {
                this.writeBit((v & pos) != 0);
                pos >>>= 1;
            }
        }
    }

    public void writeCharLE(int v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeChar(Character.reverseBytes((char)v));
            this.bitswritten += 16L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeInt(v);
            this.bitswritten += 32L;
        } else {
            int pos = Integer.MIN_VALUE;
            while (pos != 0) {
                this.writeBit((v & pos) != 0);
                pos >>>= 1;
            }
        }
    }

    public void writeIntLE(int v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeInt(Integer.reverseBytes(v));
            this.bitswritten += 32L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeLong(v);
            this.bitswritten += 64L;
        } else {
            long pos = Long.MIN_VALUE;
            while (pos != 0L) {
                this.writeBit((v & pos) != 0L);
                pos >>>= 1;
            }
        }
    }

    public void writeLongLE(long v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeLong(Long.reverseBytes(v));
            this.bitswritten += 64L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeFloat(v);
            this.bitswritten += 32L;
        } else {
            this.writeInt(Float.floatToRawIntBits(v));
        }
    }

    public void writeFloatLE(float v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeInt(Integer.reverseBytes(Float.floatToRawIntBits(v)));
            this.bitswritten += 32L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeDouble(v);
            this.bitswritten += 64L;
        } else {
            this.writeLong(Double.doubleToRawLongBits(v));
        }
    }

    public void writeDoubleLE(double v) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeLong(Long.reverseBytes(Double.doubleToRawLongBits(v)));
            this.bitswritten += 64L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeBytes(s);
            this.bitswritten += (long)s.length() << 3;
        } else {
            StringCharacterIterator i = new StringCharacterIterator(s);
            char ch = i.first();
            while (ch != '\uffff') {
                this.writeByte(ch);
                ch = i.next();
            }
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeChars(s);
            this.bitswritten += (long)s.length() << 4;
        } else {
            StringCharacterIterator i = new StringCharacterIterator(s);
            char ch = i.first();
            while (ch != '\uffff') {
                this.writeChar(ch);
                ch = i.next();
            }
        }
    }

    public void writeCharsLE(String s) throws IOException {
        if (this.bitpos == 0) {
            StringCharacterIterator i = new StringCharacterIterator(s);
            char ch = i.first();
            while (ch != '\uffff') {
                this.out.writeChar(Character.reverseBytes(ch));
                this.bitswritten += 16L;
                ch = i.next();
            }
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        throw new UnsupportedOperationException();
    }
}

