/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.rsrc.MacResource;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class ColorLookUpTableResource
extends MacResource {
    public static final int RESOURCE_TYPE = 1668052340;
    public static final short FLAG_FOR_DEVICE = Short.MIN_VALUE;

    public static boolean isMyType(int type) {
        return type == 1668052340;
    }

    public ColorLookUpTableResource(short id, byte[] data) {
        super(1668052340, id, data);
    }

    public ColorLookUpTableResource(short id, String name, byte[] data) {
        super(1668052340, id, name, data);
    }

    public ColorLookUpTableResource(short id, byte attr, byte[] data) {
        super(1668052340, id, attr, data);
    }

    public ColorLookUpTableResource(short id, byte attr, String name, byte[] data) {
        super(1668052340, id, attr, name, data);
    }

    public ColorLookUpTableResource(int type, short id, byte[] data) {
        super(type, id, data);
    }

    public ColorLookUpTableResource(int type, short id, String name, byte[] data) {
        super(type, id, name, data);
    }

    public ColorLookUpTableResource(int type, short id, byte attr, byte[] data) {
        super(type, id, attr, data);
    }

    public ColorLookUpTableResource(int type, short id, byte attr, String name, byte[] data) {
        super(type, id, attr, name, data);
    }

    public int getSeed() {
        return KSFLUtilities.getInt(this.data, 0);
    }

    public short getFlags() {
        return KSFLUtilities.getShort(this.data, 4);
    }

    public int getColorCount() {
        return KSFLUtilities.getShort(this.data, 6) + 1 & 0xFFFF;
    }

    public int arrayIndexToPixelIndex(int aIndex) {
        return KSFLUtilities.getShort(this.data, 8 + aIndex * 8) & 0xFFFF;
    }

    public int pixelIndexToArrayIndex(int pIndex) {
        int i = 0;
        int p = 8;
        while (p < this.data.length) {
            if (KSFLUtilities.getShort(this.data, p) == (short)pIndex) {
                return i;
            }
            ++i;
            p += 8;
        }
        return -1;
    }

    public int[] getColor8ByArrayIndex(int ai) {
        return new int[]{(KSFLUtilities.getShort(this.data, 8 + ai * 8 + 2) & 0xFFFF) / 257, (KSFLUtilities.getShort(this.data, 8 + ai * 8 + 4) & 0xFFFF) / 257, (KSFLUtilities.getShort(this.data, 8 + ai * 8 + 6) & 0xFFFF) / 257};
    }

    public int[] getColor16ByArrayIndex(int ai) {
        return new int[]{KSFLUtilities.getShort(this.data, 8 + ai * 8 + 2) & 0xFFFF, KSFLUtilities.getShort(this.data, 8 + ai * 8 + 4) & 0xFFFF, KSFLUtilities.getShort(this.data, 8 + ai * 8 + 6) & 0xFFFF};
    }

    public float[] getColorFloatsByArrayIndex(int ai) {
        return new float[]{(float)(KSFLUtilities.getShort(this.data, 8 + ai * 8 + 2) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(this.data, 8 + ai * 8 + 4) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(this.data, 8 + ai * 8 + 6) & 0xFFFF) / 65535.0f};
    }

    public Color getColorByArrayIndex(int ai) {
        return new Color((float)(KSFLUtilities.getShort(this.data, 8 + ai * 8 + 2) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(this.data, 8 + ai * 8 + 4) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(this.data, 8 + ai * 8 + 6) & 0xFFFF) / 65535.0f);
    }

    public int[] getColor8ByPixelIndex(int pi) {
        return this.getColor8ByArrayIndex(this.pixelIndexToArrayIndex(pi));
    }

    public int[] getColor16ByPixelIndex(int pi) {
        return this.getColor16ByArrayIndex(this.pixelIndexToArrayIndex(pi));
    }

    public float[] getColorFloatsByPixelIndex(int pi) {
        return this.getColorFloatsByArrayIndex(this.pixelIndexToArrayIndex(pi));
    }

    public Color getColorByPixelIndex(int pi) {
        return this.getColorByArrayIndex(this.pixelIndexToArrayIndex(pi));
    }

    public Color[] getColorsByArrayIndex() {
        int cc = KSFLUtilities.getShort(this.data, 6) + 1 & 0xFFFF;
        Color[] ret = new Color[cc];
        int i = 0;
        int p = 8;
        while (i < cc && p < this.data.length) {
            ret[i] = new Color((float)(KSFLUtilities.getShort(this.data, p + 2) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(this.data, p + 4) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(this.data, p + 6) & 0xFFFF) / 65535.0f);
            ++i;
            p += 8;
        }
        return ret;
    }

    public Map<Integer, Color> getColorsByPixelIndex() {
        int cc = KSFLUtilities.getShort(this.data, 6) + 1 & 0xFFFF;
        HashMap<Integer, Color> ret = new HashMap<Integer, Color>();
        int i = 0;
        int p = 8;
        while (i < cc && p < this.data.length) {
            ret.put(KSFLUtilities.getShort(this.data, p) & 0xFFFF, new Color((float)(KSFLUtilities.getShort(this.data, p + 2) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(this.data, p + 4) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(this.data, p + 6) & 0xFFFF) / 65535.0f));
            ++i;
            p += 8;
        }
        return ret;
    }
}

