#!/bin/bash
# -*- shell-script -*-

# Test _Dbg_file_canonic
test_file_file_canonic()
{
    _Dbg_set_basename=0
    for file in /tmp/foo.bar /a/b/foo.bar foo.bar ; do 
	typeset canonic_file
	canonic_file=$(_Dbg_file_canonic "$file")
	assertEquals 'canonic_file should return 0' '0' $?
	assertEquals 'canonic_file should do nothing' "$file" "$canonic_file"
    done

    _Dbg_set_basename=1
    typeset canonic_file
    for file in /tmp/foo.bar /a/b/foo.bar foo.bar ; do 
	canonic_file=$(_Dbg_file_canonic "$file")
	assertEquals 'canonic_file should return 0' '0' $?
	assertEquals 'canonic_file should shorten file' 'foo.bar' "$canonic_file"
    done
    canonic_file=$(_Dbg_file_canonic)
    assertNotEquals 'canonic_file not should return 0' '0' $?
    # Other tests need _Dbg_set_basename = 0
    _Dbg_set_basename=0
}

# Test _Dbg_glob_filename
test_file_glob_filename()
{
    typeset filename

    filename=''
    _Dbg_glob_filename $shunit_file
    assertEquals '0' $?
    filename=${filename##*/}  
    assertEquals 'shunit2' $filename

    _Dbg_glob_filename ./${srcdir}shunit?
    assertEquals '0' $?
    filename=${filename##*/}  
    assertEquals 'shunit2' $filename

    _Dbg_glob_filename ./${srcdir}[a-s]h*nit?
    assertEquals '0' $?
    filename=${filename##*/}  
    assertEquals 'shunit2' $filename

    _Dbg_glob_filename ${srcdir}abcdefg
    assertEquals '1' $?
    filename=${filename##*/}  
    assertEquals 'abcdefg' "$filename"

    if [[ -r ~ ]] ; then
	_Dbg_glob_filename '~'
	assertEquals '0' $?
	assertEquals ~ "$filename"
    fi

    _Dbg_glob_filename ${srcdir}'some embedded spaces'
    assertEquals '1' $?
    filename=${filename##*/}  
    assertEquals 'some embedded spaces' "$filename"
    
}

# Test _Dbg_adjust_filename
test_file_adjust_filename()
{
    typeset filename
    _Dbg_set_annotate=0
    _Dbg_set_basename=0
    filename=$(_Dbg_adjust_filename abc)
    assertEquals 'abc' $filename
    filename=$(_Dbg_adjust_filename /abc)
    assertEquals '/abc' $filename
    _Dbg_set_basename=1
    filename=$(_Dbg_adjust_filename /abc)
    assertEquals 'abc' $filename
}

# Test _Dbg_glob_filename
test_file_resolve_expand_filename()
{
    filename=$(_Dbg_resolve_expand_filename /)
    assertEquals '0' $?
    assertEquals '/' "$filename"
    filename=$(_Dbg_resolve_expand_filename .)
    assertEquals '0' $?
    assertEquals '/' "${filename:0:1}"
    filename=$(_Dbg_resolve_expand_filename ./fdafdsa)
    assertEquals '0' $?
    typeset -i size=${#filename}
    assertEquals '/fdafdsa' "${filename:$size-8}"
    assertNotEquals '.' "${filename:$size-1}"
}

abs_top_srcdir=/src/external-vcs/bashdb
# Make sure $abs_top_srcrdir has a trailing slash
abs_top_srcdir=${abs_top_srcdir%%/}/
. ${abs_top_srcdir}test/unit/helper.sh

srcdir=.
srcdir=${srcdir%%/}/

. $abs_top_srcdir/init/pre.sh
. $abs_top_srcdir/lib/filecache.sh
. $abs_top_srcdir/lib/file.sh

set -- # reset $# so shunit2 doesn't get confused.

[[ $0 == ${BASH_SOURCE} ]] && . ${shunit_file}
