# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# --------------------------------------------------------------------------------------------
# pylint: skip-file
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrestazure.azure_exceptions import CloudError
from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError
from . import models


class DigitalTwinRepositoryProvisioningServiceConfiguration(Configuration):
    """Configuration for DigitalTwinRepositoryProvisioningService
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        if not base_url:
            base_url = 'http://localhost'

        super(DigitalTwinRepositoryProvisioningServiceConfiguration, self).__init__(base_url)

        self.add_user_agent('digitaltwinrepositoryprovisioningservice/{}'.format(VERSION))


class DigitalTwinRepositoryProvisioningService(object):
    """DigitalTwin Repository Control Plane Service. Provisions Repository and Access keys to a repository.

    :ivar config: Configuration for client.
    :vartype config: DigitalTwinRepositoryProvisioningServiceConfiguration

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        self.config = DigitalTwinRepositoryProvisioningServiceConfiguration(base_url)
        self._client = ServiceClient(None, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2019-07-01-Preview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

    def get_keys_async(
            self, repository_id, api_version, custom_headers=None, raw=False, **operation_config):
        """Gets all the keys associated to a repository.
        Connection String format:
        HostName=repository svc endpoint;RepositoryId=repository
        id(GUID);SharedAccessKeyName =access key id/name;SharedAccessKey=shared
        access key;.

        :param repository_id: Repository id
        :type repository_id: str
        :param api_version: API version.
        :type api_version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype:
         list[~digitaltwinrepositoryprovisioningservice.models.KeyMetadata] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_keys_async.metadata['url']
        path_format_arguments = {
            'repositoryId': self._serialize.url("repository_id", repository_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise CloudError(response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[KeyMetadata]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_keys_async.metadata = {'url': '/repositories/{repositoryId}/authKeys'}

    def create_or_update_key_async(
            self, repository_id, api_version, properties=None, custom_headers=None, raw=False, **operation_config):
        """Creates or updates a key for the given repository.
        If Id present in the RepositoryKeyRequest's properties, it will update
        the key with new key.
        Otherwise return a new key.

        :param repository_id: Repository id
        :type repository_id: str
        :param api_version: API version.
        :type api_version: str
        :param properties:
        :type properties:
         ~digitaltwinrepositoryprovisioningservice.models.RepositoryKeyRequestProperties
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: KeyMetadata or ClientRawResponse if raw=true
        :rtype: ~digitaltwinrepositoryprovisioningservice.models.KeyMetadata
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        repository_key_request = None
        if properties is not None:
            repository_key_request = models.RepositoryKeyRequest(properties=properties)

        # Construct URL
        url = self.create_or_update_key_async.metadata['url']
        path_format_arguments = {
            'repositoryId': self._serialize.url("repository_id", repository_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if repository_key_request is not None:
            body_content = self._serialize.body(repository_key_request, 'RepositoryKeyRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise CloudError(response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('KeyMetadata', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_or_update_key_async.metadata = {'url': '/repositories/{repositoryId}/authKeys'}

    def get_key_async(
            self, repository_id, id, api_version, custom_headers=None, raw=False, **operation_config):
        """Gets a key metadata information for the given key.
        Connection String format:
        HostName=repository svc endpoint;RepositoryId=repository
        id(GUID);SharedAccessKeyName =access key id/name;SharedAccessKey=shared
        access key;.

        :param repository_id: Repository Id
        :type repository_id: str
        :param id: Key Id.
        :type id: str
        :param api_version: API version.
        :type api_version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: KeyMetadata or ClientRawResponse if raw=true
        :rtype: ~digitaltwinrepositoryprovisioningservice.models.KeyMetadata
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_key_async.metadata['url']
        path_format_arguments = {
            'repositoryId': self._serialize.url("repository_id", repository_id, 'str'),
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise CloudError(response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('KeyMetadata', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_key_async.metadata = {'url': '/repositories/{repositoryId}/authKeys/{id}'}

    def delete_key_async(
            self, id, repository_id, api_version, custom_headers=None, raw=False, **operation_config):
        """Deletes a key from the given repository.

        :param id: Key id.
        :type id: str
        :param repository_id: Repository id.
        :type repository_id: str
        :param api_version: API version.
        :type api_version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_key_async.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
            'repositoryId': self._serialize.url("repository_id", repository_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise CloudError(response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_key_async.metadata = {'url': '/repositories/{repositoryId}/authKeys/{id}'}

    def get_repositories_async(
            self, api_version, custom_headers=None, raw=False, **operation_config):
        """Gets all the repositories metadata belong to the user's tenant.

        :param api_version: API version.
        :type api_version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype:
         list[~digitaltwinrepositoryprovisioningservice.models.RepositoryMetadata]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_repositories_async.metadata['url']

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise CloudError(response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[RepositoryMetadata]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_repositories_async.metadata = {'url': '/repositories'}

    def create_or_update_repository_async(
            self, api_version, properties=None, custom_headers=None, raw=False, **operation_config):
        """Create or updates a repository.
        If Id is present in the RepositoryRequest properties object, service
        tries to update the repository.
        otherwise it will try to create repository.

        :param api_version: API version.
        :type api_version: str
        :param properties:
        :type properties:
         ~digitaltwinrepositoryprovisioningservice.models.RepositoryUpsertRequestProperties
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: RepositoryProvisionResponseBase or ClientRawResponse if
         raw=true
        :rtype:
         ~digitaltwinrepositoryprovisioningservice.models.RepositoryProvisionResponseBase
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        repository_upsert_request = None
        if properties is not None:
            repository_upsert_request = models.RepositoryUpsertRequest(properties=properties)

        # Construct URL
        url = self.create_or_update_repository_async.metadata['url']

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if repository_upsert_request is not None:
            body_content = self._serialize.body(repository_upsert_request, 'RepositoryUpsertRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise CloudError(response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('RepositoryProvisionResponseBase', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_or_update_repository_async.metadata = {'url': '/repositories'}

    def get_repository_async(
            self, repository_id, api_version, custom_headers=None, raw=False, **operation_config):
        """Gets the repository metadata for the given repository id.

        :param repository_id: Repository Id.
        :type repository_id: str
        :param api_version: API version.
        :type api_version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: RepositoryMetadata or ClientRawResponse if raw=true
        :rtype:
         ~digitaltwinrepositoryprovisioningservice.models.RepositoryMetadata or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_repository_async.metadata['url']
        path_format_arguments = {
            'repositoryId': self._serialize.url("repository_id", repository_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise CloudError(response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('RepositoryMetadata', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_repository_async.metadata = {'url': '/repositories/{repositoryId}'}

    def delete_repository_async(
            self, repository_id, api_version, custom_headers=None, raw=False, **operation_config):
        """Deletes the repository for given id.

        :param repository_id: Repository Id
        :type repository_id: str
        :param api_version: API version.
        :type api_version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: RepositoryProvisionResponseBase or ClientRawResponse if
         raw=true
        :rtype:
         ~digitaltwinrepositoryprovisioningservice.models.RepositoryProvisionResponseBase
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_repository_async.metadata['url']
        path_format_arguments = {
            'repositoryId': self._serialize.url("repository_id", repository_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise CloudError(response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('RepositoryProvisionResponseBase', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_repository_async.metadata = {'url': '/repositories/{repositoryId}'}

    def get_provision_status(
            self, repository_id, tracking_id, api_version, custom_headers=None, raw=False, **operation_config):
        """Returns the repository provisioning status.

        :param repository_id: Repository id.
        :type repository_id: str
        :param tracking_id: Tracking id (provisioningState)
        :type tracking_id: str
        :param api_version: API version.
        :type api_version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: RepositoryProvisionResponseBase or ClientRawResponse if
         raw=true
        :rtype:
         ~digitaltwinrepositoryprovisioningservice.models.RepositoryProvisionResponseBase
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_provision_status.metadata['url']
        path_format_arguments = {
            'repositoryId': self._serialize.url("repository_id", repository_id, 'str'),
            'trackingId': self._serialize.url("tracking_id", tracking_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise CloudError(response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('RepositoryProvisionResponseBase', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_provision_status.metadata = {'url': '/repositories/{repositoryId}/status/{trackingId}'}
