/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.sigfile.AnnotationParser;
import com.sun.tdk.signaturetest.sigfile.Parser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class F40Parser
implements Parser {
    private String line;
    private int linesz;
    private int idx;
    private char chr;
    private List elems;
    private String currentClassName;

    F40Parser() {
    }

    public ClassDescription parseClassDescription(String classDefinition, List members) {
        ClassDescription classDescription = this.processClassDescription(classDefinition);
        MemberDescription m2 = classDescription;
        ArrayList<String> alist = new ArrayList<String>();
        ArrayList<MemberDescription> items = new ArrayList<MemberDescription>();
        int method_count = 0;
        int field_count = 0;
        int constructor_count = 0;
        int inner_count = 0;
        int interfaces_count = 0;
        for (String str : members) {
            if (this.parseFutureSpecific(str, classDescription)) continue;
            if ((str = this.convertFutureSpecific(str, classDescription)).startsWith("anno")) {
                alist.add(str);
                continue;
            }
            if (str.startsWith("outer")) {
                this.processOuter(classDescription, str);
                continue;
            }
            if (str.startsWith("hfds")) {
                Set internalFields = this.parseInternals(str);
                classDescription.setInternalFields(internalFields);
                continue;
            }
            if (str.startsWith("hcls")) {
                Set internalClasses = this.parseInternals(str);
                classDescription.setInternalClasses(internalClasses);
                continue;
            }
            this.appendAnnotations(m2, alist);
            m2 = this.parse(str);
            MemberType mt = m2.getMemberType();
            if (mt == MemberType.METHOD) {
                ++method_count;
            } else if (mt == MemberType.FIELD) {
                ++field_count;
            } else if (mt == MemberType.CONSTRUCTOR) {
                ++constructor_count;
            } else if (mt == MemberType.INNER) {
                ++inner_count;
            } else if (mt == MemberType.SUPERINTERFACE) {
                ++interfaces_count;
            }
            if (m2 == classDescription) continue;
            items.add(m2);
        }
        this.appendAnnotations(m2, alist);
        if (constructor_count > 0) {
            classDescription.createConstructors(constructor_count);
        }
        if (method_count > 0) {
            classDescription.createMethods(method_count);
        }
        if (field_count > 0) {
            classDescription.createFields(field_count);
        }
        if (inner_count > 0) {
            classDescription.createNested(inner_count);
        }
        if (interfaces_count > 0) {
            classDescription.createInterfaces(interfaces_count);
        }
        constructor_count = 0;
        method_count = 0;
        field_count = 0;
        inner_count = 0;
        interfaces_count = 0;
        for (MemberDescription m2 : items) {
            MemberType mt = m2.getMemberType();
            if (mt == MemberType.METHOD) {
                classDescription.setMethod(method_count, (MethodDescr)m2);
                ++method_count;
                continue;
            }
            if (mt == MemberType.FIELD) {
                classDescription.setField(field_count, (FieldDescr)m2);
                ++field_count;
                continue;
            }
            if (mt == MemberType.CONSTRUCTOR) {
                classDescription.setConstructor(constructor_count, (ConstructorDescr)m2);
                ((ConstructorDescr)m2).setupConstuctorName(classDescription.getQualifiedName());
                ++constructor_count;
                continue;
            }
            if (mt == MemberType.INNER) {
                classDescription.setNested(inner_count, (InnerDescr)m2);
                ++inner_count;
                continue;
            }
            if (mt == MemberType.SUPERCLASS) {
                classDescription.setSuperClass((SuperClass)m2);
                continue;
            }
            if (mt == MemberType.SUPERINTERFACE) {
                SuperInterface si = (SuperInterface)m2;
                si.setDirect(true);
                classDescription.setInterface(interfaces_count, si);
                ++interfaces_count;
                continue;
            }
            assert (false);
        }
        return classDescription;
    }

    protected boolean parseFutureSpecific(String str, ClassDescription cl) {
        return false;
    }

    protected String convertFutureSpecific(String str, ClassDescription classDescription) {
        return str;
    }

    protected void processOuter(ClassDescription classDescription, String str) {
    }

    protected Set parseInternals(String str) {
        int nextPos;
        HashSet<String> result = new HashSet<String>();
        int startPos = str.indexOf(32) + 1;
        do {
            String name;
            if ((nextPos = str.indexOf(44, startPos)) != -1) {
                name = str.substring(startPos, nextPos);
                startPos = nextPos + 1;
            } else {
                name = str.substring(startPos);
            }
            result.add(name);
        } while (nextPos != -1);
        return result;
    }

    protected void appendAnnotations(MemberDescription fid, List alist) {
        if (alist.size() != 0) {
            AnnotationItem[] tmp = new AnnotationItem[alist.size()];
            AnnotationParser par = new AnnotationParser();
            for (int i = 0; i < alist.size(); ++i) {
                tmp[i] = par.parse((String)alist.get(i));
            }
            fid.setAnnoList(tmp);
            alist.clear();
        }
    }

    protected MemberDescription parse(String definition) {
        MemberDescription member = null;
        MemberType type = MemberType.getItemType(definition);
        if (type == MemberType.CLASS) {
            member = this.parse(new ClassDescription(), definition);
            this.currentClassName = member.getQualifiedName();
        } else if (type == MemberType.CONSTRUCTOR) {
            member = this.parse(new ConstructorDescr(), definition);
        } else if (type == MemberType.METHOD) {
            member = this.parse(new MethodDescr(), definition);
        } else if (type == MemberType.FIELD) {
            member = this.parse(new FieldDescr(), definition);
        } else if (type == MemberType.SUPERCLASS) {
            member = this.parse(new SuperClass(), definition);
        } else if (type == MemberType.SUPERINTERFACE) {
            member = this.parse(new SuperInterface(), definition);
        } else if (type == MemberType.INNER) {
            member = this.parse(new InnerDescr(), definition);
        } else assert (false);
        return member;
    }

    protected ClassDescription processClassDescription(String classDefinition) {
        ClassDescription classDescription = (ClassDescription)this.parse(classDefinition);
        return classDescription;
    }

    private void init(MemberDescription m, String def) {
        this.line = def.trim();
        this.linesz = this.line.length();
        this.idx = def.indexOf(32);
        this.scanElems();
    }

    protected MemberDescription parse(ClassDescription cls, String def) {
        this.init(cls, def);
        cls.setModifiers(Modifier.scanModifiers(this.elems));
        String s = this.getElem();
        cls.setupGenericClassName(s);
        return cls;
    }

    private MemberDescription parse(ConstructorDescr ctor, String def) {
        this.init(ctor, def);
        ctor.setModifiers(Modifier.scanModifiers(this.elems));
        String s = this.getElem();
        if (s != null && s.charAt(0) == '<') {
            ctor.setTypeParameters(s);
            s = this.getElem();
        }
        ctor.setupConstuctorName(s);
        s = this.getElem();
        if (s.charAt(0) != '(') {
            this.err();
        }
        if (!"()".equals(s)) {
            ctor.setArgs(s.substring(1, s.length() - 1));
        }
        if (this.elems.size() != 0) {
            s = this.getElem();
            if (!s.equals("throws")) {
                this.err();
            }
            s = this.getElem();
            ctor.setThrowables(s);
        }
        return ctor;
    }

    private MemberDescription parse(MethodDescr method, String def) {
        this.init(method, def);
        method.setModifiers(Modifier.scanModifiers(this.elems));
        String s = this.getElem();
        if (s != null && s.charAt(0) == '<') {
            method.setTypeParameters(s);
            s = this.getElem();
        }
        method.setType(s);
        method.setupMemberName(this.getElem(), this.currentClassName);
        s = this.getElem();
        if (s.charAt(0) != '(') {
            this.err();
        }
        if (!"()".equals(s)) {
            method.setArgs(s.substring(1, s.length() - 1));
        }
        if (this.elems.size() != 0) {
            s = this.getElem();
            if (!s.equals("throws")) {
                this.err();
            }
            s = this.getElem();
            method.setThrowables(s);
        }
        return method;
    }

    private MemberDescription parse(FieldDescr field, String def) {
        this.init(field, def);
        field.setModifiers(Modifier.scanModifiers(this.elems));
        String s = this.getElem();
        field.setType(s);
        s = this.getElem();
        field.setupMemberName(s, this.currentClassName);
        if (this.elems.size() != 0) {
            s = this.getElem();
            if (!s.startsWith("=")) {
                this.err();
            }
            field.setConstantValue(s.substring(1).trim());
        }
        return field;
    }

    private MemberDescription parse(SuperClass superCls, String def) {
        this.init(superCls, def);
        superCls.setModifiers(Modifier.scanModifiers(this.elems));
        int n = this.elems.size();
        if (n == 0) {
            this.err();
        }
        superCls.setupGenericClassName((String)this.elems.get(n - 1));
        return superCls;
    }

    private MemberDescription parse(SuperInterface superIntf, String def) {
        this.init(superIntf, def);
        superIntf.setModifiers(Modifier.scanModifiers(this.elems));
        int n = this.elems.size();
        if (n == 0) {
            this.err();
        }
        superIntf.setupGenericClassName((String)this.elems.get(n - 1));
        return superIntf;
    }

    private MemberDescription parse(InnerDescr inner, String def) {
        this.init(inner, def);
        inner.setModifiers(Modifier.scanModifiers(this.elems));
        String s = this.getElem();
        inner.setupInnerClassName(s, this.currentClassName);
        return inner;
    }

    private String getElem() {
        String s = null;
        if (this.elems.size() != 0) {
            s = (String)this.elems.get(0);
            this.elems.remove(0);
        }
        if (s == null) {
            this.err();
        }
        return s;
    }

    private void scanElems() {
        this.elems = new LinkedList();
        while (true) {
            if (this.idx < this.linesz && (this.chr = this.line.charAt(this.idx)) == ' ') {
                ++this.idx;
                continue;
            }
            if (this.idx >= this.linesz) break;
            int pos = this.idx++;
            if (this.chr == '=') {
                this.idx = this.linesz;
                this.elems.add(this.line.substring(pos));
                break;
            }
            if (this.chr == '(') {
                this.skip(')');
                ++this.idx;
                this.elems.add(this.line.substring(pos, this.idx));
                continue;
            }
            if (this.chr == '<') {
                ++this.idx;
                this.skip('>');
                ++this.idx;
                this.elems.add(this.line.substring(pos, this.idx));
                continue;
            }
            ++this.idx;
            while (this.idx < this.linesz) {
                this.chr = this.line.charAt(this.idx);
                if (this.chr == '<') {
                    ++this.idx;
                    this.skip('>');
                    ++this.idx;
                    continue;
                }
                if (this.chr == ' ' || this.chr == '(') break;
                ++this.idx;
            }
            this.elems.add(this.line.substring(pos, this.idx));
        }
    }

    private void skip(char term) {
        while (true) {
            if (this.idx >= this.linesz) {
                this.err();
            }
            if ((this.chr = this.line.charAt(this.idx)) == term) {
                return;
            }
            if (this.chr == '(') {
                ++this.idx;
                this.skip(')');
                ++this.idx;
                continue;
            }
            if (this.chr == '<') {
                ++this.idx;
                this.skip('>');
                ++this.idx;
                continue;
            }
            ++this.idx;
        }
    }

    private void err() {
        throw new Error(this.line);
    }
}

