/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.attribute.Attribute;

public class LocalVariableTableAttribute
extends Attribute {
    public static final String ATTRIBUTE_NAME = "LocalVariableTable";
    private List<LocalVariable> localVariables = new LinkedList<LocalVariable>();

    public LocalVariableTableAttribute(ConstantPool cp) {
        super(cp.addUtf8Info(ATTRIBUTE_NAME).getEntryIndex());
        this.setConstantPool(cp);
    }

    LocalVariableTableAttribute(short nameIndex, int attributeLength, DataInputStream dis) throws IOException {
        super(nameIndex, attributeLength, dis);
        dis = this.getDataInputStream();
        int local_variable_table_length = dis.readShort();
        for (int i = 0; i < local_variable_table_length; ++i) {
            short start_pc = dis.readShort();
            short length = dis.readShort();
            short name_index = dis.readShort();
            short descriptor_index = dis.readShort();
            short index = dis.readShort();
            this.localVariables.add(new LocalVariable(start_pc, length, name_index, descriptor_index, index));
        }
    }

    @Override
    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(this.localVariables.size());
            for (LocalVariable lv : this.localVariables) {
                dos.writeShort(lv.getStartPc());
                dos.writeShort(lv.getLength());
                dos.writeShort(lv.getNameIndex());
                dos.writeShort(lv.getDescriptorIndex());
                dos.writeShort(lv.getIndex());
            }
            dos.flush();
            dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public List<LocalVariable> getEntries() {
        return this.localVariables;
    }

    public class LocalVariable {
        private short start_pc;
        private short length;
        private short name_index;
        private short descriptor_index;
        private short index;

        LocalVariable(short start_pc, short length, short name_index, short descriptor_index, short index) {
            this.start_pc = start_pc;
            this.length = length;
            this.name_index = name_index;
            this.descriptor_index = descriptor_index;
            this.index = index;
        }

        public short getStartPc() {
            return this.start_pc;
        }

        public void setStartPc(short start_pc) {
            this.start_pc = start_pc;
        }

        public short getLength() {
            return this.length;
        }

        public void setLength(short length) {
            this.length = length;
        }

        public String getName() {
            return LocalVariableTableAttribute.this.cp.getUtf8(this.name_index);
        }

        short getNameIndex() {
            return this.name_index;
        }

        public String getDescriptor() {
            return LocalVariableTableAttribute.this.cp.getUtf8(this.descriptor_index);
        }

        short getDescriptorIndex() {
            return this.descriptor_index;
        }

        public short getIndex() {
            return this.index;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("start: " + this.start_pc);
            sb.append(", length: " + this.length);
            sb.append(", name: " + this.getName());
            sb.append(", descriptor: " + this.getDescriptor());
            sb.append(", index: " + this.index);
            return sb.toString();
        }
    }
}

