/*
 * Copyright (c) 2000-2004 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

#ifndef Argus_out_h
#define Argus_out_h

#if defined(HAVE_SOLARIS) || defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
#include <sys/types.h>
#include <sys/socket.h>
#if !defined(_NET_IF_H_)
#include <net/if.h>
#define _NET_IF_H_
#endif
#endif

#if !defined(__OpenBSD__) || !defined(_NETINET_IF_ETHER_H_)
#include <netinet/if_ether.h>
#define _NETINET_IF_ETHER_H_
#endif 

#include <netinet/rtp.h>
#include <argus_llc.h>



struct ArgusETHERObject {
   unsigned char ethersrc[6];
   unsigned char etherdst[6];
};

struct ArgusMACFlow {
   struct ether_header ehdr;
   unsigned char dsap, ssap;
};

struct ArgusESPFlow {
   unsigned int ip_src, ip_dst;
   unsigned char ip_p, tp_p;
   unsigned short pad;
   unsigned int spi;
};

struct ArgusArpFlow {
   unsigned int arp_spa;
   unsigned int arp_tpa;
   unsigned char etheraddr[6];
   unsigned short pad;
};

struct ArgusRarpFlow {
   unsigned int arp_tpa;
   unsigned char srceaddr[6];
   unsigned char tareaddr[6];
};

struct ArgusICMPFlow {
   unsigned int ip_src, ip_dst;
   unsigned char ip_p, tp_p;
   unsigned char type, code;
   unsigned short id, ip_id;
};

struct ArgusIPFlow {
   unsigned int ip_src, ip_dst;
   unsigned char ip_p, tp_p;
   unsigned short sport, dport;
   unsigned short ip_id;
};

#define   ip_flow flow_union.ip
#define icmp_flow flow_union.icmp
#define  mac_flow flow_union.mac
#define  arp_flow flow_union.arp
#define rarp_flow flow_union.rarp
#define  esp_flow flow_union.esp


struct ArgusTimeObject {
   int n;
   unsigned int min;
   unsigned int mean;
   unsigned int stdev;
   unsigned int max;
};

struct ArgusTimeEntity {
   struct ArgusTimeObject act, idle;
};

struct ArgusAHObject {
   unsigned int src_spi, dst_spi;
   unsigned int src_replay, dst_replay;
};


struct ArgusARPObject {
   unsigned char respaddr[6];
   unsigned short pad;
};

struct ArgusDHCPObject {
   unsigned int respaddr;
};

struct ArgusFragObject {
   unsigned char type, length;
   unsigned short status;
   int fragnum, frag_id;
   unsigned short ip_id, totlen, currlen, maxfraglen;
};

struct ArgusICMPObject {
   unsigned char type, length;
   unsigned short status;
   unsigned char icmp_type, icmp_code;
   unsigned short iseq;
   unsigned int osrcaddr, odstaddr;
   unsigned int isrcaddr, idstaddr;
   unsigned int igwaddr;
};

struct ArgusTCPObjectMetrics {
   unsigned int seqbase, ackbytes;
   unsigned int bytes, rpkts;
   unsigned short win;
   unsigned char flags, pad;
};

struct ArgusTCPObject {
   unsigned char type, length;
   unsigned short status;
   unsigned int state;
   unsigned int options;
   unsigned int synAckuSecs, ackDatauSecs;
   struct ArgusTCPObjectMetrics src, dst;
};

struct ArgusRTPObject {
   unsigned char type, length;
   unsigned short status;
   struct rtphdr  src, dst;
   unsigned short sdrop, ddrop;
   unsigned short ssdev, dsdev;
};
 
struct ArgusRTCPObject {
   unsigned char type, length;
   unsigned short status;
   struct rtcphdr src, dst;
   unsigned short src_pkt_drop, dst_pkt_drop;
};

struct ArgusIGMPObject {
   unsigned char igmp_type, pad;
   unsigned int igmp_group;
};

struct ArgusFRAGObject {
   int fragnum, frag_id;
   unsigned short status, totlen, currlen, maxfraglen;
};

struct ArgusESPObject {
   unsigned int spi, lastseq, lostseq;
};

struct ArgusESPStruct {
   unsigned char type, length;
   u_short status;
   struct ArgusESPObject src, dst;
};

struct ArgusAGRStruct {
   unsigned char type, length;
   u_short status;
   unsigned int count;
   struct timeval laststartime, lasttime;
   struct ArgusTimeObject act, idle;
};

struct ArgusTimeStruct {
   unsigned char type, length;
   u_short status;
   struct ArgusTimeEntity src, dst;
};

struct ArgusMacStruct {
   unsigned char type, length;
   unsigned short status;
   union {
      struct ArgusETHERObject ether;
   } phys_union;
};

struct ArgusVlanStruct {
   unsigned char type, length;
   unsigned short status;
   unsigned short sid, did;
};

struct ArgusMplsStruct {
   unsigned char type, length;
   unsigned short status;
   unsigned int slabel;
   unsigned int dlabel;
};

struct ArgusMarStruct {
   struct argtimeval startime, now;
   unsigned char  major_version, minor_version; 
   unsigned char interfaceType, interfaceStatus;
   unsigned short reportInterval, argusMrInterval;
   unsigned int argusid, localnet, netmask, nextMrSequenceNum; 
   unsigned long long pktsRcvd, bytesRcvd;
   unsigned int  pktsDrop, flows, flowsClosed;
   unsigned int actIPcons,  cloIPcons;
   unsigned int actICMPcons,  cloICMPcons;
   unsigned int actIGMPcons,  cloIGMPcons;
   unsigned int actFRAGcons,  cloFRAGcons;
   unsigned int actSECcons,  cloSECcons;
   int record_len;
};

struct ArgusTimeDesc {
   struct timeval start;
   struct timeval last;
};

struct ArgusFlow {
   union {
      struct ArgusIPFlow     ip;
      struct ArgusICMPFlow icmp;
      struct ArgusMACFlow   mac;
      struct ArgusArpFlow   arp;
      struct ArgusRarpFlow rarp;
      struct ArgusESPFlow   esp;
  } flow_union;
};

struct ArgusIPAttributes {
   unsigned short soptions, doptions;
   unsigned char sttl, dttl;
   unsigned char stos, dtos;
};

struct ArgusARPAttributes {
   unsigned char response[8]; 
};

struct ArgusAttributes {
   union {
      struct ArgusIPAttributes   ip;
      struct ArgusARPAttributes arp;
   } attr_union;
};

#define attr_ip   attr.attr_union.ip
#define attr_arp  attr.attr_union.arp

struct ArgusMeter {
   unsigned int count, bytes, appbytes;
};

struct ArgusMeterObject {
   unsigned char type, length;
   unsigned short status;
 
   struct ArgusMeter src, dst;
};

struct ArgusFarHeaderStruct {
   unsigned char type, length;
   unsigned short status;
};

struct ArgusFarStruct {
   unsigned char type, length;
   unsigned short status;

   unsigned int ArgusTransRefNum;
   struct ArgusTimeDesc time;
   struct ArgusFlow flow;
   struct ArgusAttributes attr;
   struct ArgusMeter src, dst;
};


struct ArgusRecordHeader {
   unsigned char type, cause;
   unsigned short length;
   unsigned int status;
   unsigned int argusid;
   unsigned int seqNumber;
};

struct ArgusRecord {
   struct ArgusRecordHeader ahdr;
   union {
      struct ArgusMarStruct  mar;
      struct ArgusFarStruct  far;
   } ar_union;
};

struct ArgusCanonicalRecord {
   struct ArgusRecordHeader ahdr;
   struct ArgusFarStruct    far;
   struct ArgusMacStruct    mac;
   union {
      struct ArgusTCPObject     tcp;
      struct ArgusESPStruct     esp;
      struct ArgusICMPObject   icmp;
      struct ArgusIGMPObject   igmp;
      struct ArgusDHCPObject   dhcp;
      struct ArgusRTPObject     rtp;
      struct ArgusRTCPObject   rtcp;
      struct ArgusARPObject     arp;
      struct ArgusAHObject       ah;
      struct ArgusFRAGObject   frag;
   } acr_union;

   struct ArgusAGRStruct    agr;
   struct ArgusTimeStruct   time;
   struct ArgusVlanStruct   vlan;
   struct ArgusMplsStruct   mpls;
};


#define argus_mar   ar_union.mar
#define argus_far   ar_union.far

#define acr_arp   acr_union.arp
#define acr_dhcp  acr_union.dhcp
#define acr_icmp  acr_union.icmp
#define acr_igmp  acr_union.igmp
#define acr_tcp   acr_union.tcp
#define acr_rtp   acr_union.rtp
#define acr_esp   acr_union.esp
#define acr_frag  acr_union.frag


struct ArgusUserStruct {
   unsigned char type, length;
   u_short status;
   char data;
};


#endif /*  Argus_out_h  */
