/*
Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

module asgen.bindings.freetypeTypes;

import core.stdc.config : c_long, c_ulong;

extern(C):
nothrow:
@nogc:

// config/ftconfig.h
alias FT_Int16 = short;
alias FT_UInt16 = ushort;
alias FT_Int32 = int;
alias FT_UInt32 = uint;
alias FT_Fast = int;
alias FT_UFast = uint;
alias FT_Int64 = long;
alias FT_Uint64 = ulong;

// fttypes.h
alias FT_Bool = ubyte;
alias FT_FWord = short;
alias FT_UFWord = ushort;
alias FT_Char = char;
alias FT_Byte = ubyte;
alias FT_Bytes = FT_Byte*;
alias FT_Tag = FT_UInt32;
alias FT_String = char;
alias FT_Short = short;
alias FT_UShort = ushort;
alias FT_Int = int;
alias FT_UInt = uint;
alias FT_Long = c_long;
alias FT_ULong = c_ulong;
alias FT_F2Dot14 = short;
alias FT_F26Dot6 = c_long;
alias FT_Fixed = c_long;
alias FT_Error = int;
alias FT_Pointer = void*;
alias FT_Offset = size_t;
alias FT_PtrDist = ptrdiff_t;

struct FT_UnitVector {
    FT_F2Dot14 x;
    FT_F2Dot14 y;
}

struct FT_Matrix {
    FT_Fixed xx, xy;
    FT_Fixed yx, yy;
}

struct FT_Data {
    const( FT_Byte )* pointer;
    FT_Int length;
}

extern( C ) nothrow alias FT_Generic_Finalizer = void function( void* );

struct FT_Generic {
    void* data;
    FT_Generic_Finalizer finalizer;
}

FT_Tag FT_MAKE_TAG( char x1, char x2, char x3, char x4 ) {
    return cast( FT_UInt32)(( x1 << 24 ) | ( x2 << 16 ) | ( x3 << 8 ) | x4 );
}

alias FT_ListNode = FT_ListNodeRec*;
alias FT_List = FT_ListRec*;

struct FT_ListNodeRec {
    FT_ListNode prev;
    FT_ListNode next;
    void* data;
}

struct FT_ListRec {
    FT_ListNode head;
    FT_ListNode tail;
}

// freetype.h
struct FT_Glyph_Metrics {
    FT_Pos width;
    FT_Pos height;
    FT_Pos horiBearingX;
    FT_Pos horiBearingY;
    FT_Pos horiAdvance;
    FT_Pos vertBearingX;
    FT_Pos vertBearingY;
    FT_Pos vertAdvance;
}

struct FT_Bitmap_Size {
    FT_Short height;
    FT_Short width;
    FT_Pos size;
    FT_Pos x_ppem;
    FT_Pos y_ppem;
}

struct FT_LibraryRec;
struct FT_ModuleRec;
struct FT_DriverRec;
struct FT_RendererRec;

alias FT_Library = FT_LibraryRec*;
alias FT_Module = FT_ModuleRec*;
alias FT_Driver = FT_DriverRec*;
alias FT_Renderer = FT_RendererRec*;
alias FT_Face = FT_FaceRec*;
alias FT_Size = FT_SizeRec*;
alias FT_GlyphSlot = FT_GlyphSlotRec*;
alias FT_CharMap = FT_CharMapRec*;

alias FT_ENC_TAG = FT_MAKE_TAG;

alias FT_Encoding = FT_Tag;
enum : FT_Tag {
    FT_ENCODING_NONE = 0,
    FT_ENCODING_MS_SYMBOL = FT_MAKE_TAG( 's','y','m','b' ),
    FT_ENCODING_UNICODE = FT_MAKE_TAG( 'u','n','i','c' ),
    FT_ENCODING_SJIS = FT_MAKE_TAG( 's','j','i','s' ),
    FT_ENCODING_GB2312 = FT_MAKE_TAG( 'g','b',' ',' ' ),
    FT_ENCODING_BIG5 = FT_MAKE_TAG('b','i','g','5' ),
    FT_ENCODING_WANSUNG = FT_MAKE_TAG( 'w','a','n','s' ),
    FT_ENCODING_JOHAB = FT_MAKE_TAG( 'j','o','h','a' ),
    FT_ENCODING_MS_SJIS = FT_ENCODING_SJIS,
    FT_ENCODING_MS_GB2312 = FT_ENCODING_GB2312,
    FT_ENCODING_MS_BIG5 = FT_ENCODING_BIG5,
    FT_ENCODING_MS_WANSUNG = FT_ENCODING_WANSUNG,
    FT_ENCODING_MS_JOHAB = FT_ENCODING_JOHAB,
    FT_ENCODING_ADOBE_STANDARD = FT_MAKE_TAG( 'A','D','O','B' ),
    FT_ENCODING_ADOBE_EXPERT = FT_MAKE_TAG( 'A','D','B','E' ),
    FT_ENCODING_ADOBE_CUSTOM = FT_MAKE_TAG( 'A','D','B','C' ),
    FT_ENCODING_ADOBE_LATIN_1 = FT_MAKE_TAG( 'l','a','t','1' ),
    FT_ENCODING_OLD_LATIN_2 = FT_MAKE_TAG( 'l','a','t','2' ),
    FT_ENCODING_APPLE_ROMAN = FT_MAKE_TAG( 'a','r','m','n' ),
}

struct FT_CharMapRec {
    FT_Face face;
    FT_Encoding encoding;
    FT_UShort platform_id;
    FT_UShort encoding_id;
}

struct FT_Face_InternalRec;
alias FT_Face_Internal = FT_Face_InternalRec*;

struct FT_FaceRec {
    FT_Long num_faces;
    FT_Long face_index;
    FT_Long face_flags;
    FT_Long style_flags;
    FT_Long num_glyphs;
    FT_String* family_name;
    FT_String* style_name;
    FT_Int num_fixed_sizes;
    FT_Bitmap_Size* available_sizes;
    FT_Int num_charmaps;
    FT_CharMap* charmaps;
    FT_Generic generic;
    FT_BBox bbox;
    FT_UShort units_per_EM;
    FT_Short ascender;
    FT_Short descender;
    FT_Short height;
    FT_Short max_advance_width;
    FT_Short max_advance_height;
    FT_Short underline_position;
    FT_Short underline_thickness;
    FT_GlyphSlot glyph;
    FT_Size size;
    FT_CharMap charmap;
    FT_Driver driver;
    FT_Memory memory;
    FT_Stream stream;
    FT_ListRec sizes_list;
    FT_Generic autohint;
    void* extensions;
    FT_Face_Internal internal;
}

enum : uint {
    FT_FACE_FLAG_SCALABLE = 1 << 0,
    FT_FACE_FLAG_FIXED_SIZES = 1 << 1,
    FT_FACE_FLAG_FIXED_WIDTH = 1 << 2,
    FT_FACE_FLAG_SFNT = 1 << 3,
    FT_FACE_FLAG_HORIZONTAL = 1 << 4,
    FT_FACE_FLAG_VERTICAL = 1 << 5,
    FT_FACE_FLAG_KERNING = 1 << 6,
    FT_FACE_FLAG_FAST_GLYPHS = 1 << 7,
    FT_FACE_FLAG_MULTIPLE_MASTERS = 1 << 8,
    FT_FACE_FLAG_GLYPH_NAMES = 1 << 9,
    FT_FACE_FLAG_EXTERNAL_STREAM = 1 << 10,
    FT_FACE_FLAG_HINTER = 1 << 11,
    FT_FACE_FLAG_CID_KEYED = 1 << 12,
    FT_FACE_FLAG_TRICKY = 1 << 13,
    FT_FACE_FLAG_COLOR = 1 << 14,
}

@nogc nothrow {
    bool FT_HAS_HORIZONTAL( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_HORIZONTAL ) == 0;
    }

    bool FT_HAS_VERTICAL( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_VERTICAL ) == 0;
    }

    bool FT_HAS_KERNING( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_KERNING ) == 0;
    }

    bool FT_IS_SCALABLE( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_SCALABLE ) == 0;
    }

    bool FT_IS_SFNT( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_SFNT ) == 0;
    }

    bool FT_IS_FIXED_WIDTH( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_FIXED_WIDTH ) == 0;
    }

    bool FT_HAS_FIXED_SIZES( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_FIXED_SIZES ) == 0;
    }

    bool FT_HAS_FAST_GLYPHS( FT_FaceRec* face ) {
        return false;
    }

    bool FT_HAS_GLYPH_NAMES( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_GLYPH_NAMES ) == 0;
    }

    bool FT_HAS_MULTIPLE_MASTERS( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_MULTIPLE_MASTERS ) == 0;
    }

    bool FT_IS_CID_KEYED( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_CID_KEYED ) == 0;
    }

    bool FT_IS_TRICKY( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_TRICKY ) == 0;
    }

    bool FT_HAS_COLOR( FT_FaceRec* face ) {
        return ( face.face_flags & FT_FACE_FLAG_COLOR ) == 0;
    }
}

enum {
    FT_STYLE_FLAG_ITALIC          = 1 << 0,
    FT_STYLE_FLAG_BOLD            = 1 << 1,
}

struct FT_Size_InternalRec;
alias FT_Size_Internal = FT_Size_InternalRec*;

struct FT_Size_Metrics {
    FT_UShort x_ppem;
    FT_UShort y_ppem;

    FT_Fixed x_scale;
    FT_Fixed y_scale;

    FT_Pos ascender;
    FT_Pos descender;
    FT_Pos height;
    FT_Pos max_advance;
}

struct FT_SizeRec {
    FT_Face face;
    FT_Generic generic;
    FT_Size_Metrics metrics;
    FT_Size_Internal internal;
}

struct FT_SubGlyphRec;
struct FT_Slot_InternalRec;
alias FT_SubGlyph = FT_SubGlyphRec*;
alias FT_Slot_Internal = FT_Slot_InternalRec*;

struct FT_GlyphSlotRec {
    FT_Library library;
    FT_Face face;
    FT_GlyphSlot next;
    FT_UInt reserved;
    FT_Generic generic;
    FT_Glyph_Metrics metrics;
    FT_Fixed linearHoriAdvance;
    FT_Fixed linearVertAdvance;
    FT_Vector advance;
    FT_Glyph_Format format;
    FT_Bitmap bitmap;
    FT_Int bitmap_left;
    FT_Int bitmap_top;
    FT_Outline outline;
    FT_UInt num_subglyphs;
    FT_SubGlyph subglyphs;
    void* control_data;
    c_long control_len;
    FT_Pos lsb_delta;
    FT_Pos rsb_delta;
    void* other;
    FT_Slot_Internal internal;
}

enum : uint {
    FT_OPEN_MEMORY           = 0x1,
    FT_OPEN_STREAM           = 0x2,
    FT_OPEN_DRIVER           = 0x4,
    FT_OPEN_PATHNAME         = 0x8,
    FT_OPEN_PARAMS           = 0x10,
}

struct FT_Parameter {
    FT_ULong tag;
    FT_Pointer data;
}

struct FT_Open_Args {
    FT_UInt flags;
    const( FT_Byte )* memory_base;
    FT_Long memory_size;
    FT_String* pathname;
    FT_Stream stream;
    FT_Module driver;
    FT_Int num_params;
    FT_Parameter* params;
}

alias FT_Size_Request_Type = int;
enum  {
    FT_SIZE_REQUEST_TYPE_NOMINAL,
    FT_SIZE_REQUEST_TYPE_REAL_DIM,
    FT_SIZE_REQUEST_TYPE_BBOX,
    FT_SIZE_REQUEST_TYPE_CELL,
    FT_SIZE_REQUEST_TYPE_SCALES,
    FT_SIZE_REQUEST_TYPE_MAX
}

struct FT_Size_RequestRec {
    FT_Size_Request_Type type;
    FT_Long width;
    FT_Long height;
    FT_UInt horiResolution;
    FT_UInt vertResolution;
}

alias FT_Size_Request = FT_Size_RequestRec*;

enum : uint {
    FT_LOAD_DEFAULT = 0x0,
    FT_LOAD_NO_SCALE = 1 << 0,
    FT_LOAD_NO_HINTING = 1 << 1,
    FT_LOAD_RENDER = 1 << 2,
    FT_LOAD_NO_BITMAP = 1 << 3,
    FT_LOAD_VERTICAL_LAYOUT = 1 << 4,
    FT_LOAD_FORCE_AUTOHINT = 1 << 5,
    FT_LOAD_CROP_BITMAP = 1 << 6,
    FT_LOAD_PEDANTIC = 1 << 7,
    FT_LOAD_IGNORE_GLOBAL_ADVANCE_WIDTH = 1 << 9,
    FT_LOAD_NO_RECURSE = 1 << 10,
    FT_LOAD_IGNORE_TRANSFORM = 1 << 11,
    FT_LOAD_MONOCHROME = 1 << 12,
    FT_LOAD_LINEAR_DESIGN = 1 << 13,
    FT_LOAD_NO_AUTOHINT = 1 << 15,
    FT_LOAD_COLOR = 1 << 20,
    FT_LOAD_COMPUTE_METRICS = 1 << 21,
}

enum {
    FT_LOAD_TARGET_NORMAL = ( FT_RENDER_MODE_NORMAL & 15 ) << 16,
    FT_LOAD_TARGET_LIGHT = ( FT_RENDER_MODE_LIGHT & 15 ) << 16,
    FT_LOAD_TARGET_MONO = ( FT_RENDER_MODE_MONO & 15 ) << 16,
    FT_LOAD_TARGET_LCD = ( FT_RENDER_MODE_LCD & 15 ) << 16,
    FT_LOAD_TARGET_LCD_V = ( FT_RENDER_MODE_LCD_V & 15 ) << 16,
}

@nogc FT_Render_Mode FT_LOAD_TARGET_MODE( uint x ) nothrow {
    return cast( FT_Render_Mode )(( x >> 16 ) & 15 );
}

alias FT_Render_Mode = uint;
enum {
    FT_RENDER_MODE_NORMAL = 0,
    FT_RENDER_MODE_LIGHT,
    FT_RENDER_MODE_MONO,
    FT_RENDER_MODE_LCD,
    FT_RENDER_MODE_LCD_V,
    FT_RENDER_MODE_MAX
}

enum FT_Kerning_Mode {
    FT_KERNING_DEFAULT = 0,
    FT_KERNING_UNFITTED,
    FT_KERNING_UNSCALED
}

enum
{
    FT_SUBGLYPH_FLAG_ARGS_ARE_WORDS = 1,
    FT_SUBGLYPH_FLAG_ARGS_ARE_XY_VALUES = 2,
    FT_SUBGLYPH_FLAG_ROUND_XY_TO_GRID = 4,
    FT_SUBGLYPH_FLAG_SCALE = 8,
    FT_SUBGLYPH_FLAG_XY_SCALE = 0x40,
    FT_SUBGLYPH_FLAG_2X2 = 0x80,
    FT_SUBGLYPH_FLAG_USE_MY_METRICS = 0x200,
}

enum {
    FT_FSTYPE_INSTALLABLE_EMBEDDING = 0x0000,
    FT_FSTYPE_RESTRICTED_LICENSE_EMBEDDING = 0x0002,
    FT_FSTYPE_PREVIEW_AND_PRINT_EMBEDDING = 0x0004,
    FT_FSTYPE_EDITABLE_EMBEDDING = 0x0008,
    FT_FSTYPE_NO_SUBSETTING = 0x0100,
    FT_FSTYPE_BITMAP_EMBEDDING_ONLY = 0x0200,
}

enum
{
    FREETYPE_MAJOR  = 2,
    FREETYPE_MINOR  = 6,
    FREETYPE_PATCH  = 3,
}

// ftadvanc.h
enum FT_ADVANCE_FLAG_FAST_ONLY = 0x20000000;

// ftautoh.h
enum {
    FT_AUTOHINTER_SCRIPT_NONE = 0,
    FT_AUTOHINTER_SCRIPT_LATIN = 1,
    FT_AUTOHINTER_SCRIPT_CJK = 2,
    FT_AUTOHINTER_SCRIPT_INDIC = 3,
}

struct FT_Prop_GlyphToScriptMap {
    FT_Face face;
    FT_UShort* map;
}

struct FT_Prop_IncreaseXHeight {
    FT_Face face;
    FT_UInt32 limit;
}

// ftbdf.h
version( linux ) {
    alias BDF_PropertyType = int;
    enum {
        BDF_PROPERTY_TYPE_NONE = 0,
        BDF_PROPERTY_TYPE_ATOM = 1,
        BDF_PROPERTY_TYPE_INTEGER = 2,
        BDF_PROPERTY_TYPE_CARDINAL = 3
    }

    alias BDF_Property = BDF_PropertyRec*;

    struct BDF_PropertyRec {
        BDF_PropertyType type;
        union u {
         char* atom;
         FT_Int32 integer;
         FT_UInt32 cardinal;
        }
    }
}

// ftcache.h
alias FTC_FaceID = FT_Pointer;
extern( C ) nothrow alias FTC_Face_Requester = FT_Error function( FTC_FaceID,FT_Library,FT_Pointer,FT_Face* );

struct FTC_ManagerRec;
struct FTC_NodeRec;

alias FTC_Manager = FTC_ManagerRec*;
alias FTC_Node = FTC_NodeRec*;

struct FTC_ScalerRec {
    FTC_FaceID face_id;
    FT_UInt width;
    FT_UInt height;
    FT_Int pixel;
    FT_UInt x_res;
    FT_UInt y_res;
}

alias FTC_Scaler = FTC_ScalerRec*;

struct FTC_CMapCacheRec;
alias FTC_CMapCache = FTC_CMapCacheRec*;

struct FTC_ImageTypeRec {
    FTC_FaceID face_id;
    FT_UInt width;
    FT_UInt height;
    FT_Int32 flags;
}


alias FTC_ImageType = FTC_ImageTypeRec*;

struct FTC_ImageCacheRec;
alias FTC_ImageCache = FTC_ImageCacheRec*;

alias FTC_SBit = FTC_SBitRec*;

struct FTC_SBitRec {
    FT_Byte width;
    FT_Byte height;
    FT_Char left;
    FT_Char top;
    FT_Byte format;
    FT_Byte max_grays;
    FT_Short pitch;
    FT_Char xadvance;
    FT_Char yadvance;
    FT_Byte* buffer;
}

struct FTC_SBitCacheRec;
alias FTC_SBitCache = FTC_SBitCacheRec*;

// ftcffdrv.h
enum {
    FT_CFF_HINTING_FREETYPE = 0,
    FT_CFF_HINTING_ADOBE = 1,
}

// fterrdef.h
enum {
    FT_Err_Ok  = 0x00,
    FT_Err_Cannot_Open_Resource  = 0x01,
    FT_Err_Unknown_File_Format  = 0x02,
    FT_Err_Invalid_File_Format  = 0x03,
    FT_Err_Invalid_Version  = 0x04,
    FT_Err_Lower_Module_Version  = 0x05,
    FT_Err_Invalid_Argument  = 0x06,
    FT_Err_Unimplemented_Feature  = 0x07,
    FT_Err_Invalid_Table  = 0x08,
    FT_Err_Invalid_Offset  = 0x09,
    FT_Err_Array_Too_Large = 0x0A,
    FT_Err_Missing_Module = 0x0B,
    FT_Err_Missing_Property = 0x0C,

    FT_Err_Invalid_Glyph_Index  = 0x10,
    FT_Err_Invalid_Character_Code  = 0x11,
    FT_Err_Invalid_Glyph_Format  = 0x12,
    FT_Err_Cannot_Render_Glyph  = 0x13,
    FT_Err_Invalid_Outline  = 0x14,
    FT_Err_Invalid_Composite  = 0x15,
    FT_Err_Too_Many_Hints  = 0x16,
    FT_Err_Invalid_Pixel_Size  = 0x17,

    FT_Err_Invalid_Handle  = 0x20,
    FT_Err_Invalid_Library_Handle  = 0x21,
    FT_Err_Invalid_Driver_Handle  = 0x22,
    FT_Err_Invalid_Face_Handle  = 0x23,
    FT_Err_Invalid_Size_Handle  = 0x24,
    FT_Err_Invalid_Slot_Handle  = 0x25,
    FT_Err_Invalid_CharMap_Handle  = 0x26,
    FT_Err_Invalid_Cache_Handle  = 0x27,
    FT_Err_Invalid_Stream_Handle  = 0x28,

    FT_Err_Too_Many_Drivers  = 0x30,
    FT_Err_Too_Many_Extensions  = 0x31,

    FT_Err_Out_Of_Memory  = 0x40,
    FT_Err_Unlisted_Object  = 0x41,

    FT_Err_Cannot_Open_Stream  = 0x51,
    FT_Err_Invalid_Stream_Seek  = 0x52,
    FT_Err_Invalid_Stream_Skip  = 0x53,
    FT_Err_Invalid_Stream_Read  = 0x54,
    FT_Err_Invalid_Stream_Operation  = 0x55,
    FT_Err_Invalid_Frame_Operation  = 0x56,
    FT_Err_Nested_Frame_Access  = 0x57,
    FT_Err_Invalid_Frame_Read  = 0x58,

    FT_Err_Raster_Uninitialized  = 0x60,
    FT_Err_Raster_Corrupted  = 0x61,
    FT_Err_Raster_Overflow  = 0x62,
    FT_Err_Raster_Negative_Height  = 0x63,

    FT_Err_Too_Many_Caches  = 0x70,

    FT_Err_Invalid_Opcode  = 0x80,
    FT_Err_Too_Few_Arguments  = 0x81,
    FT_Err_Stack_Overflow  = 0x82,
    FT_Err_Code_Overflow  = 0x83,
    FT_Err_Bad_Argument  = 0x84,
    FT_Err_Divide_By_Zero  = 0x85,
    FT_Err_Invalid_Reference  = 0x86,
    FT_Err_Debug_OpCode  = 0x87,
    FT_Err_ENDF_In_Exec_Stream  = 0x88,
    FT_Err_Nested_DEFS  = 0x89,
    FT_Err_Invalid_CodeRange  = 0x8A,
    FT_Err_Execution_Too_Long  = 0x8B,
    FT_Err_Too_Many_Function_Defs  = 0x8C,
    FT_Err_Too_Many_Instruction_Defs  = 0x8D,
    FT_Err_Table_Missing  = 0x8E,
    FT_Err_Horiz_Header_Missing  = 0x8F,
    FT_Err_Locations_Missing  = 0x90,
    FT_Err_Name_Table_Missing  = 0x91,
    FT_Err_CMap_Table_Missing  = 0x92,
    FT_Err_Hmtx_Table_Missing  = 0x93,
    FT_Err_Post_Table_Missing  = 0x94,
    FT_Err_Invalid_Horiz_Metrics  = 0x95,
    FT_Err_Invalid_CharMap_Format  = 0x96,
    FT_Err_Invalid_PPem  = 0x97,
    FT_Err_Invalid_Vert_Metrics  = 0x98,
    FT_Err_Could_Not_Find_Context  = 0x99,
    FT_Err_Invalid_Post_Table_Format  = 0x9A,
    FT_Err_Invalid_Post_Table  = 0x9B,

    FT_Err_Syntax_Error  = 0xA0,
    FT_Err_Stack_Underflow  = 0xA1,
    FT_Err_Ignore  = 0xA2,
    FT_Err_No_Unicode_Glyph_Name = 0xA3,
    FT_Err_Glyph_Too_Big = 0xA4,

    FT_Err_Missing_Startfont_Field  = 0xB0,
    FT_Err_Missing_Font_Field  = 0xB1,
    FT_Err_Missing_Size_Field  = 0xB2,
    FT_Err_Missing_Fontboundingbox_Field = 0xB3,
    FT_Err_Missing_Chars_Field  = 0xB4,
    FT_Err_Missing_Startchar_Field  = 0xB5,
    FT_Err_Missing_Encoding_Field  = 0xB6,
    FT_Err_Missing_Bbx_Field  = 0xB7,
    FT_Err_Bbx_Too_Big = 0xB8,
    FT_Err_Corrupted_Font_Header = 0xB9,
    FT_Err_Corrupted_Font_Glyphs = 0xBA,

    FT_Err_Max,
}

// ftgasp.h
enum {
    FT_GASP_NO_TABLE = -1,
    FT_GASP_DO_GRIDFIT = 0x01,
    FT_GASP_DO_GRAY = 0x02,
    FT_GASP_SYMMETRIC_SMOOTHING = 0x08,
    FT_GASP_SYMMETRIC_GRIDFIT = 0x10
}

// ftglyph.h
alias FT_Glyph = FT_GlyphRec*;

struct FT_GlyphRec {
    FT_Library library;
    FT_Glyph_Class* clazz;
    FT_Glyph_Format format;
    FT_Vector advance;
}

alias FT_BitmapGlyph = FT_BitmapGlyphRec*;

struct FT_BitmapGlyphRec {
    FT_GlyphRec root;
    FT_Int left;
    FT_Int top;
    FT_Bitmap bitmap;
}

alias FT_OutlineGlyph = FT_OutlineGlyphRec*;

struct FT_OutlineGlyphRec {
    FT_GlyphRec root;
    FT_Outline outline;
}

alias FT_Glyph_BBox_Mode = int;
enum {
    FT_GLYPH_BBOX_UNSCALED = 0,
    FT_GLYPH_BBOX_SUBPIXELS = 0,
    FT_GLYPH_BBOX_GRIDFIT = 1,
    FT_GLYPH_BBOX_TRUNCATE = 2,
    FT_GLYPH_BBOX_PIXELS = 3
}

// ftgxval.h
enum {
    FT_VALIDATE_feat_INDEX = 0,
    FT_VALIDATE_mort_INDEX = 1,
    FT_VALIDATE_morx_INDEX = 2,
    FT_VALIDATE_bsln_INDEX = 3,
    FT_VALIDATE_just_INDEX = 4,
    FT_VALIDATE_kern_INDEX = 5,
    FT_VALIDATE_opbd_INDEX = 6,
    FT_VALIDATE_trak_INDEX = 7,
    FT_VALIDATE_prop_INDEX = 8,
    FT_VALIDATE_lcar_INDEX = 9,
    FT_VALIDATE_GX_LAST_INDEX = FT_VALIDATE_lcar_INDEX,
    FT_VALIDATE_GX_LENGTH = FT_VALIDATE_GX_LAST_INDEX + 1,

    FT_VALIDATE_GX_START = 0x4000,
    FT_VALIDATE_feat = FT_VALIDATE_GX_START << FT_VALIDATE_feat_INDEX,
    FT_VALIDATE_mort = FT_VALIDATE_GX_START << FT_VALIDATE_mort_INDEX,
    FT_VALIDATE_morx = FT_VALIDATE_GX_START << FT_VALIDATE_morx_INDEX,
    FT_VALIDATE_bsln = FT_VALIDATE_GX_START << FT_VALIDATE_bsln_INDEX,
    FT_VALIDATE_just = FT_VALIDATE_GX_START << FT_VALIDATE_just_INDEX,
    FT_VALIDATE_kern = FT_VALIDATE_GX_START << FT_VALIDATE_kern_INDEX,
    FT_VALIDATE_opbd = FT_VALIDATE_GX_START << FT_VALIDATE_opbd_INDEX,
    FT_VALIDATE_trak = FT_VALIDATE_GX_START << FT_VALIDATE_trak_INDEX,
    FT_VALIDATE_prop = FT_VALIDATE_GX_START << FT_VALIDATE_prop_INDEX,
    FT_VALIDATE_lcar = FT_VALIDATE_GX_START << FT_VALIDATE_lcar_INDEX,

    FT_VALIDATE_GX = ( FT_VALIDATE_feat |
                       FT_VALIDATE_mort |
                       FT_VALIDATE_morx |
                       FT_VALIDATE_bsln |
                       FT_VALIDATE_just |
                       FT_VALIDATE_kern |
                       FT_VALIDATE_opbd |
                       FT_VALIDATE_trak |
                       FT_VALIDATE_prop |
                       FT_VALIDATE_lcar ),

    FT_VALIDATE_MS = FT_VALIDATE_GX_START << 0,
    FT_VALIDATE_APPLE = FT_VALIDATE_GX_START << 1,
    FT_VALIDATE_CKERN = FT_VALIDATE_MS | FT_VALIDATE_APPLE,
}

// ftimage.h
alias FT_Pos = c_long;

struct FT_Vector {
    FT_Pos x;
    FT_Pos y;
}

struct FT_BBox {
    FT_Pos xMin, yMin;
    FT_Pos xMax, yMax;
}

alias FT_Pixel_Mode = int;
enum {
    FT_PIXEL_MODE_NONE = 0,
    FT_PIXEL_MODE_MONO,
    FT_PIXEL_MODE_GRAY,
    FT_PIXEL_MODE_GRAY2,
    FT_PIXEL_MODE_GRAY4,
    FT_PIXEL_MODE_LCD,
    FT_PIXEL_MODE_LCD_V,
    FT_PIXEL_MODE_MAX
}

struct FT_Bitmap {
    uint rows;
    uint width;
    int pitch;
    ubyte* buffer;
    ushort num_grays;
    ubyte pixel_mode;
    ubyte palette_mode;
    void* palette;
}

struct FT_Outline {
    short n_contours;
    short n_points;
    FT_Vector* points;
    byte* tags;
    short* contours;
    int flags;
}

enum FT_OUTLINE_CONTOURS_MAX = short.max;
enum FT_OUTLINE_POINTS_MAX = short.max;

enum : uint {
    FT_OUTLINE_NONE            = 0x0,
    FT_OUTLINE_OWNER           = 0x1,
    FT_OUTLINE_EVEN_ODD_FILL   = 0x2,
    FT_OUTLINE_REVERSE_FILL    = 0x4,
    FT_OUTLINE_IGNORE_DROPOUTS = 0x8,
    FT_OUTLINE_HIGH_PRECISION  = 0x100,
    FT_OUTLINE_SINGLE_PASS     = 0x200,
}

enum {
    FT_CURVE_TAG_ON          = 1,
    FT_CURVE_TAG_CONIC       = 0,
    FT_CURVE_TAG_CUBIC       = 2,
    FT_CURVE_TAG_TOUCH_X     = 8,
    FT_CURVE_TAG_TOUCH_Y     = 16,
    FT_CURVE_TAG_TOUCH_BOTH  = FT_CURVE_TAG_TOUCH_X | FT_CURVE_TAG_TOUCH_Y,
}

extern( C ) nothrow {
    alias FT_Outline_MoveToFunc = int function( const( FT_Vector )*, void* );
    alias FT_Outline_LineToFunc = int function( const( FT_Vector )*, void* );
    alias FT_Outline_ConicToFunc = int function( const( FT_Vector )*, const( FT_Vector )*, void* );
    alias FT_Outline_CubicToFunc = int function( const( FT_Vector )*, const( FT_Vector )*, const( FT_Vector )*, void* );
}

struct FT_Outline_Funcs {
    FT_Outline_MoveToFunc move_to;
    FT_Outline_LineToFunc line_to;
    FT_Outline_ConicToFunc conic_to;
    FT_Outline_CubicToFunc cubic_to;
    int shift;
    FT_Pos delta;
}

alias FT_Glyph_Format = FT_Tag;
enum : FT_Tag {
    FT_GLYPH_FORMAT_NONE = 0,
    FT_GLYPH_FORMAT_COMPOSITE = FT_MAKE_TAG( 'c','o','m','p' ),
    FT_GLYPH_FORMAT_BITMAP = FT_MAKE_TAG( 'b','i','t','s' ),
    FT_GLYPH_FORMAT_OUTLINE = FT_MAKE_TAG( 'o','u','t','l' ),
    FT_GLYPH_FORMAT_PLOTTER = FT_MAKE_TAG( 'p','l','o','t' ),
}

struct FT_RasterRec;
alias FT_Raster = FT_RasterRec*;

struct FT_Span {
    short x;
    ushort len;
    ubyte coverage;
}

extern( C ) nothrow alias FT_SpanFunc = void function( int, int, FT_Span*, void* );

enum {
    FT_RASTER_FLAG_DEFAULT  = 0x0,
    FT_RASTER_FLAG_AA       = 0x1,
    FT_RASTER_FLAG_DIRECT   = 0x2,
    FT_RASTER_FLAG_CLIP     = 0x4
}

struct FT_Raster_Params {
    const( FT_Bitmap )* target;
    const( void )* source;
    int flags;
    FT_SpanFunc gray_spans;
    void* black_spans;
    void* bit_test;
    void* bit_set;
    void* user;
    FT_BBox clip_box;
}

extern( C ) nothrow {
    alias FT_Raster_NewFunc = int function( void*, FT_Raster* );
    alias FT_Raster_DoneFunc = void function( FT_Raster );
    alias FT_Raster_ResetFunc = void function( FT_Raster, ubyte*, uint );
    alias FT_Raster_SetModeFunc = int function( FT_Raster, uint, void* );
    alias FT_Raster_RenderFunc = int function( FT_Raster, FT_Raster_Params* );
}


struct FT_Raster_Funcs {
    FT_Glyph_Format glyph_format;
    FT_Raster_NewFunc raster_new;
    FT_Raster_ResetFunc raster_reset;
    FT_Raster_SetModeFunc raster_set_mode;
    FT_Raster_RenderFunc raster_render;
    FT_Raster_DoneFunc raster_done;
}

// ftincrem.h
struct FT_IncrementalRec;
alias FT_Incremental = FT_IncrementalRec*;

struct FT_Incremental_MetricsRec {
    FT_Long bearing_x;
    FT_Long bearing_y;
    FT_Long advance;
}

alias FT_Incremental_Metrics = FT_Incremental_MetricsRec*;

extern( C ) nothrow {
    alias FT_Incremental_GetGlyphDataFunc = FT_Error function( FT_Incremental, FT_UInt, FT_Data* );
    alias FT_Incremental_FreeGlyphDataFunc = void function( FT_Incremental, FT_Data* );
    alias FT_Incremental_GetGlyphMetricsFunc = FT_Error function( FT_Incremental, FT_UInt, FT_Bool, FT_Incremental_MetricsRec* );
}

struct FT_Incremental_FuncsRec {
    FT_Incremental_GetGlyphDataFunc get_glyph_data;
    FT_Incremental_FreeGlyphDataFunc free_glyph_data;
    FT_Incremental_GetGlyphMetricsFunc get_glyph_metrics;
}

struct FT_Incremental_InterfaceRec {
    FT_Incremental_FuncsRec* funcs;
    FT_Incremental object;
}

enum FT_PARAM_TAG_INCREMENTAL = FT_MAKE_TAG( 'i','n','c','r' );

alias FT_Incremental_Interface = FT_Incremental_InterfaceRec*;

// ftlcdfil.h
alias FT_LcdFilter = int;
enum {
    FT_LCD_FILTER_NONE    = 0,
    FT_LCD_FILTER_DEFAULT = 1,
    FT_LCD_FILTER_LIGHT   = 2,
    FT_LCD_FILTER_LEGACY1 = 3,
    FT_LCD_FILTER_LEGACY  = 16,
    FT_LCD_FILTER_MAX
}

// ftlist.h
extern( C ) nothrow {
    alias FT_List_Iterator = FT_Error function( FT_ListNode, void* );
    alias FT_List_Destructor = void function( FT_Memory, void*, void* );
}

// ftmm.h
struct FT_MM_Axis {
    FT_String* name;
    FT_Long minimum;
    FT_Long maximum;
}

struct FT_Multi_Master {
    FT_UInt num_axis;
    FT_UInt num_designs;
    FT_MM_Axis[4] axis;
}

struct FT_Var_Axis {
    FT_String* name;
    FT_Fixed minimum;
    FT_Fixed def;
    FT_Fixed maximum;
    FT_ULong tag;
    FT_UInt strid;
}

struct FT_Var_Named_Style {
    FT_Fixed* coords;
    FT_UInt strid;
}

struct FT_MM_Var {
    FT_UInt num_axis;
    FT_UInt num_designs;
    FT_UInt num_namedstyles;
    FT_Var_Axis* axis;
    FT_Var_Named_Style* namedstyle;
}

// ftmodapi.h
enum
{
    FT_MODULE_FONT_DRIVER       = 1,
    FT_MODULE_RENDERER          = 2,
    FT_MODULE_HINTER            = 4,
    FT_MODULE_STYLER            = 8,
    FT_MODULE_DRIVER_SCALABLE   = 0x100,
    FT_MODULE_DRIVER_NO_OUTLINES= 0x200,
    FT_MODULE_DRIVER_HAS_HINTER = 0x400,
    FT_MODULE_DRIVER_HINTS_LIGHTLY = 0x800,
}

alias FT_Module_Interface = FT_Pointer;

extern( C ) nothrow {
    alias FT_Module_Constructor = FT_Error function( FT_Module );
    alias FT_Module_Destructor = void function( FT_Module );
    alias FT_Module_Requester = FT_Module_Interface function( FT_Module, const( char )* );
}

struct FT_Module_Class {
    FT_ULong module_flags;
    FT_Long module_size;
    FT_String* module_name;
    FT_Fixed module_version;
    FT_Fixed module_requires;
    void* module_interface;
    FT_Module_Constructor module_init;
    FT_Module_Destructor module_done;
    FT_Module_Requester get_interface;
}

extern( C ) nothrow alias FT_DebugHook_Func = void function( void* );

alias FT_TrueTypeEngineType = int;
enum {
    FT_TRUETYPE_ENGINE_TYPE_NONE = 0,
    FT_TRUETYPE_ENGINE_TYPE_UNPATENTED,
    FT_TRUETYPE_ENGINE_TYPE_PATENTED

}

// ftmoderr.h
enum {
    FT_Mod_Err_Base = 0x000,
    FT_Mod_Err_Autofit = 0x100,
    FT_Mod_Err_BDF = 0x200,
    FT_Mod_Err_Bzip2 = 0x300,
    FT_Mod_Err_Cache = 0x400,
    FT_Mod_Err_CFF = 0x500,
    FT_Mod_Err_CID = 0x600,
    FT_Mod_Err_Gzip = 0x700,
    FT_Mod_Err_LZW = 0x800,
    FT_Mod_Err_OTvalid = 0x900,
    FT_Mod_Err_PCF = 0xA00,
    FT_Mod_Err_PFR = 0xB00,
    FT_Mod_Err_PSaux = 0xC00,
    FT_Mod_Err_PShinter = 0xD00,
    FT_Mod_Err_PSnames = 0xE00,
    FT_Mod_Err_Raster = 0xF00,
    FT_Mod_Err_SFNT = 0x1000,
    FT_Mod_Err_Smooth = 0x1100,
    FT_Mod_Err_TrueType = 0x1200,
    FT_Mod_Err_Type1 = 0x1300,
    FT_Mod_Err_Type42 = 0x1400,
    FT_Mod_Err_Winfonts = 0x1500,
    FT_Mod_Err_GXvalid = 0x1600,
    FT_Mod_Err_Max,
}

// ftotval.h
enum {
    FT_VALIDATE_BASE = 0x0100,
    FT_VALIDATE_GDEF = 0x0200,
    FT_VALIDATE_GPOS = 0x0400,
    FT_VALIDATE_GSUB = 0x0800,
    FT_VALIDATE_JSTF = 0x1000,
    FT_VALIDATE_MATH = 0x2000,
    FT_VALIDATE_OT   = FT_VALIDATE_BASE |
                       FT_VALIDATE_GDEF |
                       FT_VALIDATE_GPOS |
                       FT_VALIDATE_GSUB |
                       FT_VALIDATE_JSTF |
                       FT_VALIDATE_MATH,
}

// ftoutln
alias FT_Orientation = int;
enum {
    FT_ORIENTATION_TRUETYPE = 0,
    FT_ORIENTATION_POSTSCRIPT = 1,
    FT_ORIENTATION_FILL_RIGHT = FT_ORIENTATION_TRUETYPE,
    FT_ORIENTATION_FILL_LEFT = FT_ORIENTATION_POSTSCRIPT
}

// ftrender.h
extern( C ) nothrow {
    alias FT_Glyph_InitFunc = FT_Error function( FT_Glyph, FT_GlyphSlot );
    alias FT_Glyph_DoneFunc = void function( FT_Glyph );
    alias FT_Glyph_TransformFunc = void function( FT_Glyph, const( FT_Matrix )* matrix, const( FT_Vector )* );
    alias FT_Glyph_GetBBoxFunc = void function( FT_Glyph, FT_BBox* );
    alias FT_Glyph_CopyFunc = FT_Error function( FT_Glyph, FT_Glyph );
    alias FT_Glyph_PrepareFunc = FT_Error function( FT_Glyph, FT_GlyphSlot );
}

struct FT_Glyph_Class {  // typedef'd in ftglyph.h
    FT_Long glyph_size;
    FT_Glyph_Format glyph_format;
    FT_Glyph_InitFunc glyph_init;
    FT_Glyph_DoneFunc glyph_done;
    FT_Glyph_CopyFunc glyph_copy;
    FT_Glyph_TransformFunc glyph_transform;
    FT_Glyph_GetBBoxFunc glyph_bbox;
    FT_Glyph_PrepareFunc glyph_prepare;
}

extern( C ) nothrow {
    alias FT_Renderer_RenderFunc = FT_Error function( FT_Renderer, FT_GlyphSlot, FT_UInt, const( FT_Vector )* );
    alias FT_Renderer_TransformFunc = FT_Error function( FT_Renderer, FT_GlyphSlot, const( FT_Matrix )*, const( FT_Vector )* );
    alias FT_Renderer_GetCBoxFunc = void function( FT_Renderer, FT_GlyphSlot, FT_BBox* );
    alias FT_Renderer_SetModeFunc = FT_Error function( FT_Renderer, FT_ULong, FT_Pointer );
}

struct FT_Renderer_Class {
    FT_Module_Class root;
    FT_Glyph_Format glyph_format;
    FT_Renderer_RenderFunc render_glyph;
    FT_Renderer_TransformFunc transform_glyph;
    FT_Renderer_GetCBoxFunc get_glyph_cbox;
    FT_Renderer_SetModeFunc set_mode;
    FT_Raster_Funcs* raster_class;
}

// ftsnames.h
struct FT_SfntName {
    FT_UShort platform_id;
    FT_UShort encoding_id;
    FT_UShort language_id;
    FT_UShort name_id;
    FT_Byte* string;
    FT_UInt string_len;
}

enum FT_PARAM_TAG_IGNORE_PREFERRED_FAMILY = FT_MAKE_TAG( 'i','g','p','f' );
enum FT_PARAM_TAG_IGNORE_PREFERRED_SUBFAMILY = FT_MAKE_TAG( 'i','g','p','s' );

// ftstroke.h
struct FT_StrokerRec;
alias FT_Stroker = FT_StrokerRec*;

alias FT_Stroker_LineJoin = int;
enum {
    FT_STROKER_LINEJOIN_ROUND = 0,
    FT_STROKER_LINEJOIN_BEVEL,
    FT_STROKER_LINEJOIN_MITER
}

alias FT_Stroker_LineCap = int;
enum {
    FT_STROKER_LINECAP_BUTT = 0,
    FT_STROKER_LINECAP_ROUND,
    FT_STROKER_LINECAP_SQUARE
}

alias FT_StrokerBorder = int;
enum {
    FT_STROKER_BORDER_LEFT = 0,
    FT_STROKER_BORDER_RIGHT
}

// ftsystem.h
alias FT_Memory = FT_MemoryRec*;

extern( C ) nothrow {
    alias FT_Alloc_Func = void* function( FT_Memory, c_long );
    alias FT_Free_Func = void  function( FT_Memory, void* );
    alias FT_Realloc_Func = void* function( FT_Memory, c_long, c_long, void* );
}

struct FT_MemoryRec {
    void* user;
    FT_Alloc_Func alloc;
    FT_Free_Func free;
    FT_Realloc_Func realloc;
}

alias FT_Stream = FT_StreamRec*;

union FT_StreamDesc {
    int value;
    void* pointer;
}

extern( C ) nothrow {
    alias FT_Stream_IoFunc = c_ulong function( FT_Stream, c_ulong, ubyte*, c_ulong );
    alias FT_Stream_CloseFunc = void function( FT_Stream );
}

struct FT_StreamRec {
    ubyte* base;
    c_ulong size;
    c_ulong pos;
    FT_StreamDesc descriptor;
    FT_StreamDesc pathname;
    FT_Stream_IoFunc read;
    FT_Stream_CloseFunc close;
    FT_Memory memory;
    ubyte* cursor;
    ubyte* limit;
}

// fttrigon.h
alias FT_Angle = FT_Fixed;

enum {
    FT_ANGLE_PI     = 180 << 16,
    FT_ANGLE_2PI    = FT_ANGLE_PI * 2,
    FT_ANGLE_PI2    = FT_ANGLE_PI / 2,
    FT_ANGLE_PI4    = FT_ANGLE_PI / 4
}

// ftttdrv.h
enum TT_INTERPRETER_VERSION_35 = 35;
enum TT_INTERPRETER_VERSION_38 = 38;

// ftwinfnt.h
enum {
    FT_WinFNT_ID_CP1252 = 0,
    FT_WinFNT_ID_DEFAULT = 1,
    FT_WinFNT_ID_SYMBOL = 2,
    FT_WinFNT_ID_MAC = 77,
    FT_WinFNT_ID_CP932 = 128,
    FT_WinFNT_ID_CP949 = 129,
    FT_WinFNT_ID_CP1361 = 130,
    FT_WinFNT_ID_CP936 = 134,
    FT_WinFNT_ID_CP950 = 136,
    FT_WinFNT_ID_CP1253 = 161,
    FT_WinFNT_ID_CP1254 = 162,
    FT_WinFNT_ID_CP1258 = 163,
    FT_WinFNT_ID_CP1255 = 177,
    FT_WinFNT_ID_CP1256 = 178,
    FT_WinFNT_ID_CP1257 = 186,
    FT_WinFNT_ID_CP1251 = 204,
    FT_WinFNT_ID_CP874 = 222,
    FT_WinFNT_ID_CP1250 = 238,
    FT_WinFNT_ID_OEM = 255,
}


struct FT_WinFNT_HeaderRec {
    FT_UShort _version;
    FT_ULong file_size;
    FT_Byte[60] copyright;
    FT_UShort file_type;
    FT_UShort nominal_point_size;
    FT_UShort vertical_resolution;
    FT_UShort horizontal_resolution;
    FT_UShort ascent;
    FT_UShort internal_leading;
    FT_UShort external_leading;
    FT_Byte italic;
    FT_Byte underline;
    FT_Byte strike_out;
    FT_UShort weight;
    FT_Byte charset;
    FT_UShort pixel_width;
    FT_UShort pixel_height;
    FT_Byte pitch_and_family;
    FT_UShort avg_width;
    FT_UShort max_width;
    FT_Byte first_char;
    FT_Byte last_char;
    FT_Byte default_char;
    FT_Byte break_char;
    FT_UShort bytes_per_row;
    FT_ULong device_offset;
    FT_ULong face_name_offset;
    FT_ULong bits_pointer;
    FT_ULong bits_offset;
    FT_Byte reserved;
    FT_ULong flags;
    FT_UShort A_space;
    FT_UShort B_space;
    FT_UShort C_space;
    FT_UShort color_table_offset;
    FT_ULong[4] reserved1;
}

alias FT_WinFNT_Header = FT_WinFNT_HeaderRec*;

// t1tables.h
struct PS_FontInfoRec {
    FT_String* _version;
    FT_String* notice;
    FT_String* full_name;
    FT_String* family_name;
    FT_String* weight;
    FT_Long italic_angle;
    FT_Bool is_fixed_pitch;
    FT_Short underline_position;
    FT_UShort underline_thickness;
}

alias PS_FontInfo = PS_FontInfoRec*;

struct PS_PrivateRec {
    FT_Int unique_id;
    FT_Int lenIV;
    FT_Byte num_blue_values;
    FT_Byte num_other_blues;
    FT_Byte num_family_blues;
    FT_Byte num_family_other_blues;
    FT_Short[14] blue_values;
    FT_Short[10] other_blues;
    FT_Short[14] family_blues;
    FT_Short[10] family_other_blues;
    FT_Fixed blue_scale;
    FT_Int blue_shift;
    FT_Int blue_fuzz;
    FT_UShort[1] standard_width;
    FT_UShort[1] standard_height;
    FT_Byte num_snap_widths;
    FT_Byte num_snap_heights;
    FT_Bool force_bold;
    FT_Bool round_stem_up;
    FT_Short[13] snap_widths;
    FT_Short[13] snap_heights;
    FT_Fixed expansion_factor;
    FT_Long language_group;
    FT_Long password;
    FT_Short[2] min_feature;
}

alias PS_Private = PS_PrivateRec*;

alias T1_Blend_Flags = int;
enum {
    T1_BLEND_UNDERLINE_POSITION = 0,
    T1_BLEND_UNDERLINE_THICKNESS,
    T1_BLEND_ITALIC_ANGLE,
    T1_BLEND_BLUE_VALUES,
    T1_BLEND_OTHER_BLUES,
    T1_BLEND_STANDARD_WIDTH,
    T1_BLEND_STANDARD_HEIGHT,
    T1_BLEND_STEM_SNAP_WIDTHS,
    T1_BLEND_STEM_SNAP_HEIGHTS,
    T1_BLEND_BLUE_SCALE,
    T1_BLEND_BLUE_SHIFT,
    T1_BLEND_FAMILY_BLUES,
    T1_BLEND_FAMILY_OTHER_BLUES,
    T1_BLEND_FORCE_BOLD,
    T1_BLEND_MAX
}

enum T1_MAX_MM_DESIGNS = 16;
enum T1_MAX_MM_AXIS = 4;
enum T1_MAX_MM_MAP_POINTS = 20;

struct PS_DesignMapRec {
    FT_Byte num_points;
    FT_Long* design_points;
    FT_Fixed* blend_points;
}

alias PS_DesignMap = PS_DesignMapRec*;

struct PS_BlendRec {
    FT_UInt num_designs;
    FT_UInt num_axis;
    FT_String*[T1_MAX_MM_AXIS] axis_names;
    FT_Fixed*[T1_MAX_MM_DESIGNS] design_pos;
    PS_DesignMapRec[T1_MAX_MM_AXIS] design_map;
    FT_Fixed* weight_vector;
    FT_Fixed* default_weight_vector;
    PS_FontInfo[T1_MAX_MM_DESIGNS+1] font_infos;
    PS_Private[T1_MAX_MM_DESIGNS+1] privates;
    FT_ULong blend_bitflags;
    FT_BBox*[T1_MAX_MM_DESIGNS+1] bboxes;
    FT_UInt[T1_MAX_MM_DESIGNS] default_design_vector;
    FT_UInt num_default_design_vector;
}

alias PS_Blend = PS_BlendRec*;

struct CID_FaceDictRec {
    PS_PrivateRec private_dict;
    FT_UInt len_buildchar;
    FT_Fixed forcebold_threshold;
    FT_Pos stroke_width;
    FT_Fixed expansion_factor;
    FT_Byte paint_type;
    FT_Byte font_type;
    FT_Matrix font_matrix;
    FT_Vector font_offset;
    FT_UInt num_subrs;
    FT_ULong subrmap_offset;
    FT_Int sd_bytes;
}

alias CID_FaceDict = CID_FaceDictRec*;

struct CID_FaceInfoRec {
    FT_String* cid_font_name;
    FT_Fixed cid_version;
    FT_Int cid_font_type;
    FT_String* registry;
    FT_String* ordering;
    FT_Int supplement;
    PS_FontInfoRec font_info;
    FT_BBox font_bbox;
    FT_ULong uid_base;
    FT_Int num_xuid;
    FT_ULong[16] xuid;
    FT_ULong cidmap_offset;
    FT_Int fd_bytes;
    FT_Int gd_bytes;
    FT_ULong cid_count;
    FT_Int num_dicts;
    CID_FaceDict font_dicts;
    FT_ULong data_offset;
}

alias CID_FaceInfo = CID_FaceInfoRec*;

alias T1_EncodingType = int;
enum {
    T1_ENCODING_TYPE_NONE = 0,
    T1_ENCODING_TYPE_ARRAY,
    T1_ENCODING_TYPE_STANDARD,
    T1_ENCODING_TYPE_ISOLATIN1,
    T1_ENCODING_TYPE_EXPERT,
}

alias PS_Dict_Keys = int;
enum {
    PS_DICT_FONT_TYPE,
    PS_DICT_FONT_MATRIX,
    PS_DICT_FONT_BBOX,
    PS_DICT_PAINT_TYPE,
    PS_DICT_FONT_NAME,
    PS_DICT_UNIQUE_ID,
    PS_DICT_NUM_CHAR_STRINGS,
    PS_DICT_CHAR_STRING_KEY,
    PS_DICT_CHAR_STRING,
    PS_DICT_ENCODING_TYPE,
    PS_DICT_ENCODING_ENTRY,

    PS_DICT_NUM_SUBRS,
    PS_DICT_SUBR,
    PS_DICT_STD_HW,
    PS_DICT_STD_VW,
    PS_DICT_NUM_BLUE_VALUES,
    PS_DICT_BLUE_VALUE,
    PS_DICT_BLUE_FUZZ,
    PS_DICT_NUM_OTHER_BLUES,
    PS_DICT_OTHER_BLUE,
    PS_DICT_NUM_FAMILY_BLUES,
    PS_DICT_FAMILY_BLUE,
    PS_DICT_NUM_FAMILY_OTHER_BLUES,
    PS_DICT_FAMILY_OTHER_BLUE,
    PS_DICT_BLUE_SCALE,
    PS_DICT_BLUE_SHIFT,
    PS_DICT_NUM_STEM_SNAP_H,
    PS_DICT_STEM_SNAP_H,
    PS_DICT_NUM_STEM_SNAP_V,
    PS_DICT_STEM_SNAP_V,
    PS_DICT_FORCE_BOLD,
    PS_DICT_RND_STEM_UP,
    PS_DICT_MIN_FEATURE,
    PS_DICT_LEN_IV,
    PS_DICT_PASSWORD,
    PS_DICT_LANGUAGE_GROUP,

    PS_DICT_VERSION,
    PS_DICT_NOTICE,
    PS_DICT_FULL_NAME,
    PS_DICT_FAMILY_NAME,
    PS_DICT_WEIGHT,
    PS_DICT_IS_FIXED_PITCH,
    PS_DICT_UNDERLINE_POSITION,
    PS_DICT_UNDERLINE_THICKNESS,
    PS_DICT_FS_TYPE,
    PS_DICT_ITALIC_ANGLE,

    PS_DICT_MAX = PS_DICT_ITALIC_ANGLE
}

// ttnameid.h
enum {
    TT_PLATFORM_APPLE_UNICODE = 0,
    TT_PLATFORM_MACINTOSH = 1,
    TT_PLATFORM_MICROSOFT = 3,
    TT_PLATFORM_CUSTOM = 4,
    TT_PLATFORM_ADOBE = 7,
}

enum {
    TT_APPLE_ID_DEFAULT = 0,
    TT_APPLE_ID_UNICODE_1_1 = 1,
    TT_APPLE_ID_UNICODE_2_0 = 3,
    TT_APPLE_ID_UNICODE_32 = 4,
    TT_APPLE_ID_VARIANT_SELECTOR = 5,
}

enum {
    TT_MAC_ID_ROMAN = 0,
    TT_MAC_ID_JAPANESE = 1,
    TT_MAC_ID_TRADITIONAL_CHINESE = 2,
    TT_MAC_ID_KOREAN = 3,
    TT_MAC_ID_ARABIC = 4,
    TT_MAC_ID_HEBREW = 5,
    TT_MAC_ID_GREEK = 6,
    TT_MAC_ID_RUSSIAN = 7,
    TT_MAC_ID_RSYMBOL = 8,
    TT_MAC_ID_DEVANAGARI = 9,
    TT_MAC_ID_GURMUKHI = 10,
    TT_MAC_ID_GUJARATI = 11,
    TT_MAC_ID_ORIYA = 12,
    TT_MAC_ID_BENGALI = 13,
    TT_MAC_ID_TAMIL = 14,
    TT_MAC_ID_TELUGU = 15,
    TT_MAC_ID_KANNADA = 16,
    TT_MAC_ID_MALAYALAM = 17,
    TT_MAC_ID_SINHALESE = 18,
    TT_MAC_ID_BURMESE = 19,
    TT_MAC_ID_KHMER = 20,
    TT_MAC_ID_THAI = 21,
    TT_MAC_ID_LAOTIAN = 22,
    TT_MAC_ID_GEORGIAN = 23,
    TT_MAC_ID_ARMENIAN = 24,
    TT_MAC_ID_MALDIVIAN = 25,
    TT_MAC_ID_SIMPLIFIED_CHINESE = 25,
    TT_MAC_ID_TIBETAN = 26,
    TT_MAC_ID_MONGOLIAN = 27,
    TT_MAC_ID_GEEZ = 28,
    TT_MAC_ID_SLAVIC = 29,
    TT_MAC_ID_VIETNAMESE = 30,
    TT_MAC_ID_SINDHI = 31,
    TT_MAC_ID_UNINTERP = 32,
}

enum {
    TT_ISO_ID_7BIT_ASCII = 0,
    TT_ISO_ID_10646 = 1,
    TT_ISO_ID_8859_1 = 2,
}

enum {
    TT_MS_ID_SYMBOL_CS = 0,
    TT_MS_ID_UNICODE_CS = 1,
    TT_MS_ID_SJIS = 2,
    TT_MS_ID_GB2312 = 3,
    TT_MS_ID_BIG_5 = 4,
    TT_MS_ID_WANSUNG = 5,
    TT_MS_ID_JOHAB = 6,
    TT_MS_ID_UCS_4 = 10,
}

enum {
    TT_ADOBE_ID_STANDARD = 0,
    TT_ADOBE_ID_EXPERT = 1,
    TT_ADOBE_ID_CUSTOM = 2,
    TT_ADOBE_ID_LATIN_1 = 3,
}

enum {
    TT_MAC_LANGID_ENGLISH = 0,
    TT_MAC_LANGID_FRENCH = 1,
    TT_MAC_LANGID_GERMAN = 2,
    TT_MAC_LANGID_ITALIAN = 3,
    TT_MAC_LANGID_DUTCH = 4,
    TT_MAC_LANGID_SWEDISH = 5,
    TT_MAC_LANGID_SPANISH = 6,
    TT_MAC_LANGID_DANISH = 7,
    TT_MAC_LANGID_PORTUGUESE = 8,
    TT_MAC_LANGID_NORWEGIAN = 9,
    TT_MAC_LANGID_HEBREW = 10,
    TT_MAC_LANGID_JAPANESE = 11,
    TT_MAC_LANGID_ARABIC = 12,
    TT_MAC_LANGID_FINNISH = 13,
    TT_MAC_LANGID_GREEK = 14,
    TT_MAC_LANGID_ICELANDIC = 15,
    TT_MAC_LANGID_MALTESE = 16,
    TT_MAC_LANGID_TURKISH = 17,
    TT_MAC_LANGID_CROATIAN = 18,
    TT_MAC_LANGID_CHINESE_TRADITIONAL = 19,
    TT_MAC_LANGID_URDU = 20,
    TT_MAC_LANGID_HINDI = 21,
    TT_MAC_LANGID_THAI = 22,
    TT_MAC_LANGID_KOREAN = 23,
    TT_MAC_LANGID_LITHUANIAN = 24,
    TT_MAC_LANGID_POLISH = 25,
    TT_MAC_LANGID_HUNGARIAN = 26,
    TT_MAC_LANGID_ESTONIAN = 27,
    TT_MAC_LANGID_LETTISH = 28,
    TT_MAC_LANGID_SAAMISK = 29,
    TT_MAC_LANGID_FAEROESE = 30,
    TT_MAC_LANGID_FARSI = 31,
    TT_MAC_LANGID_RUSSIAN = 32,
    TT_MAC_LANGID_CHINESE_SIMPLIFIED = 33,
    TT_MAC_LANGID_FLEMISH = 34,
    TT_MAC_LANGID_IRISH = 35,
    TT_MAC_LANGID_ALBANIAN = 36,
    TT_MAC_LANGID_ROMANIAN = 37,
    TT_MAC_LANGID_CZECH = 38,
    TT_MAC_LANGID_SLOVAK = 39,
    TT_MAC_LANGID_SLOVENIAN = 40,
    TT_MAC_LANGID_YIDDISH = 41,
    TT_MAC_LANGID_SERBIAN = 42,
    TT_MAC_LANGID_MACEDONIAN = 43,
    TT_MAC_LANGID_BULGARIAN = 44,
    TT_MAC_LANGID_UKRAINIAN = 45,
    TT_MAC_LANGID_BYELORUSSIAN = 46,
    TT_MAC_LANGID_UZBEK = 47,
    TT_MAC_LANGID_KAZAKH = 48,
    TT_MAC_LANGID_AZERBAIJANI = 49,
    TT_MAC_LANGID_AZERBAIJANI_CYRILLIC_SCRIPT = 49,
    TT_MAC_LANGID_AZERBAIJANI_ARABIC_SCRIPT = 50,
    TT_MAC_LANGID_ARMENIAN = 51,
    TT_MAC_LANGID_GEORGIAN = 52,
    TT_MAC_LANGID_MOLDAVIAN = 53,
    TT_MAC_LANGID_KIRGHIZ = 54,
    TT_MAC_LANGID_TAJIKI = 55,
    TT_MAC_LANGID_TURKMEN = 56,
    TT_MAC_LANGID_MONGOLIAN = 57,
    TT_MAC_LANGID_MONGOLIAN_MONGOLIAN_SCRIPT = 57,
    TT_MAC_LANGID_MONGOLIAN_CYRILLIC_SCRIPT = 58,
    TT_MAC_LANGID_PASHTO = 59,
    TT_MAC_LANGID_KURDISH = 60,
    TT_MAC_LANGID_KASHMIRI = 61,
    TT_MAC_LANGID_SINDHI = 62,
    TT_MAC_LANGID_TIBETAN = 63,
    TT_MAC_LANGID_NEPALI = 64,
    TT_MAC_LANGID_SANSKRIT = 65,
    TT_MAC_LANGID_MARATHI = 66,
    TT_MAC_LANGID_BENGALI = 67,
    TT_MAC_LANGID_ASSAMESE = 68,
    TT_MAC_LANGID_GUJARATI = 69,
    TT_MAC_LANGID_PUNJABI = 70,
    TT_MAC_LANGID_ORIYA = 71,
    TT_MAC_LANGID_MALAYALAM = 72,
    TT_MAC_LANGID_KANNADA = 73,
    TT_MAC_LANGID_TAMIL = 74,
    TT_MAC_LANGID_TELUGU = 75,
    TT_MAC_LANGID_SINHALESE = 76,
    TT_MAC_LANGID_BURMESE = 77,
    TT_MAC_LANGID_KHMER = 78,
    TT_MAC_LANGID_LAO = 79,
    TT_MAC_LANGID_VIETNAMESE = 80,
    TT_MAC_LANGID_INDONESIAN = 81,
    TT_MAC_LANGID_TAGALOG = 82,
    TT_MAC_LANGID_MALAY_ROMAN_SCRIPT = 83,
    TT_MAC_LANGID_MALAY_ARABIC_SCRIPT = 84,
    TT_MAC_LANGID_AMHARIC = 85,
    TT_MAC_LANGID_TIGRINYA = 86,
    TT_MAC_LANGID_GALLA = 87,
    TT_MAC_LANGID_SOMALI = 88,
    TT_MAC_LANGID_SWAHILI = 89,
    TT_MAC_LANGID_RUANDA = 90,
    TT_MAC_LANGID_RUNDI = 91,
    TT_MAC_LANGID_CHEWA = 92,
    TT_MAC_LANGID_MALAGASY = 93,
    TT_MAC_LANGID_ESPERANTO = 94,
    TT_MAC_LANGID_WELSH = 128,
    TT_MAC_LANGID_BASQUE = 129,
    TT_MAC_LANGID_CATALAN = 130,
    TT_MAC_LANGID_LATIN = 131,
    TT_MAC_LANGID_QUECHUA = 132,
    TT_MAC_LANGID_GUARANI = 133,
    TT_MAC_LANGID_AYMARA = 134,
    TT_MAC_LANGID_TATAR = 135,
    TT_MAC_LANGID_UIGHUR = 136,
    TT_MAC_LANGID_DZONGKHA = 137,
    TT_MAC_LANGID_JAVANESE = 138,
    TT_MAC_LANGID_SUNDANESE = 139,
    TT_MAC_LANGID_GALICIAN = 140,
    TT_MAC_LANGID_AFRIKAANS = 141,
    TT_MAC_LANGID_BRETON = 142,
    TT_MAC_LANGID_INUKTITUT = 143,
    TT_MAC_LANGID_SCOTTISH_GAELIC = 144,
    TT_MAC_LANGID_MANX_GAELIC = 145,
    TT_MAC_LANGID_IRISH_GAELIC = 146,
    TT_MAC_LANGID_TONGAN = 147,
    TT_MAC_LANGID_GREEK_POLYTONIC = 148,
    TT_MAC_LANGID_GREELANDIC = 149,
    TT_MAC_LANGID_AZERBAIJANI_ROMAN_SCRIPT = 150,
}

enum {
    TT_MS_LANGID_ARABIC_GENERAL = 0x0001,
    TT_MS_LANGID_ARABIC_SAUDI_ARABIA = 0x0401,
    TT_MS_LANGID_ARABIC_IRAQ = 0x0801,
    TT_MS_LANGID_ARABIC_EGYPT = 0x0c01,
    TT_MS_LANGID_ARABIC_LIBYA = 0x1001,
    TT_MS_LANGID_ARABIC_ALGERIA = 0x1401,
    TT_MS_LANGID_ARABIC_MOROCCO = 0x1801,
    TT_MS_LANGID_ARABIC_TUNISIA = 0x1c01,
    TT_MS_LANGID_ARABIC_OMAN = 0x2001,
    TT_MS_LANGID_ARABIC_YEMEN = 0x2401,
    TT_MS_LANGID_ARABIC_SYRIA = 0x2801,
    TT_MS_LANGID_ARABIC_JORDAN = 0x2c01,
    TT_MS_LANGID_ARABIC_LEBANON = 0x3001,
    TT_MS_LANGID_ARABIC_KUWAIT = 0x3401,
    TT_MS_LANGID_ARABIC_UAE = 0x3801,
    TT_MS_LANGID_ARABIC_BAHRAIN = 0x3c01,
    TT_MS_LANGID_ARABIC_QATAR = 0x4001,
    TT_MS_LANGID_BULGARIAN_BULGARIA = 0x0402,
    TT_MS_LANGID_CATALAN_SPAIN = 0x0403,
    TT_MS_LANGID_CHINESE_GENERAL = 0x0004,
    TT_MS_LANGID_CHINESE_TAIWAN = 0x0404,
    TT_MS_LANGID_CHINESE_PRC = 0x0804,
    TT_MS_LANGID_CHINESE_HONG_KONG = 0x0c04,
    TT_MS_LANGID_CHINESE_SINGAPORE = 0x1004,
    TT_MS_LANGID_CHINESE_MACAU = 0x1404,
    TT_MS_LANGID_CZECH_CZECH_REPUBLIC = 0x0405,
    TT_MS_LANGID_DANISH_DENMARK = 0x0406,
    TT_MS_LANGID_GERMAN_GERMANY = 0x0407,
    TT_MS_LANGID_GERMAN_SWITZERLAND = 0x0807,
    TT_MS_LANGID_GERMAN_AUSTRIA = 0x0c07,
    TT_MS_LANGID_GERMAN_LUXEMBOURG = 0x1007,
    TT_MS_LANGID_GERMAN_LIECHTENSTEI = 0x1407,
    TT_MS_LANGID_GREEK_GREECE = 0x0408,
    TT_MS_LANGID_ENGLISH_GENERAL = 0x0009,
    TT_MS_LANGID_ENGLISH_UNITED_STATES = 0x0409,
    TT_MS_LANGID_ENGLISH_UNITED_KINGDOM = 0x0809,
    TT_MS_LANGID_ENGLISH_AUSTRALIA = 0x0c09,
    TT_MS_LANGID_ENGLISH_CANADA = 0x1009,
    TT_MS_LANGID_ENGLISH_NEW_ZEALAND = 0x1409,
    TT_MS_LANGID_ENGLISH_IRELAND = 0x1809,
    TT_MS_LANGID_ENGLISH_SOUTH_AFRICA = 0x1c09,
    TT_MS_LANGID_ENGLISH_JAMAICA = 0x2009,
    TT_MS_LANGID_ENGLISH_CARIBBEAN = 0x2409,
    TT_MS_LANGID_ENGLISH_BELIZE = 0x2809,
    TT_MS_LANGID_ENGLISH_TRINIDAD = 0x2c09,
    TT_MS_LANGID_ENGLISH_ZIMBABWE = 0x3009,
    TT_MS_LANGID_ENGLISH_PHILIPPINES = 0x3409,
    TT_MS_LANGID_ENGLISH_INDONESIA = 0x3809,
    TT_MS_LANGID_ENGLISH_HONG_KONG = 0x3c09,
    TT_MS_LANGID_ENGLISH_INDIA = 0x4009,
    TT_MS_LANGID_ENGLISH_MALAYSIA = 0x4409,
    TT_MS_LANGID_ENGLISH_SINGAPORE = 0x4809,
    TT_MS_LANGID_SPANISH_SPAIN_TRADITIONAL_SORT = 0x040a,
    TT_MS_LANGID_SPANISH_MEXICO = 0x080a,
    TT_MS_LANGID_SPANISH_SPAIN_INTERNATIONAL_SORT = 0x0c0a,
    TT_MS_LANGID_SPANISH_GUATEMALA = 0x100a,
    TT_MS_LANGID_SPANISH_COSTA_RICA = 0x140a,
    TT_MS_LANGID_SPANISH_PANAMA = 0x180a,
    TT_MS_LANGID_SPANISH_DOMINICAN_REPUBLIC = 0x1c0a,
    TT_MS_LANGID_SPANISH_VENEZUELA = 0x200a,
    TT_MS_LANGID_SPANISH_COLOMBIA = 0x240a,
    TT_MS_LANGID_SPANISH_PERU = 0x280a,
    TT_MS_LANGID_SPANISH_ARGENTINA = 0x2c0a,
    TT_MS_LANGID_SPANISH_ECUADOR = 0x300a,
    TT_MS_LANGID_SPANISH_CHILE = 0x340a,
    TT_MS_LANGID_SPANISH_URUGUAY = 0x380a,
    TT_MS_LANGID_SPANISH_PARAGUAY = 0x3c0a,
    TT_MS_LANGID_SPANISH_BOLIVIA = 0x400a,
    TT_MS_LANGID_SPANISH_EL_SALVADOR = 0x440a,
    TT_MS_LANGID_SPANISH_HONDURAS = 0x480a,
    TT_MS_LANGID_SPANISH_NICARAGUA = 0x4c0a,
    TT_MS_LANGID_SPANISH_PUERTO_RICO = 0x500a,
    TT_MS_LANGID_SPANISH_UNITED_STATES = 0x540a,
    TT_MS_LANGID_SPANISH_LATIN_AMERICA = 0xE40aU,
    TT_MS_LANGID_FINNISH_FINLAND = 0x040b,
    TT_MS_LANGID_FRENCH_FRANCE = 0x040c,
    TT_MS_LANGID_FRENCH_BELGIUM = 0x080c,
    TT_MS_LANGID_FRENCH_CANADA = 0x0c0c,
    TT_MS_LANGID_FRENCH_SWITZERLAND = 0x100c,
    TT_MS_LANGID_FRENCH_LUXEMBOURG = 0x140c,
    TT_MS_LANGID_FRENCH_MONACO = 0x180c,
    TT_MS_LANGID_FRENCH_WEST_INDIES = 0x1c0c,
    TT_MS_LANGID_FRENCH_REUNION = 0x200c,
    TT_MS_LANGID_FRENCH_CONGO = 0x240c,
    TT_MS_LANGID_FRENCH_ZAIRE = TT_MS_LANGID_FRENCH_CONGO,
    TT_MS_LANGID_FRENCH_SENEGAL = 0x280c,
    TT_MS_LANGID_FRENCH_CAMEROON = 0x2c0c,
    TT_MS_LANGID_FRENCH_COTE_D_IVOIRE = 0x300c,
    TT_MS_LANGID_FRENCH_MALI = 0x340c,
    TT_MS_LANGID_FRENCH_MOROCCO = 0x380c,
    TT_MS_LANGID_FRENCH_HAITI = 0x3c0c,
    TT_MS_LANGID_FRENCH_NORTH_AFRICA = 0xE40cU,
    TT_MS_LANGID_HEBREW_ISRAEL = 0x040d,
    TT_MS_LANGID_HUNGARIAN_HUNGARY = 0x040e,
    TT_MS_LANGID_ICELANDIC_ICELAND = 0x040f,
    TT_MS_LANGID_ITALIAN_ITALY = 0x0410,
    TT_MS_LANGID_ITALIAN_SWITZERLAND = 0x0810,
    TT_MS_LANGID_JAPANESE_JAPAN = 0x0411,
    TT_MS_LANGID_KOREAN_EXTENDED_WANSUNG_KOREA = 0x0412,
    TT_MS_LANGID_KOREAN_JOHAB_KOREA = 0x0812,
    TT_MS_LANGID_DUTCH_NETHERLANDS = 0x0413,
    TT_MS_LANGID_DUTCH_BELGIUM = 0x0813,
    TT_MS_LANGID_NORWEGIAN_NORWAY_BOKMAL = 0x0414,
    TT_MS_LANGID_NORWEGIAN_NORWAY_NYNORSK = 0x0814,
    TT_MS_LANGID_POLISH_POLAND = 0x0415,
    TT_MS_LANGID_PORTUGUESE_BRAZIL = 0x0416,
    TT_MS_LANGID_PORTUGUESE_PORTUGAL = 0x0816,
    TT_MS_LANGID_RHAETO_ROMANIC_SWITZERLAND = 0x0417,
    TT_MS_LANGID_ROMANIAN_ROMANIA = 0x0418,
    TT_MS_LANGID_MOLDAVIAN_MOLDAVIA = 0x0818,
    TT_MS_LANGID_RUSSIAN_RUSSIA = 0x0419,
    TT_MS_LANGID_RUSSIAN_MOLDAVIA = 0x0819,
    TT_MS_LANGID_CROATIAN_CROATIA = 0x041a,
    TT_MS_LANGID_SERBIAN_SERBIA_LATIN = 0x081a,
    TT_MS_LANGID_SERBIAN_SERBIA_CYRILLIC = 0x0c1a,
    TT_MS_LANGID_CROATIAN_BOSNIA_HERZEGOVINA = 0x101a,
    TT_MS_LANGID_BOSNIAN_BOSNIA_HERZEGOVINA = 0x141a,
    TT_MS_LANGID_SERBIAN_BOSNIA_HERZ_LATIN = 0x181a,
    TT_MS_LANGID_SERBIAN_BOSNIA_HERZ_CYRILLIC = 0x181a,
    TT_MS_LANGID_SLOVAK_SLOVAKIA = 0x041b,
    TT_MS_LANGID_ALBANIAN_ALBANIA = 0x041c,
    TT_MS_LANGID_SWEDISH_SWEDEN = 0x041d,
    TT_MS_LANGID_SWEDISH_FINLAND = 0x081d,
    TT_MS_LANGID_THAI_THAILAND = 0x041e,
    TT_MS_LANGID_TURKISH_TURKEY = 0x041f,
    TT_MS_LANGID_URDU_PAKISTAN = 0x0420,
    TT_MS_LANGID_URDU_INDIA = 0x0820,
    TT_MS_LANGID_INDONESIAN_INDONESIA = 0x0421,
    TT_MS_LANGID_UKRAINIAN_UKRAINE = 0x0422,
    TT_MS_LANGID_BELARUSIAN_BELARUS = 0x0423,
    TT_MS_LANGID_SLOVENE_SLOVENIA = 0x0424,
    TT_MS_LANGID_ESTONIAN_ESTONIA = 0x0425,
    TT_MS_LANGID_LATVIAN_LATVIA = 0x0426,
    TT_MS_LANGID_LITHUANIAN_LITHUANIA = 0x0427,
    TT_MS_LANGID_CLASSIC_LITHUANIAN_LITHUANIA = 0x0827,
    TT_MS_LANGID_TAJIK_TAJIKISTAN = 0x0428,
    TT_MS_LANGID_FARSI_IRAN = 0x0429,
    TT_MS_LANGID_VIETNAMESE_VIET_NAM = 0x042a,
    TT_MS_LANGID_ARMENIAN_ARMENIA = 0x042b,
    TT_MS_LANGID_AZERI_AZERBAIJAN_LATIN = 0x042c,
    TT_MS_LANGID_AZERI_AZERBAIJAN_CYRILLIC = 0x082c,
    TT_MS_LANGID_BASQUE_SPAIN = 0x042d,
    TT_MS_LANGID_SORBIAN_GERMANY = 0x042e,
    TT_MS_LANGID_MACEDONIAN_MACEDONIA = 0x042f,
    TT_MS_LANGID_SUTU_SOUTH_AFRICA = 0x0430,
    TT_MS_LANGID_TSONGA_SOUTH_AFRICA = 0x0431,
    TT_MS_LANGID_TSWANA_SOUTH_AFRICA = 0x0432,
    TT_MS_LANGID_VENDA_SOUTH_AFRICA = 0x0433,
    TT_MS_LANGID_XHOSA_SOUTH_AFRICA = 0x0434,
    TT_MS_LANGID_ZULU_SOUTH_AFRICA = 0x0435,
    TT_MS_LANGID_AFRIKAANS_SOUTH_AFRICA = 0x0436,
    TT_MS_LANGID_GEORGIAN_GEORGIA = 0x0437,
    TT_MS_LANGID_FAEROESE_FAEROE_ISLANDS = 0x0438,
    TT_MS_LANGID_HINDI_INDIA = 0x0439,
    TT_MS_LANGID_MALTESE_MALTA = 0x043a,
    TT_MS_LANGID_SAMI_NORTHERN_NORWAY = 0x043b,
    TT_MS_LANGID_SAMI_NORTHERN_SWEDEN = 0x083b,
    TT_MS_LANGID_SAMI_NORTHERN_FINLAND = 0x0C3b,
    TT_MS_LANGID_SAMI_LULE_NORWAY = 0x103b,
    TT_MS_LANGID_SAMI_LULE_SWEDEN = 0x143b,
    TT_MS_LANGID_SAMI_SOUTHERN_NORWAY = 0x183b,
    TT_MS_LANGID_SAMI_SOUTHERN_SWEDEN = 0x1C3b,
    TT_MS_LANGID_SAMI_SKOLT_FINLAND = 0x203b,
    TT_MS_LANGID_SAMI_INARI_FINLAND = 0x243b,
    TT_MS_LANGID_SAAMI_LAPONIA = 0x043b,
    TT_MS_LANGID_SCOTTISH_GAELIC_UNITED_KINGDOM = 0x083c,
    TT_MS_LANGID_IRISH_GAELIC_IRELAND = 0x043c,
    TT_MS_LANGID_YIDDISH_GERMANY = 0x043d,
    TT_MS_LANGID_MALAY_MALAYSIA = 0x043e,
    TT_MS_LANGID_MALAY_BRUNEI_DARUSSALAM = 0x083e,
    TT_MS_LANGID_KAZAK_KAZAKSTAN = 0x043f,
    TT_MS_LANGID_KIRGHIZ_KIRGHIZSTAN  = 0x0440,
    TT_MS_LANGID_KIRGHIZ_KIRGHIZ_REPUBLIC = TT_MS_LANGID_KIRGHIZ_KIRGHIZSTAN,
    TT_MS_LANGID_SWAHILI_KENYA = 0x0441,
    TT_MS_LANGID_TURKMEN_TURKMENISTAN = 0x0442,
    TT_MS_LANGID_UZBEK_UZBEKISTAN_LATIN = 0x0443,
    TT_MS_LANGID_UZBEK_UZBEKISTAN_CYRILLIC = 0x0843,
    TT_MS_LANGID_TATAR_TATARSTAN = 0x0444,
    TT_MS_LANGID_BENGALI_INDIA = 0x0445,
    TT_MS_LANGID_BENGALI_BANGLADESH = 0x0845,
    TT_MS_LANGID_PUNJABI_INDIA = 0x0446,
    TT_MS_LANGID_PUNJABI_ARABIC_PAKISTAN = 0x0846,
    TT_MS_LANGID_GUJARATI_INDIA = 0x0447,
    TT_MS_LANGID_ORIYA_INDIA = 0x0448,
    TT_MS_LANGID_TAMIL_INDIA = 0x0449,
    TT_MS_LANGID_TELUGU_INDIA = 0x044a,
    TT_MS_LANGID_KANNADA_INDIA = 0x044b,
    TT_MS_LANGID_MALAYALAM_INDIA = 0x044c,
    TT_MS_LANGID_ASSAMESE_INDIA = 0x044d,
    TT_MS_LANGID_MARATHI_INDIA = 0x044e,
    TT_MS_LANGID_SANSKRIT_INDIA = 0x044f,
    TT_MS_LANGID_MONGOLIAN_MONGOLIA = 0x0450,
    TT_MS_LANGID_MONGOLIAN_MONGOLIA_MONGOLIAN = 0x0850,
    TT_MS_LANGID_TIBETAN_CHINA = 0x0451,
    TT_MS_LANGID_DZONGHKA_BHUTAN = 0x0851,
    TT_MS_LANGID_TIBETAN_BHUTAN = TT_MS_LANGID_DZONGHKA_BHUTAN,
    TT_MS_LANGID_WELSH_WALES = 0x0452,
    TT_MS_LANGID_KHMER_CAMBODIA = 0x0453,
    TT_MS_LANGID_LAO_LAOS = 0x0454,
    TT_MS_LANGID_BURMESE_MYANMAR = 0x0455,
    TT_MS_LANGID_GALICIAN_SPAIN = 0x0456,
    TT_MS_LANGID_KONKANI_INDIA = 0x0457,
    TT_MS_LANGID_MANIPURI_INDIA = 0x0458,
    TT_MS_LANGID_SINDHI_INDIA = 0x0459,
    TT_MS_LANGID_SINDHI_PAKISTAN = 0x0859,
    TT_MS_LANGID_SYRIAC_SYRIA = 0x045a,
    TT_MS_LANGID_SINHALESE_SRI_LANKA = 0x045b,
    TT_MS_LANGID_CHEROKEE_UNITED_STATES = 0x045c,
    TT_MS_LANGID_INUKTITUT_CANADA = 0x045d,
    TT_MS_LANGID_AMHARIC_ETHIOPIA = 0x045e,
    TT_MS_LANGID_TAMAZIGHT_MOROCCO = 0x045f,
    TT_MS_LANGID_TAMAZIGHT_MOROCCO_LATIN = 0x085f,
    TT_MS_LANGID_KASHMIRI_PAKISTAN = 0x0460,
    TT_MS_LANGID_KASHMIRI_SASIA = 0x0860,
    TT_MS_LANGID_KASHMIRI_INDIA = TT_MS_LANGID_KASHMIRI_SASIA,
    TT_MS_LANGID_NEPALI_NEPAL = 0x0461,
    TT_MS_LANGID_NEPALI_INDIA = 0x0861,
    TT_MS_LANGID_FRISIAN_NETHERLANDS = 0x0462,
    TT_MS_LANGID_PASHTO_AFGHANISTAN = 0x0463,
    TT_MS_LANGID_FILIPINO_PHILIPPINES = 0x0464,
    TT_MS_LANGID_DHIVEHI_MALDIVES = 0x0465,
    TT_MS_LANGID_DIVEHI_MALDIVES = TT_MS_LANGID_DHIVEHI_MALDIVES,
    TT_MS_LANGID_EDO_NIGERIA = 0x0466,
    TT_MS_LANGID_FULFULDE_NIGERIA = 0x0467,
    TT_MS_LANGID_HAUSA_NIGERIA = 0x0468,
    TT_MS_LANGID_IBIBIO_NIGERIA = 0x0469,
    TT_MS_LANGID_YORUBA_NIGERIA = 0x046a,
    TT_MS_LANGID_QUECHUA_BOLIVIA = 0x046b,
    TT_MS_LANGID_QUECHUA_ECUADOR = 0x086b,
    TT_MS_LANGID_QUECHUA_PERU = 0x0c6b,
    TT_MS_LANGID_SEPEDI_SOUTH_AFRICA = 0x046c,
    TT_MS_LANGID_SOTHO_SOUTHERN_SOUTH_AFRICA = TT_MS_LANGID_SEPEDI_SOUTH_AFRICA,
    TT_MS_LANGID_IGBO_NIGERIA = 0x0470,
    TT_MS_LANGID_KANURI_NIGERIA = 0x0471,
    TT_MS_LANGID_OROMO_ETHIOPIA = 0x0472,
    TT_MS_LANGID_TIGRIGNA_ETHIOPIA = 0x0473,
    TT_MS_LANGID_TIGRIGNA_ERYTHREA = 0x0873,
    TT_MS_LANGID_TIGRIGNA_ERYTREA = TT_MS_LANGID_TIGRIGNA_ERYTHREA,
    TT_MS_LANGID_GUARANI_PARAGUAY = 0x0474,
    TT_MS_LANGID_HAWAIIAN_UNITED_STATES = 0x0475,
    TT_MS_LANGID_LATIN = 0x0476,
    TT_MS_LANGID_SOMALI_SOMALIA = 0x0477,
    TT_MS_LANGID_YI_CHINA = 0x0478,
    TT_MS_LANGID_PAPIAMENTU_NETHERLANDS_ANTILLES = 0x0479,
    TT_MS_LANGID_UIGHUR_CHINA = 0x0480,
    TT_MS_LANGID_MAORI_NEW_ZEALAND = 0x0481,
}

enum {
    TT_NAME_ID_COPYRIGHT = 0,
    TT_NAME_ID_FONT_FAMILY = 1,
    TT_NAME_ID_FONT_SUBFAMILY = 2,
    TT_NAME_ID_UNIQUE_ID = 3,
    TT_NAME_ID_FULL_NAME = 4,
    TT_NAME_ID_VERSION_STRING = 5,
    TT_NAME_ID_PS_NAME = 6,
    TT_NAME_ID_TRADEMARK = 7,
    TT_NAME_ID_MANUFACTURER = 8,
    TT_NAME_ID_DESIGNER = 9,
    TT_NAME_ID_DESCRIPTION = 10,
    TT_NAME_ID_VENDOR_URL = 11,
    TT_NAME_ID_DESIGNER_URL = 12,
    TT_NAME_ID_LICENSE = 13,
    TT_NAME_ID_LICENSE_URL = 14,
    TT_NAME_ID_PREFERRED_FAMILY = 16,
    TT_NAME_ID_PREFERRED_SUBFAMILY = 17,
    TT_NAME_ID_MAC_FULL_NAME = 18,
    TT_NAME_ID_SAMPLE_TEXT = 19,
    TT_NAME_ID_CID_FINDFONT_NAME = 20,
    TT_NAME_ID_WWS_FAMILY = 21,
    TT_NAME_ID_WWS_SUBFAMILY = 22,
}

enum {
    TT_UCR_BASIC_LATIN = 1 <<  0,
    TT_UCR_LATIN1_SUPPLEMENT = 1 <<  1,
    TT_UCR_LATIN_EXTENDED_A = 1 <<  2,
    TT_UCR_LATIN_EXTENDED_B = 1 <<  3,
    TT_UCR_IPA_EXTENSIONS = 1 <<  4,
    TT_UCR_SPACING_MODIFIER = 1 <<  5,
    TT_UCR_COMBINING_DIACRITICS = 1 <<  6,
    TT_UCR_GREEK = 1 <<  7,
    TT_UCR_COPTIC = 1 <<  8,
    TT_UCR_CYRILLIC = 1 <<  9,
    TT_UCR_ARMENIAN = 1 << 10,
    TT_UCR_HEBREW = 1 << 11,
    TT_UCR_VAI = 1 << 12,
    TT_UCR_ARABIC = 1 << 13,
    TT_UCR_NKO = 1 << 14,
    TT_UCR_DEVANAGARI = 1 << 15,
    TT_UCR_BENGALI = 1 << 16,
    TT_UCR_GURMUKHI = 1 << 17,
    TT_UCR_GUJARATI = 1 << 18,
    TT_UCR_ORIYA = 1 << 19,
    TT_UCR_TAMIL = 1 << 20,
    TT_UCR_TELUGU = 1 << 21,
    TT_UCR_KANNADA = 1 << 22,
    TT_UCR_MALAYALAM = 1 << 23,
    TT_UCR_THAI = 1 << 24,
    TT_UCR_LAO = 1 << 25,
    TT_UCR_GEORGIAN = 1 << 26,
    TT_UCR_BALINESE = 1 << 27,
    TT_UCR_HANGUL_JAMO = 1 << 28,
    TT_UCR_LATIN_EXTENDED_ADDITIONAL = 1 << 29,
    TT_UCR_GREEK_EXTENDED = 1 << 30,
    TT_UCR_SUPERSCRIPTS_SUBSCRIPTS = 1 <<  0,
    TT_UCR_CURRENCY_SYMBOLS = 1 <<  1,
    TT_UCR_COMBINING_DIACRITICS_SYMB = 1 <<  2,
    TT_UCR_LETTERLIKE_SYMBOLS = 1 <<  3,
    TT_UCR_NUMBER_FORMS = 1 <<  4,
    TT_UCR_ARROWS = 1 <<  5,
    TT_UCR_MATHEMATICAL_OPERATORS = 1 <<  6,
    TT_UCR_MISCELLANEOUS_TECHNICAL = 1 <<  7,
    TT_UCR_CONTROL_PICTURES = 1 <<  8,
    TT_UCR_OCR = 1 <<  9,
    TT_UCR_ENCLOSED_ALPHANUMERICS = 1 << 10,
    TT_UCR_BOX_DRAWING = 1 << 11,
    TT_UCR_BLOCK_ELEMENTS = 1 << 12,
    TT_UCR_GEOMETRIC_SHAPES = 1 << 13,
    TT_UCR_MISCELLANEOUS_SYMBOLS = 1 << 14,
    TT_UCR_DINGBATS = 1 << 15,
    TT_UCR_CJK_SYMBOLS = 1 << 16,
    TT_UCR_HIRAGANA = 1 << 17,
    TT_UCR_KATAKANA = 1 << 18,
    TT_UCR_BOPOMOFO = 1 << 19,
    TT_UCR_HANGUL_COMPATIBILITY_JAMO = 1 << 20,
    TT_UCR_CJK_MISC = 1 << 21,
    TT_UCR_ENCLOSED_CJK_LETTERS_MONTHS = 1 << 22,
    TT_UCR_CJK_COMPATIBILITY = 1 << 23,
    TT_UCR_HANGUL = 1 << 24,
    TT_UCR_SURROGATES = 1 << 25,
    TT_UCR_NON_PLANE_0 = TT_UCR_SURROGATES,
    TT_UCR_PHOENICIAN = 1 << 26,
    TT_UCR_CJK_UNIFIED_IDEOGRAPHS = 1 << 27,
    TT_UCR_PRIVATE_USE = 1 << 28,
    TT_UCR_CJK_COMPATIBILITY_IDEOGRAPHS = 1 << 29,
    TT_UCR_ALPHABETIC_PRESENTATION_FORMS = 1 << 30,
    TT_UCR_ARABIC_PRESENTATIONS_A = 1 << 31,
    TT_UCR_COMBINING_HALF_MARKS = 1 <<  0,
    TT_UCR_CJK_COMPATIBILITY_FORMS = 1 <<  1,
    TT_UCR_SMALL_FORM_VARIANTS = 1 <<  2,
    TT_UCR_ARABIC_PRESENTATIONS_B = 1 <<  3,
    TT_UCR_HALFWIDTH_FULLWIDTH_FORMS = 1 <<  4,
    TT_UCR_SPECIALS = 1 <<  5,
    TT_UCR_TIBETAN = 1 <<  6,
    TT_UCR_SYRIAC = 1 <<  7,
    TT_UCR_THAANA = 1 <<  8,
    TT_UCR_SINHALA = 1 <<  9,
    TT_UCR_MYANMAR = 1 << 10,
    TT_UCR_ETHIOPIC = 1 << 11,
    TT_UCR_CHEROKEE = 1 << 12,
    TT_UCR_CANADIAN_ABORIGINAL_SYLLABICS = 1 << 13,
    TT_UCR_OGHAM = 1 << 14,
    TT_UCR_RUNIC = 1 << 15,
    TT_UCR_KHMER = 1 << 16,
    TT_UCR_MONGOLIAN = 1 << 17,
    TT_UCR_BRAILLE = 1 << 18,
    TT_UCR_YI = 1 << 19,
    TT_UCR_PHILIPPINE = 1 << 20,
    TT_UCR_OLD_ITALIC = 1 << 21,
    TT_UCR_GOTHIC = 1 << 22,
    TT_UCR_DESERET = 1 << 23,
    TT_UCR_MUSICAL_SYMBOLS = 1 << 24,
    TT_UCR_MATH_ALPHANUMERIC_SYMBOLS = 1 << 25,
    TT_UCR_PRIVATE_USE_SUPPLEMENTARY = 1 << 26,
    TT_UCR_VARIATION_SELECTORS = 1 << 27,
    TT_UCR_TAGS = 1 << 28,
    TT_UCR_LIMBU = 1 << 29,
    TT_UCR_TAI_LE = 1 << 30,
    TT_UCR_NEW_TAI_LUE = 1 << 31,
    TT_UCR_BUGINESE = 1 <<  0,
    TT_UCR_GLAGOLITIC = 1 <<  1,
    TT_UCR_TIFINAGH = 1 <<  2,
    TT_UCR_YIJING = 1 <<  3,
    TT_UCR_SYLOTI_NAGRI = 1 <<  4,
    TT_UCR_LINEAR_B = 1 <<  5,
    TT_UCR_ANCIENT_GREEK_NUMBERS = 1 <<  6,
    TT_UCR_UGARITIC = 1 <<  7,
    TT_UCR_OLD_PERSIAN = 1 <<  8,
    TT_UCR_SHAVIAN = 1 <<  9,
    TT_UCR_OSMANYA = 1 << 10,
    TT_UCR_CYPRIOT_SYLLABARY = 1 << 11,
    TT_UCR_KHAROSHTHI = 1 << 12,
    TT_UCR_TAI_XUAN_JING = 1 << 13,
    TT_UCR_CUNEIFORM = 1 << 14,
    TT_UCR_COUNTING_ROD_NUMERALS = 1 << 15,
    TT_UCR_SUNDANESE = 1 << 16,
    TT_UCR_LEPCHA = 1 << 17,
    TT_UCR_OL_CHIKI = 1 << 18,
    TT_UCR_SAURASHTRA = 1 << 19,
    TT_UCR_KAYAH_LI = 1 << 20,
    TT_UCR_REJANG = 1 << 21,
    TT_UCR_CHAM = 1 << 22,
    TT_UCR_ANCIENT_SYMBOLS = 1 << 23,
    TT_UCR_PHAISTOS_DISC = 1 << 24,
    TT_UCR_OLD_ANATOLIAN = 1 << 25,
    TT_UCR_GAME_TILES = 1 << 26,
}

// tttables.h
struct TT_Header {
    FT_Fixed Table_Version;
    FT_Fixed Font_Revision;
    FT_Long CheckSum_Adjust;
    FT_Long Magic_Number;
    FT_UShort Flags;
    FT_UShort Units_Per_EM;
    FT_Long[2] Created;
    FT_Long[2] Modified;
    FT_Short xMin;
    FT_Short yMin;
    FT_Short xMax;
    FT_Short yMax;
    FT_UShort Mac_Style;
    FT_UShort Lowest_Rec_PPEM;
    FT_Short Font_Direction;
    FT_Short Index_To_Loc_Format;
    FT_Short Glyph_Data_Format;
}

struct TT_HoriHeader {
    FT_Fixed Version;
    FT_Short Ascender;
    FT_Short Descender;
    FT_Short Line_Gap;
    FT_UShort advance_Width_Max;
    FT_Short min_Left_Side_Bearing;
    FT_Short min_Right_Side_Bearing;
    FT_Short xMax_Extent;
    FT_Short caret_Slope_Rise;
    FT_Short caret_Slope_Run;
    FT_Short caret_Offset;
    FT_Short[4] Reserved;
    FT_Short metric_Data_Format;
    FT_UShort number_Of_HMetrics;
    void* long_metrics;
    void* short_metrics;
}

struct TT_VertHeader {
    FT_Fixed Version;
    FT_Short Ascender;
    FT_Short Descender;
    FT_Short Line_Gap;
    FT_UShort advance_Height_Max;
    FT_Short min_Top_Side_Bearing;
    FT_Short min_Bottom_Side_Bearing;
    FT_Short yMax_Extent;
    FT_Short caret_Slope_Rise;
    FT_Short caret_Slope_Run;
    FT_Short caret_Offset;
    FT_Short[4] Reserved;
    FT_Short metric_Data_Format;
    FT_UShort number_Of_VMetrics;
    void* long_metrics;
    void* short_metrics;
}

struct TT_OS2 {
    FT_UShort _version;
    FT_Short xAvgCharWidth;
    FT_UShort usWeightClass;
    FT_UShort usWidthClass;
    FT_UShort fsType;
    FT_Short ySubscriptXSize;
    FT_Short ySubscriptYSize;
    FT_Short ySubscriptXOffset;
    FT_Short ySubscriptYOffset;
    FT_Short ySuperscriptXSize;
    FT_Short ySuperscriptYSize;
    FT_Short ySuperscriptXOffset;
    FT_Short ySuperscriptYOffset;
    FT_Short yStrikeoutSize;
    FT_Short yStrikeoutPosition;
    FT_Short sFamilyClass;
    FT_Byte[10] panose;
    FT_ULong ulUnicodeRange1;
    FT_ULong ulUnicodeRange2;
    FT_ULong ulUnicodeRange3;
    FT_ULong ulUnicodeRange4;
    FT_Char[4] achVendID;
    FT_UShort fsSelection;
    FT_UShort usFirstCharIndex;
    FT_UShort usLastCharIndex;
    FT_Short sTypoAscender;
    FT_Short sTypoDescender;
    FT_Short sTypoLineGap;
    FT_UShort usWinAscent;
    FT_UShort usWinDescent;
    FT_ULong ulCodePageRange1;
    FT_ULong ulCodePageRange2;
    FT_Short sxHeight;
    FT_Short sCapHeight;
    FT_UShort usDefaultChar;
    FT_UShort usBreakChar;
    FT_UShort usMaxContext;
    FT_UShort usLowerOpticalPointSize;
    FT_UShort usUpperOpticalPointSize;
}

struct TT_Postscript {
    FT_Fixed FormatType;
    FT_Fixed italicAngle;
    FT_Short underlinePosition;
    FT_Short underlineThickness;
    FT_ULong isFixedPitch;
    FT_ULong minMemType42;
    FT_ULong maxMemType42;
    FT_ULong minMemType1;
    FT_ULong maxMemType1;
}

struct TT_PCLT {
    FT_Fixed Version;
    FT_ULong FontNumber;
    FT_UShort Pitch;
    FT_UShort xHeight;
    FT_UShort Style;
    FT_UShort TypeFamily;
    FT_UShort CapHeight;
    FT_UShort SymbolSet;
    FT_Char[16] TypeFace;
    FT_Char[8] CharacterComplement;
    FT_Char[6] FileName;
    FT_Char StrokeWeight;
    FT_Char WidthType;
    FT_Byte SerifStyle;
    FT_Byte Reserved;
}

struct TT_MaxProfile {
    FT_Fixed _version;
    FT_UShort numGlyphs;
    FT_UShort maxPoints;
    FT_UShort maxContours;
    FT_UShort maxCompositePoints;
    FT_UShort maxCompositeContours;
    FT_UShort maxZones;
    FT_UShort maxTwilightPoints;
    FT_UShort maxStorage;
    FT_UShort maxFunctionDefs;
    FT_UShort maxInstructionDefs;
    FT_UShort maxStackElements;
    FT_UShort maxSizeOfInstructions;
    FT_UShort maxComponentElements;
    FT_UShort maxComponentDepth;
}

alias FT_Sfnt_Tag = int;
enum {
    FT_SFNT_HEAD,
    FT_SFNT_MAXP,
    FT_SFNT_OS2,
    FT_SFNT_HHEA,
    FT_SFNT_VHEA,
    FT_SFNT_POST,
    FT_SFNT_PCLT,
    FT_SFNT_MAX
}
