/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.BindingBuildInfo;
import android.databinding.tool.store.LayoutFileParser;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.writer.JavaFileWriter;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.xml.sax.SAXException;

public class LayoutXmlProcessor {
    public static final String RESOURCE_BUNDLE_PACKAGE = "android.databinding.layouts";
    public static final String CLASS_NAME = "DataBindingInfo";
    private final JavaFileWriter mFileWriter;
    private final ResourceBundle mResourceBundle;
    private final int mMinSdk;
    private boolean mProcessingComplete;
    private boolean mWritten;
    private final boolean mIsLibrary;
    private final String mBuildId = UUID.randomUUID().toString();
    private final List<File> mResources;
    private static final Predicate<File> fileExists = new Predicate<File>(){

        @Override
        public boolean apply(File input) {
            return input.exists() && input.canRead();
        }
    };
    private static final FilenameFilter layoutFolderFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("layout");
        }
    };
    private static final FilenameFilter xmlFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".xml");
        }
    };

    public LayoutXmlProcessor(String applicationPackage, List<File> resources, JavaFileWriter fileWriter, int minSdk, boolean isLibrary) {
        this.mFileWriter = fileWriter;
        this.mResourceBundle = new ResourceBundle(applicationPackage);
        this.mResources = resources;
        this.mMinSdk = minSdk;
        this.mIsLibrary = isLibrary;
    }

    public static List<File> getLayoutFiles(List<File> resources) {
        ArrayList<File> result = new ArrayList<File>();
        for (File resource : Iterables.filter(resources, fileExists)) {
            if (resource.isDirectory()) {
                for (File layoutFolder : resource.listFiles(layoutFolderFilter)) {
                    for (File xmlFile : layoutFolder.listFiles(xmlFileFilter)) {
                        result.add(xmlFile);
                    }
                }
                continue;
            }
            if (!xmlFileFilter.accept(resource.getParentFile(), resource.getName())) continue;
            result.add(resource);
        }
        return result;
    }

    public ResourceBundle getResourceBundle() {
        return this.mResourceBundle;
    }

    public boolean processResources() throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        if (this.mProcessingComplete) {
            return false;
        }
        LayoutFileParser layoutFileParser = new LayoutFileParser();
        for (File xmlFile : LayoutXmlProcessor.getLayoutFiles(this.mResources)) {
            ResourceBundle.LayoutFileBundle bindingLayout = layoutFileParser.parseXml(xmlFile, this.mResourceBundle.getAppPackage());
            if (bindingLayout == null || bindingLayout.isEmpty()) continue;
            this.mResourceBundle.addLayoutBundle(bindingLayout);
        }
        this.mProcessingComplete = true;
        return true;
    }

    public void writeLayoutInfoFiles(File xmlOutDir) throws JAXBException {
        if (this.mWritten) {
            return;
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResourceBundle.LayoutFileBundle.class});
        Marshaller marshaller = context.createMarshaller();
        for (List<ResourceBundle.LayoutFileBundle> layouts : this.mResourceBundle.getLayoutBundles().values()) {
            for (ResourceBundle.LayoutFileBundle layout : layouts) {
                this.writeXmlFile(xmlOutDir, layout, marshaller);
            }
        }
        this.mWritten = true;
    }

    private void writeXmlFile(File xmlOutDir, ResourceBundle.LayoutFileBundle layout, Marshaller marshaller) throws JAXBException {
        String filename = this.generateExportFileName(layout) + ".xml";
        String xml = this.toXML(layout, marshaller);
        this.mFileWriter.writeToFile(new File(xmlOutDir, filename), xml);
    }

    public String getInfoClassFullName() {
        return "android.databinding.layouts.DataBindingInfo";
    }

    private String toXML(ResourceBundle.LayoutFileBundle layout, Marshaller marshaller) throws JAXBException {
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)layout, (Writer)writer);
        return writer.getBuffer().toString();
    }

    public String generateExportFileName(ResourceBundle.LayoutFileBundle layout) {
        StringBuilder name = new StringBuilder(layout.getFileName());
        name.append('-').append(layout.getDirectory());
        for (int i = name.length() - 1; i >= 0; --i) {
            char c = name.charAt(i);
            if (c != '-') continue;
            name.deleteCharAt(i);
            c = Character.toUpperCase(name.charAt(i));
            name.setCharAt(i, c);
        }
        return name.toString();
    }

    public void writeInfoClass(File sdkDir, File xmlOutDir) {
        this.writeInfoClass(sdkDir, xmlOutDir, false);
    }

    public void writeInfoClass(File sdkDir, File xmlOutDir, boolean enableDebugLogs) {
        String sdkPath = sdkDir == null ? null : StringEscapeUtils.escapeJava(sdkDir.getAbsolutePath());
        Class<BindingBuildInfo> annotation = BindingBuildInfo.class;
        String layoutInfoPath = StringEscapeUtils.escapeJava(xmlOutDir.getAbsolutePath());
        String classString = "package android.databinding.layouts;\n\nimport " + annotation.getCanonicalName() + ";\n\n" + "@" + annotation.getSimpleName() + "(buildId=\"" + this.mBuildId + "\", " + "modulePackage=\"" + this.mResourceBundle.getAppPackage() + "\", " + "sdkRoot=" + "\"" + (sdkPath == null ? "" : sdkPath) + "\"," + "layoutInfoDir=\"" + layoutInfoPath + "\"," + "isLibrary=" + this.mIsLibrary + "," + "minSdk=" + this.mMinSdk + "," + "enableDebugLogs=" + enableDebugLogs + ")\n" + "public class " + CLASS_NAME + " {}\n";
        this.mFileWriter.writeToFile("android.databinding.layouts.DataBindingInfo", classString);
    }
}

