{-# OPTIONS_GHC -w #-}
{-# OPTIONS -XMagicHash -XBangPatterns -XTypeSynonymInstances -XFlexibleInstances -cpp #-}
#if __GLASGOW_HASKELL__ >= 710
{-# OPTIONS_GHC -XPartialTypeSignatures #-}
#endif
{-# LANGUAGE PatternGuards #-}

{-| The parser is generated by Happy (<http://www.haskell.org/happy>).
 -
 - Ideally, ranges should be as precise as possible, to get messages that
 - emphasize precisely the faulting term(s) upon error.
 -
 - However, interactive highlighting is only applied at the end of each
 - mutual block, keywords are only highlighted once (see
 - `TypeChecking.Rules.Decl'). So if the ranges of two declarations
 - interleave, one must ensure that keyword ranges are not included in
 - the intersection. (Otherwise they are uncolored by the interactive
 - highlighting.)
 -
 -}
module Agda.Syntax.Parser.Parser (
      moduleParser
    , moduleNameParser
    , exprParser
    , exprWhereParser
    , tokensParser
    , holeContentParser
    , splitOnDots  -- only used by the internal test-suite
    ) where

import Control.Applicative ( (<|>) )
import Control.Monad

import Data.Bifunctor (first)
import Data.Char
import Data.List
import Data.Maybe
import Data.Monoid
import qualified Data.Traversable as T

import Debug.Trace

import Agda.Syntax.Position hiding (tests)
import Agda.Syntax.Parser.Monad
import Agda.Syntax.Parser.Lexer
import Agda.Syntax.Parser.Tokens
import Agda.Syntax.Concrete as C
import Agda.Syntax.Concrete.Attribute
import Agda.Syntax.Concrete.Pattern
import Agda.Syntax.Common
import Agda.Syntax.Fixity
import Agda.Syntax.Notation
import Agda.Syntax.Literal

import Agda.TypeChecking.Positivity.Occurrence hiding (tests)

import Agda.Utils.Either hiding (tests)
import Agda.Utils.Functor
import Agda.Utils.Hash
import Agda.Utils.List ( spanJust, chopWhen )
import Agda.Utils.Monad
import Agda.Utils.Pretty
import qualified Agda.Utils.Maybe.Strict as Strict

import Agda.Utils.Impossible
import qualified Data.Array as Happy_Data_Array
import qualified Data.Bits as Bits
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.12

newtype HappyAbsSyn  = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
newtype HappyWrap10 = HappyWrap10 ([Token])
happyIn10 :: ([Token]) -> (HappyAbsSyn )
happyIn10 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap10 x)
{-# INLINE happyIn10 #-}
happyOut10 :: (HappyAbsSyn ) -> HappyWrap10
happyOut10 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut10 #-}
newtype HappyWrap11 = HappyWrap11 ([Token])
happyIn11 :: ([Token]) -> (HappyAbsSyn )
happyIn11 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap11 x)
{-# INLINE happyIn11 #-}
happyOut11 :: (HappyAbsSyn ) -> HappyWrap11
happyOut11 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut11 #-}
newtype HappyWrap12 = HappyWrap12 (Token)
happyIn12 :: (Token) -> (HappyAbsSyn )
happyIn12 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap12 x)
{-# INLINE happyIn12 #-}
happyOut12 :: (HappyAbsSyn ) -> HappyWrap12
happyOut12 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut12 #-}
newtype HappyWrap13 = HappyWrap13 (([Pragma], [Declaration]))
happyIn13 :: (([Pragma], [Declaration])) -> (HappyAbsSyn )
happyIn13 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap13 x)
{-# INLINE happyIn13 #-}
happyOut13 :: (HappyAbsSyn ) -> HappyWrap13
happyOut13 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut13 #-}
newtype HappyWrap14 = HappyWrap14 (())
happyIn14 :: (()) -> (HappyAbsSyn )
happyIn14 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap14 x)
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn ) -> HappyWrap14
happyOut14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut14 #-}
newtype HappyWrap15 = HappyWrap15 (())
happyIn15 :: (()) -> (HappyAbsSyn )
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap15 x)
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn ) -> HappyWrap15
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
newtype HappyWrap16 = HappyWrap16 (Interval)
happyIn16 :: (Interval) -> (HappyAbsSyn )
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap16 x)
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn ) -> HappyWrap16
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
newtype HappyWrap17 = HappyWrap17 (())
happyIn17 :: (()) -> (HappyAbsSyn )
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap17 x)
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn ) -> HappyWrap17
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
newtype HappyWrap18 = HappyWrap18 (Ranged Double)
happyIn18 :: (Ranged Double) -> (HappyAbsSyn )
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap18 x)
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn ) -> HappyWrap18
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
newtype HappyWrap19 = HappyWrap19 (Name)
happyIn19 :: (Name) -> (HappyAbsSyn )
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap19 x)
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn ) -> HappyWrap19
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
newtype HappyWrap20 = HappyWrap20 ([Name])
happyIn20 :: ([Name]) -> (HappyAbsSyn )
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap20 x)
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn ) -> HappyWrap20
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
newtype HappyWrap21 = HappyWrap21 (Range)
happyIn21 :: (Range) -> (HappyAbsSyn )
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap21 x)
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn ) -> HappyWrap21
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
newtype HappyWrap22 = HappyWrap22 (Arg Name)
happyIn22 :: (Arg Name) -> (HappyAbsSyn )
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap22 x)
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn ) -> HappyWrap22
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
newtype HappyWrap23 = HappyWrap23 ([Arg Name])
happyIn23 :: ([Arg Name]) -> (HappyAbsSyn )
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap23 x)
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn ) -> HappyWrap23
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
newtype HappyWrap24 = HappyWrap24 ([Arg Name])
happyIn24 :: ([Arg Name]) -> (HappyAbsSyn )
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap24 x)
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn ) -> HappyWrap24
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
newtype HappyWrap25 = HappyWrap25 (([Attr], [Arg Name]))
happyIn25 :: (([Attr], [Arg Name])) -> (HappyAbsSyn )
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap25 x)
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn ) -> HappyWrap25
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
newtype HappyWrap26 = HappyWrap26 (Attr)
happyIn26 :: (Attr) -> (HappyAbsSyn )
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap26 x)
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn ) -> HappyWrap26
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
newtype HappyWrap27 = HappyWrap27 ([Attr])
happyIn27 :: ([Attr]) -> (HappyAbsSyn )
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap27 x)
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn ) -> HappyWrap27
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
newtype HappyWrap28 = HappyWrap28 ([Attr])
happyIn28 :: ([Attr]) -> (HappyAbsSyn )
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap28 x)
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn ) -> HappyWrap28
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
newtype HappyWrap29 = HappyWrap29 (QName)
happyIn29 :: (QName) -> (HappyAbsSyn )
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap29 x)
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn ) -> HappyWrap29
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
newtype HappyWrap30 = HappyWrap30 (QName)
happyIn30 :: (QName) -> (HappyAbsSyn )
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap30 x)
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn ) -> HappyWrap30
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
newtype HappyWrap31 = HappyWrap31 (Name)
happyIn31 :: (Name) -> (HappyAbsSyn )
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap31 x)
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn ) -> HappyWrap31
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
newtype HappyWrap32 = HappyWrap32 ([Name])
happyIn32 :: ([Name]) -> (HappyAbsSyn )
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap32 x)
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn ) -> HappyWrap32
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
newtype HappyWrap33 = HappyWrap33 ([NamedArg Binder])
happyIn33 :: ([NamedArg Binder]) -> (HappyAbsSyn )
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap33 x)
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn ) -> HappyWrap33
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
newtype HappyWrap34 = HappyWrap34 (Either [NamedArg Binder] [Expr])
happyIn34 :: (Either [NamedArg Binder] [Expr]) -> (HappyAbsSyn )
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap34 x)
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn ) -> HappyWrap34
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
newtype HappyWrap35 = HappyWrap35 ([NamedArg Binder])
happyIn35 :: ([NamedArg Binder]) -> (HappyAbsSyn )
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap35 x)
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn ) -> HappyWrap35
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
newtype HappyWrap36 = HappyWrap36 ([String])
happyIn36 :: ([String]) -> (HappyAbsSyn )
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap36 x)
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn ) -> HappyWrap36
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
newtype HappyWrap37 = HappyWrap37 ([(Interval, String)])
happyIn37 :: ([(Interval, String)]) -> (HappyAbsSyn )
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap37 x)
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn ) -> HappyWrap37
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
newtype HappyWrap38 = HappyWrap38 ([(Interval, String)])
happyIn38 :: ([(Interval, String)]) -> (HappyAbsSyn )
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap38 x)
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn ) -> HappyWrap38
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
newtype HappyWrap39 = HappyWrap39 (Name)
happyIn39 :: (Name) -> (HappyAbsSyn )
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap39 x)
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn ) -> HappyWrap39
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
newtype HappyWrap40 = HappyWrap40 (QName)
happyIn40 :: (QName) -> (HappyAbsSyn )
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap40 x)
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn ) -> HappyWrap40
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
newtype HappyWrap41 = HappyWrap41 ([QName])
happyIn41 :: ([QName]) -> (HappyAbsSyn )
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap41 x)
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn ) -> HappyWrap41
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
newtype HappyWrap42 = HappyWrap42 (Expr)
happyIn42 :: (Expr) -> (HappyAbsSyn )
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap42 x)
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn ) -> HappyWrap42
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
newtype HappyWrap43 = HappyWrap43 (Expr)
happyIn43 :: (Expr) -> (HappyAbsSyn )
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap43 x)
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn ) -> HappyWrap43
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
newtype HappyWrap44 = HappyWrap44 ([Expr])
happyIn44 :: ([Expr]) -> (HappyAbsSyn )
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap44 x)
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn ) -> HappyWrap44
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
newtype HappyWrap45 = HappyWrap45 ([Expr])
happyIn45 :: ([Expr]) -> (HappyAbsSyn )
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap45 x)
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn ) -> HappyWrap45
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
newtype HappyWrap46 = HappyWrap46 (Expr)
happyIn46 :: (Expr) -> (HappyAbsSyn )
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap46 x)
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn ) -> HappyWrap46
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
newtype HappyWrap47 = HappyWrap47 (Maybe Expr)
happyIn47 :: (Maybe Expr) -> (HappyAbsSyn )
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap47 x)
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn ) -> HappyWrap47
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
newtype HappyWrap48 = HappyWrap48 (Expr)
happyIn48 :: (Expr) -> (HappyAbsSyn )
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap48 x)
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn ) -> HappyWrap48
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
newtype HappyWrap49 = HappyWrap49 ([Expr])
happyIn49 :: ([Expr]) -> (HappyAbsSyn )
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap49 x)
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn ) -> HappyWrap49
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
newtype HappyWrap50 = HappyWrap50 ([Expr])
happyIn50 :: ([Expr]) -> (HappyAbsSyn )
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap50 x)
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn ) -> HappyWrap50
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
newtype HappyWrap51 = HappyWrap51 (Expr)
happyIn51 :: (Expr) -> (HappyAbsSyn )
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap51 x)
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn ) -> HappyWrap51
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
newtype HappyWrap52 = HappyWrap52 (Expr)
happyIn52 :: (Expr) -> (HappyAbsSyn )
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap52 x)
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn ) -> HappyWrap52
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
newtype HappyWrap53 = HappyWrap53 (Expr)
happyIn53 :: (Expr) -> (HappyAbsSyn )
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap53 x)
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn ) -> HappyWrap53
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
newtype HappyWrap54 = HappyWrap54 (Expr)
happyIn54 :: (Expr) -> (HappyAbsSyn )
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap54 x)
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn ) -> HappyWrap54
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
newtype HappyWrap55 = HappyWrap55 (RecordAssignments)
happyIn55 :: (RecordAssignments) -> (HappyAbsSyn )
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap55 x)
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn ) -> HappyWrap55
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
newtype HappyWrap56 = HappyWrap56 (RecordAssignments)
happyIn56 :: (RecordAssignments) -> (HappyAbsSyn )
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap56 x)
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn ) -> HappyWrap56
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
newtype HappyWrap57 = HappyWrap57 (RecordAssignment)
happyIn57 :: (RecordAssignment) -> (HappyAbsSyn )
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap57 x)
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn ) -> HappyWrap57
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
newtype HappyWrap58 = HappyWrap58 (ModuleAssignment)
happyIn58 :: (ModuleAssignment) -> (HappyAbsSyn )
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap58 x)
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn ) -> HappyWrap58
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
newtype HappyWrap59 = HappyWrap59 ([FieldAssignment])
happyIn59 :: ([FieldAssignment]) -> (HappyAbsSyn )
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap59 x)
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn ) -> HappyWrap59
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
newtype HappyWrap60 = HappyWrap60 ([FieldAssignment])
happyIn60 :: ([FieldAssignment]) -> (HappyAbsSyn )
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap60 x)
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn ) -> HappyWrap60
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
newtype HappyWrap61 = HappyWrap61 (FieldAssignment)
happyIn61 :: (FieldAssignment) -> (HappyAbsSyn )
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap61 x)
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn ) -> HappyWrap61
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
newtype HappyWrap62 = HappyWrap62 (Telescope)
happyIn62 :: (Telescope) -> (HappyAbsSyn )
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap62 x)
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn ) -> HappyWrap62
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
newtype HappyWrap63 = HappyWrap63 (Telescope)
happyIn63 :: (Telescope) -> (HappyAbsSyn )
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap63 x)
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn ) -> HappyWrap63
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
newtype HappyWrap64 = HappyWrap64 ([TypedBinding])
happyIn64 :: ([TypedBinding]) -> (HappyAbsSyn )
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap64 x)
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn ) -> HappyWrap64
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
newtype HappyWrap65 = HappyWrap65 (TypedBinding)
happyIn65 :: (TypedBinding) -> (HappyAbsSyn )
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap65 x)
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn ) -> HappyWrap65
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
newtype HappyWrap66 = HappyWrap66 (TypedBinding)
happyIn66 :: (TypedBinding) -> (HappyAbsSyn )
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap66 x)
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn ) -> HappyWrap66
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
newtype HappyWrap67 = HappyWrap67 (TypedBinding)
happyIn67 :: (TypedBinding) -> (HappyAbsSyn )
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap67 x)
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn ) -> HappyWrap67
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
newtype HappyWrap68 = HappyWrap68 (TypedBinding)
happyIn68 :: (TypedBinding) -> (HappyAbsSyn )
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap68 x)
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn ) -> HappyWrap68
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
newtype HappyWrap69 = HappyWrap69 (TypedBinding)
happyIn69 :: (TypedBinding) -> (HappyAbsSyn )
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap69 x)
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn ) -> HappyWrap69
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
newtype HappyWrap70 = HappyWrap70 ([LamBinding])
happyIn70 :: ([LamBinding]) -> (HappyAbsSyn )
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap70 x)
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn ) -> HappyWrap70
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
newtype HappyWrap71 = HappyWrap71 (Either ([LamBinding], Hiding) [Expr])
happyIn71 :: (Either ([LamBinding], Hiding) [Expr]) -> (HappyAbsSyn )
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap71 x)
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn ) -> HappyWrap71
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
newtype HappyWrap72 = HappyWrap72 ([Either Hiding LamBinding])
happyIn72 :: ([Either Hiding LamBinding]) -> (HappyAbsSyn )
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap72 x)
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn ) -> HappyWrap72
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
newtype HappyWrap73 = HappyWrap73 (Either [Either Hiding LamBinding] [Expr])
happyIn73 :: (Either [Either Hiding LamBinding] [Expr]) -> (HappyAbsSyn )
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap73 x)
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn ) -> HappyWrap73
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
newtype HappyWrap74 = HappyWrap74 (LamClause)
happyIn74 :: (LamClause) -> (HappyAbsSyn )
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap74 x)
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn ) -> HappyWrap74
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
newtype HappyWrap75 = HappyWrap75 (LamClause)
happyIn75 :: (LamClause) -> (HappyAbsSyn )
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap75 x)
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn ) -> HappyWrap75
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
newtype HappyWrap76 = HappyWrap76 (LamClause)
happyIn76 :: (LamClause) -> (HappyAbsSyn )
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap76 x)
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn ) -> HappyWrap76
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
newtype HappyWrap77 = HappyWrap77 ([LamClause])
happyIn77 :: ([LamClause]) -> (HappyAbsSyn )
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap77 x)
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn ) -> HappyWrap77
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
newtype HappyWrap78 = HappyWrap78 ([LamClause])
happyIn78 :: ([LamClause]) -> (HappyAbsSyn )
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap78 x)
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn ) -> HappyWrap78
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
newtype HappyWrap79 = HappyWrap79 ([LamBinding])
happyIn79 :: ([LamBinding]) -> (HappyAbsSyn )
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap79 x)
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn ) -> HappyWrap79
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
newtype HappyWrap80 = HappyWrap80 ([LamBinding])
happyIn80 :: ([LamBinding]) -> (HappyAbsSyn )
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap80 x)
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn ) -> HappyWrap80
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
newtype HappyWrap81 = HappyWrap81 ([LamBinding])
happyIn81 :: ([LamBinding]) -> (HappyAbsSyn )
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap81 x)
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn ) -> HappyWrap81
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
newtype HappyWrap82 = HappyWrap82 ([LamBinding])
happyIn82 :: ([LamBinding]) -> (HappyAbsSyn )
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap82 x)
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn ) -> HappyWrap82
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
newtype HappyWrap83 = HappyWrap83 (Maybe Pattern)
happyIn83 :: (Maybe Pattern) -> (HappyAbsSyn )
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap83 x)
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn ) -> HappyWrap83
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
newtype HappyWrap84 = HappyWrap84 (Either [LamBinding] [Expr])
happyIn84 :: (Either [LamBinding] [Expr]) -> (HappyAbsSyn )
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap84 x)
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn ) -> HappyWrap84
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
newtype HappyWrap85 = HappyWrap85 ([DoStmt])
happyIn85 :: ([DoStmt]) -> (HappyAbsSyn )
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap85 x)
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn ) -> HappyWrap85
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
newtype HappyWrap86 = HappyWrap86 (DoStmt)
happyIn86 :: (DoStmt) -> (HappyAbsSyn )
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap86 x)
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn ) -> HappyWrap86
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
newtype HappyWrap87 = HappyWrap87 ([LamClause])
happyIn87 :: ([LamClause]) -> (HappyAbsSyn )
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap87 x)
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn ) -> HappyWrap87
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
newtype HappyWrap88 = HappyWrap88 (ImportDirective)
happyIn88 :: (ImportDirective) -> (HappyAbsSyn )
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap88 x)
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn ) -> HappyWrap88
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
newtype HappyWrap89 = HappyWrap89 ([ImportDirective])
happyIn89 :: ([ImportDirective]) -> (HappyAbsSyn )
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap89 x)
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn ) -> HappyWrap89
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
newtype HappyWrap90 = HappyWrap90 (ImportDirective)
happyIn90 :: (ImportDirective) -> (HappyAbsSyn )
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap90 x)
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn ) -> HappyWrap90
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
newtype HappyWrap91 = HappyWrap91 ((Using, Range))
happyIn91 :: ((Using, Range)) -> (HappyAbsSyn )
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap91 x)
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn ) -> HappyWrap91
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
newtype HappyWrap92 = HappyWrap92 (([ImportedName], Range))
happyIn92 :: (([ImportedName], Range)) -> (HappyAbsSyn )
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap92 x)
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn ) -> HappyWrap92
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
newtype HappyWrap93 = HappyWrap93 (([Renaming] , Range))
happyIn93 :: (([Renaming] , Range)) -> (HappyAbsSyn )
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap93 x)
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn ) -> HappyWrap93
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
newtype HappyWrap94 = HappyWrap94 ([Renaming])
happyIn94 :: ([Renaming]) -> (HappyAbsSyn )
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap94 x)
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn ) -> HappyWrap94
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
newtype HappyWrap95 = HappyWrap95 (Renaming)
happyIn95 :: (Renaming) -> (HappyAbsSyn )
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap95 x)
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn ) -> HappyWrap95
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
newtype HappyWrap96 = HappyWrap96 ((Maybe Fixity, Name))
happyIn96 :: ((Maybe Fixity, Name)) -> (HappyAbsSyn )
happyIn96 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap96 x)
{-# INLINE happyIn96 #-}
happyOut96 :: (HappyAbsSyn ) -> HappyWrap96
happyOut96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut96 #-}
newtype HappyWrap97 = HappyWrap97 (ImportedName)
happyIn97 :: (ImportedName) -> (HappyAbsSyn )
happyIn97 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap97 x)
{-# INLINE happyIn97 #-}
happyOut97 :: (HappyAbsSyn ) -> HappyWrap97
happyOut97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut97 #-}
newtype HappyWrap98 = HappyWrap98 (ImportedName)
happyIn98 :: (ImportedName) -> (HappyAbsSyn )
happyIn98 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap98 x)
{-# INLINE happyIn98 #-}
happyOut98 :: (HappyAbsSyn ) -> HappyWrap98
happyOut98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut98 #-}
newtype HappyWrap99 = HappyWrap99 ([ImportedName])
happyIn99 :: ([ImportedName]) -> (HappyAbsSyn )
happyIn99 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap99 x)
{-# INLINE happyIn99 #-}
happyOut99 :: (HappyAbsSyn ) -> HappyWrap99
happyOut99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut99 #-}
newtype HappyWrap100 = HappyWrap100 ([ImportedName])
happyIn100 :: ([ImportedName]) -> (HappyAbsSyn )
happyIn100 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap100 x)
{-# INLINE happyIn100 #-}
happyOut100 :: (HappyAbsSyn ) -> HappyWrap100
happyOut100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut100 #-}
newtype HappyWrap101 = HappyWrap101 (LHS)
happyIn101 :: (LHS) -> (HappyAbsSyn )
happyIn101 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap101 x)
{-# INLINE happyIn101 #-}
happyOut101 :: (HappyAbsSyn ) -> HappyWrap101
happyOut101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut101 #-}
newtype HappyWrap102 = HappyWrap102 ([Either RewriteEqn [Expr]])
happyIn102 :: ([Either RewriteEqn [Expr]]) -> (HappyAbsSyn )
happyIn102 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap102 x)
{-# INLINE happyIn102 #-}
happyOut102 :: (HappyAbsSyn ) -> HappyWrap102
happyOut102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut102 #-}
newtype HappyWrap103 = HappyWrap103 (HoleContent)
happyIn103 :: (HoleContent) -> (HappyAbsSyn )
happyIn103 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap103 x)
{-# INLINE happyIn103 #-}
happyOut103 :: (HappyAbsSyn ) -> HappyWrap103
happyOut103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut103 #-}
newtype HappyWrap104 = HappyWrap104 (WhereClause)
happyIn104 :: (WhereClause) -> (HappyAbsSyn )
happyIn104 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap104 x)
{-# INLINE happyIn104 #-}
happyOut104 :: (HappyAbsSyn ) -> HappyWrap104
happyOut104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut104 #-}
newtype HappyWrap105 = HappyWrap105 (ExprWhere)
happyIn105 :: (ExprWhere) -> (HappyAbsSyn )
happyIn105 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap105 x)
{-# INLINE happyIn105 #-}
happyOut105 :: (HappyAbsSyn ) -> HappyWrap105
happyOut105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut105 #-}
newtype HappyWrap106 = HappyWrap106 ([Declaration])
happyIn106 :: ([Declaration]) -> (HappyAbsSyn )
happyIn106 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap106 x)
{-# INLINE happyIn106 #-}
happyOut106 :: (HappyAbsSyn ) -> HappyWrap106
happyOut106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut106 #-}
newtype HappyWrap107 = HappyWrap107 ([Declaration])
happyIn107 :: ([Declaration]) -> (HappyAbsSyn )
happyIn107 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap107 x)
{-# INLINE happyIn107 #-}
happyOut107 :: (HappyAbsSyn ) -> HappyWrap107
happyOut107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut107 #-}
newtype HappyWrap108 = HappyWrap108 ([Arg Declaration])
happyIn108 :: ([Arg Declaration]) -> (HappyAbsSyn )
happyIn108 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap108 x)
{-# INLINE happyIn108 #-}
happyOut108 :: (HappyAbsSyn ) -> HappyWrap108
happyOut108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut108 #-}
newtype HappyWrap109 = HappyWrap109 ([Declaration])
happyIn109 :: ([Declaration]) -> (HappyAbsSyn )
happyIn109 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap109 x)
{-# INLINE happyIn109 #-}
happyOut109 :: (HappyAbsSyn ) -> HappyWrap109
happyOut109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut109 #-}
newtype HappyWrap110 = HappyWrap110 (RHSOrTypeSigs)
happyIn110 :: (RHSOrTypeSigs) -> (HappyAbsSyn )
happyIn110 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap110 x)
{-# INLINE happyIn110 #-}
happyOut110 :: (HappyAbsSyn ) -> HappyWrap110
happyOut110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut110 #-}
newtype HappyWrap111 = HappyWrap111 (Declaration)
happyIn111 :: (Declaration) -> (HappyAbsSyn )
happyIn111 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap111 x)
{-# INLINE happyIn111 #-}
happyOut111 :: (HappyAbsSyn ) -> HappyWrap111
happyOut111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut111 #-}
newtype HappyWrap112 = HappyWrap112 (Declaration)
happyIn112 :: (Declaration) -> (HappyAbsSyn )
happyIn112 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap112 x)
{-# INLINE happyIn112 #-}
happyOut112 :: (HappyAbsSyn ) -> HappyWrap112
happyOut112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut112 #-}
newtype HappyWrap113 = HappyWrap113 (Declaration)
happyIn113 :: (Declaration) -> (HappyAbsSyn )
happyIn113 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap113 x)
{-# INLINE happyIn113 #-}
happyOut113 :: (HappyAbsSyn ) -> HappyWrap113
happyOut113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut113 #-}
newtype HappyWrap114 = HappyWrap114 (Declaration)
happyIn114 :: (Declaration) -> (HappyAbsSyn )
happyIn114 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap114 x)
{-# INLINE happyIn114 #-}
happyOut114 :: (HappyAbsSyn ) -> HappyWrap114
happyOut114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut114 #-}
newtype HappyWrap115 = HappyWrap115 ((Name, IsInstance))
happyIn115 :: ((Name, IsInstance)) -> (HappyAbsSyn )
happyIn115 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap115 x)
{-# INLINE happyIn115 #-}
happyOut115 :: (HappyAbsSyn ) -> HappyWrap115
happyOut115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut115 #-}
newtype HappyWrap116 = HappyWrap116 (Declaration)
happyIn116 :: (Declaration) -> (HappyAbsSyn )
happyIn116 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap116 x)
{-# INLINE happyIn116 #-}
happyOut116 :: (HappyAbsSyn ) -> HappyWrap116
happyOut116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut116 #-}
newtype HappyWrap117 = HappyWrap117 (Declaration)
happyIn117 :: (Declaration) -> (HappyAbsSyn )
happyIn117 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap117 x)
{-# INLINE happyIn117 #-}
happyOut117 :: (HappyAbsSyn ) -> HappyWrap117
happyOut117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut117 #-}
newtype HappyWrap118 = HappyWrap118 ([Declaration])
happyIn118 :: ([Declaration]) -> (HappyAbsSyn )
happyIn118 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap118 x)
{-# INLINE happyIn118 #-}
happyOut118 :: (HappyAbsSyn ) -> HappyWrap118
happyOut118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut118 #-}
newtype HappyWrap119 = HappyWrap119 (Declaration)
happyIn119 :: (Declaration) -> (HappyAbsSyn )
happyIn119 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap119 x)
{-# INLINE happyIn119 #-}
happyOut119 :: (HappyAbsSyn ) -> HappyWrap119
happyOut119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut119 #-}
newtype HappyWrap120 = HappyWrap120 (Declaration)
happyIn120 :: (Declaration) -> (HappyAbsSyn )
happyIn120 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap120 x)
{-# INLINE happyIn120 #-}
happyOut120 :: (HappyAbsSyn ) -> HappyWrap120
happyOut120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut120 #-}
newtype HappyWrap121 = HappyWrap121 (Declaration)
happyIn121 :: (Declaration) -> (HappyAbsSyn )
happyIn121 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap121 x)
{-# INLINE happyIn121 #-}
happyOut121 :: (HappyAbsSyn ) -> HappyWrap121
happyOut121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut121 #-}
newtype HappyWrap122 = HappyWrap122 (Declaration)
happyIn122 :: (Declaration) -> (HappyAbsSyn )
happyIn122 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap122 x)
{-# INLINE happyIn122 #-}
happyOut122 :: (HappyAbsSyn ) -> HappyWrap122
happyOut122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut122 #-}
newtype HappyWrap123 = HappyWrap123 (Declaration)
happyIn123 :: (Declaration) -> (HappyAbsSyn )
happyIn123 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap123 x)
{-# INLINE happyIn123 #-}
happyOut123 :: (HappyAbsSyn ) -> HappyWrap123
happyOut123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut123 #-}
newtype HappyWrap124 = HappyWrap124 (Declaration)
happyIn124 :: (Declaration) -> (HappyAbsSyn )
happyIn124 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap124 x)
{-# INLINE happyIn124 #-}
happyOut124 :: (HappyAbsSyn ) -> HappyWrap124
happyOut124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut124 #-}
newtype HappyWrap125 = HappyWrap125 (Declaration)
happyIn125 :: (Declaration) -> (HappyAbsSyn )
happyIn125 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap125 x)
{-# INLINE happyIn125 #-}
happyOut125 :: (HappyAbsSyn ) -> HappyWrap125
happyOut125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut125 #-}
newtype HappyWrap126 = HappyWrap126 (Declaration)
happyIn126 :: (Declaration) -> (HappyAbsSyn )
happyIn126 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap126 x)
{-# INLINE happyIn126 #-}
happyOut126 :: (HappyAbsSyn ) -> HappyWrap126
happyOut126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut126 #-}
newtype HappyWrap127 = HappyWrap127 (Declaration)
happyIn127 :: (Declaration) -> (HappyAbsSyn )
happyIn127 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap127 x)
{-# INLINE happyIn127 #-}
happyOut127 :: (HappyAbsSyn ) -> HappyWrap127
happyOut127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut127 #-}
newtype HappyWrap128 = HappyWrap128 (Declaration)
happyIn128 :: (Declaration) -> (HappyAbsSyn )
happyIn128 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap128 x)
{-# INLINE happyIn128 #-}
happyOut128 :: (HappyAbsSyn ) -> HappyWrap128
happyOut128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut128 #-}
newtype HappyWrap129 = HappyWrap129 ([Arg Name])
happyIn129 :: ([Arg Name]) -> (HappyAbsSyn )
happyIn129 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap129 x)
{-# INLINE happyIn129 #-}
happyOut129 :: (HappyAbsSyn ) -> HappyWrap129
happyOut129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut129 #-}
newtype HappyWrap130 = HappyWrap130 ([RString])
happyIn130 :: ([RString]) -> (HappyAbsSyn )
happyIn130 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap130 x)
{-# INLINE happyIn130 #-}
happyOut130 :: (HappyAbsSyn ) -> HappyWrap130
happyOut130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut130 #-}
newtype HappyWrap131 = HappyWrap131 ([NamedArg HoleName])
happyIn131 :: ([NamedArg HoleName]) -> (HappyAbsSyn )
happyIn131 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap131 x)
{-# INLINE happyIn131 #-}
happyOut131 :: (HappyAbsSyn ) -> HappyWrap131
happyOut131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut131 #-}
newtype HappyWrap132 = HappyWrap132 (NamedArg HoleName)
happyIn132 :: (NamedArg HoleName) -> (HappyAbsSyn )
happyIn132 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap132 x)
{-# INLINE happyIn132 #-}
happyOut132 :: (HappyAbsSyn ) -> HappyWrap132
happyOut132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut132 #-}
newtype HappyWrap133 = HappyWrap133 (HoleName)
happyIn133 :: (HoleName) -> (HappyAbsSyn )
happyIn133 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap133 x)
{-# INLINE happyIn133 #-}
happyOut133 :: (HappyAbsSyn ) -> HappyWrap133
happyOut133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut133 #-}
newtype HappyWrap134 = HappyWrap134 (HoleName)
happyIn134 :: (HoleName) -> (HappyAbsSyn )
happyIn134 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap134 x)
{-# INLINE happyIn134 #-}
happyOut134 :: (HappyAbsSyn ) -> HappyWrap134
happyOut134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut134 #-}
newtype HappyWrap135 = HappyWrap135 (RString)
happyIn135 :: (RString) -> (HappyAbsSyn )
happyIn135 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap135 x)
{-# INLINE happyIn135 #-}
happyOut135 :: (HappyAbsSyn ) -> HappyWrap135
happyOut135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut135 #-}
newtype HappyWrap136 = HappyWrap136 (Maybe Range)
happyIn136 :: (Maybe Range) -> (HappyAbsSyn )
happyIn136 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap136 x)
{-# INLINE happyIn136 #-}
happyOut136 :: (HappyAbsSyn ) -> HappyWrap136
happyOut136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut136 #-}
newtype HappyWrap137 = HappyWrap137 ([Declaration])
happyIn137 :: ([Declaration]) -> (HappyAbsSyn )
happyIn137 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap137 x)
{-# INLINE happyIn137 #-}
happyOut137 :: (HappyAbsSyn ) -> HappyWrap137
happyOut137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut137 #-}
newtype HappyWrap138 = HappyWrap138 ([Expr])
happyIn138 :: ([Expr]) -> (HappyAbsSyn )
happyIn138 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap138 x)
{-# INLINE happyIn138 #-}
happyOut138 :: (HappyAbsSyn ) -> HappyWrap138
happyOut138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut138 #-}
newtype HappyWrap139 = HappyWrap139 (Telescope -> Parser ModuleApplication)
happyIn139 :: (Telescope -> Parser ModuleApplication) -> (HappyAbsSyn )
happyIn139 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap139 x)
{-# INLINE happyIn139 #-}
happyOut139 :: (HappyAbsSyn ) -> HappyWrap139
happyOut139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut139 #-}
newtype HappyWrap140 = HappyWrap140 (Declaration)
happyIn140 :: (Declaration) -> (HappyAbsSyn )
happyIn140 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap140 x)
{-# INLINE happyIn140 #-}
happyOut140 :: (HappyAbsSyn ) -> HappyWrap140
happyOut140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut140 #-}
newtype HappyWrap141 = HappyWrap141 (Declaration)
happyIn141 :: (Declaration) -> (HappyAbsSyn )
happyIn141 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap141 x)
{-# INLINE happyIn141 #-}
happyOut141 :: (HappyAbsSyn ) -> HappyWrap141
happyOut141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut141 #-}
newtype HappyWrap142 = HappyWrap142 (Name)
happyIn142 :: (Name) -> (HappyAbsSyn )
happyIn142 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap142 x)
{-# INLINE happyIn142 #-}
happyOut142 :: (HappyAbsSyn ) -> HappyWrap142
happyOut142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut142 #-}
newtype HappyWrap143 = HappyWrap143 ([Declaration])
happyIn143 :: ([Declaration]) -> (HappyAbsSyn )
happyIn143 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap143 x)
{-# INLINE happyIn143 #-}
happyOut143 :: (HappyAbsSyn ) -> HappyWrap143
happyOut143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut143 #-}
newtype HappyWrap144 = HappyWrap144 (Declaration)
happyIn144 :: (Declaration) -> (HappyAbsSyn )
happyIn144 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap144 x)
{-# INLINE happyIn144 #-}
happyOut144 :: (HappyAbsSyn ) -> HappyWrap144
happyOut144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut144 #-}
newtype HappyWrap145 = HappyWrap145 (Pragma)
happyIn145 :: (Pragma) -> (HappyAbsSyn )
happyIn145 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap145 x)
{-# INLINE happyIn145 #-}
happyOut145 :: (HappyAbsSyn ) -> HappyWrap145
happyOut145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut145 #-}
newtype HappyWrap146 = HappyWrap146 (Pragma)
happyIn146 :: (Pragma) -> (HappyAbsSyn )
happyIn146 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap146 x)
{-# INLINE happyIn146 #-}
happyOut146 :: (HappyAbsSyn ) -> HappyWrap146
happyOut146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut146 #-}
newtype HappyWrap147 = HappyWrap147 (Pragma)
happyIn147 :: (Pragma) -> (HappyAbsSyn )
happyIn147 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap147 x)
{-# INLINE happyIn147 #-}
happyOut147 :: (HappyAbsSyn ) -> HappyWrap147
happyOut147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut147 #-}
newtype HappyWrap148 = HappyWrap148 (Pragma)
happyIn148 :: (Pragma) -> (HappyAbsSyn )
happyIn148 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap148 x)
{-# INLINE happyIn148 #-}
happyOut148 :: (HappyAbsSyn ) -> HappyWrap148
happyOut148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut148 #-}
newtype HappyWrap149 = HappyWrap149 (Pragma)
happyIn149 :: (Pragma) -> (HappyAbsSyn )
happyIn149 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap149 x)
{-# INLINE happyIn149 #-}
happyOut149 :: (HappyAbsSyn ) -> HappyWrap149
happyOut149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut149 #-}
newtype HappyWrap150 = HappyWrap150 (Pragma)
happyIn150 :: (Pragma) -> (HappyAbsSyn )
happyIn150 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap150 x)
{-# INLINE happyIn150 #-}
happyOut150 :: (HappyAbsSyn ) -> HappyWrap150
happyOut150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut150 #-}
newtype HappyWrap151 = HappyWrap151 (Pragma)
happyIn151 :: (Pragma) -> (HappyAbsSyn )
happyIn151 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap151 x)
{-# INLINE happyIn151 #-}
happyOut151 :: (HappyAbsSyn ) -> HappyWrap151
happyOut151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut151 #-}
newtype HappyWrap152 = HappyWrap152 (Pragma)
happyIn152 :: (Pragma) -> (HappyAbsSyn )
happyIn152 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap152 x)
{-# INLINE happyIn152 #-}
happyOut152 :: (HappyAbsSyn ) -> HappyWrap152
happyOut152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut152 #-}
newtype HappyWrap153 = HappyWrap153 (Pragma)
happyIn153 :: (Pragma) -> (HappyAbsSyn )
happyIn153 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap153 x)
{-# INLINE happyIn153 #-}
happyOut153 :: (HappyAbsSyn ) -> HappyWrap153
happyOut153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut153 #-}
newtype HappyWrap154 = HappyWrap154 (Pragma)
happyIn154 :: (Pragma) -> (HappyAbsSyn )
happyIn154 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap154 x)
{-# INLINE happyIn154 #-}
happyOut154 :: (HappyAbsSyn ) -> HappyWrap154
happyOut154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut154 #-}
newtype HappyWrap155 = HappyWrap155 (Pragma)
happyIn155 :: (Pragma) -> (HappyAbsSyn )
happyIn155 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap155 x)
{-# INLINE happyIn155 #-}
happyOut155 :: (HappyAbsSyn ) -> HappyWrap155
happyOut155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut155 #-}
newtype HappyWrap156 = HappyWrap156 (Pragma)
happyIn156 :: (Pragma) -> (HappyAbsSyn )
happyIn156 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap156 x)
{-# INLINE happyIn156 #-}
happyOut156 :: (HappyAbsSyn ) -> HappyWrap156
happyOut156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut156 #-}
newtype HappyWrap157 = HappyWrap157 (Pragma)
happyIn157 :: (Pragma) -> (HappyAbsSyn )
happyIn157 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap157 x)
{-# INLINE happyIn157 #-}
happyOut157 :: (HappyAbsSyn ) -> HappyWrap157
happyOut157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut157 #-}
newtype HappyWrap158 = HappyWrap158 (Pragma)
happyIn158 :: (Pragma) -> (HappyAbsSyn )
happyIn158 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap158 x)
{-# INLINE happyIn158 #-}
happyOut158 :: (HappyAbsSyn ) -> HappyWrap158
happyOut158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut158 #-}
newtype HappyWrap159 = HappyWrap159 (Pragma)
happyIn159 :: (Pragma) -> (HappyAbsSyn )
happyIn159 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap159 x)
{-# INLINE happyIn159 #-}
happyOut159 :: (HappyAbsSyn ) -> HappyWrap159
happyOut159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut159 #-}
newtype HappyWrap160 = HappyWrap160 (Pragma)
happyIn160 :: (Pragma) -> (HappyAbsSyn )
happyIn160 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap160 x)
{-# INLINE happyIn160 #-}
happyOut160 :: (HappyAbsSyn ) -> HappyWrap160
happyOut160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut160 #-}
newtype HappyWrap161 = HappyWrap161 (Pragma)
happyIn161 :: (Pragma) -> (HappyAbsSyn )
happyIn161 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap161 x)
{-# INLINE happyIn161 #-}
happyOut161 :: (HappyAbsSyn ) -> HappyWrap161
happyOut161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut161 #-}
newtype HappyWrap162 = HappyWrap162 (Pragma)
happyIn162 :: (Pragma) -> (HappyAbsSyn )
happyIn162 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap162 x)
{-# INLINE happyIn162 #-}
happyOut162 :: (HappyAbsSyn ) -> HappyWrap162
happyOut162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut162 #-}
newtype HappyWrap163 = HappyWrap163 (Pragma)
happyIn163 :: (Pragma) -> (HappyAbsSyn )
happyIn163 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap163 x)
{-# INLINE happyIn163 #-}
happyOut163 :: (HappyAbsSyn ) -> HappyWrap163
happyOut163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut163 #-}
newtype HappyWrap164 = HappyWrap164 (Pragma)
happyIn164 :: (Pragma) -> (HappyAbsSyn )
happyIn164 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap164 x)
{-# INLINE happyIn164 #-}
happyOut164 :: (HappyAbsSyn ) -> HappyWrap164
happyOut164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut164 #-}
newtype HappyWrap165 = HappyWrap165 (Pragma)
happyIn165 :: (Pragma) -> (HappyAbsSyn )
happyIn165 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap165 x)
{-# INLINE happyIn165 #-}
happyOut165 :: (HappyAbsSyn ) -> HappyWrap165
happyOut165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut165 #-}
newtype HappyWrap166 = HappyWrap166 (Pragma)
happyIn166 :: (Pragma) -> (HappyAbsSyn )
happyIn166 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap166 x)
{-# INLINE happyIn166 #-}
happyOut166 :: (HappyAbsSyn ) -> HappyWrap166
happyOut166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut166 #-}
newtype HappyWrap167 = HappyWrap167 (Pragma)
happyIn167 :: (Pragma) -> (HappyAbsSyn )
happyIn167 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap167 x)
{-# INLINE happyIn167 #-}
happyOut167 :: (HappyAbsSyn ) -> HappyWrap167
happyOut167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut167 #-}
newtype HappyWrap168 = HappyWrap168 (Pragma)
happyIn168 :: (Pragma) -> (HappyAbsSyn )
happyIn168 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap168 x)
{-# INLINE happyIn168 #-}
happyOut168 :: (HappyAbsSyn ) -> HappyWrap168
happyOut168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut168 #-}
newtype HappyWrap169 = HappyWrap169 ([(Range, Occurrence)])
happyIn169 :: ([(Range, Occurrence)]) -> (HappyAbsSyn )
happyIn169 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap169 x)
{-# INLINE happyIn169 #-}
happyOut169 :: (HappyAbsSyn ) -> HappyWrap169
happyOut169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut169 #-}
newtype HappyWrap170 = HappyWrap170 ((Range, Occurrence))
happyIn170 :: ((Range, Occurrence)) -> (HappyAbsSyn )
happyIn170 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap170 x)
{-# INLINE happyIn170 #-}
happyOut170 :: (HappyAbsSyn ) -> HappyWrap170
happyOut170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut170 #-}
newtype HappyWrap171 = HappyWrap171 ([TypeSignature])
happyIn171 :: ([TypeSignature]) -> (HappyAbsSyn )
happyIn171 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap171 x)
{-# INLINE happyIn171 #-}
happyOut171 :: (HappyAbsSyn ) -> HappyWrap171
happyOut171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut171 #-}
newtype HappyWrap172 = HappyWrap172 ([TypeSignature])
happyIn172 :: ([TypeSignature]) -> (HappyAbsSyn )
happyIn172 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap172 x)
{-# INLINE happyIn172 #-}
happyOut172 :: (HappyAbsSyn ) -> HappyWrap172
happyOut172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut172 #-}
newtype HappyWrap173 = HappyWrap173 ([TypeSignature])
happyIn173 :: ([TypeSignature]) -> (HappyAbsSyn )
happyIn173 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap173 x)
{-# INLINE happyIn173 #-}
happyOut173 :: (HappyAbsSyn ) -> HappyWrap173
happyOut173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut173 #-}
newtype HappyWrap174 = HappyWrap174 ([Arg TypeSignature])
happyIn174 :: ([Arg TypeSignature]) -> (HappyAbsSyn )
happyIn174 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap174 x)
{-# INLINE happyIn174 #-}
happyOut174 :: (HappyAbsSyn ) -> HappyWrap174
happyOut174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut174 #-}
newtype HappyWrap175 = HappyWrap175 ([Arg TypeSignature])
happyIn175 :: ([Arg TypeSignature]) -> (HappyAbsSyn )
happyIn175 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap175 x)
{-# INLINE happyIn175 #-}
happyOut175 :: (HappyAbsSyn ) -> HappyWrap175
happyOut175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut175 #-}
newtype HappyWrap176 = HappyWrap176 ([Arg TypeSignature])
happyIn176 :: ([Arg TypeSignature]) -> (HappyAbsSyn )
happyIn176 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap176 x)
{-# INLINE happyIn176 #-}
happyOut176 :: (HappyAbsSyn ) -> HappyWrap176
happyOut176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut176 #-}
newtype HappyWrap177 = HappyWrap177 ([Arg TypeSignature])
happyIn177 :: ([Arg TypeSignature]) -> (HappyAbsSyn )
happyIn177 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap177 x)
{-# INLINE happyIn177 #-}
happyOut177 :: (HappyAbsSyn ) -> HappyWrap177
happyOut177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut177 #-}
newtype HappyWrap178 = HappyWrap178 (((Maybe (Ranged Induction), Maybe HasEta, Maybe (Name, IsInstance)), [Declaration]))
happyIn178 :: (((Maybe (Ranged Induction), Maybe HasEta, Maybe (Name, IsInstance)), [Declaration])) -> (HappyAbsSyn )
happyIn178 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap178 x)
{-# INLINE happyIn178 #-}
happyOut178 :: (HappyAbsSyn ) -> HappyWrap178
happyOut178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut178 #-}
newtype HappyWrap179 = HappyWrap179 ([RecordDirective])
happyIn179 :: ([RecordDirective]) -> (HappyAbsSyn )
happyIn179 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap179 x)
{-# INLINE happyIn179 #-}
happyOut179 :: (HappyAbsSyn ) -> HappyWrap179
happyOut179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut179 #-}
newtype HappyWrap180 = HappyWrap180 (RecordDirective)
happyIn180 :: (RecordDirective) -> (HappyAbsSyn )
happyIn180 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap180 x)
{-# INLINE happyIn180 #-}
happyOut180 :: (HappyAbsSyn ) -> HappyWrap180
happyOut180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut180 #-}
newtype HappyWrap181 = HappyWrap181 (Ranged HasEta)
happyIn181 :: (Ranged HasEta) -> (HappyAbsSyn )
happyIn181 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap181 x)
{-# INLINE happyIn181 #-}
happyOut181 :: (HappyAbsSyn ) -> HappyWrap181
happyOut181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut181 #-}
newtype HappyWrap182 = HappyWrap182 (Ranged Induction)
happyIn182 :: (Ranged Induction) -> (HappyAbsSyn )
happyIn182 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap182 x)
{-# INLINE happyIn182 #-}
happyOut182 :: (HappyAbsSyn ) -> HappyWrap182
happyOut182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut182 #-}
newtype HappyWrap183 = HappyWrap183 ([Declaration])
happyIn183 :: ([Declaration]) -> (HappyAbsSyn )
happyIn183 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap183 x)
{-# INLINE happyIn183 #-}
happyOut183 :: (HappyAbsSyn ) -> HappyWrap183
happyOut183 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut183 #-}
newtype HappyWrap184 = HappyWrap184 ([Declaration])
happyIn184 :: ([Declaration]) -> (HappyAbsSyn )
happyIn184 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap184 x)
{-# INLINE happyIn184 #-}
happyOut184 :: (HappyAbsSyn ) -> HappyWrap184
happyOut184 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut184 #-}
newtype HappyWrap185 = HappyWrap185 ([Declaration])
happyIn185 :: ([Declaration]) -> (HappyAbsSyn )
happyIn185 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap185 x)
{-# INLINE happyIn185 #-}
happyOut185 :: (HappyAbsSyn ) -> HappyWrap185
happyOut185 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut185 #-}
newtype HappyWrap186 = HappyWrap186 ([Declaration])
happyIn186 :: ([Declaration]) -> (HappyAbsSyn )
happyIn186 x = Happy_GHC_Exts.unsafeCoerce# (HappyWrap186 x)
{-# INLINE happyIn186 #-}
happyOut186 :: (HappyAbsSyn ) -> HappyWrap186
happyOut186 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut186 #-}
happyInTok :: (Token) -> (HappyAbsSyn )
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn ) -> (Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyExpList :: HappyAddr
happyExpList = HappyA# "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2b\x0c\x00\x00\x98\x63\xab\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x89\x00\x00\x00\x60\x8e\xa9\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xa5\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x20\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x08\x05\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x89\x00\x00\x00\x60\x8e\xa1\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\x96\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x22\x00\x00\x00\x98\x63\xa8\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\x58\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x08\x00\x00\x00\xe6\x18\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x22\x00\x00\x00\x98\x63\xa8\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\xc0\x08\x42\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x84\xd0\xa9\x10\x00\x00\x60\x8e\xed\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\x96\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x0f\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x36\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x27\x02\x00\x00\x80\x39\x86\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x08\x00\x00\x00\xe6\x18\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xbb\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x3e\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\xda\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x1d\xde\xfb\x9d\x3b\x01\x00\x00\xe6\xd8\x6a\xa1\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x27\x02\x00\x00\x80\x39\x86\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xa9\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x08\x42\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x08\x05\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x42\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x08\x05\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x42\xa7\x42\x00\x00\x80\x39\xb6\x5b\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\xea\x83\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x8d\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xed\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\xfa\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x83\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xbb\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x3e\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\xda\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x27\x02\x00\x00\x80\x39\x86\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x1d\xde\xfb\x9d\x3b\x01\x00\x00\xe6\xd8\x6a\xa1\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x08\x05\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x08\x42\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x84\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x08\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x89\x00\x00\x00\x60\x8e\xa1\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xa9\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\x58\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xa9\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xa5\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\x96\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\x58\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xa9\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x08\x00\x00\x00\xe6\x18\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\x58\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x80\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\x58\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xa5\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\x96\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xa9\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xa5\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\x96\x5a\x68\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x08\x42\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x20\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x42\xa7\x42\x00\x00\x80\x39\xb6\x5b\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\xea\x83\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x0d\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x89\x00\x00\x00\x60\x8e\xa1\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x27\x02\x00\x00\x80\x39\x86\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x50\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x08\x42\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x87\xf7\x7e\xe7\x4e\x00\x00\x80\x39\xb6\x5a\x6a\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x08\x42\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x82\x50\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x08\x42\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x82\x50\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x1d\xde\xfb\x9d\x3b\x01\x00\x00\xe6\xd8\x6a\xa1\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x22\x00\x00\x00\x98\x63\xa8\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x20\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x08\x42\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x08\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x08\x05\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x9d\x0a\x01\x00\x00\xe6\xd8\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x08\x05\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x08\x00\x00\x00\xe6\x18\x6a\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x88\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x3e\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xa5\x16\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xa9\x85\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x88\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x80\x08\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xa5\x16\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xa9\x85\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x50\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\xd0\xa9\x10\x00\x00\x60\x8e\xad\x16\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x80\x08\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x74\x2a\x04\x00\x00\x98\x63\xab\x05\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x27\x02\x00\x00\x80\x39\x86\x5a\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x22\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x1f\xdf\xff\x9d\x3b\x01\x00\x00\xe6\xd8\x6a\xa1\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x20\x02\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x22\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x40\xa7\x42\x00\x00\x80\x39\xb6\xfa\x60\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x50\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x40\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x00\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x50\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x40\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x05\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd9\xe1\xbd\xdf\xb9\x13\x00\x00\x60\x8e\xad\x96\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfd\xf1\xfd\xdf\xb9\x13\x00\x00\x60\x8e\xad\x16\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

{-# NOINLINE happyExpListPerState #-}
happyExpListPerState st =
    token_strs_expected
  where token_strs = ["error","%dummy","%start_tokensParser","%start_exprParser","%start_exprWhereParser","%start_moduleParser","%start_moduleNameParser","%start_funclauseParser","%start_holeContentParser","Tokens","TokensR","Token","File","maybe_vclose","close","semi","beginImpDir","Float","Id","SpaceIds","DoubleCloseBrace","MaybeDottedId","MaybeDottedIds","ArgIds","ModalArgIds","Attribute","Attributes","Attributes1","QId","ModuleName","BId","SpaceBIds","CommaBIds","CommaBIdAndAbsurds","BIdsWithHiding","PragmaStrings","Strings","ForeignCode","PragmaName","PragmaQName","PragmaQNames","Expr","Expr1","WithExprs","Application","Expr2","LetBody","ExtendedOrAbsurdLam","Application3","Application3PossiblyEmpty","Expr3Curly","Expr3NoCurly","ExprOrAttr","Expr3","RecordAssignments","RecordAssignments1","RecordAssignment","ModuleAssignment","FieldAssignments","FieldAssignments1","FieldAssignment","TeleArrow","Telescope1","TypedBindings","TypedBinding","TBind","ModalTBind","TBindWithHiding","ModalTBindWithHiding","LamBindings","AbsurdLamBindings","LamBinds","LamBindsAbsurd","NonAbsurdLamClause","AbsurdLamClause","LamClause","LamClauses","LamWhereClauses","ForallBindings","TypedUntypedBindings1","TypedUntypedBindings","DomainFreeBinding","MaybeAsPattern","DomainFreeBindingAbsurd","DoStmts","DoStmt","DoWhere","ImportDirective","ImportDirectives","ImportDirective1","Using","Hiding","RenamingDir","Renamings","Renaming","RenamingTarget","ImportName_","ImportName","CommaImportNames","CommaImportNames1","LHS","WithRewriteExpressions","HoleContent","WhereClause","ExprWhere","Declaration","TypeSigs","ArgTypeSigs","FunClause","RHS","Data","DataSig","Record","RecordSig","RecordConstructorName","Infix","Fields","Generalize","Mutual","Abstract","Private","Instance","Macro","Postulate","Primitive","UnquoteDecl","Syntax","PatternSyn","PatternSynArgs","SimpleIds","HoleNames","HoleName","SimpleTopHole","SimpleHole","SimpleId","MaybeOpen","Open","OpenArgs","ModuleApplication","ModuleMacro","Module","Underscore","TopLevel","Pragma","DeclarationPragma","OptionsPragma","BuiltinPragma","RewritePragma","ForeignPragma","CompilePragma","StaticPragma","InlinePragma","NoInlinePragma","InjectivePragma","DisplayPragma","EtaPragma","NoTerminationCheckPragma","NonTerminatingPragma","TerminatingPragma","NonCoveringPragma","MeasurePragma","CatchallPragma","ImpossiblePragma","NoPositivityCheckPragma","NoUniverseCheckPragma","PolarityPragma","WarningOnUsagePragma","WarningOnImportPragma","Polarities","Polarity","TypeSignatures0","TypeSignatures","TypeSignatures1","ArgTypeSignatures","ArgTypeSignatures1","ArgTypeSignaturesOrEmpty","ArgTypeSignatures0","RecordDeclarations","RecordDirectives","RecordDirective","RecordEta","RecordInduction","Declarations","Declarations0","Declarations1","TopDeclarations","'abstract'","'codata'","'coinductive'","'constructor'","'data'","'eta-equality'","'field'","'forall'","'variable'","'hiding'","'import'","'in'","'inductive'","'infix'","'infixl'","'infixr'","'instance'","'overlap'","'let'","'macro'","'module'","'mutual'","'no-eta-equality'","'open'","'pattern'","'postulate'","'primitive'","'private'","'Prop'","'public'","'quote'","'quoteTerm'","'record'","'renaming'","'rewrite'","'Set'","'syntax'","'tactic'","'to'","'unquote'","'unquoteDecl'","'unquoteDef'","'using'","'where'","'do'","'with'","'BUILTIN'","'CATCHALL'","'DISPLAY'","'ETA'","'FOREIGN'","'COMPILE'","'IMPOSSIBLE'","'INJECTIVE'","'INLINE'","'NOINLINE'","'MEASURE'","'NO_TERMINATION_CHECK'","'NO_POSITIVITY_CHECK'","'NO_UNIVERSE_CHECK'","'NON_TERMINATING'","'NON_COVERING'","'OPTIONS'","'POLARITY'","'WARNING_ON_USAGE'","'WARNING_ON_IMPORT'","'REWRITE'","'STATIC'","'TERMINATING'","setN","propN","tex","comment","'...'","'..'","'.'","';'","':'","'='","'_'","'?'","'->'","'\\\\'","'@'","'|'","'('","')'","'(|'","'|)'","'(|)'","'{{'","'}}'","'{'","'}'","vopen","vclose","vsemi","'{-#'","'#-}'","id","q_id","string","literal","%eof"]
        bit_start = st * 290
        bit_end = (st + 1) * 290
        read_bit = readArrayBit happyExpList
        bits = map read_bit [bit_start..bit_end - 1]
        bits_indexed = zip bits [0..289]
        token_strs_expected = concatMap f bits_indexed
        f (False, _) = []
        f (True, nr) = [token_strs !! nr]

happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\x00\x00\x37\x0e\x37\x0e\xaa\xff\x71\x00\x84\x0e\x73\x07\x00\x00\x90\x05\xc2\xff\x00\x00\x53\x18\x00\x00\x00\x00\xcd\xff\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x00\x00\x2c\x0b\xd1\x0e\xe3\xff\x00\x00\xd7\x02\x00\x00\xd4\xff\xb3\x02\xeb\xff\x00\x00\x00\x00\x00\x00\x95\x18\x51\x16\x00\x00\xd7\x18\x00\x00\x22\x00\x51\x16\x00\x00\x00\x00\x00\x00\x19\x19\x5b\x19\x00\x00\x00\x00\xd7\x05\x15\x02\xc9\x07\x51\x16\x00\x00\x16\x08\x78\x0b\x00\x00\x00\x00\x00\x00\x1e\x0f\xeb\x01\x53\x00\x89\x02\x10\x00\x9d\x19\x9d\x19\xc5\x0b\x63\x08\x12\x0c\x00\x00\x00\x00\x10\x00\x10\x00\x28\x05\xf8\xff\x10\x00\x10\x00\x10\x00\x00\x00\x67\x00\x50\x00\x7d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdd\x00\x00\x00\x00\x00\x00\x00\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x00\xf6\x00\x0c\x01\x0c\x01\x0a\x01\x0a\x01\x0a\x01\x2d\x01\x2d\x01\x05\x01\x2d\x01\x3b\x01\x40\x01\xa0\x01\xac\x01\xb1\x01\xdf\x19\xb3\x01\x83\x00\xb3\x01\x1d\x0f\xbc\x01\x00\x00\x00\x00\x6b\x01\x00\x00\xcc\x01\xad\x01\x00\x00\x00\x00\x00\x00\xf8\xff\x6b\x0f\x6b\x0f\x51\x16\x00\x00\x00\x00\x89\x02\xb8\x0f\x17\x02\x1a\x02\x00\x00\x18\x02\x0c\x02\x0f\x02\x24\x02\x6b\x01\x6b\x01\x1f\x02\x05\x10\x2d\x02\x52\x01\x35\x02\x39\x02\x3e\x02\x3c\x02\xe5\x02\x00\x00\x52\x10\x00\x00\x4c\x02\x52\x03\x52\x10\x00\x00\x51\x02\x00\x00\xc3\x0a\xa8\x04\x49\x02\xca\x02\xc1\x03\x00\x00\xba\x08\x07\x09\x54\x09\x5f\x0c\xa1\x09\xac\x0c\xf9\x0c\xa1\x09\x46\x0d\xeb\x01\x52\x10\x00\x00\x21\x1a\xeb\x01\x58\x02\xe5\x02\xad\x02\x26\x07\xf6\x0b\x52\x10\x73\x02\xf6\x0b\x00\x00\x9d\x0d\x9f\x10\x9f\x10\x00\x00\xda\x02\xe8\x02\x9d\x0d\x9f\x10\x9f\x10\x00\x00\x00\x00\x00\x00\x00\x00\xec\x10\xec\x10\x87\x02\x21\x1a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\x10\x00\x00\x00\x00\x39\x11\x00\x00\x51\x16\x86\x11\x00\x00\x51\x16\x9d\x16\x9d\x16\xe9\x16\x35\x17\x35\x17\xd3\x11\x62\x02\xd3\x11\x87\x01\xd3\x11\x86\x02\x00\x00\x00\x00\x00\x00\x00\x00\x17\x00\x00\x00\x20\x12\xae\x02\x21\x1a\xa3\x02\x00\x00\xbd\x02\x00\x00\x00\x00\xab\x02\x00\x00\xf8\x02\x17\x00\x81\x01\x00\x00\xf6\x02\x6b\x01\x04\x03\x0b\x03\x6b\x01\x14\x03\x19\x01\x20\x03\x6d\x12\x00\x00\xa1\x01\x20\x01\x81\x17\x40\x03\x69\x03\x4a\x03\x53\x03\x76\x03\xcd\x17\xcd\x17\x76\x03\xcd\x17\xcd\x17\xb9\x12\xc8\x0d\x6b\x03\xc8\x0d\xf8\x09\x45\x0a\xea\x0d\x00\x00\x00\x00\x7f\x03\x00\x00\x21\x1a\x63\x1a\x09\x00\x00\x00\x00\x00\x00\x00\x05\x13\x8c\x03\x00\x00\x00\x00\x00\x00\x16\x01\x00\x00\x00\x00\x05\x13\x78\x01\x91\x03\xf8\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe6\xff\x8d\x03\xa5\x03\xc2\x03\xcd\x03\xd6\x03\xa0\x03\xe2\x03\xe2\x03\xe2\x03\xe5\x03\xb3\x03\xe1\x03\xed\x03\xf0\x03\xf5\x03\xf4\x03\x07\x04\x0c\x04\xfa\x03\x13\x04\x1c\x04\x26\x04\x33\x04\x54\x04\x59\x04\x05\x13\x57\x02\x15\x0e\x00\x00\x00\x00\xc3\x04\x00\x00\x00\x00\x19\x00\x00\x00\x62\x0e\x56\x04\x00\x00\xaf\x0e\xaf\x0e\x00\x00\x00\x00\x00\x00\xa6\x01\x00\x00\xa6\x01\xa6\x01\x00\x00\xbb\x01\x00\x00\xaf\x0e\x00\x00\x00\x00\x00\x00\xe5\x02\x26\x07\x00\x00\xc1\x06\x00\x00\x92\x04\x9b\x04\x5d\x04\x5d\x04\x00\x00\xa5\x1a\xaf\x0e\xef\xff\xaf\x0e\x7b\x04\x40\x04\x00\x00\xae\x00\x76\x04\x00\x00\xa6\x01\x00\x00\x00\x00\x00\x00\xae\x04\x2d\x00\xaf\x0e\x00\x00\x9f\x04\x00\x00\x93\x04\x00\x00\xae\x00\x00\x00\x00\x00\x00\x00\x86\x00\x52\x13\x9d\x03\x00\x00\x00\x00\x00\x00\x97\x04\x87\x00\x87\x00\x00\x00\x00\x00\x9f\x13\x9f\x13\x00\x00\x00\x00\x96\x04\x00\x00\x00\x00\x9a\x04\x8f\x04\x9c\x04\xa1\x04\x00\x00\x00\x00\x9e\x04\x91\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaf\x04\xb2\x04\xb7\x04\xb9\x04\x00\x00\xc8\x04\xe0\x01\xd2\x04\xd4\x04\x00\x00\xd9\x04\xd9\x04\x00\x00\x9f\x13\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x13\x00\x00\x00\x00\xa5\x1a\xb5\x00\x92\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x00\x82\x01\x87\x01\x00\x00\xb7\x01\x87\x01\x00\x00\x00\x00\xcd\x04\xec\x13\x00\x00\x00\x00\xec\x13\x00\x00\x38\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x14\x85\x14\x00\x00\x00\x00\xac\x04\x00\x05\xa6\x04\x00\x00\x06\x05\xe5\x02\x00\x00\xb5\x00\xd2\x14\x00\x00\x00\x00\x00\x00\x03\x05\x0d\x05\x00\x00\xa5\x01\x00\x00\xfa\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\x00\x00\x00\x00\x00\x00\x00\x10\x05\x00\x00\x21\x05\x24\x05\x00\x00\x19\x05\x00\x00\x1f\x15\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x15\x6b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x05\x1e\x05\x2b\x05\x00\x00\x96\x05\xe0\x01\xe0\x01\x23\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x00\x9e\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2d\x05\x35\x05\xa8\x01\xad\x05\xc6\x05\xb0\x01\x00\x00\xcf\x05\x54\x01\xbf\x05\x04\x16\x00\x00\xd8\x05\x04\x16\x04\x16\xfa\x05\xef\x05\xe5\x02\xef\x05\x00\x00\xf8\x05\x00\x00\xb2\x03\x00\x00\xb2\x03\x00\x00\x5e\x03\x00\x00\x00\x00\xe6\x01\x78\x02\xf4\x00\xf4\x00\x04\x16\x00\x00\xf1\x05\x04\x16\x00\x00\xb5\x00\x00\x00\x00\x00\x00\x00\x27\x06\x00\x00\x00\x00\xf4\x00\xf9\x05\x0a\x06\x0a\x06\x6b\x01\x00\x00\x0a\x06\x0a\x06\x00\x00\x0a\x06\x0a\x06\x00\x00\x00\x00\x00\x00\xae\x00\x04\x16\x00\x00\xe7\x1a\xb5\x00\x00\x00\x62\x03\x00\x00\x00\x00\x00\x00\x52\x06\x00\x00\xf7\x05\x1b\x06\x00\x00\x31\x06\x35\x06\x87\x00\x00\x00\x42\x06\x44\x06\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x06\x00\x00\x32\x06\x00\x00\x00\x00\x00\x00\x00\x00\xb5\x00\x00\x00\x00\x00\xae\x00\x00\x00\xf6\xff\xfe\xff\xf6\xff\x00\x00\x00\x00\x4a\x06\x4d\x06\x00\x00\x36\x06\x36\x06\x53\x06\x58\x06\x82\x06\x00\x00\x00\x00\x54\x06\x00\x00\x00\x00\xe0\x01\x00\x00\x50\x06\x00\x00\x4f\x06\x4f\x06\x59\x06\x56\x06\x56\x06\x00\x00\x00\x00\xae\x00\x00\x00\x00\x00\x00\x00\x17\x00\x00\x00\x57\x06\x00\x00\x00\x00\x5d\x06\x00\x00\x65\x06\xb5\x00\x00\x00\x00\x00\xdf\x0a\x00\x00\x00\x00\xec\x03\x5a\x06\x6b\x01\x67\x06\x6b\x01\x5e\x03\x5e\x03\x00\x00\x68\x06\x00\x00\x00\x00\x00\x00\x5e\x03\x5e\x03\x5e\x03\x5e\x03\x00\x00\x6b\x01\x00\x00\x00\x00\x5b\x04\x00\x00\x00\x00\x00\x00\x5c\x06\x76\x06\x77\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x06\x3f\x00\xc3\x06\x00\x00\x00\x00\x00\x00\x00\x00\xf6\xff\x00\x00\x00\x00\x00\x00\x00\x00\x7c\x06\x7c\x06\x7c\x06\x00\x00\x00\x00\x00\x00\x00\x00\x17\x00\x80\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x00\x00\x00\x80\x06\x80\x06\x80\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\xff\x03\x07\x1e\x19\x18\xe5\x06\x99\x01\x2b\x04\x38\x18\xeb\x06\xef\x06\x00\x00\x00\x00\x43\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x0d\x26\x1e\x00\x00\x00\x00\xd2\x03\x00\x00\x00\x00\xd6\x01\x46\x06\x00\x00\x00\x00\x00\x00\xb1\x00\x4d\x0a\x00\x00\xb9\x07\x00\x00\x00\x00\xa2\x0a\x00\x00\x00\x00\x00\x00\x14\x02\x80\x02\x00\x00\x00\x00\xfb\x03\x25\x00\xac\x03\x6f\x0c\x00\x00\xe0\x1b\x0a\x1c\x00\x00\x00\x00\x00\x00\x7b\x02\x98\x06\x00\x00\x91\x06\x00\x00\x16\x04\x79\x07\x45\x1e\xe8\x1d\x64\x1e\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x99\x06\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x74\x03\xf0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf4\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x03\xf1\x06\x55\x06\x5b\x06\xf7\x06\xfa\x06\xfb\x06\x99\x03\xb0\x03\x23\x00\xe4\x03\xfe\x02\xf3\x06\xf2\x03\x94\x03\xfc\x03\x5f\x01\xfc\x06\x74\x04\xbc\x04\x00\x00\x00\x00\x00\x00\x00\x00\xee\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x06\x83\x1e\xa2\x1e\xb4\x0c\x00\x00\x00\x00\xa2\x06\x85\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x06\xff\x06\x00\x00\xf1\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x06\xfe\x02\x00\x00\xc1\x1e\x00\x00\xc6\x06\xf3\x02\xe0\x1e\x00\x00\x00\x00\x00\x00\xd0\x03\x00\x00\x00\x00\x98\x00\xc4\x00\x00\x00\x16\x03\x58\x1c\x88\x03\x91\x1b\x36\x1d\x8f\x1d\xb0\x1b\x66\x1d\xb8\x1d\xb4\x06\x33\x1b\x00\x00\x28\x08\xb7\x06\x00\x00\xf5\x01\xf5\x06\x5c\x02\xd3\x03\xff\x1e\x00\x00\x50\x04\x00\x00\x16\x03\x9a\x1c\xb8\x1c\x00\x00\x00\x00\x00\x00\xcb\x03\xd6\x1c\xf4\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x1f\x3d\x1f\x00\x00\xa9\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5c\x1f\x00\x00\x00\x00\x37\x0b\x00\x00\xaf\x0d\x0b\x0d\x00\x00\xa8\x18\xd4\x07\x21\x08\xea\x18\x6e\x08\xc5\x08\x91\x0b\x00\x00\xd0\x0b\x12\x07\x24\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x07\x00\x00\x7b\x1f\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\xd2\x06\x1c\x07\x1a\x07\x00\x00\x00\x00\x1e\x07\x00\x00\x00\x00\x1f\x07\x00\x00\x00\x00\x00\x00\xff\x0c\x00\x00\x2b\x07\x2c\x07\xa3\x0d\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x06\x12\x09\x5f\x09\xea\x06\xac\x09\x03\x0a\x07\x00\xb8\x04\x00\x00\x1d\x05\xe9\x03\x7c\x1c\x12\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x75\x08\xb9\x00\x18\x07\x00\x00\x00\x00\x00\x00\x9a\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x35\x01\x00\x00\x00\x00\xb9\x1f\x66\x01\x00\x00\xda\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x07\x00\x00\x00\x00\x00\x00\x2f\x07\x33\x07\x38\x07\x3b\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x07\x3d\x07\x3e\x07\x00\x00\x2c\x02\x40\x07\x00\x00\xc6\x04\x00\x00\x00\x00\xd8\x1f\x70\x03\x0f\x05\x00\x00\x00\x00\xfc\xff\x00\x00\x00\x00\xfd\xff\x00\x00\x2e\x01\x52\x07\x00\x00\x43\x06\x51\x06\x00\x00\x00\x00\x00\x00\x67\x01\x00\x00\xa8\x02\xcb\x02\x00\x00\x03\x00\x00\x00\xa8\x06\x00\x00\x00\x00\x00\x00\x3b\x03\xf2\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x04\x44\x04\x00\x00\xc5\x00\xb6\x06\x00\x00\x0d\x07\x00\x00\xaa\x02\x00\x00\xf6\x04\xa5\x06\xe5\x00\xf7\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1b\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x05\x00\x00\x00\x00\x00\x00\x00\x00\x34\x1c\x3d\x03\x00\x00\x00\x00\x00\x00\x00\x00\x94\x04\xa5\x04\x00\x00\x00\x00\xf7\x1f\x16\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x07\x00\x00\x00\x00\xc0\x06\x00\x00\x00\x00\x46\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x07\x48\x07\x00\x00\x4c\x07\x00\x00\x49\x07\x4a\x07\x00\x00\x35\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x20\x00\x00\x00\x00\xe0\x00\xde\x03\xe8\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x05\x00\x00\x5e\x07\x00\x00\x00\x00\x5f\x07\x00\x00\x00\x00\x00\x00\x33\x01\x00\x00\x00\x00\xd1\x01\x00\x00\x73\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x03\x00\x00\x0e\x05\x92\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd9\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x9d\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6e\x02\x63\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x53\x07\x57\x07\x5a\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x00\x02\x07\x00\x00\x69\x01\x00\x00\xd0\x06\xd0\x20\x00\x00\x3c\x00\xef\x20\x0e\x21\x00\x00\x86\x04\x2b\x00\x9d\x04\x00\x00\x00\x00\x00\x00\xf9\xff\x00\x00\x47\x00\x00\x00\x81\x02\x00\x00\x00\x00\x7b\x07\x7c\x07\x6a\x03\x8a\x03\x2d\x21\x00\x00\xb5\x04\x4c\x21\x00\x00\x1a\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x03\x00\x00\x7e\x07\x80\x07\x84\x07\x00\x00\x67\x05\x6c\x05\x00\x00\x7d\x05\x10\x06\x00\x00\x00\x00\x00\x00\x20\x06\x6b\x21\x00\x00\x5b\x01\xe7\x05\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x01\x14\x07\x00\x00\x00\x00\x00\x00\xb2\x05\x00\x00\x00\x00\x00\x00\xb4\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x06\x00\x00\x00\x00\x3a\x06\x00\x00\x77\x00\xdf\x00\x09\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x07\x95\x07\x00\x00\x00\x00\x00\x00\x98\x07\x00\x00\x00\x00\x00\x00\x00\x00\x8a\x07\x00\x00\x00\x00\x00\x00\x2d\x07\x30\x07\x00\x00\x36\x07\x37\x07\x00\x00\x00\x00\x3f\x06\x00\x00\x00\x00\x00\x00\xa2\x07\x00\x00\xac\x07\x00\x00\x00\x00\xa8\x05\x00\x00\x0e\x07\x4e\x06\x00\x00\x00\x00\xe8\x1d\x00\x00\x00\x00\xdb\x00\x00\x00\xad\x07\x00\x00\xb0\x07\x2a\x03\x81\x04\x00\x00\xba\x05\x00\x00\x00\x00\x00\x00\x87\x04\x90\x04\xa4\x04\xab\x04\x00\x00\xb5\x07\x00\x00\x00\x00\xfc\xff\x00\x00\x00\x00\x00\x00\xc6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x07\xfb\xff\x2b\x01\x00\x00\x00\x00\x00\x00\x00\x00\xfa\xff\x00\x00\x00\x00\x00\x00\x00\x00\xbd\x07\xc0\x07\xc2\x07\x00\x00\x00\x00\x00\x00\x00\x00\xbc\x07\xc6\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd1\x07\x00\x00\xd0\x07\xd2\x07\xd5\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyAdjustOffset :: Happy_GHC_Exts.Int# -> Happy_GHC_Exts.Int#
happyAdjustOffset off = off

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\xf6\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\xfe\x00\x00\xf8\xff\x66\xff\x69\xff\x00\x00\x1e\xff\xa0\xfe\x4b\xff\x4a\xff\x48\xff\x47\xff\x44\xff\x00\x00\x1b\xff\x1a\xff\x1f\xff\x40\xff\x00\x00\x00\x00\x0c\xff\x0a\xff\x9f\xfe\x00\x00\x00\x00\x00\x00\x31\xff\x2f\xff\x2e\xff\x00\x00\x00\x00\x30\xff\x00\x00\x2d\xff\x00\x00\x00\x00\x2c\xff\x2b\xff\x20\xff\x00\x00\x00\x00\x32\xff\x33\xff\x00\x00\x00\x00\x4e\xfe\x00\x00\x28\xff\x00\x00\x00\x00\x85\xff\x67\xff\x1d\xff\x00\x00\xa3\xfe\x00\x00\x7b\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x66\xff\x65\xff\x00\x00\x00\x00\x4e\xfe\x9e\xfe\x00\x00\x00\x00\x00\x00\x9a\xfe\x00\x00\x00\x00\xef\xfd\x98\xfe\x97\xfe\x96\xfe\x95\xfe\x94\xfe\x93\xfe\x99\xfe\x92\xfe\x91\xfe\x90\xfe\x8f\xfe\x8e\xfe\x8d\xfe\x8c\xfe\x8b\xfe\x84\xfe\x86\xfe\x85\xfe\x00\x00\x8a\xfe\x89\xfe\x88\xfe\x8d\xff\x87\xfe\x40\xfe\x29\xfe\x3f\xfe\x3e\xfe\x3c\xfe\x3d\xfe\x3b\xfe\x39\xfe\x38\xfe\x3a\xfe\x2e\xfe\x2d\xfe\x34\xfe\x35\xfe\x36\xfe\x33\xfe\x30\xfe\x2f\xfe\x37\xfe\x2c\xfe\x2b\xfe\x2a\xfe\x32\xfe\x31\xfe\xed\xfd\x41\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\xff\x26\xff\x00\x00\x82\xff\x00\x00\x00\x00\x27\xff\x24\xff\x23\xff\x9e\xfe\x00\x00\x00\x00\x00\x00\xa4\xfe\x68\xff\x7b\xfe\x00\x00\x1e\xff\x00\x00\x60\xff\x5f\xff\x00\x00\x00\x00\x32\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5a\xff\x00\x00\x00\x00\x00\x00\x00\x00\x4f\xfe\x6c\xff\x00\x00\x64\xff\xd2\xfe\xeb\xfe\x00\x00\x3a\xff\x00\x00\xf6\xfe\xf3\xfe\xec\xfe\x00\x00\x00\x00\x00\x00\x63\xff\x4e\xfe\x00\x00\x37\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\xfe\x00\x00\x3f\xff\x39\xff\xa3\xfe\x00\x00\x19\xff\x3d\xff\x4e\xfe\xd8\xfe\x00\x00\x00\x00\xd9\xfe\xd4\xfe\x4e\xfe\x00\x00\x00\x00\x0b\xff\x00\x00\x00\x00\x4e\xfe\x00\x00\x00\x00\x0d\xff\x4f\xff\x46\xff\x38\xff\x00\x00\x00\x00\x00\x00\x00\x00\xf7\xff\xf5\xff\xf4\xff\xf3\xff\xf2\xff\xf1\xff\xef\xff\xee\xff\xed\xff\xca\xff\xec\xff\xeb\xff\xea\xff\xe9\xff\xe8\xff\xe7\xff\xe6\xff\xe5\xff\xde\xff\xe4\xff\xe3\xff\xe2\xff\xe1\xff\xe0\xff\xdf\xff\xdd\xff\xdc\xff\xdb\xff\xda\xff\xd9\xff\xd8\xff\xd7\xff\xd6\xff\xd5\xff\xd4\xff\xd3\xff\xd2\xff\xd1\xff\xd0\xff\xcf\xff\xce\xff\xcd\xff\xcc\xff\xcb\xff\xc9\xff\xf0\xff\xc8\xff\xc7\xff\xc6\xff\xc4\xff\xc3\xff\xc2\xff\xc5\xff\xc1\xff\xc0\xff\xbf\xff\xbd\xff\xbe\xff\xbb\xff\xbc\xff\xba\xff\xb9\xff\xb8\xff\xb7\xff\xb6\xff\xb1\xff\xb2\xff\xb5\xff\xb4\xff\xb3\xff\xb0\xff\xaf\xff\xae\xff\xad\xff\xac\xff\xab\xff\xaa\xff\xa9\xff\xa8\xff\xa7\xff\xa6\xff\xa5\xff\xa4\xff\xa3\xff\xa2\xff\xa1\xff\xa0\xff\x9f\xff\x9e\xff\x9d\xff\x9c\xff\x9b\xff\x9a\xff\x99\xff\x98\xff\x97\xff\x96\xff\x95\xff\x94\xff\x93\xff\x92\xff\x91\xff\x90\xff\x8f\xff\x25\xff\x00\x00\x4c\xff\x4e\xff\x00\x00\x5f\xff\x40\xff\x00\x00\x5a\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\xff\x00\x00\x00\x00\x00\x00\x5a\xff\xdb\xfe\xdc\xfe\x43\xff\xda\xfe\x00\x00\x42\xff\x00\x00\x66\xff\x4a\xfe\x00\x00\x18\xff\x17\xff\x14\xff\x15\xff\x12\xff\xa1\xfe\xc0\xfe\x00\x00\xc4\xfe\xa2\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe5\xfe\x00\x00\x40\xff\xdf\xfe\x00\x00\x00\x00\x37\xff\xe9\xfe\x00\x00\xe8\xfe\xea\xfe\xd2\xfe\x00\x00\x00\x00\xd2\xfe\x00\x00\x00\x00\x37\xff\xf2\xfe\xee\xfe\xf3\xfe\x4e\xfe\x00\x00\x00\x00\xf7\xfe\x45\xff\xed\xfe\xd1\xfe\x00\x00\x4a\xfe\x3d\xff\xfd\xfe\x02\xff\x03\xff\x00\x00\x00\x00\x29\xff\x00\xff\x01\xff\x00\x00\xfe\xfe\xff\xfe\x00\x00\x00\x00\x00\x00\x9e\xfe\x49\xff\x7d\xfe\x7c\xfe\x7f\xfe\x1c\xff\x81\xff\x2a\xff\x35\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x59\xff\x00\x00\x00\x00\x00\x00\x57\xff\x00\x00\x00\x00\x83\xff\x00\x00\x00\x00\x00\x00\x00\x00\xd5\xfe\xf2\xfd\x6b\xfe\x00\x00\x67\xfe\x0c\xfe\x00\x00\x68\xfe\x61\xfe\x00\x00\x6d\xfe\xd5\xfe\xd5\xfe\x42\xfe\x69\xfe\x6a\xfe\x00\x00\x86\xff\x00\x00\x00\x00\x6e\xfe\x02\xfe\x6f\xfe\xd5\xfe\x6c\xfe\x8e\xff\x8c\xff\x00\x00\x4e\xfe\x89\xff\xf0\xfd\x9d\xfe\x00\x00\x00\x00\x00\x00\x00\x00\xf1\xfd\x4a\xfe\xd5\xfe\x00\x00\xd5\xfe\x00\x00\x00\x00\x03\xfe\x00\x00\x00\x00\x6b\xff\x61\xff\x72\xfe\x71\xfe\x70\xfe\x00\x00\x00\x00\xd5\xfe\x60\xfe\x00\x00\x0d\xfe\x00\x00\x09\xfe\x00\x00\x8a\xff\x8b\xff\xf3\xfd\x00\x00\x12\xff\x00\x00\x5d\xfe\x5b\xfe\x56\xfe\x00\x00\x00\x00\x00\x00\x50\xfe\x66\xfe\x00\x00\x00\x00\x84\xff\x1a\xfe\x00\x00\x51\xff\x50\xff\x00\x00\x57\xff\x00\x00\x00\x00\x10\xfe\x52\xff\x00\x00\x59\xff\x19\xfe\x1b\xfe\x14\xfe\x15\xfe\x1c\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x16\xfe\x00\x00\x55\xff\x00\x00\x59\xff\x17\xfe\x00\x00\x00\x00\x7e\xfe\x00\x00\x5e\xff\x5c\xff\xfb\xfe\x5d\xff\x5b\xff\x00\x00\xf9\xfe\xfc\xfe\x4a\xfe\xbc\xfe\x00\x00\xd3\xfe\xf0\xfe\xef\xfe\xf1\xfe\xf5\xfe\xf4\xfe\xe5\xfe\xe3\xfe\xe2\xfe\xdd\xfe\x00\x00\x00\x00\x00\x00\xcf\xfe\x00\x00\x00\x00\xd0\xfe\xe4\xfe\x00\x00\x37\xff\x3c\xff\x88\xff\x37\xff\x36\xff\x00\x00\x09\xff\x07\xff\x08\xff\x06\xff\x04\xff\x05\xff\x00\x00\xc3\xfe\x41\xff\xc1\xfe\x00\x00\x00\x00\x00\x00\x11\xff\x10\xff\x00\x00\x22\xff\xbc\xfe\x00\x00\x3e\xff\xf4\xfd\xce\xfe\x00\x00\x5a\xff\xca\xfe\x00\x00\xcc\xfe\x60\xff\x4d\xff\xcb\xfe\xc9\xfe\xcd\xfe\x0e\xff\x13\xff\xbe\xfe\xbc\xfe\xba\xfe\xb9\xfe\xb8\xfe\x00\x00\xbb\xfe\x00\x00\x00\x00\x16\xff\x00\x00\x21\xff\x37\xff\xc2\xfe\xe7\xfe\xe0\xfe\xe1\xfe\x00\x00\xc7\xfe\xc8\xfe\xc5\xfe\xc6\xfe\x3b\xff\x37\xff\x20\xff\x4c\xfe\x49\xfe\xf8\xfe\xfa\xfe\x00\x00\x00\x00\x00\x00\x1d\xfe\x00\x00\x55\xff\x55\xff\x59\xff\x1f\xfe\x21\xfe\x20\xfe\x18\xfe\x58\xff\x28\xfe\x00\x00\x00\x00\x11\xfe\x56\xff\x25\xfe\x22\xfe\x64\xfe\x65\xfe\x00\x00\x53\xfe\x00\x00\x00\x00\x53\xfe\x00\x00\x5c\xfe\x00\x00\x66\xff\x00\x00\x00\x00\x0b\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\xff\x00\x00\x80\xfe\x6b\xff\x05\xfe\x6b\xff\x7e\xff\x7a\xff\x6d\xff\x6a\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd7\xfe\x00\x00\x00\x00\xd6\xfe\xbc\xfe\x9c\xfe\x9b\xfe\x4d\xfe\x78\xfe\x79\xfe\x82\xfe\x7c\xff\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xff\x00\x00\x00\x00\x80\xff\x00\x00\x00\x00\x7b\xff\x04\xfe\x06\xfe\x00\x00\x00\x00\x43\xfe\x4a\xfe\xbc\xfe\x44\xfe\x00\x00\x62\xfe\x83\xfe\x0a\xfe\x75\xfe\x76\xfe\xfe\xfd\x63\xfe\x5f\xfe\x00\x00\x00\x00\x00\x00\x59\xfe\x00\x00\x00\x00\x00\x00\x5a\xfe\x12\xfe\x0f\xfe\x13\xfe\x0e\xfe\x00\x00\x54\xff\x00\x00\x24\xfe\x1e\xfe\x26\xfe\x27\xfe\xbc\xfe\xde\xfe\xe6\xfe\x00\x00\x0f\xff\xa8\xfe\x87\xff\xa8\xfe\xbd\xfe\xaa\xfe\xa6\xfe\x00\x00\xa7\xfe\x00\x00\x00\x00\x00\x00\xb2\xfe\x00\x00\x87\xff\xb4\xfe\x00\x00\xbf\xfe\x4b\xfe\x55\xff\x23\xfe\x00\x00\x53\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5e\xfe\xfb\xfd\x00\x00\xfc\xfd\xf9\xfd\xfa\xfd\x00\x00\xf5\xfd\x00\x00\xf8\xfd\xf6\xfd\x00\x00\xf7\xfd\x00\x00\xbc\xfe\x46\xfe\x47\xfe\x00\x00\x81\xfe\x08\xfe\x6b\xff\x00\x00\x00\x00\x00\x00\x00\x00\x78\xff\x76\xff\x7d\xff\x00\x00\x7a\xfe\x77\xff\x79\xff\x72\xff\x74\xff\x6e\xff\x70\xff\x07\xfe\x20\xff\x45\xfe\x77\xfe\x00\x00\x74\xfe\xff\xfd\x01\xfe\x4e\xfe\x00\x00\x00\x00\x57\xfe\x52\xfe\x51\xfe\x58\xfe\x53\xff\xb7\xfe\x00\x00\x00\x00\x87\xff\xb5\xfe\xac\xfe\xa9\xfe\xb6\xfe\x00\x00\xa5\xfe\xb3\xfe\xb0\xfe\xb1\xfe\x00\x00\x00\x00\x00\x00\xab\xfe\x54\xfe\x55\xfe\xfd\xfd\x00\x00\x00\x00\x48\xfe\x71\xff\x6f\xff\x75\xff\x73\xff\x00\x00\x00\xfe\x00\x00\x00\x00\x00\x00\xaf\xfe\xae\xfe\xad\xfe\x73\xfe"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x05\x00\x05\x00\x09\x00\x09\x00\x09\x00\x09\x00\x0a\x00\x0f\x00\x5f\x00\x11\x00\x15\x00\x10\x00\x15\x00\x12\x00\x13\x00\x09\x00\x09\x00\x0f\x00\x15\x00\x11\x00\x0c\x00\x54\x00\x00\x00\x09\x00\x00\x00\x13\x00\x2c\x00\x4f\x00\x21\x00\x22\x00\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x2c\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x43\x00\x23\x00\x24\x00\x09\x00\x26\x00\x09\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x09\x00\x52\x00\x13\x00\x14\x00\x13\x00\x09\x00\x32\x00\x33\x00\x68\x00\x4e\x00\x13\x00\x14\x00\x31\x00\x32\x00\x33\x00\x13\x00\x14\x00\x09\x00\x0a\x00\x40\x00\x41\x00\x42\x00\x5f\x00\x44\x00\x66\x00\x0e\x00\x0f\x00\x10\x00\x2b\x00\x56\x00\x58\x00\x09\x00\x5a\x00\x57\x00\x0f\x00\x5b\x00\x11\x00\x2c\x00\x64\x00\x62\x00\x60\x00\x13\x00\x61\x00\x63\x00\x57\x00\x65\x00\x66\x00\x67\x00\x68\x00\x62\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x60\x00\x68\x00\x60\x00\x7e\x00\x7f\x00\x4f\x00\x64\x00\x82\x00\x83\x00\x09\x00\x5f\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x09\x00\x84\x00\x61\x00\xa5\x00\x98\x00\xa3\x00\x09\x00\x10\x00\x64\x00\x12\x00\x13\x00\x09\x00\x84\x00\x55\x00\x62\x00\xa7\x00\xaf\x00\x81\x00\x15\x00\x00\x00\x5f\x00\x13\x00\x81\x00\x2c\x00\x21\x00\x22\x00\x23\x00\x24\x00\x50\x00\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x0a\x00\x23\x00\x24\x00\x09\x00\x26\x00\x13\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x80\x00\x64\x00\x13\x00\x09\x00\x09\x00\x58\x00\x59\x00\x5a\x00\x4f\x00\x1e\x00\x4e\x00\x64\x00\x65\x00\x22\x00\x13\x00\x15\x00\x53\x00\x2a\x00\x2b\x00\x40\x00\x41\x00\x42\x00\x2b\x00\x44\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x07\x00\x64\x00\x0b\x00\x09\x00\x0f\x00\x64\x00\x11\x00\x5b\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x60\x00\x13\x00\x0f\x00\x63\x00\x11\x00\x65\x00\x66\x00\x67\x00\x68\x00\x4d\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x60\x00\x60\x00\x61\x00\x7e\x00\x7f\x00\x09\x00\x52\x00\x82\x00\x83\x00\x55\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x09\x00\x07\x00\x54\x00\x55\x00\x98\x00\x57\x00\x09\x00\x10\x00\x80\x00\x12\x00\x13\x00\x09\x00\x62\x00\x09\x00\x4b\x00\x4c\x00\xaf\x00\xb0\x00\x15\x00\x63\x00\x80\x00\x13\x00\x66\x00\x13\x00\x21\x00\x22\x00\x23\x00\x24\x00\x5f\x00\x26\x00\x27\x00\x15\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x50\x00\x23\x00\x24\x00\x64\x00\x26\x00\x64\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x80\x00\x58\x00\x59\x00\x5a\x00\x09\x00\x37\x00\x50\x00\x4e\x00\x09\x00\x64\x00\x65\x00\x5f\x00\x3e\x00\x4d\x00\x13\x00\x09\x00\x09\x00\x67\x00\x13\x00\x40\x00\x41\x00\x42\x00\x48\x00\x5e\x00\x4a\x00\x13\x00\x64\x00\x65\x00\x15\x00\x16\x00\x5e\x00\x54\x00\x55\x00\x61\x00\x57\x00\x5b\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x60\x00\x2a\x00\x2b\x00\x63\x00\x5f\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x64\x00\x65\x00\x4f\x00\x09\x00\x4f\x00\x64\x00\x77\x00\x7e\x00\x7f\x00\x54\x00\x57\x00\x82\x00\x83\x00\x13\x00\x14\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x5c\x00\x50\x00\x5e\x00\x4d\x00\x98\x00\x11\x00\x12\x00\x4d\x00\x09\x00\x4e\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\x4e\x00\x10\x00\xaf\x00\x12\x00\x13\x00\x09\x00\x80\x00\x64\x00\x65\x00\x61\x00\x09\x00\x5e\x00\x78\x00\x61\x00\x5c\x00\x13\x00\x5e\x00\x7d\x00\x21\x00\x22\x00\x23\x00\x24\x00\x15\x00\x26\x00\x27\x00\x4d\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x4e\x00\x23\x00\x24\x00\x50\x00\x26\x00\x50\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x09\x00\x5f\x00\x50\x00\x5c\x00\x61\x00\x5e\x00\x57\x00\x4e\x00\x4b\x00\x4c\x00\x13\x00\x14\x00\x64\x00\x5f\x00\x64\x00\x37\x00\x23\x00\x54\x00\x5f\x00\x40\x00\x41\x00\x42\x00\x64\x00\x5e\x00\x5b\x00\x64\x00\x5d\x00\x2e\x00\x5e\x00\x45\x00\x46\x00\x09\x00\x48\x00\x64\x00\x4a\x00\x5b\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x60\x00\x13\x00\x33\x00\x63\x00\x5e\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x5b\x00\x62\x00\x5d\x00\x7e\x00\x7f\x00\x66\x00\x1b\x00\x82\x00\x83\x00\x64\x00\x1f\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x09\x00\x4f\x00\x4f\x00\x4e\x00\x98\x00\x5e\x00\x56\x00\x10\x00\x5e\x00\x12\x00\x13\x00\xaa\x00\xab\x00\xac\x00\x4f\x00\x5c\x00\xaf\x00\x5e\x00\x09\x00\x59\x00\x64\x00\x65\x00\x4e\x00\x67\x00\x21\x00\x22\x00\x23\x00\x24\x00\x13\x00\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x09\x00\x09\x00\x10\x00\x57\x00\x0c\x00\x13\x00\x0e\x00\x57\x00\x23\x00\x24\x00\x13\x00\x26\x00\x57\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x5f\x00\x21\x00\x22\x00\x23\x00\x24\x00\x54\x00\x26\x00\x27\x00\x52\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x5f\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x56\x00\x40\x00\x41\x00\x42\x00\x09\x00\x5b\x00\x09\x00\x5d\x00\x5d\x00\x0c\x00\x5b\x00\x0e\x00\x0c\x00\x10\x00\x64\x00\x60\x00\x15\x00\x16\x00\x63\x00\x5e\x00\x65\x00\x66\x00\x67\x00\x68\x00\x52\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x5b\x00\x09\x00\x5d\x00\x5b\x00\x4e\x00\x4f\x00\x52\x00\x7e\x00\x7f\x00\x64\x00\x57\x00\x82\x00\x83\x00\x15\x00\x16\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x09\x00\x09\x00\x4f\x00\x4b\x00\x4c\x00\x09\x00\x5e\x00\x10\x00\x50\x00\x12\x00\x13\x00\x98\x00\x09\x00\x15\x00\x56\x00\x4d\x00\xaf\x00\x15\x00\x16\x00\x5b\x00\x64\x00\x5d\x00\x13\x00\x14\x00\x21\x00\x22\x00\x23\x00\x24\x00\x64\x00\x26\x00\x27\x00\x50\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x09\x00\x56\x00\x09\x00\x4b\x00\x4c\x00\x2c\x00\x5b\x00\x10\x00\x5d\x00\x12\x00\x13\x00\x37\x00\x13\x00\x14\x00\x56\x00\x64\x00\x19\x00\x56\x00\x3e\x00\x5b\x00\x09\x00\x5d\x00\x5b\x00\x0c\x00\x5d\x00\x0e\x00\x23\x00\x24\x00\x48\x00\x26\x00\x4a\x00\x56\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x5b\x00\x09\x00\x5d\x00\x2e\x00\x2f\x00\x30\x00\x64\x00\x65\x00\x33\x00\x09\x00\x5b\x00\x13\x00\x14\x00\x3a\x00\x3b\x00\x60\x00\x10\x00\x5e\x00\x63\x00\x13\x00\x65\x00\x66\x00\x67\x00\x68\x00\x57\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x5e\x00\x27\x00\x57\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x7e\x00\x7f\x00\x52\x00\x09\x00\x82\x00\x83\x00\x0c\x00\x0d\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x09\x00\x52\x00\x09\x00\x7e\x00\x7f\x00\x0c\x00\x0d\x00\x10\x00\x30\x00\x12\x00\x13\x00\x52\x00\x4b\x00\x4c\x00\x17\x00\x18\x00\xaf\x00\x50\x00\x09\x00\x52\x00\x52\x00\x0c\x00\x0d\x00\x56\x00\x4b\x00\x4c\x00\x23\x00\x24\x00\x5b\x00\x26\x00\x5d\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x09\x00\x64\x00\x7a\x00\x7b\x00\x5b\x00\x7d\x00\x5d\x00\x10\x00\x52\x00\x12\x00\x13\x00\x38\x00\x39\x00\x64\x00\x11\x00\x12\x00\x19\x00\x64\x00\x65\x00\x40\x00\x41\x00\x54\x00\x43\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x52\x00\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x09\x00\x4e\x00\x10\x00\x09\x00\x12\x00\x13\x00\x4e\x00\x34\x00\x35\x00\x36\x00\x37\x00\x19\x00\x15\x00\x3a\x00\x3b\x00\x15\x00\x79\x00\x7a\x00\x7b\x00\x4f\x00\x7d\x00\x23\x00\x24\x00\x63\x00\x26\x00\x09\x00\x56\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x5b\x00\x10\x00\x5d\x00\x12\x00\x13\x00\x11\x00\x12\x00\x00\x00\x01\x00\x64\x00\x19\x00\x63\x00\x09\x00\x3a\x00\x3b\x00\x37\x00\x36\x00\x37\x00\x37\x00\x66\x00\x23\x00\x24\x00\x3e\x00\x26\x00\x15\x00\x50\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x63\x00\x56\x00\x48\x00\x46\x00\x4a\x00\x48\x00\x5b\x00\x4a\x00\x5d\x00\x09\x00\x98\x00\xad\x00\xae\x00\x3a\x00\x3b\x00\x64\x00\xad\x00\xae\x00\x66\x00\x13\x00\x7e\x00\x7f\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x37\x00\x66\x00\x09\x00\xa1\x00\xa2\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x10\x00\x66\x00\x12\x00\x13\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x48\x00\x63\x00\x4a\x00\xad\x00\xae\x00\x66\x00\x7e\x00\x7f\x00\x66\x00\x21\x00\x22\x00\x23\x00\x24\x00\x63\x00\x26\x00\x27\x00\x63\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x63\x00\x09\x00\x66\x00\x00\x00\x01\x00\xad\x00\xae\x00\x04\x00\x05\x00\x67\x00\x07\x00\x08\x00\x09\x00\x15\x00\x0b\x00\x7e\x00\x7f\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x66\x00\x13\x00\x14\x00\x15\x00\x16\x00\x66\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x66\x00\x1f\x00\x20\x00\x21\x00\x09\x00\x0a\x00\x24\x00\x25\x00\x26\x00\x66\x00\x28\x00\x29\x00\x2a\x00\x5b\x00\x37\x00\x2d\x00\x63\x00\x09\x00\x4b\x00\x4c\x00\x0c\x00\x63\x00\x0e\x00\x09\x00\xad\x00\xae\x00\x0c\x00\x54\x00\x0e\x00\x46\x00\x64\x00\x48\x00\x09\x00\x4a\x00\x5b\x00\x0c\x00\x5d\x00\x0e\x00\xad\x00\xae\x00\x46\x00\x47\x00\x4f\x00\x64\x00\x4a\x00\x4b\x00\x4c\x00\x4f\x00\xad\x00\xae\x00\x50\x00\x51\x00\x09\x00\x53\x00\x54\x00\x0c\x00\x56\x00\x0e\x00\x58\x00\x09\x00\x5a\x00\x5b\x00\x0c\x00\x5d\x00\x0e\x00\x64\x00\x60\x00\x5f\x00\x62\x00\x2c\x00\x64\x00\x65\x00\x09\x00\x67\x00\x00\x00\x01\x00\x09\x00\x0a\x00\x2c\x00\x05\x00\x4e\x00\x07\x00\x08\x00\x09\x00\x15\x00\x0b\x00\x09\x00\x0a\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x5f\x00\x13\x00\x14\x00\x15\x00\x16\x00\x2c\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x4e\x00\x1f\x00\x20\x00\x21\x00\xad\x00\xae\x00\x24\x00\x25\x00\x26\x00\x53\x00\x28\x00\x29\x00\x2a\x00\x4f\x00\x37\x00\x2d\x00\xad\x00\xae\x00\x4b\x00\x4c\x00\x66\x00\x3e\x00\x66\x00\x50\x00\x63\x00\x52\x00\x05\x00\x06\x00\x63\x00\x56\x00\x63\x00\x48\x00\x63\x00\x4a\x00\x5b\x00\x5e\x00\x5d\x00\x05\x00\x06\x00\x67\x00\x46\x00\x47\x00\x5f\x00\x64\x00\x4a\x00\x4b\x00\x4c\x00\x7c\x00\x7d\x00\x63\x00\x50\x00\x51\x00\x63\x00\x53\x00\x54\x00\x09\x00\x56\x00\x63\x00\x58\x00\x63\x00\x5a\x00\x5b\x00\x52\x00\x5d\x00\x7c\x00\x7d\x00\x60\x00\x15\x00\x62\x00\x09\x00\x64\x00\x65\x00\x01\x00\x67\x00\x05\x00\x06\x00\x05\x00\x66\x00\x07\x00\x08\x00\x09\x00\x15\x00\xad\x00\xae\x00\x63\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x66\x00\x13\x00\x14\x00\x15\x00\x16\x00\x66\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x37\x00\x1f\x00\x20\x00\x21\x00\xad\x00\xae\x00\x24\x00\x25\x00\x26\x00\x4f\x00\x28\x00\x29\x00\x2a\x00\x4d\x00\x37\x00\x2d\x00\x47\x00\x48\x00\x5e\x00\x4a\x00\x57\x00\x3e\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\xad\x00\xae\x00\x57\x00\x48\x00\x56\x00\x4a\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x46\x00\x47\x00\x09\x00\x0a\x00\x4a\x00\x4b\x00\x4c\x00\x09\x00\x0a\x00\x56\x00\x50\x00\x51\x00\x56\x00\x53\x00\x54\x00\x64\x00\x56\x00\x63\x00\x58\x00\x63\x00\x5a\x00\x5b\x00\x4f\x00\x5d\x00\x09\x00\x0a\x00\x60\x00\x66\x00\x62\x00\x5e\x00\x64\x00\x65\x00\x63\x00\x67\x00\x68\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x01\x00\x63\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x09\x00\x63\x00\x0b\x00\x2c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x5c\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x4f\x00\x1f\x00\x20\x00\x21\x00\x09\x00\x0a\x00\x24\x00\x25\x00\x26\x00\x5f\x00\x28\x00\x29\x00\x2a\x00\x4b\x00\x4c\x00\x2d\x00\x05\x00\x06\x00\x50\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x56\x00\x7c\x00\x7d\x00\x7c\x00\x7d\x00\x5b\x00\x64\x00\x5d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x64\x00\x64\x00\x46\x00\x47\x00\x05\x00\x06\x00\x4a\x00\x4b\x00\x4c\x00\x05\x00\x06\x00\x4e\x00\x50\x00\x51\x00\x4f\x00\x53\x00\x54\x00\x09\x00\x56\x00\x5f\x00\x58\x00\x5f\x00\x5a\x00\x5b\x00\x2c\x00\x5d\x00\xad\x00\xae\x00\x5e\x00\x15\x00\x62\x00\x09\x00\x64\x00\x65\x00\x01\x00\x67\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x09\x00\x15\x00\xad\x00\xae\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x64\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x37\x00\x1f\x00\x20\x00\x21\x00\x2c\x00\x64\x00\x24\x00\x25\x00\x26\x00\x52\x00\x28\x00\x29\x00\x2a\x00\x52\x00\x37\x00\x2d\x00\x47\x00\x48\x00\x63\x00\x4a\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x52\x00\x63\x00\x52\x00\x4d\x00\x47\x00\x48\x00\x64\x00\x4a\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x46\x00\x47\x00\x57\x00\x4d\x00\x4a\x00\x4b\x00\x4c\x00\x27\x00\x57\x00\x57\x00\x50\x00\x51\x00\x5e\x00\x53\x00\x54\x00\x09\x00\x56\x00\x64\x00\x58\x00\x5c\x00\x5a\x00\x5b\x00\x5e\x00\x5d\x00\x64\x00\x64\x00\x5f\x00\x15\x00\x62\x00\x09\x00\x64\x00\x65\x00\x01\x00\x67\x00\x5f\x00\x5e\x00\x05\x00\x5f\x00\x07\x00\x08\x00\x09\x00\x15\x00\x0b\x00\x57\x00\x57\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x64\x00\x13\x00\x14\x00\x15\x00\x16\x00\x15\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x37\x00\x1f\x00\x20\x00\x21\x00\x67\x00\x64\x00\x24\x00\x25\x00\x26\x00\x03\x00\x28\x00\x29\x00\x2a\x00\x01\x00\x37\x00\x2d\x00\x47\x00\x48\x00\x02\x00\x4a\x00\xad\x00\x5c\x00\x64\x00\x06\x00\x5e\x00\x04\x00\x0b\x00\x09\x00\xa6\x00\x09\x00\x47\x00\x48\x00\x08\x00\x4a\x00\xa6\x00\x08\x00\x08\x00\x5e\x00\x09\x00\x64\x00\x46\x00\x47\x00\x0b\x00\x0b\x00\x4a\x00\x4b\x00\x4c\x00\xad\x00\x49\x00\x5c\x00\x50\x00\x51\x00\x5c\x00\x53\x00\x54\x00\x09\x00\x56\x00\x05\x00\x58\x00\x25\x00\x5a\x00\x5b\x00\x0b\x00\x5d\x00\x4d\x00\x06\x00\x05\x00\x15\x00\x62\x00\x09\x00\x64\x00\x65\x00\x01\x00\x67\x00\x0b\x00\x0b\x00\x05\x00\x49\x00\x07\x00\x08\x00\x09\x00\x15\x00\x06\x00\x06\x00\x49\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x5e\x00\x13\x00\x14\x00\x15\x00\x16\x00\x25\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x37\x00\x1f\x00\x20\x00\x21\x00\x1e\x00\xa4\x00\x24\x00\x25\x00\x26\x00\x1e\x00\x28\x00\x29\x00\x2a\x00\x1e\x00\x37\x00\x2d\x00\x47\x00\x48\x00\x1e\x00\x4a\x00\x1d\x00\x1a\x00\x1d\x00\x09\x00\x1e\x00\x1b\x00\x1e\x00\x9f\x00\x1a\x00\x1e\x00\x47\x00\x48\x00\x1c\x00\x4a\x00\x1a\x00\x1e\x00\x1e\x00\x0b\x00\x0b\x00\x0b\x00\x46\x00\x47\x00\x0b\x00\x1c\x00\x4a\x00\x4b\x00\x4c\x00\x1c\x00\x1a\x00\xa0\x00\x50\x00\x51\x00\xa8\x00\x53\x00\x54\x00\x08\x00\x56\x00\x7d\x00\x58\x00\x7d\x00\x5a\x00\x5b\x00\x09\x00\x5d\x00\x09\x00\x09\x00\x13\x00\x09\x00\x62\x00\x09\x00\x64\x00\x65\x00\x13\x00\x67\x00\x09\x00\x0b\x00\x1d\x00\x7d\x00\x1f\x00\x20\x00\x21\x00\x10\x00\x23\x00\x24\x00\x13\x00\x26\x00\x09\x00\x28\x00\x17\x00\x18\x00\x09\x00\x07\x00\x2d\x00\x2e\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x1c\x00\x05\x00\x23\x00\x24\x00\x7d\x00\x26\x00\x27\x00\x7d\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x09\x00\x7d\x00\x7d\x00\x09\x00\xa8\x00\x09\x00\x0b\x00\x46\x00\x47\x00\x0b\x00\x13\x00\x4a\x00\x4b\x00\x4c\x00\x0b\x00\x05\x00\x09\x00\x50\x00\x51\x00\x08\x00\x53\x00\x54\x00\x08\x00\x56\x00\x08\x00\x58\x00\x13\x00\x5a\x00\x5b\x00\x09\x00\x5d\x00\x08\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x05\x00\x64\x00\x65\x00\x09\x00\x67\x00\x09\x00\x13\x00\x09\x00\x09\x00\xff\xff\x27\x00\x18\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x1d\x00\x13\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x18\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\x57\x00\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\x09\x00\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\x09\x00\xff\xff\x1d\x00\x13\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x18\x00\x24\x00\x13\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\xff\xff\x13\x00\x09\x00\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\x09\x00\xff\xff\x1d\x00\x13\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x18\x00\x24\x00\x13\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x08\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x13\x00\x09\x00\xff\xff\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x13\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x18\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\x57\x00\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\x09\x00\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\x13\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x18\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\xff\xff\x13\x00\x09\x00\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\x13\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x18\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\x5e\x00\xff\xff\x13\x00\x09\x00\x62\x00\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\x13\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x18\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x08\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x13\x00\x09\x00\xff\xff\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x13\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x18\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\x57\x00\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\x09\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\x13\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\x21\x00\x22\x00\x23\x00\x24\x00\x2d\x00\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\x09\x00\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\x13\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\x09\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x10\x00\xff\xff\x24\x00\x13\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x19\x00\xff\xff\x2d\x00\xff\xff\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x56\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\x64\x00\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\xff\xff\x13\x00\x09\x00\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\x10\x00\xff\xff\x1d\x00\x13\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x18\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x08\x00\x55\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x09\x00\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\x10\x00\xff\xff\xff\xff\x13\x00\x2d\x00\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\x5e\x00\xff\xff\x13\x00\x09\x00\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\x10\x00\xff\xff\x1d\x00\x13\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x18\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\x57\x00\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\x09\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x10\x00\xff\xff\x24\x00\x13\x00\x26\x00\xff\xff\x28\x00\xff\xff\x18\x00\x19\x00\xff\xff\x2d\x00\xff\xff\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\x56\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\x64\x00\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\x5e\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\x09\x00\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\x13\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\x57\x00\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\x09\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\x13\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\x22\x00\x23\x00\x24\x00\x2d\x00\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\x09\x00\x5d\x00\x5e\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\x13\x00\x67\x00\x09\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x10\x00\xff\xff\x24\x00\x13\x00\x26\x00\xff\xff\x28\x00\x23\x00\x24\x00\x19\x00\x26\x00\x2d\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\x57\x00\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\x09\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\x13\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x23\x00\x24\x00\x2d\x00\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\x5e\x00\x08\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\x09\x00\x67\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x13\x00\xff\xff\x09\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\x13\x00\x26\x00\xff\xff\x28\x00\x23\x00\x24\x00\xff\xff\x26\x00\x2d\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\x2d\x00\x50\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\x5e\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\x2d\x00\x50\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\x2d\x00\x50\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\x2d\x00\x50\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x08\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x08\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\x62\x00\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x08\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\x62\x00\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x08\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\x62\x00\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x08\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\x62\x00\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x54\x00\x08\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x08\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x08\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x08\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x08\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\x08\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\x53\x00\xff\xff\x09\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\x10\x00\x5d\x00\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\x5f\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\x54\x00\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\x09\x00\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x64\x00\x65\x00\x24\x00\x67\x00\x13\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\x3a\x00\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\x09\x00\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x64\x00\x65\x00\x24\x00\x67\x00\x13\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\x3a\x00\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x64\x00\x65\x00\x24\x00\x67\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x64\x00\x65\x00\x24\x00\x67\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x64\x00\x65\x00\x24\x00\x67\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x64\x00\x65\x00\x24\x00\x67\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x64\x00\x65\x00\x24\x00\x67\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x64\x00\x65\x00\x24\x00\x67\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x64\x00\x65\x00\x24\x00\x67\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x64\x00\x65\x00\x24\x00\x67\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x46\x00\x47\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\x09\x00\x56\x00\xff\xff\x58\x00\xff\xff\x5a\x00\x5b\x00\x10\x00\x5d\x00\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x65\x00\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4b\x00\x4c\x00\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x19\x00\xff\xff\xff\xff\x4b\x00\x4c\x00\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x19\x00\xff\xff\x3a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\x09\x00\x3a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\x09\x00\xff\xff\x0b\x00\xff\xff\x31\x00\x32\x00\x33\x00\x10\x00\xff\xff\x12\x00\x13\x00\x38\x00\x39\x00\xff\xff\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\x38\x00\x39\x00\xff\xff\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x09\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x09\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x09\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x09\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x09\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\x38\x00\x39\x00\xff\xff\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x10\x00\xff\xff\x12\x00\x13\x00\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\xff\xff\x29\x00\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x36\x00\x37\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\x1b\x02\x15\x02\x28\x03\x7e\x03\x09\x00\xd8\x01\x16\x02\x06\x02\x4a\x00\x07\x02\x2d\x03\x0a\x00\x50\x00\x3b\x00\x0c\x00\x09\x00\x78\x02\x06\x02\x32\x03\x07\x02\x78\x01\xf4\x00\x1a\x02\x78\x02\x1a\x02\x0c\x00\xe6\x02\xf2\x00\x3c\x00\x0f\x00\x10\x00\x11\x00\xfd\x01\x12\x00\x3d\x00\x51\x00\x14\x00\x15\x00\x16\x00\x17\x00\x46\x02\x5a\x02\x11\x00\x45\x00\x12\x00\x45\x00\x8c\x01\x14\x00\x15\x00\x16\x00\x8d\x01\x45\x00\xed\x00\x46\x00\xe8\x01\x0c\x00\x45\x00\x23\x03\x7b\x02\xff\xff\xe7\x02\x46\x00\x00\x03\x79\x02\x7a\x02\x7b\x02\x46\x00\x00\x03\xd8\x01\x16\x02\x5b\x02\x5c\x02\x5d\x02\xde\x00\x5e\x02\x47\x02\x81\x03\x82\x03\x83\x03\xbd\x00\x7f\x03\x29\x03\x09\x00\x7c\x03\x33\x03\x06\x02\x3e\x00\x07\x02\xd3\x02\x39\x00\xfc\x02\x51\x00\x0c\x00\x17\x02\x52\x00\x51\x02\x53\x00\x54\x00\x55\x00\x56\x00\x08\x02\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x14\x00\x15\x00\x16\x00\x51\x02\x1b\x02\xff\xff\x1b\x02\x64\x00\x65\x00\xd4\x02\x39\x00\x66\x00\x67\x00\x28\x03\xd7\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x09\x00\xfe\x01\x06\x03\xfd\x02\x91\x01\x18\x02\xbf\x00\x0a\x00\x39\x00\x3b\x00\x0c\x00\x09\x00\xe9\x01\xa7\x00\xfb\x02\x09\x02\x75\x01\x01\x03\x99\x01\x1a\x02\xe1\x01\x0c\x00\x4d\x03\xcc\x02\x3c\x00\x0f\x00\x10\x00\x11\x00\xeb\x01\x12\x00\x3d\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x95\x02\x5a\x02\x11\x00\x09\x00\x12\x00\x0c\x00\x8c\x01\x14\x00\x15\x00\x16\x00\x8d\x01\x7e\x02\x39\x00\x0c\x00\xbf\x00\x09\x00\x29\x03\x33\x03\x2b\x03\xdc\x01\x96\x02\xcd\x02\x39\x00\x3a\x00\x97\x02\x0c\x00\x96\x01\xc5\x02\xda\x00\x16\x00\x5b\x02\x5c\x02\x5d\x02\x98\x02\x22\x03\x14\x00\x15\x00\x16\x00\x51\x02\x2d\x03\x39\x00\xf9\x01\x09\x00\x06\x02\x26\x02\x07\x02\x3e\x00\x14\x00\x15\x00\x16\x00\x51\x02\x51\x00\x0c\x00\xd6\x02\x52\x00\x07\x02\x53\x00\x54\x00\x55\x00\x56\x00\xfb\x01\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x14\x00\x15\x00\x16\x00\x51\x02\xf8\x01\x1b\x02\x6a\x02\x64\x00\x65\x00\x28\x03\xf1\x00\x66\x00\x67\x00\xa7\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x09\x00\x2d\x03\x2e\x03\x2f\x03\x91\x01\x30\x03\xbf\x00\x0a\x00\x52\x02\x3b\x00\x0c\x00\x09\x00\x63\x03\x45\x00\xf2\x02\xf3\x02\x82\x00\x83\x00\xc0\x00\x17\x03\xe8\x02\x0c\x00\x18\x03\x4c\x02\x3c\x00\x0f\x00\x10\x00\x11\x00\xe1\x01\x12\x00\x3d\x00\xe7\x01\x14\x00\x15\x00\x16\x00\x17\x00\xeb\x01\x5a\x02\x11\x00\x39\x00\x12\x00\x39\x00\x8c\x01\x14\x00\x15\x00\x16\x00\x8d\x01\xa9\x02\x29\x03\x2a\x03\x2b\x03\x09\x00\x9d\x01\x4e\x02\x5f\xff\x09\x00\x39\x00\x3a\x00\xf3\x01\x13\x02\xfb\x01\x0c\x00\x45\x00\xbf\x00\xef\x01\x0c\x00\x5b\x02\x5c\x02\x9f\x02\x9f\x01\x5f\xff\xe2\x00\x49\x02\x39\x00\x3a\x00\x0c\x02\x0f\x02\x69\x02\x7d\x03\x2f\x03\x6a\x02\x30\x03\x3e\x00\x14\x00\x15\x00\x16\x00\x51\x02\x51\x00\xdd\x01\x16\x00\x52\x00\xe1\x01\x53\x00\x54\x00\x55\x00\x56\x00\x40\x03\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x39\x00\x3a\x00\x48\xff\x45\x00\x80\x02\x39\x00\x14\x02\x64\x00\x65\x00\xf4\x00\x48\xff\x66\x00\x67\x00\x46\x00\x47\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x9e\x00\x4b\x02\x9f\x00\xfb\x01\x91\x01\x0b\x02\x0c\x02\xfb\x01\x09\x00\xb6\x01\x41\x03\x42\x03\x43\x03\x44\x03\xb6\x01\x0a\x00\x45\x03\x3b\x00\x0c\x00\x09\x00\x4f\x03\x39\x00\x3a\x00\xfc\x01\xbf\x00\xa5\x02\x0a\x03\x75\x02\x9e\x00\x0c\x00\x9f\x00\x0b\x03\x3c\x00\x0f\x00\x10\x00\x11\x00\xc0\x00\x12\x00\x3d\x00\xfb\x01\x14\x00\x15\x00\x16\x00\x17\x00\x49\x02\x5a\x02\x11\x00\xcc\x00\x12\x00\x12\x03\x8c\x01\x14\x00\x15\x00\x16\x00\x8d\x01\x78\x01\xe1\x01\x0e\x03\x9e\x00\x6a\x02\x9f\x00\xbe\x01\xb6\x01\x6b\xff\x6b\xff\x46\x00\x79\x01\x39\x00\xe4\x01\x26\x02\xde\x00\x25\x00\x6b\xff\xe1\x01\x5b\x02\x5c\x02\x9e\x02\x26\x02\xa3\x02\x6b\xff\x39\x00\x6b\xff\x2a\x00\xc1\x01\xdf\x00\xe0\x00\x09\x00\xe1\x00\x6b\xff\xe2\x00\x3e\x00\x7a\x01\x7b\x01\x7c\x01\x7d\x01\x51\x00\x0c\x00\x7e\x01\x52\x00\xbf\x01\x53\x00\x54\x00\x55\x00\x56\x00\x40\x03\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x14\x00\x15\x00\x16\x00\xa2\x00\xf9\x02\xb2\x02\xfa\x02\x64\x00\x65\x00\xb3\x02\x2d\x02\x66\x00\x67\x00\x39\x00\x2e\x02\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x09\x00\xb7\x01\x48\xff\xb6\x01\x91\x01\xb5\x01\xbf\x00\x0a\x00\xb4\x01\x3b\x00\x0c\x00\x86\x03\x43\x03\x44\x03\xb3\x01\x48\xff\x87\x03\x48\xff\x09\x00\xb0\x01\x39\x00\x3a\x00\xae\x01\x3b\x00\x3c\x00\x0f\x00\x10\x00\x11\x00\x0c\x00\x12\x00\x3d\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x09\x00\xdb\x02\xa8\x00\xad\x01\xdc\x02\x0c\x00\xfa\x02\xac\x01\x5a\x02\x11\x00\x0c\x00\x12\x00\xab\x01\x8c\x01\x14\x00\x15\x00\x16\x00\x8d\x01\xde\x00\x3c\x00\x0f\x00\x10\x00\x11\x00\xa8\x01\x12\x00\x3d\x00\xa4\x01\x14\x00\x15\x00\x16\x00\x17\x00\x9d\x01\x14\x00\x15\x00\x16\x00\xa1\x00\x23\x02\x5b\x02\x5c\x02\x20\x03\xbf\x00\x24\x02\xdb\x02\x25\x02\x80\x01\xdc\x02\x3e\x00\xdd\x02\x78\x01\xde\x02\x26\x02\x51\x00\x0c\x02\x0e\x02\x52\x00\x88\x02\x53\x00\x54\x00\x55\x00\x56\x00\x73\x01\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\xf6\x02\xbf\x00\xf7\x02\xa9\x00\xa5\x00\xa6\x00\x5e\x01\x64\x00\x65\x00\x39\x00\x83\x02\x66\x00\x67\x00\x0c\x02\x0d\x02\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x09\x00\xbf\x00\x80\x02\xca\x00\xcb\x00\xbf\x00\x7e\x02\x0a\x00\xcc\x00\x3b\x00\x0c\x00\x91\x01\x45\x00\xc0\x00\xe4\x00\x7d\x02\x75\x01\x0c\x02\xd5\x02\xe5\x00\x39\x00\xe6\x00\x46\x00\xa8\x01\x3c\x00\x0f\x00\x10\x00\x11\x00\x39\x00\x12\x00\x3d\x00\xcc\x00\x14\x00\x15\x00\x16\x00\x17\x00\x09\x00\x69\x01\x78\x01\xe8\x00\xe9\x00\x78\x02\x9b\x01\x0a\x00\x9c\x01\x6f\x01\x0c\x00\x9d\x01\x46\x00\x79\x01\xea\x00\x39\x00\xb6\x00\x69\x01\xa5\x01\xeb\x00\xdb\x02\xec\x00\x6a\x01\xdc\x02\x6b\x01\x5e\x03\x70\x01\x11\x00\x9f\x01\x12\x00\xe2\x00\x66\x01\x14\x00\x15\x00\x16\x00\x62\x01\x67\x01\x45\x00\x68\x01\x98\x02\x7c\x01\x7d\x01\x39\x00\x3a\x00\x7e\x01\x09\x00\x3e\x00\x46\x00\x02\x02\xb8\x00\xb9\x00\x51\x00\xa8\x00\x73\x02\x52\x00\x0c\x00\x53\x00\x54\x00\x55\x00\x56\x00\x71\x02\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x70\x02\xf2\x00\x6e\x02\x14\x00\x15\x00\x16\x00\xd8\x00\x64\x00\x65\x00\x6d\x02\xdb\x02\x66\x00\x67\x00\xef\x02\xf3\x02\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x09\x00\xf0\xfe\xdb\x02\x64\x00\xba\x00\xef\x02\xf0\x02\x0a\x00\xc3\x01\x6b\x01\xab\x00\xef\xfe\xca\x00\xcb\x00\xac\x00\x6c\x01\x01\x02\xcc\x00\xdb\x02\xf2\xfe\xf1\xfe\xef\x02\x5a\x03\xa1\x01\xe0\x02\xe1\x02\x8b\x01\x11\x00\xa2\x01\x12\x00\xa3\x01\x8c\x01\x14\x00\x15\x00\x16\x00\x8d\x01\x09\x00\x39\x00\xc8\x02\x20\x02\xe2\x02\x21\x02\xe3\x02\x0a\x00\xf5\xfe\xb5\x00\x0c\x00\xaf\x00\xb0\x00\x39\x00\x0b\x02\x0c\x02\xb6\x00\x39\x00\x3a\x00\x8e\x01\x8f\x01\xa8\x01\x90\x01\x9f\x00\x0e\x00\x0f\x00\xb7\x00\x11\x00\xf4\xfe\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\xbf\x00\x4f\x02\x0a\x00\xbf\x00\x63\x01\x0c\x00\x49\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\xb6\x00\xc0\x00\xb8\x00\xb9\x00\xc0\x00\x1e\x02\x1f\x02\x20\x02\xca\x02\x21\x02\x64\x01\x11\x00\x45\x02\x12\x00\x09\x00\x23\x02\x14\x00\x15\x00\x16\x00\x62\x01\x24\x02\x0a\x00\x25\x02\x6f\x01\x0c\x00\x0b\x02\x0c\x02\x4d\x00\x08\x00\x26\x02\xb6\x00\x40\x02\xbf\x00\xb8\x00\xb9\x00\x9d\x01\xe6\x00\x1b\x00\xde\x00\x44\x02\x70\x01\x11\x00\x9e\x01\x12\x00\xc0\x00\xcc\x00\x14\x00\x15\x00\x16\x00\x62\x01\x3b\x02\x66\x01\x9f\x01\x74\x01\xe2\x00\xe1\x00\x98\x01\xe2\x00\x99\x01\x09\x00\x91\x01\xde\x01\xfc\x01\xb8\x00\xb9\x00\x39\x00\xde\x01\xf5\x01\x2d\x02\x0c\x00\x64\x00\xba\x00\xa8\x02\x8f\x02\x90\x02\x91\x02\x92\x02\x93\x02\xc1\x00\x42\x02\x09\x00\xe1\x01\xe2\x01\xc2\x00\xc3\x00\xc4\x00\xc5\x00\x0a\x00\x41\x02\x3b\x00\x0c\x00\x14\x00\x15\x00\x16\x00\xa2\x00\xc6\x00\x3a\x02\xc7\x00\xde\x01\xec\x01\x2d\x02\x64\x00\xba\x00\x34\x02\x3c\x00\x0f\x00\x10\x00\x11\x00\x39\x02\x12\x00\x3d\x00\x38\x02\x14\x00\x15\x00\x16\x00\x17\x00\x37\x02\xbf\x00\x36\x02\x1a\x02\x85\x00\xde\x01\xeb\x01\x89\x03\x86\x00\x31\x02\x87\x00\x1f\x00\x88\x00\xc0\x00\x4e\xfe\x64\x00\xba\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x34\x02\x20\x00\x8d\x00\x8e\x00\x8f\x00\x2d\x02\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x21\x00\x30\x02\x22\x00\x23\x00\x95\x00\xd8\x01\xda\x01\x26\x00\x96\x00\x27\x00\x2d\x02\x28\x00\x97\x00\x98\x00\x3e\x00\xde\x00\x29\x00\x2b\x02\xdb\x02\xe0\x02\xe1\x02\xdc\x02\x3f\x00\x5d\x03\xdb\x02\xde\x01\xe7\x01\xdc\x02\x33\x00\x8d\x03\x71\x01\x39\x00\xe1\x00\xdb\x02\xe2\x00\xe2\x02\xdc\x02\xe3\x02\x8c\x03\xde\x01\xe4\x01\x2b\x00\x2c\x00\x29\x02\x39\x00\x2d\x00\x41\x00\x42\x00\x28\x02\xde\x01\xdf\x01\x30\x00\x31\x00\xdb\x02\x32\x00\x33\x00\xdc\x02\x43\x00\x8b\x03\x35\x00\xdb\x02\x36\x00\x44\x00\xdc\x02\x45\x00\x8a\x03\x39\x00\x1b\x02\xe1\x01\x99\x00\x01\x02\x39\x00\x3a\x00\xbf\x00\x3b\x00\x1a\x02\x85\x00\xd8\x01\xd9\x01\x00\x02\x86\x00\xe4\x02\x87\x00\x1f\x00\x88\x00\xc0\x00\x4e\xfe\xd8\x01\x29\x02\x89\x00\x8a\x00\x8b\x00\x8c\x00\xd9\x02\x20\x00\x8d\x00\x8e\x00\x8f\x00\xd5\x02\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x21\x00\xd0\x02\x22\x00\x23\x00\x95\x00\xde\x01\xea\x02\x26\x00\x96\x00\x27\x00\xc8\x02\x28\x00\x97\x00\x98\x00\xd1\x02\x9d\x01\x29\x00\xde\x01\xe9\x02\xd4\xfe\xd4\xfe\x30\x02\x59\x02\x36\x02\xd4\xfe\xc0\x02\xd4\xfe\xd9\x02\xda\x02\xbf\x02\xd4\xfe\xbd\x02\x9f\x01\xba\x02\xe2\x00\xd4\xfe\x9b\x02\xd4\xfe\xcd\x02\xce\x02\xbc\x02\x2b\x00\x2c\x00\x9c\x02\xd4\xfe\x2d\x00\x41\x00\x42\x00\xc5\x02\xc6\x02\xb8\x02\x30\x00\x31\x00\xb7\x02\x32\x00\x33\x00\xbf\x00\x43\x00\xb6\x02\x35\x00\xb5\x02\x36\x00\x44\x00\xa1\x02\x45\x00\xc2\x02\xc3\x02\x1b\x02\xc0\x00\x99\x00\xbf\x00\x39\x00\x3a\x00\x85\x00\x3b\x00\xa5\x02\xa6\x02\x86\x00\x2d\x02\x87\x00\x1f\x00\x88\x00\xc0\x00\xde\x01\x02\x03\xb0\x02\x89\x00\x8a\x00\x8b\x00\x8c\x00\x36\x02\x20\x00\x8d\x00\x8e\x00\x8f\x00\x2d\x02\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x21\x00\x03\x02\x22\x00\x23\x00\x95\x00\xde\x01\xff\x02\x26\x00\x96\x00\x27\x00\x80\x02\x28\x00\x97\x00\x98\x00\x9a\x02\x9d\x01\x29\x00\x1c\x02\x05\x02\x8b\x02\xe2\x00\x8d\x02\x58\x02\x8e\x02\x8f\x02\x90\x02\x91\x02\x92\x02\x93\x02\xde\x01\xed\x02\x5f\xff\x9f\x01\x27\x03\xe2\x00\xeb\x02\x8f\x02\x90\x02\x91\x02\x92\x02\x93\x02\x2b\x00\x2c\x00\xd8\x01\x57\x03\x2d\x00\x41\x00\x42\x00\xd8\x01\x56\x03\x26\x03\x30\x00\x31\x00\x25\x03\x32\x00\x33\x00\x39\x00\x43\x00\x1f\x03\x35\x00\x1e\x03\x36\x00\x44\x00\x13\x03\x45\x00\xd8\x01\x55\x03\xee\xfd\x36\x02\x99\x00\x14\x03\x39\x00\x3a\x00\x1d\x03\x3b\x00\xee\xfd\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\x02\x01\x03\x01\x04\x01\x05\x01\x06\x01\x07\x01\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x0e\x01\x0f\x01\x10\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01\x20\x01\x21\x01\x22\x01\x23\x01\x24\x01\x25\x01\x26\x01\x27\x01\x28\x01\x29\x01\x2a\x01\x2b\x01\x2c\x01\x2d\x01\x2e\x01\x2f\x01\x30\x01\x31\x01\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x39\x01\x3a\x01\x3b\x01\x3c\x01\x3d\x01\x3e\x01\x3f\x01\x40\x01\x41\x01\x42\x01\x43\x01\x44\x01\x45\x01\x46\x01\x47\x01\x48\x01\x49\x01\x4a\x01\x4b\x01\x4c\x01\x4d\x01\x4e\x01\x4f\x01\x50\x01\x51\x01\x52\x01\x53\x01\x54\x01\x55\x01\x56\x01\x57\x01\x58\x01\x59\x01\x5a\x01\x5b\x01\x5c\x01\x85\x00\x1c\x03\x47\x03\x48\x03\x86\x00\x49\x03\x87\x00\x1f\x00\x88\x00\x15\x03\x4e\xfe\xc9\x00\x4a\x03\x89\x00\x8a\x00\x8b\x00\x4b\x03\x10\x03\x20\x00\x8d\x00\x8e\x00\x8f\x00\x4c\x03\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x21\x00\x0f\x03\x22\x00\x23\x00\x95\x00\xd8\x01\x54\x03\x26\x00\x96\x00\x27\x00\x0a\x03\x28\x00\x97\x00\x98\x00\xca\x00\xcb\x00\x29\x00\x52\x03\x53\x03\xcc\x00\x27\x03\x90\x02\x91\x02\x92\x02\x93\x02\xcd\x00\x3c\x03\x39\x03\x38\x03\x39\x03\xce\x00\x26\x02\xcf\x00\x4e\x03\x8f\x02\x90\x02\x91\x02\x92\x02\x93\x02\x39\x00\x39\x00\x2b\x00\x2c\x00\x34\x03\xa6\x02\x2d\x00\x41\x00\x42\x00\x6a\x03\x6b\x03\xff\x02\x30\x00\x31\x00\x04\x03\x32\x00\x33\x00\xbf\x00\x43\x00\xe1\x01\x35\x00\xe1\x01\x36\x00\x44\x00\x5c\x03\x45\x00\xde\x01\xec\x01\x5a\x03\xc0\x00\x99\x00\xbf\x00\x39\x00\x3a\x00\x85\x00\x3b\x00\x47\x03\x48\x03\x86\x00\x49\x03\x87\x00\x1f\x00\x88\x00\xc0\x00\xde\x01\x5c\x03\x4a\x03\x89\x00\x8a\x00\x8b\x00\x4b\x03\x39\x00\x20\x00\x8d\x00\x8e\x00\x8f\x00\x4c\x03\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x21\x00\x03\x02\x22\x00\x23\x00\x95\x00\x4d\x03\x26\x02\x26\x00\x96\x00\x27\x00\x3f\x03\x28\x00\x97\x00\x98\x00\x3e\x03\x03\x02\x29\x00\x11\x02\x05\x02\x38\x03\xe2\x00\x35\x03\x8f\x02\x90\x02\x91\x02\x92\x02\x93\x02\x3c\x03\x37\x03\x3b\x03\x7c\x03\x10\x02\x05\x02\x39\x00\xe2\x00\x65\x03\x8f\x02\x90\x02\x91\x02\x92\x02\x93\x02\x2b\x00\x2c\x00\x7b\x03\x77\x03\x2d\x00\x41\x00\x42\x00\x76\x03\x78\x03\x74\x03\x30\x00\x31\x00\x72\x03\x32\x00\x33\x00\xbf\x00\x43\x00\x26\x02\x35\x00\x6f\x03\x36\x00\x44\x00\x63\x03\x45\x00\x26\x02\x39\x00\x68\x03\xc0\x00\x99\x00\xbf\x00\x39\x00\x3a\x00\x88\xff\x3b\x00\x0a\x03\x61\x03\x88\xff\xe1\x01\x88\xff\x88\xff\x88\xff\xc0\x00\x88\xff\x86\x03\x85\x03\x88\xff\x88\xff\x88\xff\x88\xff\x39\x00\x88\xff\x88\xff\x88\xff\x88\xff\x32\x03\x88\xff\x88\xff\x88\xff\x88\xff\x88\xff\x88\xff\x03\x02\x88\xff\x88\xff\x88\xff\xef\x01\x39\x00\x88\xff\x88\xff\x88\xff\x48\x00\x88\xff\x88\xff\x88\xff\x08\x00\x03\x02\x88\xff\x04\x02\x05\x02\xf4\x00\xe2\x00\xdc\x00\xa7\x00\xa3\x00\xf9\x01\x4e\x00\xf6\x01\xbf\x01\xf4\x01\xf3\x01\xe5\x01\xe7\x02\x05\x02\xf0\x01\xe2\x00\xf1\x01\xef\x01\xed\x01\xbc\x01\xdc\x01\xb8\x01\x88\xff\x88\xff\xb1\x01\xb0\x01\x88\xff\x88\xff\x88\xff\xa9\x01\xa6\x01\x84\x01\x88\xff\x88\xff\x80\x01\x88\xff\x88\xff\xbf\x00\x88\xff\x81\x02\x88\xff\x76\x01\x88\xff\x88\xff\x85\x02\x88\xff\x76\x02\x73\x02\x75\x02\xc0\x00\x88\xff\xbf\x00\x88\xff\x88\xff\x85\x00\x88\xff\x71\x02\x6e\x02\x86\x00\x64\x02\x87\x00\x1f\x00\x88\x00\xc0\x00\x6a\x02\x67\x02\x61\x02\x89\x00\x8a\x00\x8b\x00\x8c\x00\x47\x02\x20\x00\x8d\x00\x8e\x00\x8f\x00\x76\x01\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x21\x00\x03\x02\x22\x00\x23\x00\x95\x00\x42\x02\xd7\x02\x26\x00\x96\x00\x27\x00\x3e\x02\x28\x00\x97\x00\x98\x00\x3d\x02\x03\x02\x29\x00\xe4\x02\x05\x02\x3c\x02\xe2\x00\x3b\x02\x34\x02\x32\x02\x12\x02\x31\x02\xbd\x02\x2b\x02\xba\x02\xb8\x02\xb3\x02\xd1\x02\x05\x02\xb0\x02\xe2\x00\xae\x02\xad\x02\xac\x02\xa3\x02\xa1\x02\x8b\x02\x2b\x00\x2c\x00\x1f\x03\x1a\x03\x2d\x00\x41\x00\x42\x00\x19\x03\x18\x03\x15\x03\x30\x00\x31\x00\x08\x03\x32\x00\x33\x00\x1f\x00\x43\x00\x10\x03\x35\x00\x0c\x03\x36\x00\x44\x00\x09\x00\x45\x00\xf7\x02\xf4\x02\x20\x00\xf7\x02\x99\x00\xf4\x02\x39\x00\x3a\x00\x0c\x00\x3b\x00\x09\x00\x58\x03\x21\x00\x3f\x03\x22\x00\x23\x00\x24\x00\xa8\x00\x25\x00\x26\x00\xab\x00\x27\x00\x79\x03\x28\x00\xb7\x01\xad\x00\x78\x03\x74\x03\x29\x00\x2a\x00\x14\x00\x15\x00\x16\x00\xa1\x00\x72\x03\x69\x03\x61\x01\x11\x00\x70\x03\x12\x00\xf2\x00\x6f\x03\x14\x00\x15\x00\x16\x00\x17\x00\x09\x00\x6d\x03\x6c\x03\x68\x03\x66\x03\x83\x03\x61\x03\x2b\x00\x2c\x00\x5f\x03\x0c\x00\x2d\x00\x2e\x00\x2f\x00\x89\x03\x8f\x03\x09\x00\x30\x00\x31\x00\x92\x03\x32\x00\x33\x00\x91\x03\x34\x00\x90\x03\x35\x00\x0c\x00\x36\x00\x37\x00\x8e\x03\x38\x00\x1f\x00\x14\x00\x15\x00\x16\x00\x5c\x01\x96\x03\x39\x00\x3a\x00\x95\x03\x3b\x00\x94\x03\xbc\x00\x09\x00\x93\x03\x00\x00\xd7\x00\xbd\x00\x14\x00\x15\x00\x16\x00\xd8\x00\x21\x00\xab\x00\x22\x00\x23\x00\x24\x00\xac\x00\xad\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x01\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\xa1\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x09\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x09\x00\x00\x00\x21\x00\xab\x00\x22\x00\x23\x00\x24\x00\xac\x00\xad\x00\x26\x00\x0c\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\xef\x00\x00\x00\x14\x00\x15\x00\x16\x00\xd8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x01\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x9e\x00\x38\x00\x9f\x00\x00\x00\x20\x00\x09\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x09\x00\x00\x00\x21\x00\xab\x00\x22\x00\x23\x00\x24\x00\xac\x00\xad\x00\x26\x00\x0c\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x54\x02\x00\x00\x00\x00\x00\x00\x00\x00\x86\x01\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x00\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x9e\x00\x38\x00\x9f\x00\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\xbc\x00\x09\x00\x00\x00\x00\x00\x00\x00\xbd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\xab\x00\x22\x00\x23\x00\x24\x00\xac\x00\xad\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x01\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x96\x01\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x09\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\xab\x00\x22\x00\x23\x00\x24\x00\x63\x02\xad\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x01\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x9e\x00\x45\x00\x9f\x00\x00\x00\x20\x00\x09\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\xab\x00\x22\x00\x23\x00\x24\x00\x62\x02\xad\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x01\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x93\x01\x00\x00\x20\x00\x09\x00\x94\x01\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\xab\x00\x22\x00\x23\x00\x24\x00\x60\x02\xad\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x01\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x00\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x9e\x00\x38\x00\x9f\x00\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\xbc\x00\x09\x00\x00\x00\x00\x00\x00\x00\xbd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\xab\x00\x22\x00\x23\x00\x24\x00\x5f\x02\xad\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x01\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x58\x02\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x09\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x0c\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\xd9\x00\x0f\x00\x10\x00\x11\x00\x29\x00\x12\x00\x3d\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x9e\x00\x45\x00\x9f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x09\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x0c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\xd5\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x3d\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\xa8\x02\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x9e\x00\x38\x00\x9f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x09\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\xa8\x00\x00\x00\x26\x00\x0c\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\xae\x01\x00\x00\x29\x00\x00\x00\xca\x00\xcb\x00\x00\x00\x00\x00\x00\x00\xcc\x00\x64\x01\x11\x00\x00\x00\x12\x00\xf2\x00\xa1\x01\x14\x00\x15\x00\x16\x00\x17\x00\xa2\x01\x00\x00\xa3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x39\x00\x00\x00\x65\x03\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x9e\x00\x38\x00\x9f\x00\x00\x00\x20\x00\x09\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\xa8\x00\x00\x00\x21\x00\xab\x00\x22\x00\x23\x00\x24\x00\xb7\x01\xad\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x39\xff\x32\x00\x1f\x00\x39\xff\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x09\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\xa8\x00\x00\x00\x00\x00\xab\x00\x29\x00\x00\x00\x00\x00\xb7\x01\x88\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x9b\x00\x00\x00\x20\x00\x09\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\xa8\x00\x00\x00\x21\x00\xab\x00\x22\x00\x23\x00\x24\x00\x86\x02\xad\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\xa1\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x09\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\xa8\x00\x00\x00\x26\x00\xab\x00\x27\x00\x00\x00\x28\x00\x00\x00\x83\x02\xae\x01\x00\x00\x29\x00\x00\x00\xca\x00\xcb\x00\x00\x00\x00\x00\x00\x00\xcc\x00\x84\x02\x11\x00\x00\x00\x12\x00\x00\x00\xe4\x00\x14\x00\x15\x00\x16\x00\x62\x01\xe5\x00\x00\x00\xe6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x39\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x9b\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x09\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x0c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x00\x10\x00\x11\x00\x00\x00\x12\x00\x3d\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\xa1\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x09\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x0c\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\xb9\x01\x10\x00\x11\x00\x29\x00\x12\x00\x3d\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x09\x00\x38\x00\x9b\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x0c\x00\x3b\x00\x09\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\xa8\x00\x00\x00\x26\x00\x0c\x00\x27\x00\x00\x00\x28\x00\xee\x00\x11\x00\xae\x01\x12\x00\x29\x00\x6b\x02\x14\x00\x15\x00\x16\x00\x8d\x01\x00\x00\x00\x00\x64\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\xa1\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x09\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x0c\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\xee\x00\x11\x00\x29\x00\x12\x00\xef\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x00\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x9b\x00\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x09\x00\x3b\x00\x00\x00\x00\x00\xbc\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbd\x00\x0c\x00\x00\x00\x09\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x0c\x00\x27\x00\x00\x00\x28\x00\x65\x02\x11\x00\x00\x00\x12\x00\x29\x00\x66\x02\x14\x00\x15\x00\x16\x00\x8d\x01\x00\x00\x00\x00\xee\x00\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\xca\x00\xcb\x00\x00\x00\x00\x00\x29\x00\xcc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x01\x00\x00\xa3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x56\x02\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\xca\x00\xcb\x00\x00\x00\x00\x00\x29\x00\xcc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe5\x00\x00\x00\x1e\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\xca\x00\xcb\x00\x00\x00\x00\x00\x29\x00\xcc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x01\x00\x00\xa3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\xca\x00\xcb\x00\x00\x00\x00\x00\x29\x00\xcc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe5\x00\x00\x00\xe6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\xc2\x01\xc3\x01\xc4\x01\xc5\x01\xc6\x01\xc7\x01\xc8\x01\xc9\x01\xca\x01\xcb\x01\xcc\x01\xcd\x01\xce\x01\xcf\x01\xd0\x01\xd1\x01\xd2\x01\xd3\x01\xd4\x01\xd5\x01\xd6\x01\xd7\x01\xd8\x01\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x37\xff\x32\x00\x1f\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x1f\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x94\x01\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x1f\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x94\x01\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x88\xff\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x88\xff\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x88\xff\x00\x00\x88\xff\x88\xff\x88\xff\x00\x00\x00\x00\x88\xff\x00\x00\x88\xff\x00\x00\x88\xff\x00\x00\x00\x00\x00\x00\x00\x00\x88\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\xff\x88\xff\x00\x00\x00\x00\x88\xff\x88\xff\x88\xff\x00\x00\x00\x00\x00\x00\x88\xff\x88\xff\x00\x00\x88\xff\x88\xff\x1f\x00\x88\xff\x00\x00\x88\xff\x00\x00\x88\xff\x88\xff\x00\x00\x88\xff\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x88\xff\x88\xff\x00\x00\x88\xff\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x1f\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x94\x01\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x1f\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x94\x01\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x33\x00\x1f\x00\x34\x00\x00\x00\x35\x00\x00\x00\x36\x00\x37\x00\x00\x00\x38\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x1f\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x1f\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x1f\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x1f\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x32\x00\x1f\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x31\x00\x00\x00\x32\x00\x00\x00\x09\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x0a\x00\x45\x00\x0b\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x26\x00\x4b\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x33\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x09\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x39\x00\x3a\x00\x26\x00\x3b\x00\x0c\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\xb6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x8a\x01\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\xdc\x00\x09\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x39\x00\x3a\x00\x26\x00\x3b\x00\x0c\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\xb6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x87\x01\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x39\x00\x3a\x00\x26\x00\x3b\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x00\x00\x00\x35\x00\x00\x00\x36\x00\xd4\x00\x00\x00\xd5\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x39\x00\x3a\x00\x26\x00\x3b\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x00\x00\x00\x35\x00\x00\x00\x36\x00\xd1\x00\x00\x00\xd2\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x39\x00\x3a\x00\x26\x00\x3b\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x39\x00\x3a\x00\x26\x00\x3b\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\xdc\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x39\x00\x3a\x00\x26\x00\x3b\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x39\x00\x3a\x00\x26\x00\x3b\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x54\x02\x00\x00\x45\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x39\x00\x3a\x00\x26\x00\x3b\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x44\x00\x00\x00\x45\x00\x00\x00\x21\x00\x00\x00\x22\x00\x23\x00\x24\x00\x39\x00\x3a\x00\x26\x00\x3b\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x2d\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x30\x00\x31\x00\x00\x00\x00\x00\x00\x00\x09\x00\x43\x00\x00\x00\x35\x00\x00\x00\x36\x00\x51\x03\x0a\x00\x45\x00\x0b\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x01\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x01\x83\x01\x00\x00\x00\x00\x81\x01\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb6\x00\x00\x00\x00\x00\x9c\x02\x83\x01\x00\x00\x00\x00\x9f\x00\x0e\x00\x0f\x00\xb7\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\xb6\x00\x00\x00\x8a\x01\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x0e\x00\x0f\x00\xb7\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x09\x00\x87\x01\x9b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\xaa\x00\xab\x00\x00\x00\x00\x00\x00\x00\xac\x00\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9c\x00\x0e\x00\x0f\x00\xae\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\xb2\x00\xb3\x00\x0a\x00\x00\x00\xaa\x00\xab\x00\x00\x00\x00\x00\x00\x00\xac\x00\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x0e\x00\x0f\x00\xae\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\xaf\x00\xb0\x00\x0a\x00\x00\x00\x6b\x01\xab\x00\x00\x00\x00\x00\x00\x00\xac\x00\x6c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x09\x00\x00\x00\x94\x01\x00\x00\x79\x02\x7a\x02\x7b\x02\x0a\x00\x00\x00\x6d\x01\xab\x00\xaf\x00\xb0\x00\x00\x00\x6e\x01\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x09\x00\x00\x00\x56\x02\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x6d\x01\xab\x00\xb2\x00\xb3\x00\x00\x00\x6e\x01\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x11\x00\x00\x00\x12\x00\x09\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x0a\x00\x00\x00\x6d\x01\xab\x00\x00\x00\x00\x00\x00\x00\x6e\x01\xad\x00\x00\x00\xb2\x00\xb3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x11\x00\x00\x00\x12\x00\x09\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x0a\x00\x00\x00\x6b\x01\xab\x00\x00\x00\x00\x00\x00\x00\xac\x00\x6c\x01\x00\x00\xb2\x00\xb3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x11\x00\x00\x00\x12\x00\x09\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x0a\x00\x00\x00\x60\x01\xab\x00\x00\x00\x00\x00\x00\x00\xac\x00\xad\x00\x00\x00\xaf\x00\xb0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x11\x00\x00\x00\x12\x00\x09\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x0a\x00\x00\x00\x60\x01\xab\x00\x00\x00\x00\x00\x00\x00\xac\x00\xad\x00\x00\x00\xb2\x00\xb3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x11\x00\x00\x00\x12\x00\x09\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x00\x00\x0a\x00\x00\x00\x6b\x01\xab\x00\x00\x00\x00\x00\x00\x00\xac\x00\x6c\x01\x00\x00\xaf\x00\xb0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x11\x00\x00\x00\x12\x00\x00\x00\x00\x00\x14\x00\x15\x00\x16\x00\x62\x01\x09\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\xab\x00\xaf\x00\xb0\x00\x00\x00\xac\x00\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9c\x00\x0e\x00\x0f\x00\xae\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x89\x01\x09\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\xab\x00\x00\x00\x00\x00\x00\x00\xac\x00\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9c\x00\x0e\x00\x0f\x00\xae\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x86\x01\x0a\x00\x00\x00\x0b\x00\xab\x00\x00\x00\x00\x00\x00\x00\xac\x00\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x0e\x00\x0f\x00\xae\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x88\x01\x0a\x00\x00\x00\x0b\x00\xab\x00\x00\x00\x00\x00\x00\x00\xac\x00\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x0e\x00\x0f\x00\xae\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x85\x01\x09\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9c\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xed\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbb\x01\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\x01\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x01\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x01\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5f\x01\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5e\x01\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xab\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x03\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x03\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x03\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x03\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\x02\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x0b\x00\x0c\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x51\x03\x0e\x00\x0f\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x00\x00\x14\x00\x15\x00\x16\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (7, 530) [
	(7 , happyReduce_7),
	(8 , happyReduce_8),
	(9 , happyReduce_9),
	(10 , happyReduce_10),
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256),
	(257 , happyReduce_257),
	(258 , happyReduce_258),
	(259 , happyReduce_259),
	(260 , happyReduce_260),
	(261 , happyReduce_261),
	(262 , happyReduce_262),
	(263 , happyReduce_263),
	(264 , happyReduce_264),
	(265 , happyReduce_265),
	(266 , happyReduce_266),
	(267 , happyReduce_267),
	(268 , happyReduce_268),
	(269 , happyReduce_269),
	(270 , happyReduce_270),
	(271 , happyReduce_271),
	(272 , happyReduce_272),
	(273 , happyReduce_273),
	(274 , happyReduce_274),
	(275 , happyReduce_275),
	(276 , happyReduce_276),
	(277 , happyReduce_277),
	(278 , happyReduce_278),
	(279 , happyReduce_279),
	(280 , happyReduce_280),
	(281 , happyReduce_281),
	(282 , happyReduce_282),
	(283 , happyReduce_283),
	(284 , happyReduce_284),
	(285 , happyReduce_285),
	(286 , happyReduce_286),
	(287 , happyReduce_287),
	(288 , happyReduce_288),
	(289 , happyReduce_289),
	(290 , happyReduce_290),
	(291 , happyReduce_291),
	(292 , happyReduce_292),
	(293 , happyReduce_293),
	(294 , happyReduce_294),
	(295 , happyReduce_295),
	(296 , happyReduce_296),
	(297 , happyReduce_297),
	(298 , happyReduce_298),
	(299 , happyReduce_299),
	(300 , happyReduce_300),
	(301 , happyReduce_301),
	(302 , happyReduce_302),
	(303 , happyReduce_303),
	(304 , happyReduce_304),
	(305 , happyReduce_305),
	(306 , happyReduce_306),
	(307 , happyReduce_307),
	(308 , happyReduce_308),
	(309 , happyReduce_309),
	(310 , happyReduce_310),
	(311 , happyReduce_311),
	(312 , happyReduce_312),
	(313 , happyReduce_313),
	(314 , happyReduce_314),
	(315 , happyReduce_315),
	(316 , happyReduce_316),
	(317 , happyReduce_317),
	(318 , happyReduce_318),
	(319 , happyReduce_319),
	(320 , happyReduce_320),
	(321 , happyReduce_321),
	(322 , happyReduce_322),
	(323 , happyReduce_323),
	(324 , happyReduce_324),
	(325 , happyReduce_325),
	(326 , happyReduce_326),
	(327 , happyReduce_327),
	(328 , happyReduce_328),
	(329 , happyReduce_329),
	(330 , happyReduce_330),
	(331 , happyReduce_331),
	(332 , happyReduce_332),
	(333 , happyReduce_333),
	(334 , happyReduce_334),
	(335 , happyReduce_335),
	(336 , happyReduce_336),
	(337 , happyReduce_337),
	(338 , happyReduce_338),
	(339 , happyReduce_339),
	(340 , happyReduce_340),
	(341 , happyReduce_341),
	(342 , happyReduce_342),
	(343 , happyReduce_343),
	(344 , happyReduce_344),
	(345 , happyReduce_345),
	(346 , happyReduce_346),
	(347 , happyReduce_347),
	(348 , happyReduce_348),
	(349 , happyReduce_349),
	(350 , happyReduce_350),
	(351 , happyReduce_351),
	(352 , happyReduce_352),
	(353 , happyReduce_353),
	(354 , happyReduce_354),
	(355 , happyReduce_355),
	(356 , happyReduce_356),
	(357 , happyReduce_357),
	(358 , happyReduce_358),
	(359 , happyReduce_359),
	(360 , happyReduce_360),
	(361 , happyReduce_361),
	(362 , happyReduce_362),
	(363 , happyReduce_363),
	(364 , happyReduce_364),
	(365 , happyReduce_365),
	(366 , happyReduce_366),
	(367 , happyReduce_367),
	(368 , happyReduce_368),
	(369 , happyReduce_369),
	(370 , happyReduce_370),
	(371 , happyReduce_371),
	(372 , happyReduce_372),
	(373 , happyReduce_373),
	(374 , happyReduce_374),
	(375 , happyReduce_375),
	(376 , happyReduce_376),
	(377 , happyReduce_377),
	(378 , happyReduce_378),
	(379 , happyReduce_379),
	(380 , happyReduce_380),
	(381 , happyReduce_381),
	(382 , happyReduce_382),
	(383 , happyReduce_383),
	(384 , happyReduce_384),
	(385 , happyReduce_385),
	(386 , happyReduce_386),
	(387 , happyReduce_387),
	(388 , happyReduce_388),
	(389 , happyReduce_389),
	(390 , happyReduce_390),
	(391 , happyReduce_391),
	(392 , happyReduce_392),
	(393 , happyReduce_393),
	(394 , happyReduce_394),
	(395 , happyReduce_395),
	(396 , happyReduce_396),
	(397 , happyReduce_397),
	(398 , happyReduce_398),
	(399 , happyReduce_399),
	(400 , happyReduce_400),
	(401 , happyReduce_401),
	(402 , happyReduce_402),
	(403 , happyReduce_403),
	(404 , happyReduce_404),
	(405 , happyReduce_405),
	(406 , happyReduce_406),
	(407 , happyReduce_407),
	(408 , happyReduce_408),
	(409 , happyReduce_409),
	(410 , happyReduce_410),
	(411 , happyReduce_411),
	(412 , happyReduce_412),
	(413 , happyReduce_413),
	(414 , happyReduce_414),
	(415 , happyReduce_415),
	(416 , happyReduce_416),
	(417 , happyReduce_417),
	(418 , happyReduce_418),
	(419 , happyReduce_419),
	(420 , happyReduce_420),
	(421 , happyReduce_421),
	(422 , happyReduce_422),
	(423 , happyReduce_423),
	(424 , happyReduce_424),
	(425 , happyReduce_425),
	(426 , happyReduce_426),
	(427 , happyReduce_427),
	(428 , happyReduce_428),
	(429 , happyReduce_429),
	(430 , happyReduce_430),
	(431 , happyReduce_431),
	(432 , happyReduce_432),
	(433 , happyReduce_433),
	(434 , happyReduce_434),
	(435 , happyReduce_435),
	(436 , happyReduce_436),
	(437 , happyReduce_437),
	(438 , happyReduce_438),
	(439 , happyReduce_439),
	(440 , happyReduce_440),
	(441 , happyReduce_441),
	(442 , happyReduce_442),
	(443 , happyReduce_443),
	(444 , happyReduce_444),
	(445 , happyReduce_445),
	(446 , happyReduce_446),
	(447 , happyReduce_447),
	(448 , happyReduce_448),
	(449 , happyReduce_449),
	(450 , happyReduce_450),
	(451 , happyReduce_451),
	(452 , happyReduce_452),
	(453 , happyReduce_453),
	(454 , happyReduce_454),
	(455 , happyReduce_455),
	(456 , happyReduce_456),
	(457 , happyReduce_457),
	(458 , happyReduce_458),
	(459 , happyReduce_459),
	(460 , happyReduce_460),
	(461 , happyReduce_461),
	(462 , happyReduce_462),
	(463 , happyReduce_463),
	(464 , happyReduce_464),
	(465 , happyReduce_465),
	(466 , happyReduce_466),
	(467 , happyReduce_467),
	(468 , happyReduce_468),
	(469 , happyReduce_469),
	(470 , happyReduce_470),
	(471 , happyReduce_471),
	(472 , happyReduce_472),
	(473 , happyReduce_473),
	(474 , happyReduce_474),
	(475 , happyReduce_475),
	(476 , happyReduce_476),
	(477 , happyReduce_477),
	(478 , happyReduce_478),
	(479 , happyReduce_479),
	(480 , happyReduce_480),
	(481 , happyReduce_481),
	(482 , happyReduce_482),
	(483 , happyReduce_483),
	(484 , happyReduce_484),
	(485 , happyReduce_485),
	(486 , happyReduce_486),
	(487 , happyReduce_487),
	(488 , happyReduce_488),
	(489 , happyReduce_489),
	(490 , happyReduce_490),
	(491 , happyReduce_491),
	(492 , happyReduce_492),
	(493 , happyReduce_493),
	(494 , happyReduce_494),
	(495 , happyReduce_495),
	(496 , happyReduce_496),
	(497 , happyReduce_497),
	(498 , happyReduce_498),
	(499 , happyReduce_499),
	(500 , happyReduce_500),
	(501 , happyReduce_501),
	(502 , happyReduce_502),
	(503 , happyReduce_503),
	(504 , happyReduce_504),
	(505 , happyReduce_505),
	(506 , happyReduce_506),
	(507 , happyReduce_507),
	(508 , happyReduce_508),
	(509 , happyReduce_509),
	(510 , happyReduce_510),
	(511 , happyReduce_511),
	(512 , happyReduce_512),
	(513 , happyReduce_513),
	(514 , happyReduce_514),
	(515 , happyReduce_515),
	(516 , happyReduce_516),
	(517 , happyReduce_517),
	(518 , happyReduce_518),
	(519 , happyReduce_519),
	(520 , happyReduce_520),
	(521 , happyReduce_521),
	(522 , happyReduce_522),
	(523 , happyReduce_523),
	(524 , happyReduce_524),
	(525 , happyReduce_525),
	(526 , happyReduce_526),
	(527 , happyReduce_527),
	(528 , happyReduce_528),
	(529 , happyReduce_529),
	(530 , happyReduce_530)
	]

happy_n_terms = 105 :: Int
happy_n_nonterms = 177 :: Int

happyReduce_7 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_7 = happySpecReduce_1  0# happyReduction_7
happyReduction_7 happy_x_1
	 =  case happyOut11 happy_x_1 of { (HappyWrap11 happy_var_1) -> 
	happyIn10
		 (reverse happy_var_1
	)}

happyReduce_8 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_8 = happySpecReduce_2  1# happyReduction_8
happyReduction_8 happy_x_2
	happy_x_1
	 =  case happyOut11 happy_x_1 of { (HappyWrap11 happy_var_1) -> 
	case happyOut12 happy_x_2 of { (HappyWrap12 happy_var_2) -> 
	happyIn11
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_9 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_9 = happySpecReduce_0  1# happyReduction_9
happyReduction_9  =  happyIn11
		 ([]
	)

happyReduce_10 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_10 = happySpecReduce_1  2# happyReduction_10
happyReduction_10 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwAbstract happy_var_1) -> 
	happyIn12
		 (TokKeyword KwAbstract happy_var_1
	)}

happyReduce_11 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_11 = happySpecReduce_1  2# happyReduction_11
happyReduction_11 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoData happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCoData happy_var_1
	)}

happyReduce_12 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_12 = happySpecReduce_1  2# happyReduction_12
happyReduction_12 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoInductive happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCoInductive happy_var_1
	)}

happyReduce_13 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_13 = happySpecReduce_1  2# happyReduction_13
happyReduction_13 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwConstructor happy_var_1) -> 
	happyIn12
		 (TokKeyword KwConstructor happy_var_1
	)}

happyReduce_14 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_14 = happySpecReduce_1  2# happyReduction_14
happyReduction_14 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	happyIn12
		 (TokKeyword KwData happy_var_1
	)}

happyReduce_15 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_15 = happySpecReduce_1  2# happyReduction_15
happyReduction_15 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwDo happy_var_1) -> 
	happyIn12
		 (TokKeyword KwDo happy_var_1
	)}

happyReduce_16 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_16 = happySpecReduce_1  2# happyReduction_16
happyReduction_16 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwEta happy_var_1) -> 
	happyIn12
		 (TokKeyword KwEta happy_var_1
	)}

happyReduce_17 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_17 = happySpecReduce_1  2# happyReduction_17
happyReduction_17 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwField happy_var_1) -> 
	happyIn12
		 (TokKeyword KwField happy_var_1
	)}

happyReduce_18 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_18 = happySpecReduce_1  2# happyReduction_18
happyReduction_18 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwForall happy_var_1) -> 
	happyIn12
		 (TokKeyword KwForall happy_var_1
	)}

happyReduce_19 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_19 = happySpecReduce_1  2# happyReduction_19
happyReduction_19 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwHiding happy_var_1) -> 
	happyIn12
		 (TokKeyword KwHiding happy_var_1
	)}

happyReduce_20 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_20 = happySpecReduce_1  2# happyReduction_20
happyReduction_20 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwImport happy_var_1) -> 
	happyIn12
		 (TokKeyword KwImport happy_var_1
	)}

happyReduce_21 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_21 = happySpecReduce_1  2# happyReduction_21
happyReduction_21 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIn happy_var_1) -> 
	happyIn12
		 (TokKeyword KwIn happy_var_1
	)}

happyReduce_22 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_22 = happySpecReduce_1  2# happyReduction_22
happyReduction_22 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInductive happy_var_1) -> 
	happyIn12
		 (TokKeyword KwInductive happy_var_1
	)}

happyReduce_23 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_23 = happySpecReduce_1  2# happyReduction_23
happyReduction_23 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfix happy_var_1) -> 
	happyIn12
		 (TokKeyword KwInfix happy_var_1
	)}

happyReduce_24 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_24 = happySpecReduce_1  2# happyReduction_24
happyReduction_24 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixL happy_var_1) -> 
	happyIn12
		 (TokKeyword KwInfixL happy_var_1
	)}

happyReduce_25 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_25 = happySpecReduce_1  2# happyReduction_25
happyReduction_25 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixR happy_var_1) -> 
	happyIn12
		 (TokKeyword KwInfixR happy_var_1
	)}

happyReduce_26 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_26 = happySpecReduce_1  2# happyReduction_26
happyReduction_26 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInstance happy_var_1) -> 
	happyIn12
		 (TokKeyword KwInstance happy_var_1
	)}

happyReduce_27 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_27 = happySpecReduce_1  2# happyReduction_27
happyReduction_27 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwLet happy_var_1) -> 
	happyIn12
		 (TokKeyword KwLet happy_var_1
	)}

happyReduce_28 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_28 = happySpecReduce_1  2# happyReduction_28
happyReduction_28 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMacro happy_var_1) -> 
	happyIn12
		 (TokKeyword KwMacro happy_var_1
	)}

happyReduce_29 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_29 = happySpecReduce_1  2# happyReduction_29
happyReduction_29 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	happyIn12
		 (TokKeyword KwModule happy_var_1
	)}

happyReduce_30 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_30 = happySpecReduce_1  2# happyReduction_30
happyReduction_30 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMutual happy_var_1) -> 
	happyIn12
		 (TokKeyword KwMutual happy_var_1
	)}

happyReduce_31 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_31 = happySpecReduce_1  2# happyReduction_31
happyReduction_31 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNoEta happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNoEta happy_var_1
	)}

happyReduce_32 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_32 = happySpecReduce_1  2# happyReduction_32
happyReduction_32 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	happyIn12
		 (TokKeyword KwOpen happy_var_1
	)}

happyReduce_33 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_33 = happySpecReduce_1  2# happyReduction_33
happyReduction_33 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOverlap happy_var_1) -> 
	happyIn12
		 (TokKeyword KwOverlap happy_var_1
	)}

happyReduce_34 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_34 = happySpecReduce_1  2# happyReduction_34
happyReduction_34 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPatternSyn happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPatternSyn happy_var_1
	)}

happyReduce_35 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_35 = happySpecReduce_1  2# happyReduction_35
happyReduction_35 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPostulate happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPostulate happy_var_1
	)}

happyReduce_36 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_36 = happySpecReduce_1  2# happyReduction_36
happyReduction_36 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrimitive happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPrimitive happy_var_1
	)}

happyReduce_37 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_37 = happySpecReduce_1  2# happyReduction_37
happyReduction_37 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrivate happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPrivate happy_var_1
	)}

happyReduce_38 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_38 = happySpecReduce_1  2# happyReduction_38
happyReduction_38 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwProp happy_var_1) -> 
	happyIn12
		 (TokKeyword KwProp happy_var_1
	)}

happyReduce_39 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_39 = happySpecReduce_1  2# happyReduction_39
happyReduction_39 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPublic happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPublic happy_var_1
	)}

happyReduce_40 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_40 = happySpecReduce_1  2# happyReduction_40
happyReduction_40 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuote happy_var_1) -> 
	happyIn12
		 (TokKeyword KwQuote happy_var_1
	)}

happyReduce_41 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_41 = happySpecReduce_1  2# happyReduction_41
happyReduction_41 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteTerm happy_var_1) -> 
	happyIn12
		 (TokKeyword KwQuoteTerm happy_var_1
	)}

happyReduce_42 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_42 = happySpecReduce_1  2# happyReduction_42
happyReduction_42 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	happyIn12
		 (TokKeyword KwRecord happy_var_1
	)}

happyReduce_43 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_43 = happySpecReduce_1  2# happyReduction_43
happyReduction_43 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	happyIn12
		 (TokKeyword KwRenaming happy_var_1
	)}

happyReduce_44 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_44 = happySpecReduce_1  2# happyReduction_44
happyReduction_44 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRewrite happy_var_1) -> 
	happyIn12
		 (TokKeyword KwRewrite happy_var_1
	)}

happyReduce_45 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_45 = happySpecReduce_1  2# happyReduction_45
happyReduction_45 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSet happy_var_1) -> 
	happyIn12
		 (TokKeyword KwSet happy_var_1
	)}

happyReduce_46 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_46 = happySpecReduce_1  2# happyReduction_46
happyReduction_46 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSyntax happy_var_1) -> 
	happyIn12
		 (TokKeyword KwSyntax happy_var_1
	)}

happyReduce_47 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_47 = happySpecReduce_1  2# happyReduction_47
happyReduction_47 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTactic happy_var_1) -> 
	happyIn12
		 (TokKeyword KwTactic happy_var_1
	)}

happyReduce_48 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_48 = happySpecReduce_1  2# happyReduction_48
happyReduction_48 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTo happy_var_1) -> 
	happyIn12
		 (TokKeyword KwTo happy_var_1
	)}

happyReduce_49 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_49 = happySpecReduce_1  2# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquote happy_var_1) -> 
	happyIn12
		 (TokKeyword KwUnquote happy_var_1
	)}

happyReduce_50 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_50 = happySpecReduce_1  2# happyReduction_50
happyReduction_50 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDecl happy_var_1) -> 
	happyIn12
		 (TokKeyword KwUnquoteDecl happy_var_1
	)}

happyReduce_51 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_51 = happySpecReduce_1  2# happyReduction_51
happyReduction_51 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDef happy_var_1) -> 
	happyIn12
		 (TokKeyword KwUnquoteDef happy_var_1
	)}

happyReduce_52 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_52 = happySpecReduce_1  2# happyReduction_52
happyReduction_52 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUsing happy_var_1) -> 
	happyIn12
		 (TokKeyword KwUsing happy_var_1
	)}

happyReduce_53 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_53 = happySpecReduce_1  2# happyReduction_53
happyReduction_53 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwVariable happy_var_1) -> 
	happyIn12
		 (TokKeyword KwVariable happy_var_1
	)}

happyReduce_54 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_54 = happySpecReduce_1  2# happyReduction_54
happyReduction_54 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWhere happy_var_1) -> 
	happyIn12
		 (TokKeyword KwWhere happy_var_1
	)}

happyReduce_55 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_55 = happySpecReduce_1  2# happyReduction_55
happyReduction_55 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWith happy_var_1) -> 
	happyIn12
		 (TokKeyword KwWith happy_var_1
	)}

happyReduce_56 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_56 = happySpecReduce_1  2# happyReduction_56
happyReduction_56 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwBUILTIN happy_var_1) -> 
	happyIn12
		 (TokKeyword KwBUILTIN happy_var_1
	)}

happyReduce_57 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_57 = happySpecReduce_1  2# happyReduction_57
happyReduction_57 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCATCHALL happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCATCHALL happy_var_1
	)}

happyReduce_58 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_58 = happySpecReduce_1  2# happyReduction_58
happyReduction_58 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCOMPILE happy_var_1
	)}

happyReduce_59 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_59 = happySpecReduce_1  2# happyReduction_59
happyReduction_59 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwDISPLAY happy_var_1) -> 
	happyIn12
		 (TokKeyword KwDISPLAY happy_var_1
	)}

happyReduce_60 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_60 = happySpecReduce_1  2# happyReduction_60
happyReduction_60 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwETA happy_var_1) -> 
	happyIn12
		 (TokKeyword KwETA happy_var_1
	)}

happyReduce_61 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_61 = happySpecReduce_1  2# happyReduction_61
happyReduction_61 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwFOREIGN happy_var_1) -> 
	happyIn12
		 (TokKeyword KwFOREIGN happy_var_1
	)}

happyReduce_62 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_62 = happySpecReduce_1  2# happyReduction_62
happyReduction_62 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIMPOSSIBLE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwIMPOSSIBLE happy_var_1
	)}

happyReduce_63 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_63 = happySpecReduce_1  2# happyReduction_63
happyReduction_63 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwINJECTIVE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwINJECTIVE happy_var_1
	)}

happyReduce_64 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_64 = happySpecReduce_1  2# happyReduction_64
happyReduction_64 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwINLINE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwINLINE happy_var_1
	)}

happyReduce_65 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_65 = happySpecReduce_1  2# happyReduction_65
happyReduction_65 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMEASURE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwMEASURE happy_var_1
	)}

happyReduce_66 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_66 = happySpecReduce_1  2# happyReduction_66
happyReduction_66 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNOINLINE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNOINLINE happy_var_1
	)}

happyReduce_67 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_67 = happySpecReduce_1  2# happyReduction_67
happyReduction_67 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNO_POSITIVITY_CHECK happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNO_POSITIVITY_CHECK happy_var_1
	)}

happyReduce_68 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_68 = happySpecReduce_1  2# happyReduction_68
happyReduction_68 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNO_TERMINATION_CHECK happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNO_TERMINATION_CHECK happy_var_1
	)}

happyReduce_69 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_69 = happySpecReduce_1  2# happyReduction_69
happyReduction_69 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNO_UNIVERSE_CHECK happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNO_UNIVERSE_CHECK happy_var_1
	)}

happyReduce_70 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_70 = happySpecReduce_1  2# happyReduction_70
happyReduction_70 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNON_TERMINATING happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNON_TERMINATING happy_var_1
	)}

happyReduce_71 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_71 = happySpecReduce_1  2# happyReduction_71
happyReduction_71 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNON_COVERING happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNON_COVERING happy_var_1
	)}

happyReduce_72 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_72 = happySpecReduce_1  2# happyReduction_72
happyReduction_72 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOPTIONS happy_var_1) -> 
	happyIn12
		 (TokKeyword KwOPTIONS happy_var_1
	)}

happyReduce_73 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_73 = happySpecReduce_1  2# happyReduction_73
happyReduction_73 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPOLARITY happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPOLARITY happy_var_1
	)}

happyReduce_74 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_74 = happySpecReduce_1  2# happyReduction_74
happyReduction_74 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwREWRITE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwREWRITE happy_var_1
	)}

happyReduce_75 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_75 = happySpecReduce_1  2# happyReduction_75
happyReduction_75 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSTATIC happy_var_1) -> 
	happyIn12
		 (TokKeyword KwSTATIC happy_var_1
	)}

happyReduce_76 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_76 = happySpecReduce_1  2# happyReduction_76
happyReduction_76 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTERMINATING happy_var_1) -> 
	happyIn12
		 (TokKeyword KwTERMINATING happy_var_1
	)}

happyReduce_77 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_77 = happySpecReduce_1  2# happyReduction_77
happyReduction_77 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWARNING_ON_IMPORT happy_var_1) -> 
	happyIn12
		 (TokKeyword KwWARNING_ON_IMPORT happy_var_1
	)}

happyReduce_78 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_78 = happySpecReduce_1  2# happyReduction_78
happyReduction_78 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWARNING_ON_USAGE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwWARNING_ON_USAGE happy_var_1
	)}

happyReduce_79 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_79 = happySpecReduce_1  2# happyReduction_79
happyReduction_79 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSetN happy_var_1) -> 
	happyIn12
		 (TokSetN happy_var_1
	)}

happyReduce_80 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_80 = happySpecReduce_1  2# happyReduction_80
happyReduction_80 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokPropN happy_var_1) -> 
	happyIn12
		 (TokPropN happy_var_1
	)}

happyReduce_81 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_81 = happySpecReduce_1  2# happyReduction_81
happyReduction_81 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokTeX happy_var_1) -> 
	happyIn12
		 (TokTeX happy_var_1
	)}

happyReduce_82 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_82 = happySpecReduce_1  2# happyReduction_82
happyReduction_82 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokComment happy_var_1) -> 
	happyIn12
		 (TokComment happy_var_1
	)}

happyReduce_83 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_83 = happySpecReduce_1  2# happyReduction_83
happyReduction_83 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEllipsis happy_var_1) -> 
	happyIn12
		 (TokSymbol SymEllipsis happy_var_1
	)}

happyReduce_84 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_84 = happySpecReduce_1  2# happyReduction_84
happyReduction_84 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDotDot happy_var_1) -> 
	happyIn12
		 (TokSymbol SymDotDot happy_var_1
	)}

happyReduce_85 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_85 = happySpecReduce_1  2# happyReduction_85
happyReduction_85 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDot happy_var_1) -> 
	happyIn12
		 (TokSymbol SymDot happy_var_1
	)}

happyReduce_86 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_86 = happySpecReduce_1  2# happyReduction_86
happyReduction_86 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymSemi happy_var_1) -> 
	happyIn12
		 (TokSymbol SymSemi happy_var_1
	)}

happyReduce_87 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_87 = happySpecReduce_1  2# happyReduction_87
happyReduction_87 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymColon happy_var_1) -> 
	happyIn12
		 (TokSymbol SymColon happy_var_1
	)}

happyReduce_88 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_88 = happySpecReduce_1  2# happyReduction_88
happyReduction_88 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEqual happy_var_1) -> 
	happyIn12
		 (TokSymbol SymEqual happy_var_1
	)}

happyReduce_89 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_89 = happySpecReduce_1  2# happyReduction_89
happyReduction_89 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn12
		 (TokSymbol SymUnderscore happy_var_1
	)}

happyReduce_90 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_90 = happySpecReduce_1  2# happyReduction_90
happyReduction_90 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymQuestionMark happy_var_1) -> 
	happyIn12
		 (TokSymbol SymQuestionMark happy_var_1
	)}

happyReduce_91 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_91 = happySpecReduce_1  2# happyReduction_91
happyReduction_91 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymArrow happy_var_1) -> 
	happyIn12
		 (TokSymbol SymArrow happy_var_1
	)}

happyReduce_92 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_92 = happySpecReduce_1  2# happyReduction_92
happyReduction_92 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	happyIn12
		 (TokSymbol SymLambda happy_var_1
	)}

happyReduce_93 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_93 = happySpecReduce_1  2# happyReduction_93
happyReduction_93 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymAs happy_var_1) -> 
	happyIn12
		 (TokSymbol SymAs happy_var_1
	)}

happyReduce_94 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_94 = happySpecReduce_1  2# happyReduction_94
happyReduction_94 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymBar happy_var_1) -> 
	happyIn12
		 (TokSymbol SymBar happy_var_1
	)}

happyReduce_95 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_95 = happySpecReduce_1  2# happyReduction_95
happyReduction_95 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	happyIn12
		 (TokSymbol SymOpenParen happy_var_1
	)}

happyReduce_96 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_96 = happySpecReduce_1  2# happyReduction_96
happyReduction_96 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseParen happy_var_1) -> 
	happyIn12
		 (TokSymbol SymCloseParen happy_var_1
	)}

happyReduce_97 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_97 = happySpecReduce_1  2# happyReduction_97
happyReduction_97 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenIdiomBracket happy_var_1) -> 
	happyIn12
		 (TokSymbol SymOpenIdiomBracket happy_var_1
	)}

happyReduce_98 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_98 = happySpecReduce_1  2# happyReduction_98
happyReduction_98 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseIdiomBracket happy_var_1) -> 
	happyIn12
		 (TokSymbol SymCloseIdiomBracket happy_var_1
	)}

happyReduce_99 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_99 = happySpecReduce_1  2# happyReduction_99
happyReduction_99 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEmptyIdiomBracket happy_var_1) -> 
	happyIn12
		 (TokSymbol SymEmptyIdiomBracket happy_var_1
	)}

happyReduce_100 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_100 = happySpecReduce_1  2# happyReduction_100
happyReduction_100 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymDoubleOpenBrace happy_var_1
	)}

happyReduce_101 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_101 = happySpecReduce_1  2# happyReduction_101
happyReduction_101 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleCloseBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymDoubleCloseBrace happy_var_1
	)}

happyReduce_102 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_102 = happySpecReduce_1  2# happyReduction_102
happyReduction_102 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymOpenBrace happy_var_1
	)}

happyReduce_103 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_103 = happySpecReduce_1  2# happyReduction_103
happyReduction_103 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymCloseBrace happy_var_1
	)}

happyReduce_104 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_104 = happySpecReduce_1  2# happyReduction_104
happyReduction_104 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenVirtualBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymOpenVirtualBrace happy_var_1
	)}

happyReduce_105 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_105 = happySpecReduce_1  2# happyReduction_105
happyReduction_105 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseVirtualBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymCloseVirtualBrace happy_var_1
	)}

happyReduce_106 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_106 = happySpecReduce_1  2# happyReduction_106
happyReduction_106 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymVirtualSemi happy_var_1) -> 
	happyIn12
		 (TokSymbol SymVirtualSemi happy_var_1
	)}

happyReduce_107 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_107 = happySpecReduce_1  2# happyReduction_107
happyReduction_107 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	happyIn12
		 (TokSymbol SymOpenPragma happy_var_1
	)}

happyReduce_108 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_108 = happySpecReduce_1  2# happyReduction_108
happyReduction_108 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymClosePragma happy_var_1) -> 
	happyIn12
		 (TokSymbol SymClosePragma happy_var_1
	)}

happyReduce_109 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_109 = happySpecReduce_1  2# happyReduction_109
happyReduction_109 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	happyIn12
		 (TokId happy_var_1
	)}

happyReduce_110 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_110 = happySpecReduce_1  2# happyReduction_110
happyReduction_110 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokQId happy_var_1) -> 
	happyIn12
		 (TokQId happy_var_1
	)}

happyReduce_111 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_111 = happySpecReduce_1  2# happyReduction_111
happyReduction_111 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	happyIn12
		 (TokString happy_var_1
	)}

happyReduce_112 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_112 = happySpecReduce_1  2# happyReduction_112
happyReduction_112 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	happyIn12
		 (TokLiteral happy_var_1
	)}

happyReduce_113 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_113 = happySpecReduce_3  3# happyReduction_113
happyReduction_113 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut143 happy_x_2 of { (HappyWrap143 happy_var_2) -> 
	happyIn13
		 (takeOptionsPragmas happy_var_2
	)}

happyReduce_114 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_114 = happySpecReduce_0  4# happyReduction_114
happyReduction_114  =  happyIn14
		 (()
	)

happyReduce_115 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_115 = happySpecReduce_1  4# happyReduction_115
happyReduction_115 happy_x_1
	 =  happyIn14
		 (()
	)

happyReduce_116 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_116 = happySpecReduce_1  5# happyReduction_116
happyReduction_116 happy_x_1
	 =  happyIn15
		 (()
	)

happyReduce_117 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_117 = happyMonadReduce 1# 5# happyReduction_117
happyReduction_117 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((( popContext))
	) (\r -> happyReturn (happyIn15 r))

happyReduce_118 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_118 = happySpecReduce_1  6# happyReduction_118
happyReduction_118 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymSemi happy_var_1) -> 
	happyIn16
		 (happy_var_1
	)}

happyReduce_119 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_119 = happySpecReduce_1  6# happyReduction_119
happyReduction_119 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymVirtualSemi happy_var_1) -> 
	happyIn16
		 (happy_var_1
	)}

happyReduce_120 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_120 = happyMonadReduce 0# 7# happyReduction_120
happyReduction_120 (happyRest) tk
	 = happyThen ((( pushLexState imp_dir))
	) (\r -> happyReturn (happyIn17 r))

happyReduce_121 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_121 = happyMonadReduce 1# 8# happyReduction_121
happyReduction_121 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	( case happy_var_1 of
                   { LitNat   r i -> return $ Ranged r $ fromInteger i
                   ; LitFloat r i -> return $ Ranged r i
                   ; _            -> parseError $ "Expected floating point number"
                   })})
	) (\r -> happyReturn (happyIn18 r))

happyReduce_122 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_122 = happyMonadReduce 1# 9# happyReduction_122
happyReduction_122 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	( mkName happy_var_1)})
	) (\r -> happyReturn (happyIn19 r))

happyReduce_123 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_123 = happySpecReduce_2  10# happyReduction_123
happyReduction_123 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_1 of { (HappyWrap19 happy_var_1) -> 
	case happyOut20 happy_x_2 of { (HappyWrap20 happy_var_2) -> 
	happyIn20
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_124 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_124 = happySpecReduce_1  10# happyReduction_124
happyReduction_124 happy_x_1
	 =  case happyOut19 happy_x_1 of { (HappyWrap19 happy_var_1) -> 
	happyIn20
		 ([happy_var_1]
	)}

happyReduce_125 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_125 = happySpecReduce_1  11# happyReduction_125
happyReduction_125 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleCloseBrace happy_var_1) -> 
	happyIn21
		 (getRange happy_var_1
	)}

happyReduce_126 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_126 = happyMonadReduce 2# 11# happyReduction_126
happyReduction_126 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymCloseBrace happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseBrace happy_var_2) -> 
	(
      if posPos (fromJust (rEnd' (getRange happy_var_2))) -
         posPos (fromJust (rStart' (getRange happy_var_1))) > 2
      then parseErrorRange happy_var_2 "Expecting '}}', found separated '}'s."
      else return $ getRange (happy_var_1, happy_var_2))}})
	) (\r -> happyReturn (happyIn21 r))

happyReduce_127 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_127 = happySpecReduce_2  12# happyReduction_127
happyReduction_127 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	happyIn22
		 (setRelevance NonStrict $ defaultArg happy_var_2
	)}

happyReduce_128 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_128 = happySpecReduce_2  12# happyReduction_128
happyReduction_128 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	happyIn22
		 (setRelevance Irrelevant $ defaultArg happy_var_2
	)}

happyReduce_129 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_129 = happySpecReduce_1  12# happyReduction_129
happyReduction_129 happy_x_1
	 =  case happyOut19 happy_x_1 of { (HappyWrap19 happy_var_1) -> 
	happyIn22
		 (defaultArg happy_var_1
	)}

happyReduce_130 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_130 = happySpecReduce_2  13# happyReduction_130
happyReduction_130 happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_1 of { (HappyWrap22 happy_var_1) -> 
	case happyOut23 happy_x_2 of { (HappyWrap23 happy_var_2) -> 
	happyIn23
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_131 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_131 = happySpecReduce_1  13# happyReduction_131
happyReduction_131 happy_x_1
	 =  case happyOut22 happy_x_1 of { (HappyWrap22 happy_var_1) -> 
	happyIn23
		 ([happy_var_1]
	)}

happyReduce_132 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_132 = happySpecReduce_2  14# happyReduction_132
happyReduction_132 happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_1 of { (HappyWrap22 happy_var_1) -> 
	case happyOut24 happy_x_2 of { (HappyWrap24 happy_var_2) -> 
	happyIn24
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_133 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_133 = happySpecReduce_1  14# happyReduction_133
happyReduction_133 happy_x_1
	 =  case happyOut22 happy_x_1 of { (HappyWrap22 happy_var_1) -> 
	happyIn24
		 ([happy_var_1]
	)}

happyReduce_134 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_134 = happyReduce 4# 14# happyReduction_134
happyReduction_134 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut23 happy_x_2 of { (HappyWrap23 happy_var_2) -> 
	case happyOut24 happy_x_4 of { (HappyWrap24 happy_var_4) -> 
	happyIn24
		 (map makeInstance happy_var_2 ++ happy_var_4
	) `HappyStk` happyRest}}

happyReduce_135 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_135 = happySpecReduce_3  14# happyReduction_135
happyReduction_135 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_2 of { (HappyWrap23 happy_var_2) -> 
	happyIn24
		 (map makeInstance happy_var_2
	)}

happyReduce_136 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_136 = happyReduce 4# 14# happyReduction_136
happyReduction_136 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut23 happy_x_2 of { (HappyWrap23 happy_var_2) -> 
	case happyOut24 happy_x_4 of { (HappyWrap24 happy_var_4) -> 
	happyIn24
		 (map hide happy_var_2 ++ happy_var_4
	) `HappyStk` happyRest}}

happyReduce_137 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_137 = happySpecReduce_3  14# happyReduction_137
happyReduction_137 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_2 of { (HappyWrap23 happy_var_2) -> 
	happyIn24
		 (map hide happy_var_2
	)}

happyReduce_138 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_138 = happyReduce 5# 14# happyReduction_138
happyReduction_138 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { (HappyWrap20 happy_var_3) -> 
	case happyOut24 happy_x_5 of { (HappyWrap24 happy_var_5) -> 
	happyIn24
		 (map (hide . setRelevance Irrelevant . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_139 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_139 = happyReduce 4# 14# happyReduction_139
happyReduction_139 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { (HappyWrap20 happy_var_3) -> 
	happyIn24
		 (map (hide . setRelevance Irrelevant . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_140 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_140 = happyReduce 5# 14# happyReduction_140
happyReduction_140 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { (HappyWrap20 happy_var_3) -> 
	case happyOut24 happy_x_5 of { (HappyWrap24 happy_var_5) -> 
	happyIn24
		 (map (makeInstance . setRelevance Irrelevant . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_141 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_141 = happyReduce 4# 14# happyReduction_141
happyReduction_141 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { (HappyWrap20 happy_var_3) -> 
	happyIn24
		 (map (makeInstance . setRelevance Irrelevant . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_142 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_142 = happyReduce 5# 14# happyReduction_142
happyReduction_142 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { (HappyWrap20 happy_var_3) -> 
	case happyOut24 happy_x_5 of { (HappyWrap24 happy_var_5) -> 
	happyIn24
		 (map (hide . setRelevance NonStrict . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_143 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_143 = happyReduce 4# 14# happyReduction_143
happyReduction_143 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { (HappyWrap20 happy_var_3) -> 
	happyIn24
		 (map (hide . setRelevance NonStrict . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_144 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_144 = happyReduce 5# 14# happyReduction_144
happyReduction_144 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { (HappyWrap20 happy_var_3) -> 
	case happyOut24 happy_x_5 of { (HappyWrap24 happy_var_5) -> 
	happyIn24
		 (map (makeInstance . setRelevance NonStrict . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_145 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_145 = happyReduce 4# 14# happyReduction_145
happyReduction_145 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { (HappyWrap20 happy_var_3) -> 
	happyIn24
		 (map (makeInstance . setRelevance NonStrict . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_146 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_146 = happyMonadReduce 2# 15# happyReduction_146
happyReduction_146 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut27 happy_x_1 of { (HappyWrap27 happy_var_1) -> 
	case happyOut24 happy_x_2 of { (HappyWrap24 happy_var_2) -> 
	( (happy_var_1,) `fmap` mapM (applyAttrs happy_var_1) happy_var_2)}})
	) (\r -> happyReturn (happyIn25 r))

happyReduce_147 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_147 = happyMonadReduce 2# 16# happyReduction_147
happyReduction_147 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymAs happy_var_1) -> 
	case happyOut53 happy_x_2 of { (HappyWrap53 happy_var_2) -> 
	( setRange (getRange (happy_var_1,happy_var_2)) `fmap` toAttribute happy_var_2)}})
	) (\r -> happyReturn (happyIn26 r))

happyReduce_148 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_148 = happySpecReduce_0  17# happyReduction_148
happyReduction_148  =  happyIn27
		 ([]
	)

happyReduce_149 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_149 = happySpecReduce_2  17# happyReduction_149
happyReduction_149 happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { (HappyWrap27 happy_var_1) -> 
	case happyOut26 happy_x_2 of { (HappyWrap26 happy_var_2) -> 
	happyIn27
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_150 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_150 = happySpecReduce_1  18# happyReduction_150
happyReduction_150 happy_x_1
	 =  case happyOut26 happy_x_1 of { (HappyWrap26 happy_var_1) -> 
	happyIn28
		 ([happy_var_1]
	)}

happyReduce_151 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_151 = happySpecReduce_2  18# happyReduction_151
happyReduction_151 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { (HappyWrap28 happy_var_1) -> 
	case happyOut26 happy_x_2 of { (HappyWrap26 happy_var_2) -> 
	happyIn28
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_152 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_152 = happyMonadReduce 1# 19# happyReduction_152
happyReduction_152 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokQId happy_var_1) -> 
	( mkQName happy_var_1)})
	) (\r -> happyReturn (happyIn29 r))

happyReduce_153 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_153 = happySpecReduce_1  19# happyReduction_153
happyReduction_153 happy_x_1
	 =  case happyOut19 happy_x_1 of { (HappyWrap19 happy_var_1) -> 
	happyIn29
		 (QName happy_var_1
	)}

happyReduce_154 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_154 = happySpecReduce_1  20# happyReduction_154
happyReduction_154 happy_x_1
	 =  case happyOut29 happy_x_1 of { (HappyWrap29 happy_var_1) -> 
	happyIn30
		 (happy_var_1
	)}

happyReduce_155 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_155 = happySpecReduce_1  21# happyReduction_155
happyReduction_155 happy_x_1
	 =  case happyOut19 happy_x_1 of { (HappyWrap19 happy_var_1) -> 
	happyIn31
		 (happy_var_1
	)}

happyReduce_156 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_156 = happySpecReduce_1  21# happyReduction_156
happyReduction_156 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn31
		 (Name (getRange happy_var_1) InScope [Hole]
	)}

happyReduce_157 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_157 = happySpecReduce_2  22# happyReduction_157
happyReduction_157 happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_1 of { (HappyWrap31 happy_var_1) -> 
	case happyOut32 happy_x_2 of { (HappyWrap32 happy_var_2) -> 
	happyIn32
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_158 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_158 = happySpecReduce_1  22# happyReduction_158
happyReduction_158 happy_x_1
	 =  case happyOut31 happy_x_1 of { (HappyWrap31 happy_var_1) -> 
	happyIn32
		 ([happy_var_1]
	)}

happyReduce_159 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_159 = happyMonadReduce 1# 23# happyReduction_159
happyReduction_159 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut34 happy_x_1 of { (HappyWrap34 happy_var_1) -> 
	(
    case happy_var_1 of
      Left ns -> return ns
      Right _ -> parseError $ "expected sequence of bound identifiers, not absurd pattern")})
	) (\r -> happyReturn (happyIn33 r))

happyReduce_160 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_160 = happyMonadReduce 1# 24# happyReduction_160
happyReduction_160 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut45 happy_x_1 of { (HappyWrap45 happy_var_1) -> 
	( boundNamesOrAbsurd happy_var_1)})
	) (\r -> happyReturn (happyIn34 r))

happyReduce_161 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_161 = happyMonadReduce 3# 24# happyReduction_161
happyReduction_161 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut29 happy_x_1 of { (HappyWrap29 happy_var_1) -> 
	case happyOut29 happy_x_3 of { (HappyWrap29 happy_var_3) -> 
	( (Left . pure . updateNamedArg mkBinder) `fmap` mkNamedArg (Just happy_var_1) (Left happy_var_3))}})
	) (\r -> happyReturn (happyIn34 r))

happyReduce_162 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_162 = happyMonadReduce 3# 24# happyReduction_162
happyReduction_162 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut29 happy_x_3 of { (HappyWrap29 happy_var_3) -> 
	( (Left . pure . updateNamedArg mkBinder) `fmap` mkNamedArg Nothing   (Left happy_var_3))})
	) (\r -> happyReturn (happyIn34 r))

happyReduce_163 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_163 = happyMonadReduce 3# 24# happyReduction_163
happyReduction_163 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut29 happy_x_1 of { (HappyWrap29 happy_var_1) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymUnderscore happy_var_3) -> 
	( (Left . pure . updateNamedArg mkBinder) `fmap` mkNamedArg (Just happy_var_1) (Right $ getRange happy_var_3))}})
	) (\r -> happyReturn (happyIn34 r))

happyReduce_164 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_164 = happyMonadReduce 3# 24# happyReduction_164
happyReduction_164 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_3 of { (TokSymbol SymUnderscore happy_var_3) -> 
	( (Left . pure . updateNamedArg mkBinder) `fmap` mkNamedArg Nothing   (Right $ getRange happy_var_3))})
	) (\r -> happyReturn (happyIn34 r))

happyReduce_165 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_165 = happyMonadReduce 1# 25# happyReduction_165
happyReduction_165 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut45 happy_x_1 of { (HappyWrap45 happy_var_1) -> 
	(
  -- interpret an expression as a name and maybe a pattern
  case mapM exprAsNameOrHiddenNames happy_var_1 of
    Nothing   -> parseError "Expected sequence of possibly hidden bound identifiers"
    Just good -> forM (concat good) $ updateNamedArgA $ \ (n, me) -> do
                   p <- traverse exprToPattern me
                   pure $ Binder p (mkBoundName_ n))})
	) (\r -> happyReturn (happyIn35 r))

happyReduce_166 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_166 = happySpecReduce_0  26# happyReduction_166
happyReduction_166  =  happyIn36
		 ([]
	)

happyReduce_167 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_167 = happySpecReduce_2  26# happyReduction_167
happyReduction_167 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	case happyOut36 happy_x_2 of { (HappyWrap36 happy_var_2) -> 
	happyIn36
		 (snd happy_var_1 : happy_var_2
	)}}

happyReduce_168 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_168 = happySpecReduce_0  27# happyReduction_168
happyReduction_168  =  happyIn37
		 ([]
	)

happyReduce_169 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_169 = happySpecReduce_2  27# happyReduction_169
happyReduction_169 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	case happyOut37 happy_x_2 of { (HappyWrap37 happy_var_2) -> 
	happyIn37
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_170 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_170 = happySpecReduce_0  28# happyReduction_170
happyReduction_170  =  happyIn38
		 ([]
	)

happyReduce_171 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_171 = happySpecReduce_2  28# happyReduction_171
happyReduction_171 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	case happyOut38 happy_x_2 of { (HappyWrap38 happy_var_2) -> 
	happyIn38
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_172 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_172 = happyReduce 4# 28# happyReduction_172
happyReduction_172 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOut38 happy_x_2 of { (HappyWrap38 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	case happyOut38 happy_x_4 of { (HappyWrap38 happy_var_4) -> 
	happyIn38
		 ([(happy_var_1, "{-#")] ++ happy_var_2 ++ [(happy_var_3, "#-}")] ++ happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_173 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_173 = happyMonadReduce 1# 29# happyReduction_173
happyReduction_173 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	( mkName happy_var_1)})
	) (\r -> happyReturn (happyIn39 r))

happyReduce_174 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_174 = happyMonadReduce 1# 30# happyReduction_174
happyReduction_174 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	( pragmaQName happy_var_1)})
	) (\r -> happyReturn (happyIn40 r))

happyReduce_175 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_175 = happyMonadReduce 1# 31# happyReduction_175
happyReduction_175 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut37 happy_x_1 of { (HappyWrap37 happy_var_1) -> 
	( mapM pragmaQName happy_var_1)})
	) (\r -> happyReturn (happyIn41 r))

happyReduce_176 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_176 = happySpecReduce_2  32# happyReduction_176
happyReduction_176 happy_x_2
	happy_x_1
	 =  case happyOut62 happy_x_1 of { (HappyWrap62 happy_var_1) -> 
	case happyOut42 happy_x_2 of { (HappyWrap42 happy_var_2) -> 
	happyIn42
		 (Pi happy_var_1 happy_var_2
	)}}

happyReduce_177 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_177 = happySpecReduce_3  32# happyReduction_177
happyReduction_177 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { (HappyWrap49 happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymArrow happy_var_2) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	happyIn42
		 (Fun (getRange (happy_var_1,happy_var_2,happy_var_3))
                                              (defaultArg $ rawAppUnlessSingleton (getRange happy_var_1) happy_var_1)
                                              happy_var_3
	)}}}

happyReduce_178 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_178 = happyMonadReduce 4# 32# happyReduction_178
happyReduction_178 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut28 happy_x_1 of { (HappyWrap28 happy_var_1) -> 
	case happyOut49 happy_x_2 of { (HappyWrap49 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymArrow happy_var_3) -> 
	case happyOut42 happy_x_4 of { (HappyWrap42 happy_var_4) -> 
	( applyAttrs happy_var_1 (defaultArg $ rawAppUnlessSingleton (getRange (happy_var_1,happy_var_2)) happy_var_2) <&> \ dom ->
                                             Fun (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) dom happy_var_4)}}}})
	) (\r -> happyReturn (happyIn42 r))

happyReduce_179 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_179 = happySpecReduce_3  32# happyReduction_179
happyReduction_179 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_1 of { (HappyWrap43 happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymEqual happy_var_2) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	happyIn42
		 (Equal (getRange (happy_var_1, happy_var_2, happy_var_3)) happy_var_1 happy_var_3
	)}}}

happyReduce_180 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_180 = happySpecReduce_1  32# happyReduction_180
happyReduction_180 happy_x_1
	 =  case happyOut43 happy_x_1 of { (HappyWrap43 happy_var_1) -> 
	happyIn42
		 (happy_var_1
	)}

happyReduce_181 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_181 = happyMonadReduce 1# 33# happyReduction_181
happyReduction_181 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut44 happy_x_1 of { (HappyWrap44 happy_var_1) -> 
	( case happy_var_1 of
                      { [e]    -> return e
                      ; e : es -> return $ WithApp (fuseRange e es) e es
                      ; []     -> parseError "impossible: empty with expressions"
                      })})
	) (\r -> happyReturn (happyIn43 r))

happyReduce_182 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_182 = happySpecReduce_3  34# happyReduction_182
happyReduction_182 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { (HappyWrap49 happy_var_1) -> 
	case happyOut44 happy_x_3 of { (HappyWrap44 happy_var_3) -> 
	happyIn44
		 (RawApp (getRange happy_var_1) happy_var_1 :  happy_var_3
	)}}

happyReduce_183 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_183 = happySpecReduce_1  34# happyReduction_183
happyReduction_183 happy_x_1
	 =  case happyOut45 happy_x_1 of { (HappyWrap45 happy_var_1) -> 
	happyIn44
		 ([RawApp (getRange happy_var_1) happy_var_1]
	)}

happyReduce_184 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_184 = happySpecReduce_1  35# happyReduction_184
happyReduction_184 happy_x_1
	 =  case happyOut46 happy_x_1 of { (HappyWrap46 happy_var_1) -> 
	happyIn45
		 ([happy_var_1]
	)}

happyReduce_185 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_185 = happySpecReduce_2  35# happyReduction_185
happyReduction_185 happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { (HappyWrap54 happy_var_1) -> 
	case happyOut45 happy_x_2 of { (HappyWrap45 happy_var_2) -> 
	happyIn45
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_186 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_186 = happySpecReduce_3  36# happyReduction_186
happyReduction_186 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOut70 happy_x_2 of { (HappyWrap70 happy_var_2) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	happyIn46
		 (Lam (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2 happy_var_3
	)}}}

happyReduce_187 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_187 = happySpecReduce_1  36# happyReduction_187
happyReduction_187 happy_x_1
	 =  case happyOut48 happy_x_1 of { (HappyWrap48 happy_var_1) -> 
	happyIn46
		 (happy_var_1
	)}

happyReduce_188 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_188 = happySpecReduce_3  36# happyReduction_188
happyReduction_188 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut79 happy_x_2 of { (HappyWrap79 happy_var_2) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	happyIn46
		 (forallPi happy_var_2 happy_var_3
	)}}

happyReduce_189 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_189 = happySpecReduce_3  36# happyReduction_189
happyReduction_189 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwLet happy_var_1) -> 
	case happyOut183 happy_x_2 of { (HappyWrap183 happy_var_2) -> 
	case happyOut47 happy_x_3 of { (HappyWrap47 happy_var_3) -> 
	happyIn46
		 (Let (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2 happy_var_3
	)}}}

happyReduce_190 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_190 = happyReduce 4# 36# happyReduction_190
happyReduction_190 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwDo happy_var_1) -> 
	case happyOut85 happy_x_3 of { (HappyWrap85 happy_var_3) -> 
	happyIn46
		 (DoBlock (getRange (happy_var_1, happy_var_3)) happy_var_3
	) `HappyStk` happyRest}}

happyReduce_191 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_191 = happySpecReduce_1  36# happyReduction_191
happyReduction_191 happy_x_1
	 =  case happyOut54 happy_x_1 of { (HappyWrap54 happy_var_1) -> 
	happyIn46
		 (happy_var_1
	)}

happyReduce_192 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_192 = happySpecReduce_2  36# happyReduction_192
happyReduction_192 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTactic happy_var_1) -> 
	case happyOut49 happy_x_2 of { (HappyWrap49 happy_var_2) -> 
	happyIn46
		 (Tactic (getRange (happy_var_1, happy_var_2)) (RawApp (getRange happy_var_2) happy_var_2)
	)}}

happyReduce_193 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_193 = happySpecReduce_2  37# happyReduction_193
happyReduction_193 happy_x_2
	happy_x_1
	 =  case happyOut42 happy_x_2 of { (HappyWrap42 happy_var_2) -> 
	happyIn47
		 (Just happy_var_2
	)}

happyReduce_194 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_194 = happySpecReduce_0  37# happyReduction_194
happyReduction_194  =  happyIn47
		 (Nothing
	)

happyReduce_195 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_195 = happyReduce 4# 38# happyReduction_195
happyReduction_195 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut77 happy_x_3 of { (HappyWrap77 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn48
		 (ExtendedLam (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) (reverse happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_196 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_196 = happyReduce 5# 38# happyReduction_196
happyReduction_196 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwWhere happy_var_2) -> 
	case happyOut78 happy_x_4 of { (HappyWrap78 happy_var_4) -> 
	happyIn48
		 (ExtendedLam (getRange (happy_var_1, happy_var_2, happy_var_4)) (reverse happy_var_4)
	) `HappyStk` happyRest}}}

happyReduce_197 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_197 = happyMonadReduce 2# 38# happyReduction_197
happyReduction_197 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOut71 happy_x_2 of { (HappyWrap71 happy_var_2) -> 
	( case happy_var_2 of
                                       Left (bs, h) -> if null bs then return $ AbsurdLam r h else
                                                       return $ Lam r bs (AbsurdLam r h)
                                                         where r = fuseRange happy_var_1 bs
                                       Right es -> do -- it is of the form @\ { p1 ... () }@
                                                     p <- exprToLHS (RawApp (getRange es) es);
                                                     return $ ExtendedLam (fuseRange happy_var_1 es)
                                                                     [LamClause (p [] []) AbsurdRHS NoWhere False])}})
	) (\r -> happyReturn (happyIn48 r))

happyReduce_198 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_198 = happySpecReduce_1  39# happyReduction_198
happyReduction_198 happy_x_1
	 =  case happyOut54 happy_x_1 of { (HappyWrap54 happy_var_1) -> 
	happyIn49
		 ([happy_var_1]
	)}

happyReduce_199 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_199 = happySpecReduce_2  39# happyReduction_199
happyReduction_199 happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { (HappyWrap54 happy_var_1) -> 
	case happyOut49 happy_x_2 of { (HappyWrap49 happy_var_2) -> 
	happyIn49
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_200 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_200 = happySpecReduce_0  40# happyReduction_200
happyReduction_200  =  happyIn50
		 ([]
	)

happyReduce_201 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_201 = happySpecReduce_2  40# happyReduction_201
happyReduction_201 happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { (HappyWrap54 happy_var_1) -> 
	case happyOut50 happy_x_2 of { (HappyWrap50 happy_var_2) -> 
	happyIn50
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_202 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_202 = happyMonadReduce 3# 41# happyReduction_202
happyReduction_202 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOut42 happy_x_2 of { (HappyWrap42 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseBrace happy_var_3) -> 
	( HiddenArg (getRange (happy_var_1,happy_var_2,happy_var_3)) `fmap` maybeNamed happy_var_2)}}})
	) (\r -> happyReturn (happyIn51 r))

happyReduce_203 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_203 = happySpecReduce_2  41# happyReduction_203
happyReduction_203 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseBrace happy_var_2) -> 
	happyIn51
		 (let r = fuseRange happy_var_1 happy_var_2 in HiddenArg r $ unnamed $ Absurd r
	)}}

happyReduce_204 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_204 = happySpecReduce_1  42# happyReduction_204
happyReduction_204 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymQuestionMark happy_var_1) -> 
	happyIn52
		 (QuestionMark (getRange happy_var_1) Nothing
	)}

happyReduce_205 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_205 = happySpecReduce_1  42# happyReduction_205
happyReduction_205 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn52
		 (Underscore (getRange happy_var_1) Nothing
	)}

happyReduce_206 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_206 = happySpecReduce_1  42# happyReduction_206
happyReduction_206 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwProp happy_var_1) -> 
	happyIn52
		 (Prop (getRange happy_var_1)
	)}

happyReduce_207 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_207 = happySpecReduce_1  42# happyReduction_207
happyReduction_207 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSet happy_var_1) -> 
	happyIn52
		 (Set (getRange happy_var_1)
	)}

happyReduce_208 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_208 = happySpecReduce_1  42# happyReduction_208
happyReduction_208 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuote happy_var_1) -> 
	happyIn52
		 (Quote (getRange happy_var_1)
	)}

happyReduce_209 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_209 = happySpecReduce_1  42# happyReduction_209
happyReduction_209 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteTerm happy_var_1) -> 
	happyIn52
		 (QuoteTerm (getRange happy_var_1)
	)}

happyReduce_210 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_210 = happySpecReduce_1  42# happyReduction_210
happyReduction_210 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquote happy_var_1) -> 
	happyIn52
		 (Unquote (getRange happy_var_1)
	)}

happyReduce_211 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_211 = happySpecReduce_1  42# happyReduction_211
happyReduction_211 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSetN happy_var_1) -> 
	happyIn52
		 (SetN (getRange (fst happy_var_1)) (snd happy_var_1)
	)}

happyReduce_212 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_212 = happySpecReduce_1  42# happyReduction_212
happyReduction_212 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokPropN happy_var_1) -> 
	happyIn52
		 (PropN (getRange (fst happy_var_1)) (snd happy_var_1)
	)}

happyReduce_213 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_213 = happyMonadReduce 3# 42# happyReduction_213
happyReduction_213 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut42 happy_x_2 of { (HappyWrap42 happy_var_2) -> 
	case happyOut21 happy_x_3 of { (HappyWrap21 happy_var_3) -> 
	( InstanceArg (getRange (happy_var_1,happy_var_2,happy_var_3)) `fmap` maybeNamed happy_var_2)}}})
	) (\r -> happyReturn (happyIn52 r))

happyReduce_214 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_214 = happySpecReduce_3  42# happyReduction_214
happyReduction_214 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenIdiomBracket happy_var_1) -> 
	case happyOut44 happy_x_2 of { (HappyWrap44 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseIdiomBracket happy_var_3) -> 
	happyIn52
		 (IdiomBrackets (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_215 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_215 = happySpecReduce_1  42# happyReduction_215
happyReduction_215 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEmptyIdiomBracket happy_var_1) -> 
	happyIn52
		 (IdiomBrackets (getRange happy_var_1) []
	)}

happyReduce_216 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_216 = happySpecReduce_2  42# happyReduction_216
happyReduction_216 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseParen happy_var_2) -> 
	happyIn52
		 (Absurd (fuseRange happy_var_1 happy_var_2)
	)}}

happyReduce_217 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_217 = happySpecReduce_2  42# happyReduction_217
happyReduction_217 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut21 happy_x_2 of { (HappyWrap21 happy_var_2) -> 
	happyIn52
		 (let r = fuseRange happy_var_1 happy_var_2 in InstanceArg r $ unnamed $ Absurd r
	)}}

happyReduce_218 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_218 = happySpecReduce_3  42# happyReduction_218
happyReduction_218 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_1 of { (HappyWrap19 happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymAs happy_var_2) -> 
	case happyOut54 happy_x_3 of { (HappyWrap54 happy_var_3) -> 
	happyIn52
		 (As (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_1 happy_var_3
	)}}}

happyReduce_219 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_219 = happySpecReduce_2  42# happyReduction_219
happyReduction_219 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDot happy_var_1) -> 
	case happyOut54 happy_x_2 of { (HappyWrap54 happy_var_2) -> 
	happyIn52
		 (Dot (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_220 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_220 = happySpecReduce_2  42# happyReduction_220
happyReduction_220 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDotDot happy_var_1) -> 
	case happyOut54 happy_x_2 of { (HappyWrap54 happy_var_2) -> 
	happyIn52
		 (DoubleDot (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_221 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_221 = happyReduce 4# 42# happyReduction_221
happyReduction_221 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut55 happy_x_3 of { (HappyWrap55 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn52
		 (Rec (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_222 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_222 = happyReduce 5# 42# happyReduction_222
happyReduction_222 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut52 happy_x_2 of { (HappyWrap52 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymOpenBrace happy_var_3) -> 
	case happyOut59 happy_x_4 of { (HappyWrap59 happy_var_4) -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymCloseBrace happy_var_5) -> 
	happyIn52
		 (RecUpdate (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_223 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_223 = happySpecReduce_1  42# happyReduction_223
happyReduction_223 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEllipsis happy_var_1) -> 
	happyIn52
		 (Ellipsis (getRange happy_var_1)
	)}

happyReduce_224 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_224 = happySpecReduce_1  42# happyReduction_224
happyReduction_224 happy_x_1
	 =  case happyOut53 happy_x_1 of { (HappyWrap53 happy_var_1) -> 
	happyIn52
		 (happy_var_1
	)}

happyReduce_225 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_225 = happySpecReduce_1  43# happyReduction_225
happyReduction_225 happy_x_1
	 =  case happyOut29 happy_x_1 of { (HappyWrap29 happy_var_1) -> 
	happyIn53
		 (Ident happy_var_1
	)}

happyReduce_226 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_226 = happySpecReduce_1  43# happyReduction_226
happyReduction_226 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	happyIn53
		 (Lit happy_var_1
	)}

happyReduce_227 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_227 = happySpecReduce_3  43# happyReduction_227
happyReduction_227 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut42 happy_x_2 of { (HappyWrap42 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn53
		 (Paren (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_228 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_228 = happySpecReduce_1  44# happyReduction_228
happyReduction_228 happy_x_1
	 =  case happyOut51 happy_x_1 of { (HappyWrap51 happy_var_1) -> 
	happyIn54
		 (happy_var_1
	)}

happyReduce_229 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_229 = happySpecReduce_1  44# happyReduction_229
happyReduction_229 happy_x_1
	 =  case happyOut52 happy_x_1 of { (HappyWrap52 happy_var_1) -> 
	happyIn54
		 (happy_var_1
	)}

happyReduce_230 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_230 = happySpecReduce_0  45# happyReduction_230
happyReduction_230  =  happyIn55
		 ([]
	)

happyReduce_231 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_231 = happySpecReduce_1  45# happyReduction_231
happyReduction_231 happy_x_1
	 =  case happyOut56 happy_x_1 of { (HappyWrap56 happy_var_1) -> 
	happyIn55
		 (happy_var_1
	)}

happyReduce_232 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_232 = happySpecReduce_1  46# happyReduction_232
happyReduction_232 happy_x_1
	 =  case happyOut57 happy_x_1 of { (HappyWrap57 happy_var_1) -> 
	happyIn56
		 ([happy_var_1]
	)}

happyReduce_233 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_233 = happySpecReduce_3  46# happyReduction_233
happyReduction_233 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { (HappyWrap57 happy_var_1) -> 
	case happyOut56 happy_x_3 of { (HappyWrap56 happy_var_3) -> 
	happyIn56
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_234 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_234 = happySpecReduce_1  47# happyReduction_234
happyReduction_234 happy_x_1
	 =  case happyOut61 happy_x_1 of { (HappyWrap61 happy_var_1) -> 
	happyIn57
		 (Left  happy_var_1
	)}

happyReduce_235 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_235 = happySpecReduce_1  47# happyReduction_235
happyReduction_235 happy_x_1
	 =  case happyOut58 happy_x_1 of { (HappyWrap58 happy_var_1) -> 
	happyIn57
		 (Right happy_var_1
	)}

happyReduce_236 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_236 = happySpecReduce_3  48# happyReduction_236
happyReduction_236 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_1 of { (HappyWrap30 happy_var_1) -> 
	case happyOut138 happy_x_2 of { (HappyWrap138 happy_var_2) -> 
	case happyOut88 happy_x_3 of { (HappyWrap88 happy_var_3) -> 
	happyIn58
		 (ModuleAssignment happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_237 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_237 = happySpecReduce_0  49# happyReduction_237
happyReduction_237  =  happyIn59
		 ([]
	)

happyReduce_238 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_238 = happySpecReduce_1  49# happyReduction_238
happyReduction_238 happy_x_1
	 =  case happyOut60 happy_x_1 of { (HappyWrap60 happy_var_1) -> 
	happyIn59
		 (happy_var_1
	)}

happyReduce_239 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_239 = happySpecReduce_1  50# happyReduction_239
happyReduction_239 happy_x_1
	 =  case happyOut61 happy_x_1 of { (HappyWrap61 happy_var_1) -> 
	happyIn60
		 ([happy_var_1]
	)}

happyReduce_240 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_240 = happySpecReduce_3  50# happyReduction_240
happyReduction_240 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_1 of { (HappyWrap61 happy_var_1) -> 
	case happyOut60 happy_x_3 of { (HappyWrap60 happy_var_3) -> 
	happyIn60
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_241 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_241 = happySpecReduce_3  51# happyReduction_241
happyReduction_241 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_1 of { (HappyWrap19 happy_var_1) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	happyIn61
		 (FieldAssignment happy_var_1 happy_var_3
	)}}

happyReduce_242 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_242 = happySpecReduce_2  52# happyReduction_242
happyReduction_242 happy_x_2
	happy_x_1
	 =  case happyOut63 happy_x_1 of { (HappyWrap63 happy_var_1) -> 
	happyIn62
		 (happy_var_1
	)}

happyReduce_243 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_243 = happySpecReduce_1  53# happyReduction_243
happyReduction_243 happy_x_1
	 =  case happyOut64 happy_x_1 of { (HappyWrap64 happy_var_1) -> 
	happyIn63
		 (happy_var_1
	)}

happyReduce_244 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_244 = happySpecReduce_2  54# happyReduction_244
happyReduction_244 happy_x_2
	happy_x_1
	 =  case happyOut65 happy_x_1 of { (HappyWrap65 happy_var_1) -> 
	case happyOut64 happy_x_2 of { (HappyWrap64 happy_var_2) -> 
	happyIn64
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_245 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_245 = happySpecReduce_1  54# happyReduction_245
happyReduction_245 happy_x_1
	 =  case happyOut65 happy_x_1 of { (HappyWrap65 happy_var_1) -> 
	happyIn64
		 ([happy_var_1]
	)}

happyReduce_246 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_246 = happyReduce 4# 55# happyReduction_246
happyReduction_246 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut68 happy_x_3 of { (HappyWrap68 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn65
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setRelevance Irrelevant happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_247 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_247 = happyReduce 4# 55# happyReduction_247
happyReduction_247 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut66 happy_x_3 of { (HappyWrap66 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn65
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setHiding Hidden $
                             setRelevance Irrelevant happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_248 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_248 = happyReduce 4# 55# happyReduction_248
happyReduction_248 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOut66 happy_x_3 of { (HappyWrap66 happy_var_3) -> 
	case happyOut21 happy_x_4 of { (HappyWrap21 happy_var_4) -> 
	happyIn65
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             makeInstance $
                             setRelevance Irrelevant happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_249 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_249 = happyReduce 4# 55# happyReduction_249
happyReduction_249 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut68 happy_x_3 of { (HappyWrap68 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn65
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setRelevance NonStrict happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_250 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_250 = happyReduce 4# 55# happyReduction_250
happyReduction_250 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut66 happy_x_3 of { (HappyWrap66 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn65
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setHiding Hidden $
                             setRelevance NonStrict happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_251 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_251 = happyReduce 4# 55# happyReduction_251
happyReduction_251 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOut66 happy_x_3 of { (HappyWrap66 happy_var_3) -> 
	case happyOut21 happy_x_4 of { (HappyWrap21 happy_var_4) -> 
	happyIn65
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             makeInstance $
                             setRelevance NonStrict happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_252 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_252 = happySpecReduce_3  55# happyReduction_252
happyReduction_252 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut68 happy_x_2 of { (HappyWrap68 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn65
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_253 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_253 = happySpecReduce_3  55# happyReduction_253
happyReduction_253 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut69 happy_x_2 of { (HappyWrap69 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn65
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_254 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_254 = happySpecReduce_3  55# happyReduction_254
happyReduction_254 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut66 happy_x_2 of { (HappyWrap66 happy_var_2) -> 
	case happyOut21 happy_x_3 of { (HappyWrap21 happy_var_3) -> 
	happyIn65
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) $
                             makeInstance happy_var_2
	)}}}

happyReduce_255 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_255 = happySpecReduce_3  55# happyReduction_255
happyReduction_255 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut67 happy_x_2 of { (HappyWrap67 happy_var_2) -> 
	case happyOut21 happy_x_3 of { (HappyWrap21 happy_var_3) -> 
	happyIn65
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) $
                             makeInstance happy_var_2
	)}}}

happyReduce_256 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_256 = happySpecReduce_3  55# happyReduction_256
happyReduction_256 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOut66 happy_x_2 of { (HappyWrap66 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseBrace happy_var_3) -> 
	happyIn65
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) $
                             setHiding Hidden happy_var_2
	)}}}

happyReduce_257 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_257 = happySpecReduce_3  55# happyReduction_257
happyReduction_257 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOut67 happy_x_2 of { (HappyWrap67 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseBrace happy_var_3) -> 
	happyIn65
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) $
                             setHiding Hidden happy_var_2
	)}}}

happyReduce_258 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_258 = happySpecReduce_3  55# happyReduction_258
happyReduction_258 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut137 happy_x_2 of { (HappyWrap137 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn65
		 (TLet (getRange (happy_var_1,happy_var_3)) happy_var_2
	)}}}

happyReduce_259 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_259 = happyReduce 4# 55# happyReduction_259
happyReduction_259 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut183 happy_x_3 of { (HappyWrap183 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn65
		 (TLet (getRange (happy_var_1,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_260 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_260 = happySpecReduce_3  56# happyReduction_260
happyReduction_260 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut33 happy_x_1 of { (HappyWrap33 happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymColon happy_var_2) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	happyIn66
		 (let r = getRange (happy_var_1,happy_var_2,happy_var_3) -- the range is approximate only for TypedBindings
    in TBind r happy_var_1 happy_var_3
	)}}}

happyReduce_261 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_261 = happyMonadReduce 4# 57# happyReduction_261
happyReduction_261 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut28 happy_x_1 of { (HappyWrap28 happy_var_1) -> 
	case happyOut33 happy_x_2 of { (HappyWrap33 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymColon happy_var_3) -> 
	case happyOut42 happy_x_4 of { (HappyWrap42 happy_var_4) -> 
	( do
    let r = getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4) -- the range is approximate only for TypedBindings
    xs <- mapM (applyAttrs happy_var_1 . setTacticAttr happy_var_1) happy_var_2
    return $ TBind r xs happy_var_4)}}}})
	) (\r -> happyReturn (happyIn67 r))

happyReduce_262 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_262 = happySpecReduce_3  58# happyReduction_262
happyReduction_262 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut35 happy_x_1 of { (HappyWrap35 happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymColon happy_var_2) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	happyIn68
		 (let r = getRange (happy_var_1,happy_var_2,happy_var_3) -- the range is approximate only for TypedBindings
    in TBind r happy_var_1 happy_var_3
	)}}}

happyReduce_263 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_263 = happyMonadReduce 4# 59# happyReduction_263
happyReduction_263 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut28 happy_x_1 of { (HappyWrap28 happy_var_1) -> 
	case happyOut35 happy_x_2 of { (HappyWrap35 happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymColon happy_var_3) -> 
	case happyOut42 happy_x_4 of { (HappyWrap42 happy_var_4) -> 
	( do
    let r = getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4) -- the range is approximate only for TypedBindings
    xs <- mapM (applyAttrs happy_var_1 . setTacticAttr happy_var_1) happy_var_2
    return $ TBind r xs happy_var_4)}}}})
	) (\r -> happyReturn (happyIn69 r))

happyReduce_264 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_264 = happyMonadReduce 2# 60# happyReduction_264
happyReduction_264 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut72 happy_x_1 of { (HappyWrap72 happy_var_1) -> 
	(
      case reverse happy_var_1 of
        Left _ : _ -> parseError "Absurd lambda cannot have a body."
        _ : _      -> return [ b | Right b <- happy_var_1 ]
        []         -> parsePanic "Empty LamBinds")})
	) (\r -> happyReturn (happyIn70 r))

happyReduce_265 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_265 = happyMonadReduce 1# 61# happyReduction_265
happyReduction_265 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut73 happy_x_1 of { (HappyWrap73 happy_var_1) -> 
	(
    case happy_var_1 of
      Left lb -> case reverse lb of
                   Right _ : _ -> parseError "Missing body for lambda"
                   Left h  : _ -> return $ Left ([ b | Right b <- init lb], h)
                   _           -> parseError "Unsupported variant of lambda"
      Right es -> return $ Right es)})
	) (\r -> happyReturn (happyIn71 r))

happyReduce_266 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_266 = happySpecReduce_2  62# happyReduction_266
happyReduction_266 happy_x_2
	happy_x_1
	 =  case happyOut82 happy_x_1 of { (HappyWrap82 happy_var_1) -> 
	case happyOut72 happy_x_2 of { (HappyWrap72 happy_var_2) -> 
	happyIn72
		 (map Right happy_var_1 ++ happy_var_2
	)}}

happyReduce_267 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_267 = happySpecReduce_2  62# happyReduction_267
happyReduction_267 happy_x_2
	happy_x_1
	 =  case happyOut65 happy_x_1 of { (HappyWrap65 happy_var_1) -> 
	case happyOut72 happy_x_2 of { (HappyWrap72 happy_var_2) -> 
	happyIn72
		 (Right (DomainFull happy_var_1) : happy_var_2
	)}}

happyReduce_268 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_268 = happySpecReduce_1  62# happyReduction_268
happyReduction_268 happy_x_1
	 =  case happyOut82 happy_x_1 of { (HappyWrap82 happy_var_1) -> 
	happyIn72
		 (map Right happy_var_1
	)}

happyReduce_269 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_269 = happySpecReduce_1  62# happyReduction_269
happyReduction_269 happy_x_1
	 =  case happyOut65 happy_x_1 of { (HappyWrap65 happy_var_1) -> 
	happyIn72
		 ([Right $ DomainFull happy_var_1]
	)}

happyReduce_270 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_270 = happySpecReduce_2  62# happyReduction_270
happyReduction_270 happy_x_2
	happy_x_1
	 =  happyIn72
		 ([Left NotHidden]
	)

happyReduce_271 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_271 = happySpecReduce_2  62# happyReduction_271
happyReduction_271 happy_x_2
	happy_x_1
	 =  happyIn72
		 ([Left Hidden]
	)

happyReduce_272 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_272 = happySpecReduce_2  62# happyReduction_272
happyReduction_272 happy_x_2
	happy_x_1
	 =  happyIn72
		 ([Left (Instance NoOverlap)]
	)

happyReduce_273 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_273 = happySpecReduce_2  63# happyReduction_273
happyReduction_273 happy_x_2
	happy_x_1
	 =  case happyOut82 happy_x_1 of { (HappyWrap82 happy_var_1) -> 
	case happyOut72 happy_x_2 of { (HappyWrap72 happy_var_2) -> 
	happyIn73
		 (Left $ map Right happy_var_1 ++ happy_var_2
	)}}

happyReduce_274 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_274 = happySpecReduce_2  63# happyReduction_274
happyReduction_274 happy_x_2
	happy_x_1
	 =  case happyOut65 happy_x_1 of { (HappyWrap65 happy_var_1) -> 
	case happyOut72 happy_x_2 of { (HappyWrap72 happy_var_2) -> 
	happyIn73
		 (Left $ Right (DomainFull happy_var_1) : happy_var_2
	)}}

happyReduce_275 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_275 = happySpecReduce_1  63# happyReduction_275
happyReduction_275 happy_x_1
	 =  case happyOut84 happy_x_1 of { (HappyWrap84 happy_var_1) -> 
	happyIn73
		 (case happy_var_1 of
                                    Left lb -> Left $ map Right lb
                                    Right es -> Right es
	)}

happyReduce_276 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_276 = happySpecReduce_1  63# happyReduction_276
happyReduction_276 happy_x_1
	 =  case happyOut65 happy_x_1 of { (HappyWrap65 happy_var_1) -> 
	happyIn73
		 (Left [Right $ DomainFull happy_var_1]
	)}

happyReduce_277 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_277 = happySpecReduce_2  63# happyReduction_277
happyReduction_277 happy_x_2
	happy_x_1
	 =  happyIn73
		 (Left [Left NotHidden]
	)

happyReduce_278 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_278 = happySpecReduce_2  63# happyReduction_278
happyReduction_278 happy_x_2
	happy_x_1
	 =  happyIn73
		 (Left [Left Hidden]
	)

happyReduce_279 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_279 = happySpecReduce_2  63# happyReduction_279
happyReduction_279 happy_x_2
	happy_x_1
	 =  happyIn73
		 (Left [Left (Instance NoOverlap)]
	)

happyReduce_280 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_280 = happyMonadReduce 3# 64# happyReduction_280
happyReduction_280 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut50 happy_x_1 of { (HappyWrap50 happy_var_1) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_1) happy_var_1) ;
      return LamClause{ lamLHS      = p [] []
                      , lamRHS      = RHS happy_var_3
                      , lamWhere    = NoWhere
                      , lamCatchAll = False })}})
	) (\r -> happyReturn (happyIn74 r))

happyReduce_281 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_281 = happyMonadReduce 4# 64# happyReduction_281
happyReduction_281 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut50 happy_x_2 of { (HappyWrap50 happy_var_2) -> 
	case happyOut42 happy_x_4 of { (HappyWrap42 happy_var_4) -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_2) happy_var_2) ;
      return LamClause{ lamLHS      = p [] []
                      , lamRHS      = RHS happy_var_4
                      , lamWhere    = NoWhere
                      , lamCatchAll = True })}})
	) (\r -> happyReturn (happyIn74 r))

happyReduce_282 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_282 = happyMonadReduce 1# 65# happyReduction_282
happyReduction_282 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut45 happy_x_1 of { (HappyWrap45 happy_var_1) -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_1) happy_var_1);
      return LamClause{ lamLHS      = p [] []
                      , lamRHS      = AbsurdRHS
                      , lamWhere    = NoWhere
                      , lamCatchAll = False })})
	) (\r -> happyReturn (happyIn75 r))

happyReduce_283 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_283 = happyMonadReduce 2# 65# happyReduction_283
happyReduction_283 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut45 happy_x_2 of { (HappyWrap45 happy_var_2) -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_2) happy_var_2);
      return LamClause{ lamLHS      = p [] []
                      , lamRHS      = AbsurdRHS
                      , lamWhere    = NoWhere
                      , lamCatchAll = True })})
	) (\r -> happyReturn (happyIn75 r))

happyReduce_284 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_284 = happySpecReduce_1  66# happyReduction_284
happyReduction_284 happy_x_1
	 =  case happyOut74 happy_x_1 of { (HappyWrap74 happy_var_1) -> 
	happyIn76
		 (happy_var_1
	)}

happyReduce_285 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_285 = happySpecReduce_1  66# happyReduction_285
happyReduction_285 happy_x_1
	 =  case happyOut75 happy_x_1 of { (HappyWrap75 happy_var_1) -> 
	happyIn76
		 (happy_var_1
	)}

happyReduce_286 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_286 = happySpecReduce_3  67# happyReduction_286
happyReduction_286 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut77 happy_x_1 of { (HappyWrap77 happy_var_1) -> 
	case happyOut76 happy_x_3 of { (HappyWrap76 happy_var_3) -> 
	happyIn77
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_287 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_287 = happySpecReduce_3  67# happyReduction_287
happyReduction_287 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut75 happy_x_1 of { (HappyWrap75 happy_var_1) -> 
	case happyOut76 happy_x_3 of { (HappyWrap76 happy_var_3) -> 
	happyIn77
		 ([happy_var_3, happy_var_1]
	)}}

happyReduce_288 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_288 = happySpecReduce_1  67# happyReduction_288
happyReduction_288 happy_x_1
	 =  case happyOut74 happy_x_1 of { (HappyWrap74 happy_var_1) -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_289 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_289 = happySpecReduce_3  68# happyReduction_289
happyReduction_289 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut78 happy_x_1 of { (HappyWrap78 happy_var_1) -> 
	case happyOut76 happy_x_3 of { (HappyWrap76 happy_var_3) -> 
	happyIn78
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_290 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_290 = happySpecReduce_1  68# happyReduction_290
happyReduction_290 happy_x_1
	 =  case happyOut76 happy_x_1 of { (HappyWrap76 happy_var_1) -> 
	happyIn78
		 ([happy_var_1]
	)}

happyReduce_291 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_291 = happySpecReduce_2  69# happyReduction_291
happyReduction_291 happy_x_2
	happy_x_1
	 =  case happyOut80 happy_x_1 of { (HappyWrap80 happy_var_1) -> 
	happyIn79
		 (happy_var_1
	)}

happyReduce_292 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_292 = happySpecReduce_2  70# happyReduction_292
happyReduction_292 happy_x_2
	happy_x_1
	 =  case happyOut82 happy_x_1 of { (HappyWrap82 happy_var_1) -> 
	case happyOut80 happy_x_2 of { (HappyWrap80 happy_var_2) -> 
	happyIn80
		 (happy_var_1 ++ happy_var_2
	)}}

happyReduce_293 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_293 = happySpecReduce_2  70# happyReduction_293
happyReduction_293 happy_x_2
	happy_x_1
	 =  case happyOut65 happy_x_1 of { (HappyWrap65 happy_var_1) -> 
	case happyOut80 happy_x_2 of { (HappyWrap80 happy_var_2) -> 
	happyIn80
		 (DomainFull happy_var_1 : happy_var_2
	)}}

happyReduce_294 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_294 = happySpecReduce_1  70# happyReduction_294
happyReduction_294 happy_x_1
	 =  case happyOut82 happy_x_1 of { (HappyWrap82 happy_var_1) -> 
	happyIn80
		 (happy_var_1
	)}

happyReduce_295 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_295 = happySpecReduce_1  70# happyReduction_295
happyReduction_295 happy_x_1
	 =  case happyOut65 happy_x_1 of { (HappyWrap65 happy_var_1) -> 
	happyIn80
		 ([DomainFull happy_var_1]
	)}

happyReduce_296 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_296 = happySpecReduce_2  71# happyReduction_296
happyReduction_296 happy_x_2
	happy_x_1
	 =  case happyOut82 happy_x_1 of { (HappyWrap82 happy_var_1) -> 
	case happyOut81 happy_x_2 of { (HappyWrap81 happy_var_2) -> 
	happyIn81
		 (happy_var_1 ++ happy_var_2
	)}}

happyReduce_297 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_297 = happySpecReduce_2  71# happyReduction_297
happyReduction_297 happy_x_2
	happy_x_1
	 =  case happyOut65 happy_x_1 of { (HappyWrap65 happy_var_1) -> 
	case happyOut81 happy_x_2 of { (HappyWrap81 happy_var_2) -> 
	happyIn81
		 (DomainFull happy_var_1 : happy_var_2
	)}}

happyReduce_298 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_298 = happySpecReduce_0  71# happyReduction_298
happyReduction_298  =  happyIn81
		 ([]
	)

happyReduce_299 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_299 = happyMonadReduce 1# 72# happyReduction_299
happyReduction_299 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut84 happy_x_1 of { (HappyWrap84 happy_var_1) -> 
	( case happy_var_1 of
                             Left lbs -> return lbs
                             Right _ -> parseError "expected sequence of bound identifiers, not absurd pattern")})
	) (\r -> happyReturn (happyIn82 r))

happyReduce_300 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_300 = happyMonadReduce 2# 73# happyReduction_300
happyReduction_300 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut54 happy_x_2 of { (HappyWrap54 happy_var_2) -> 
	( fmap Just (exprToPattern happy_var_2))})
	) (\r -> happyReturn (happyIn83 r))

happyReduce_301 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_301 = happySpecReduce_0  73# happyReduction_301
happyReduction_301  =  happyIn83
		 (Nothing
	)

happyReduce_302 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_302 = happySpecReduce_2  74# happyReduction_302
happyReduction_302 happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_1 of { (HappyWrap31 happy_var_1) -> 
	case happyOut83 happy_x_2 of { (HappyWrap83 happy_var_2) -> 
	happyIn84
		 (Left [mkDomainFree_ id happy_var_2 happy_var_1]
	)}}

happyReduce_303 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_303 = happySpecReduce_3  74# happyReduction_303
happyReduction_303 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_2 of { (HappyWrap31 happy_var_2) -> 
	case happyOut83 happy_x_3 of { (HappyWrap83 happy_var_3) -> 
	happyIn84
		 (Left [mkDomainFree_ (setRelevance Irrelevant) happy_var_3 happy_var_2]
	)}}

happyReduce_304 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_304 = happySpecReduce_3  74# happyReduction_304
happyReduction_304 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_2 of { (HappyWrap31 happy_var_2) -> 
	case happyOut83 happy_x_3 of { (HappyWrap83 happy_var_3) -> 
	happyIn84
		 (Left [mkDomainFree_ (setRelevance NonStrict) happy_var_3 happy_var_2]
	)}}

happyReduce_305 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_305 = happyMonadReduce 3# 74# happyReduction_305
happyReduction_305 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut45 happy_x_2 of { (HappyWrap45 happy_var_2) -> 
	( exprToPattern (RawApp (getRange happy_var_2) happy_var_2) >>= \ p ->
                                 pure $ Left [mkDomainFree_ id (Just p) (Name noRange InScope [Hole])])})
	) (\r -> happyReturn (happyIn84 r))

happyReduce_306 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_306 = happyMonadReduce 4# 74# happyReduction_306
happyReduction_306 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut28 happy_x_2 of { (HappyWrap28 happy_var_2) -> 
	case happyOut34 happy_x_3 of { (HappyWrap34 happy_var_3) -> 
	( applyAttrs happy_var_2 defaultArgInfo <&> \ ai ->
              mapLeft (map (DomainFree . setTacticAttr happy_var_2 . setArgInfo ai)) happy_var_3)}})
	) (\r -> happyReturn (happyIn84 r))

happyReduce_307 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_307 = happySpecReduce_3  74# happyReduction_307
happyReduction_307 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut34 happy_x_2 of { (HappyWrap34 happy_var_2) -> 
	happyIn84
		 (mapLeft (map (DomainFree . hide)) happy_var_2
	)}

happyReduce_308 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_308 = happyMonadReduce 4# 74# happyReduction_308
happyReduction_308 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut28 happy_x_2 of { (HappyWrap28 happy_var_2) -> 
	case happyOut34 happy_x_3 of { (HappyWrap34 happy_var_3) -> 
	( applyAttrs happy_var_2 defaultArgInfo <&> \ ai ->
              mapLeft (map (DomainFree . hide . setTacticAttr happy_var_2 . setArgInfo ai)) happy_var_3)}})
	) (\r -> happyReturn (happyIn84 r))

happyReduce_309 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_309 = happySpecReduce_3  74# happyReduction_309
happyReduction_309 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut33 happy_x_2 of { (HappyWrap33 happy_var_2) -> 
	happyIn84
		 (Left $ map (DomainFree . makeInstance) happy_var_2
	)}

happyReduce_310 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_310 = happyMonadReduce 4# 74# happyReduction_310
happyReduction_310 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut28 happy_x_2 of { (HappyWrap28 happy_var_2) -> 
	case happyOut33 happy_x_3 of { (HappyWrap33 happy_var_3) -> 
	( applyAttrs happy_var_2 defaultArgInfo <&> \ ai ->
              Left $ map (DomainFree . makeInstance . setTacticAttr happy_var_2 . setArgInfo ai) happy_var_3)}})
	) (\r -> happyReturn (happyIn84 r))

happyReduce_311 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_311 = happyReduce 4# 74# happyReduction_311
happyReduction_311 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut33 happy_x_3 of { (HappyWrap33 happy_var_3) -> 
	happyIn84
		 (Left $ map (DomainFree . hide . setRelevance Irrelevant) happy_var_3
	) `HappyStk` happyRest}

happyReduce_312 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_312 = happyReduce 4# 74# happyReduction_312
happyReduction_312 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut33 happy_x_3 of { (HappyWrap33 happy_var_3) -> 
	happyIn84
		 (Left $ map (DomainFree . makeInstance . setRelevance Irrelevant) happy_var_3
	) `HappyStk` happyRest}

happyReduce_313 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_313 = happyReduce 4# 74# happyReduction_313
happyReduction_313 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut33 happy_x_3 of { (HappyWrap33 happy_var_3) -> 
	happyIn84
		 (Left $ map (DomainFree . hide . setRelevance NonStrict) happy_var_3
	) `HappyStk` happyRest}

happyReduce_314 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_314 = happyReduce 4# 74# happyReduction_314
happyReduction_314 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut33 happy_x_3 of { (HappyWrap33 happy_var_3) -> 
	happyIn84
		 (Left $ map (DomainFree . makeInstance . setRelevance NonStrict) happy_var_3
	) `HappyStk` happyRest}

happyReduce_315 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_315 = happySpecReduce_1  75# happyReduction_315
happyReduction_315 happy_x_1
	 =  case happyOut86 happy_x_1 of { (HappyWrap86 happy_var_1) -> 
	happyIn85
		 ([happy_var_1]
	)}

happyReduce_316 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_316 = happySpecReduce_2  75# happyReduction_316
happyReduction_316 happy_x_2
	happy_x_1
	 =  case happyOut86 happy_x_1 of { (HappyWrap86 happy_var_1) -> 
	happyIn85
		 ([happy_var_1]
	)}

happyReduce_317 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_317 = happySpecReduce_3  75# happyReduction_317
happyReduction_317 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut86 happy_x_1 of { (HappyWrap86 happy_var_1) -> 
	case happyOut85 happy_x_3 of { (HappyWrap85 happy_var_3) -> 
	happyIn85
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_318 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_318 = happyMonadReduce 2# 76# happyReduction_318
happyReduction_318 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut42 happy_x_1 of { (HappyWrap42 happy_var_1) -> 
	case happyOut87 happy_x_2 of { (HappyWrap87 happy_var_2) -> 
	( buildDoStmt happy_var_1 happy_var_2)}})
	) (\r -> happyReturn (happyIn86 r))

happyReduce_319 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_319 = happySpecReduce_0  77# happyReduction_319
happyReduction_319  =  happyIn87
		 ([]
	)

happyReduce_320 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_320 = happyReduce 4# 77# happyReduction_320
happyReduction_320 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut78 happy_x_3 of { (HappyWrap78 happy_var_3) -> 
	happyIn87
		 (reverse happy_var_3
	) `HappyStk` happyRest}

happyReduce_321 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_321 = happyMonadReduce 1# 78# happyReduction_321
happyReduction_321 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut89 happy_x_1 of { (HappyWrap89 happy_var_1) -> 
	( mergeImportDirectives happy_var_1)})
	) (\r -> happyReturn (happyIn88 r))

happyReduce_322 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_322 = happySpecReduce_2  79# happyReduction_322
happyReduction_322 happy_x_2
	happy_x_1
	 =  case happyOut90 happy_x_1 of { (HappyWrap90 happy_var_1) -> 
	case happyOut89 happy_x_2 of { (HappyWrap89 happy_var_2) -> 
	happyIn89
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_323 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_323 = happySpecReduce_0  79# happyReduction_323
happyReduction_323  =  happyIn89
		 ([]
	)

happyReduce_324 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_324 = happySpecReduce_1  80# happyReduction_324
happyReduction_324 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPublic happy_var_1) -> 
	happyIn90
		 (defaultImportDir { importDirRange = getRange happy_var_1, publicOpen = Just (getRange happy_var_1) }
	)}

happyReduce_325 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_325 = happySpecReduce_1  80# happyReduction_325
happyReduction_325 happy_x_1
	 =  case happyOut91 happy_x_1 of { (HappyWrap91 happy_var_1) -> 
	happyIn90
		 (defaultImportDir { importDirRange = snd happy_var_1, using    = fst happy_var_1 }
	)}

happyReduce_326 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_326 = happySpecReduce_1  80# happyReduction_326
happyReduction_326 happy_x_1
	 =  case happyOut92 happy_x_1 of { (HappyWrap92 happy_var_1) -> 
	happyIn90
		 (defaultImportDir { importDirRange = snd happy_var_1, hiding   = fst happy_var_1 }
	)}

happyReduce_327 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_327 = happySpecReduce_1  80# happyReduction_327
happyReduction_327 happy_x_1
	 =  case happyOut93 happy_x_1 of { (HappyWrap93 happy_var_1) -> 
	happyIn90
		 (defaultImportDir { importDirRange = snd happy_var_1, impRenaming = fst happy_var_1 }
	)}

happyReduce_328 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_328 = happyReduce 4# 81# happyReduction_328
happyReduction_328 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwUsing happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut99 happy_x_3 of { (HappyWrap99 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn91
		 ((Using happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_329 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_329 = happyReduce 4# 82# happyReduction_329
happyReduction_329 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwHiding happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut99 happy_x_3 of { (HappyWrap99 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn92
		 ((happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_330 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_330 = happyReduce 4# 83# happyReduction_330
happyReduction_330 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut94 happy_x_3 of { (HappyWrap94 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn93
		 ((happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_331 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_331 = happySpecReduce_3  83# happyReduction_331
happyReduction_331 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn93
		 (([] , getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_332 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_332 = happySpecReduce_3  84# happyReduction_332
happyReduction_332 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut95 happy_x_1 of { (HappyWrap95 happy_var_1) -> 
	case happyOut94 happy_x_3 of { (HappyWrap94 happy_var_3) -> 
	happyIn94
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_333 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_333 = happySpecReduce_1  84# happyReduction_333
happyReduction_333 happy_x_1
	 =  case happyOut95 happy_x_1 of { (HappyWrap95 happy_var_1) -> 
	happyIn94
		 ([happy_var_1]
	)}

happyReduce_334 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_334 = happySpecReduce_3  85# happyReduction_334
happyReduction_334 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut97 happy_x_1 of { (HappyWrap97 happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwTo happy_var_2) -> 
	case happyOut96 happy_x_3 of { (HappyWrap96 happy_var_3) -> 
	happyIn95
		 (Renaming happy_var_1 (setImportedName happy_var_1 (snd happy_var_3)) (fst happy_var_3) (getRange happy_var_2)
	)}}}

happyReduce_335 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_335 = happySpecReduce_1  86# happyReduction_335
happyReduction_335 happy_x_1
	 =  case happyOut19 happy_x_1 of { (HappyWrap19 happy_var_1) -> 
	happyIn96
		 ((Nothing, happy_var_1)
	)}

happyReduce_336 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_336 = happySpecReduce_3  86# happyReduction_336
happyReduction_336 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfix happy_var_1) -> 
	case happyOut18 happy_x_2 of { (HappyWrap18 happy_var_2) -> 
	case happyOut19 happy_x_3 of { (HappyWrap19 happy_var_3) -> 
	happyIn96
		 ((Just (Fixity (getRange (happy_var_1,happy_var_2)) (Related $ rangedThing happy_var_2) NonAssoc)  , happy_var_3)
	)}}}

happyReduce_337 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_337 = happySpecReduce_3  86# happyReduction_337
happyReduction_337 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixL happy_var_1) -> 
	case happyOut18 happy_x_2 of { (HappyWrap18 happy_var_2) -> 
	case happyOut19 happy_x_3 of { (HappyWrap19 happy_var_3) -> 
	happyIn96
		 ((Just (Fixity (getRange (happy_var_1,happy_var_2)) (Related $ rangedThing happy_var_2) LeftAssoc) , happy_var_3)
	)}}}

happyReduce_338 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_338 = happySpecReduce_3  86# happyReduction_338
happyReduction_338 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixR happy_var_1) -> 
	case happyOut18 happy_x_2 of { (HappyWrap18 happy_var_2) -> 
	case happyOut19 happy_x_3 of { (HappyWrap19 happy_var_3) -> 
	happyIn96
		 ((Just (Fixity (getRange (happy_var_1,happy_var_2)) (Related $ rangedThing happy_var_2) RightAssoc), happy_var_3)
	)}}}

happyReduce_339 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_339 = happySpecReduce_2  87# happyReduction_339
happyReduction_339 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	happyIn97
		 (ImportedName happy_var_2
	)}

happyReduce_340 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_340 = happySpecReduce_3  87# happyReduction_340
happyReduction_340 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_3 of { (HappyWrap19 happy_var_3) -> 
	happyIn97
		 (ImportedModule happy_var_3
	)}

happyReduce_341 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_341 = happySpecReduce_1  88# happyReduction_341
happyReduction_341 happy_x_1
	 =  case happyOut19 happy_x_1 of { (HappyWrap19 happy_var_1) -> 
	happyIn98
		 (ImportedName happy_var_1
	)}

happyReduce_342 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_342 = happySpecReduce_2  88# happyReduction_342
happyReduction_342 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	happyIn98
		 (ImportedModule happy_var_2
	)}

happyReduce_343 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_343 = happySpecReduce_0  89# happyReduction_343
happyReduction_343  =  happyIn99
		 ([]
	)

happyReduce_344 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_344 = happySpecReduce_1  89# happyReduction_344
happyReduction_344 happy_x_1
	 =  case happyOut100 happy_x_1 of { (HappyWrap100 happy_var_1) -> 
	happyIn99
		 (happy_var_1
	)}

happyReduce_345 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_345 = happySpecReduce_1  90# happyReduction_345
happyReduction_345 happy_x_1
	 =  case happyOut98 happy_x_1 of { (HappyWrap98 happy_var_1) -> 
	happyIn100
		 ([happy_var_1]
	)}

happyReduce_346 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_346 = happySpecReduce_3  90# happyReduction_346
happyReduction_346 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut98 happy_x_1 of { (HappyWrap98 happy_var_1) -> 
	case happyOut100 happy_x_3 of { (HappyWrap100 happy_var_3) -> 
	happyIn100
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_347 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_347 = happyMonadReduce 2# 91# happyReduction_347
happyReduction_347 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut43 happy_x_1 of { (HappyWrap43 happy_var_1) -> 
	case happyOut102 happy_x_2 of { (HappyWrap102 happy_var_2) -> 
	( exprToLHS happy_var_1      >>= \p ->
           buildWithBlock happy_var_2 >>= \ (rs, es) ->
           return (p rs $ map observeHiding es))}})
	) (\r -> happyReturn (happyIn101 r))

happyReduce_348 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_348 = happySpecReduce_0  92# happyReduction_348
happyReduction_348  =  happyIn102
		 ([]
	)

happyReduce_349 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_349 = happyMonadReduce 3# 92# happyReduction_349
happyReduction_349 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut43 happy_x_2 of { (HappyWrap43 happy_var_2) -> 
	case happyOut102 happy_x_3 of { (HappyWrap102 happy_var_3) -> 
	( fmap (++ happy_var_3) (buildWithStmt happy_var_2))}})
	) (\r -> happyReturn (happyIn102 r))

happyReduce_350 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_350 = happySpecReduce_3  92# happyReduction_350
happyReduction_350 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_2 of { (HappyWrap43 happy_var_2) -> 
	case happyOut102 happy_x_3 of { (HappyWrap102 happy_var_3) -> 
	happyIn102
		 (Left (Rewrite $ fmap ((),) (fromWithApp happy_var_2)) : happy_var_3
	)}}

happyReduce_351 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_351 = happySpecReduce_1  93# happyReduction_351
happyReduction_351 happy_x_1
	 =  case happyOut42 happy_x_1 of { (HappyWrap42 happy_var_1) -> 
	happyIn103
		 (HoleContentExpr    happy_var_1
	)}

happyReduce_352 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_352 = happyMonadReduce 1# 93# happyReduction_352
happyReduction_352 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut102 happy_x_1 of { (HappyWrap102 happy_var_1) -> 
	( fmap HoleContentRewrite $ forM happy_var_1 $ \case
         Left r  -> pure r
         Right{} -> parseError "Cannot declare a 'with' abstraction from inside a hole.")})
	) (\r -> happyReturn (happyIn103 r))

happyReduce_353 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_353 = happySpecReduce_0  94# happyReduction_353
happyReduction_353  =  happyIn104
		 (NoWhere
	)

happyReduce_354 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_354 = happySpecReduce_2  94# happyReduction_354
happyReduction_354 happy_x_2
	happy_x_1
	 =  case happyOut184 happy_x_2 of { (HappyWrap184 happy_var_2) -> 
	happyIn104
		 (AnyWhere happy_var_2
	)}

happyReduce_355 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_355 = happyReduce 4# 94# happyReduction_355
happyReduction_355 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	case happyOut184 happy_x_4 of { (HappyWrap184 happy_var_4) -> 
	happyIn104
		 (SomeWhere happy_var_2 PublicAccess happy_var_4
	) `HappyStk` happyRest}}

happyReduce_356 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_356 = happyReduce 4# 94# happyReduction_356
happyReduction_356 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut142 happy_x_2 of { (HappyWrap142 happy_var_2) -> 
	case happyOut184 happy_x_4 of { (HappyWrap184 happy_var_4) -> 
	happyIn104
		 (SomeWhere happy_var_2 PublicAccess happy_var_4
	) `HappyStk` happyRest}}

happyReduce_357 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_357 = happySpecReduce_2  95# happyReduction_357
happyReduction_357 happy_x_2
	happy_x_1
	 =  case happyOut42 happy_x_1 of { (HappyWrap42 happy_var_1) -> 
	case happyOut104 happy_x_2 of { (HappyWrap104 happy_var_2) -> 
	happyIn105
		 (ExprWhere happy_var_1 happy_var_2
	)}}

happyReduce_358 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_358 = happySpecReduce_1  96# happyReduction_358
happyReduction_358 happy_x_1
	 =  case happyOut117 happy_x_1 of { (HappyWrap117 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_359 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_359 = happySpecReduce_1  96# happyReduction_359
happyReduction_359 happy_x_1
	 =  case happyOut109 happy_x_1 of { (HappyWrap109 happy_var_1) -> 
	happyIn106
		 (happy_var_1
	)}

happyReduce_360 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_360 = happySpecReduce_1  96# happyReduction_360
happyReduction_360 happy_x_1
	 =  case happyOut111 happy_x_1 of { (HappyWrap111 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_361 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_361 = happySpecReduce_1  96# happyReduction_361
happyReduction_361 happy_x_1
	 =  case happyOut112 happy_x_1 of { (HappyWrap112 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_362 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_362 = happySpecReduce_1  96# happyReduction_362
happyReduction_362 happy_x_1
	 =  case happyOut113 happy_x_1 of { (HappyWrap113 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_363 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_363 = happySpecReduce_1  96# happyReduction_363
happyReduction_363 happy_x_1
	 =  case happyOut114 happy_x_1 of { (HappyWrap114 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_364 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_364 = happySpecReduce_1  96# happyReduction_364
happyReduction_364 happy_x_1
	 =  case happyOut116 happy_x_1 of { (HappyWrap116 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_365 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_365 = happySpecReduce_1  96# happyReduction_365
happyReduction_365 happy_x_1
	 =  case happyOut118 happy_x_1 of { (HappyWrap118 happy_var_1) -> 
	happyIn106
		 (happy_var_1
	)}

happyReduce_366 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_366 = happySpecReduce_1  96# happyReduction_366
happyReduction_366 happy_x_1
	 =  case happyOut119 happy_x_1 of { (HappyWrap119 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_367 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_367 = happySpecReduce_1  96# happyReduction_367
happyReduction_367 happy_x_1
	 =  case happyOut120 happy_x_1 of { (HappyWrap120 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_368 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_368 = happySpecReduce_1  96# happyReduction_368
happyReduction_368 happy_x_1
	 =  case happyOut121 happy_x_1 of { (HappyWrap121 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_369 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_369 = happySpecReduce_1  96# happyReduction_369
happyReduction_369 happy_x_1
	 =  case happyOut122 happy_x_1 of { (HappyWrap122 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_370 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_370 = happySpecReduce_1  96# happyReduction_370
happyReduction_370 happy_x_1
	 =  case happyOut123 happy_x_1 of { (HappyWrap123 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_371 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_371 = happySpecReduce_1  96# happyReduction_371
happyReduction_371 happy_x_1
	 =  case happyOut124 happy_x_1 of { (HappyWrap124 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_372 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_372 = happySpecReduce_1  96# happyReduction_372
happyReduction_372 happy_x_1
	 =  case happyOut125 happy_x_1 of { (HappyWrap125 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_373 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_373 = happySpecReduce_1  96# happyReduction_373
happyReduction_373 happy_x_1
	 =  case happyOut137 happy_x_1 of { (HappyWrap137 happy_var_1) -> 
	happyIn106
		 (happy_var_1
	)}

happyReduce_374 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_374 = happySpecReduce_1  96# happyReduction_374
happyReduction_374 happy_x_1
	 =  case happyOut140 happy_x_1 of { (HappyWrap140 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_375 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_375 = happySpecReduce_1  96# happyReduction_375
happyReduction_375 happy_x_1
	 =  case happyOut141 happy_x_1 of { (HappyWrap141 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_376 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_376 = happySpecReduce_1  96# happyReduction_376
happyReduction_376 happy_x_1
	 =  case happyOut144 happy_x_1 of { (HappyWrap144 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_377 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_377 = happySpecReduce_1  96# happyReduction_377
happyReduction_377 happy_x_1
	 =  case happyOut127 happy_x_1 of { (HappyWrap127 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_378 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_378 = happySpecReduce_1  96# happyReduction_378
happyReduction_378 happy_x_1
	 =  case happyOut128 happy_x_1 of { (HappyWrap128 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_379 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_379 = happySpecReduce_1  96# happyReduction_379
happyReduction_379 happy_x_1
	 =  case happyOut126 happy_x_1 of { (HappyWrap126 happy_var_1) -> 
	happyIn106
		 ([happy_var_1]
	)}

happyReduce_380 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_380 = happySpecReduce_3  97# happyReduction_380
happyReduction_380 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut20 happy_x_1 of { (HappyWrap20 happy_var_1) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	happyIn107
		 (map (\ x -> typeSig defaultArgInfo Nothing x happy_var_3) happy_var_1
	)}}

happyReduce_381 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_381 = happySpecReduce_3  98# happyReduction_381
happyReduction_381 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_1 of { (HappyWrap25 happy_var_1) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	happyIn108
		 (let (attrs, xs) = happy_var_1 in
                           map (fmap (\ x -> typeSig defaultArgInfo (getTacticAttr attrs) x happy_var_3)) xs
	)}}

happyReduce_382 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_382 = happyMonadReduce 4# 98# happyReduction_382
happyReduction_382 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwOverlap happy_var_1) -> 
	case happyOut25 happy_x_2 of { (HappyWrap25 happy_var_2) -> 
	case happyOut42 happy_x_4 of { (HappyWrap42 happy_var_4) -> 
	(
      let (attrs, xs) = happy_var_2
          setOverlap x =
            case getHiding x of
              Instance _ -> return $ makeInstance' YesOverlap x
              _          -> parseErrorRange happy_var_1
                             "The 'overlap' keyword only applies to instance fields (fields marked with {{ }})"
      in T.traverse (setOverlap . fmap (\ x -> typeSig defaultArgInfo (getTacticAttr attrs) x happy_var_4)) xs)}}})
	) (\r -> happyReturn (happyIn108 r))

happyReduce_383 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_383 = happySpecReduce_2  98# happyReduction_383
happyReduction_383 happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_2 of { (HappyWrap174 happy_var_2) -> 
	happyIn108
		 (let
      setInstance (TypeSig info tac x t) = TypeSig (makeInstance info) tac x t
      setInstance _ = __IMPOSSIBLE__ in
    map (fmap setInstance) happy_var_2
	)}

happyReduce_384 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_384 = happyMonadReduce 3# 99# happyReduction_384
happyReduction_384 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut101 happy_x_1 of { (HappyWrap101 happy_var_1) -> 
	case happyOut110 happy_x_2 of { (HappyWrap110 happy_var_2) -> 
	case happyOut104 happy_x_3 of { (HappyWrap104 happy_var_3) -> 
	( funClauseOrTypeSigs [] happy_var_1 happy_var_2 happy_var_3)}}})
	) (\r -> happyReturn (happyIn109 r))

happyReduce_385 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_385 = happyMonadReduce 4# 99# happyReduction_385
happyReduction_385 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut28 happy_x_1 of { (HappyWrap28 happy_var_1) -> 
	case happyOut101 happy_x_2 of { (HappyWrap101 happy_var_2) -> 
	case happyOut110 happy_x_3 of { (HappyWrap110 happy_var_3) -> 
	case happyOut104 happy_x_4 of { (HappyWrap104 happy_var_4) -> 
	( funClauseOrTypeSigs happy_var_1 happy_var_2 happy_var_3 happy_var_4)}}}})
	) (\r -> happyReturn (happyIn109 r))

happyReduce_386 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_386 = happySpecReduce_2  100# happyReduction_386
happyReduction_386 happy_x_2
	happy_x_1
	 =  case happyOut42 happy_x_2 of { (HappyWrap42 happy_var_2) -> 
	happyIn110
		 (JustRHS (RHS happy_var_2)
	)}

happyReduce_387 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_387 = happySpecReduce_2  100# happyReduction_387
happyReduction_387 happy_x_2
	happy_x_1
	 =  case happyOut42 happy_x_2 of { (HappyWrap42 happy_var_2) -> 
	happyIn110
		 (TypeSigsRHS happy_var_2
	)}

happyReduce_388 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_388 = happySpecReduce_0  100# happyReduction_388
happyReduction_388  =  happyIn110
		 (JustRHS AbsurdRHS
	)

happyReduce_389 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_389 = happyReduce 7# 101# happyReduction_389
happyReduction_389 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	case happyOut81 happy_x_3 of { (HappyWrap81 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut42 happy_x_5 of { (HappyWrap42 happy_var_5) -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut184 happy_x_7 of { (HappyWrap184 happy_var_7) -> 
	happyIn111
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) happy_var_2 happy_var_3 happy_var_5 happy_var_7
	) `HappyStk` happyRest}}}}}}}

happyReduce_390 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_390 = happyReduce 5# 101# happyReduction_390
happyReduction_390 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	case happyOut81 happy_x_3 of { (HappyWrap81 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut184 happy_x_5 of { (HappyWrap184 happy_var_5) -> 
	happyIn111
		 (DataDef (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_391 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_391 = happyReduce 5# 102# happyReduction_391
happyReduction_391 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	case happyOut81 happy_x_3 of { (HappyWrap81 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut42 happy_x_5 of { (HappyWrap42 happy_var_5) -> 
	happyIn112
		 (DataSig (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_392 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_392 = happyMonadReduce 7# 103# happyReduction_392
happyReduction_392 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut52 happy_x_2 of { (HappyWrap52 happy_var_2) -> 
	case happyOut81 happy_x_3 of { (HappyWrap81 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut42 happy_x_5 of { (HappyWrap42 happy_var_5) -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut178 happy_x_7 of { (HappyWrap178 happy_var_7) -> 
	( exprToName happy_var_2 >>= \ n -> let ((x,y,z),ds) = happy_var_7 in return $ Record (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) n x y z happy_var_3 happy_var_5 ds)}}}}}}})
	) (\r -> happyReturn (happyIn113 r))

happyReduce_393 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_393 = happyMonadReduce 5# 103# happyReduction_393
happyReduction_393 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut52 happy_x_2 of { (HappyWrap52 happy_var_2) -> 
	case happyOut81 happy_x_3 of { (HappyWrap81 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut178 happy_x_5 of { (HappyWrap178 happy_var_5) -> 
	( exprToName happy_var_2 >>= \ n -> let ((x,y,z),ds) = happy_var_5 in return $ RecordDef (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) n x y z happy_var_3 ds)}}}}})
	) (\r -> happyReturn (happyIn113 r))

happyReduce_394 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_394 = happyMonadReduce 5# 104# happyReduction_394
happyReduction_394 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut52 happy_x_2 of { (HappyWrap52 happy_var_2) -> 
	case happyOut81 happy_x_3 of { (HappyWrap81 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut42 happy_x_5 of { (HappyWrap42 happy_var_5) -> 
	( exprToName happy_var_2 >>= \ n -> return $ RecordSig (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) n happy_var_3 happy_var_5)}}}}})
	) (\r -> happyReturn (happyIn114 r))

happyReduce_395 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_395 = happySpecReduce_2  105# happyReduction_395
happyReduction_395 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	happyIn115
		 ((happy_var_2, NotInstanceDef)
	)}

happyReduce_396 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_396 = happyReduce 5# 105# happyReduction_396
happyReduction_396 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwInstance happy_var_1) -> 
	case happyOut19 happy_x_4 of { (HappyWrap19 happy_var_4) -> 
	happyIn115
		 ((happy_var_4, InstanceDef (getRange happy_var_1))
	) `HappyStk` happyRest}}

happyReduce_397 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_397 = happySpecReduce_3  106# happyReduction_397
happyReduction_397 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfix happy_var_1) -> 
	case happyOut18 happy_x_2 of { (HappyWrap18 happy_var_2) -> 
	case happyOut32 happy_x_3 of { (HappyWrap32 happy_var_3) -> 
	happyIn116
		 (Infix (Fixity (getRange (happy_var_1,happy_var_2,happy_var_3)) (Related $ rangedThing happy_var_2) NonAssoc)   happy_var_3
	)}}}

happyReduce_398 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_398 = happySpecReduce_3  106# happyReduction_398
happyReduction_398 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixL happy_var_1) -> 
	case happyOut18 happy_x_2 of { (HappyWrap18 happy_var_2) -> 
	case happyOut32 happy_x_3 of { (HappyWrap32 happy_var_3) -> 
	happyIn116
		 (Infix (Fixity (getRange (happy_var_1,happy_var_2,happy_var_3)) (Related $ rangedThing happy_var_2) LeftAssoc)  happy_var_3
	)}}}

happyReduce_399 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_399 = happySpecReduce_3  106# happyReduction_399
happyReduction_399 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixR happy_var_1) -> 
	case happyOut18 happy_x_2 of { (HappyWrap18 happy_var_2) -> 
	case happyOut32 happy_x_3 of { (HappyWrap32 happy_var_3) -> 
	happyIn116
		 (Infix (Fixity (getRange (happy_var_1,happy_var_2,happy_var_3)) (Related $ rangedThing happy_var_2) RightAssoc) happy_var_3
	)}}}

happyReduce_400 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_400 = happySpecReduce_2  107# happyReduction_400
happyReduction_400 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwField happy_var_1) -> 
	case happyOut176 happy_x_2 of { (HappyWrap176 happy_var_2) -> 
	happyIn117
		 (let
                inst i = case getHiding i of
                           Instance _ -> InstanceDef noRange  -- no @instance@ keyword here
                           _          -> NotInstanceDef
                toField (Arg info (TypeSig info' tac x t)) = FieldSig (inst info') tac x (Arg info t)
              in Field (fuseRange happy_var_1 happy_var_2) $ map toField happy_var_2
	)}}

happyReduce_401 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_401 = happySpecReduce_2  108# happyReduction_401
happyReduction_401 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwVariable happy_var_1) -> 
	case happyOut176 happy_x_2 of { (HappyWrap176 happy_var_2) -> 
	happyIn118
		 (let
                toGeneralize (Arg info (TypeSig _ tac x t)) = TypeSig info tac x t
              in [ Generalize (fuseRange happy_var_1 happy_var_2) (map toGeneralize happy_var_2) ]
	)}}

happyReduce_402 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_402 = happySpecReduce_2  109# happyReduction_402
happyReduction_402 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMutual happy_var_1) -> 
	case happyOut184 happy_x_2 of { (HappyWrap184 happy_var_2) -> 
	happyIn119
		 (Mutual (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_403 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_403 = happySpecReduce_2  110# happyReduction_403
happyReduction_403 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwAbstract happy_var_1) -> 
	case happyOut184 happy_x_2 of { (HappyWrap184 happy_var_2) -> 
	happyIn120
		 (Abstract (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_404 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_404 = happySpecReduce_2  111# happyReduction_404
happyReduction_404 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrivate happy_var_1) -> 
	case happyOut184 happy_x_2 of { (HappyWrap184 happy_var_2) -> 
	happyIn121
		 (Private (fuseRange happy_var_1 happy_var_2) UserWritten happy_var_2
	)}}

happyReduce_405 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_405 = happySpecReduce_2  112# happyReduction_405
happyReduction_405 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInstance happy_var_1) -> 
	case happyOut184 happy_x_2 of { (HappyWrap184 happy_var_2) -> 
	happyIn122
		 (InstanceB (getRange happy_var_1) happy_var_2
	)}}

happyReduce_406 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_406 = happySpecReduce_2  113# happyReduction_406
happyReduction_406 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMacro happy_var_1) -> 
	case happyOut184 happy_x_2 of { (HappyWrap184 happy_var_2) -> 
	happyIn123
		 (Macro (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_407 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_407 = happySpecReduce_2  114# happyReduction_407
happyReduction_407 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPostulate happy_var_1) -> 
	case happyOut184 happy_x_2 of { (HappyWrap184 happy_var_2) -> 
	happyIn124
		 (Postulate (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_408 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_408 = happySpecReduce_2  115# happyReduction_408
happyReduction_408 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrimitive happy_var_1) -> 
	case happyOut171 happy_x_2 of { (HappyWrap171 happy_var_2) -> 
	happyIn125
		 (Primitive (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_409 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_409 = happySpecReduce_3  116# happyReduction_409
happyReduction_409 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDecl happy_var_1) -> 
	case happyOut42 happy_x_3 of { (HappyWrap42 happy_var_3) -> 
	happyIn126
		 (UnquoteDecl (fuseRange happy_var_1 happy_var_3) [] happy_var_3
	)}}

happyReduce_410 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_410 = happyReduce 4# 116# happyReduction_410
happyReduction_410 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDecl happy_var_1) -> 
	case happyOut20 happy_x_2 of { (HappyWrap20 happy_var_2) -> 
	case happyOut42 happy_x_4 of { (HappyWrap42 happy_var_4) -> 
	happyIn126
		 (UnquoteDecl (fuseRange happy_var_1 happy_var_4) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_411 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_411 = happyReduce 4# 116# happyReduction_411
happyReduction_411 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDef happy_var_1) -> 
	case happyOut20 happy_x_2 of { (HappyWrap20 happy_var_2) -> 
	case happyOut42 happy_x_4 of { (HappyWrap42 happy_var_4) -> 
	happyIn126
		 (UnquoteDef (fuseRange happy_var_1 happy_var_4) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_412 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_412 = happyMonadReduce 5# 117# happyReduction_412
happyReduction_412 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	case happyOut131 happy_x_3 of { (HappyWrap131 happy_var_3) -> 
	case happyOut130 happy_x_5 of { (HappyWrap130 happy_var_5) -> 
	(
  case happy_var_2 of
    Name _ _ [_] -> case mkNotation happy_var_3 happy_var_5 of
      Left err -> parseError $ "Malformed syntax declaration: " ++ err
      Right n -> return $ Syntax happy_var_2 n
    _ -> parseError "Syntax declarations are allowed only for simple names (without holes)")}}})
	) (\r -> happyReturn (happyIn127 r))

happyReduce_413 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_413 = happyMonadReduce 5# 118# happyReduction_413
happyReduction_413 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwPatternSyn happy_var_1) -> 
	case happyOut19 happy_x_2 of { (HappyWrap19 happy_var_2) -> 
	case happyOut129 happy_x_3 of { (HappyWrap129 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymEqual happy_var_4) -> 
	case happyOut42 happy_x_5 of { (HappyWrap42 happy_var_5) -> 
	( do
  p <- exprToPattern happy_var_5
  return (PatternSyn (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 happy_var_3 p))}}}}})
	) (\r -> happyReturn (happyIn128 r))

happyReduce_414 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_414 = happySpecReduce_0  119# happyReduction_414
happyReduction_414  =  happyIn129
		 ([]
	)

happyReduce_415 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_415 = happyMonadReduce 1# 119# happyReduction_415
happyReduction_415 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut72 happy_x_1 of { (HappyWrap72 happy_var_1) -> 
	( patternSynArgs happy_var_1)})
	) (\r -> happyReturn (happyIn129 r))

happyReduce_416 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_416 = happySpecReduce_1  120# happyReduction_416
happyReduction_416 happy_x_1
	 =  case happyOut135 happy_x_1 of { (HappyWrap135 happy_var_1) -> 
	happyIn130
		 ([happy_var_1]
	)}

happyReduce_417 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_417 = happySpecReduce_2  120# happyReduction_417
happyReduction_417 happy_x_2
	happy_x_1
	 =  case happyOut130 happy_x_1 of { (HappyWrap130 happy_var_1) -> 
	case happyOut135 happy_x_2 of { (HappyWrap135 happy_var_2) -> 
	happyIn130
		 (happy_var_1 ++ [happy_var_2]
	)}}

happyReduce_418 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_418 = happySpecReduce_1  121# happyReduction_418
happyReduction_418 happy_x_1
	 =  case happyOut132 happy_x_1 of { (HappyWrap132 happy_var_1) -> 
	happyIn131
		 ([happy_var_1]
	)}

happyReduce_419 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_419 = happySpecReduce_2  121# happyReduction_419
happyReduction_419 happy_x_2
	happy_x_1
	 =  case happyOut131 happy_x_1 of { (HappyWrap131 happy_var_1) -> 
	case happyOut132 happy_x_2 of { (HappyWrap132 happy_var_2) -> 
	happyIn131
		 (happy_var_1 ++ [happy_var_2]
	)}}

happyReduce_420 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_420 = happySpecReduce_1  122# happyReduction_420
happyReduction_420 happy_x_1
	 =  case happyOut133 happy_x_1 of { (HappyWrap133 happy_var_1) -> 
	happyIn132
		 (defaultNamedArg happy_var_1
	)}

happyReduce_421 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_421 = happySpecReduce_3  122# happyReduction_421
happyReduction_421 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut134 happy_x_2 of { (HappyWrap134 happy_var_2) -> 
	happyIn132
		 (hide         $ defaultNamedArg happy_var_2
	)}

happyReduce_422 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_422 = happySpecReduce_3  122# happyReduction_422
happyReduction_422 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut134 happy_x_2 of { (HappyWrap134 happy_var_2) -> 
	happyIn132
		 (makeInstance $ defaultNamedArg happy_var_2
	)}

happyReduce_423 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_423 = happyReduce 5# 122# happyReduction_423
happyReduction_423 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut135 happy_x_2 of { (HappyWrap135 happy_var_2) -> 
	case happyOut134 happy_x_4 of { (HappyWrap134 happy_var_4) -> 
	happyIn132
		 (hide         $ defaultArg $ userNamed happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_424 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_424 = happyReduce 5# 122# happyReduction_424
happyReduction_424 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut135 happy_x_2 of { (HappyWrap135 happy_var_2) -> 
	case happyOut134 happy_x_4 of { (HappyWrap134 happy_var_4) -> 
	happyIn132
		 (makeInstance $ defaultArg $ userNamed happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_425 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_425 = happySpecReduce_1  123# happyReduction_425
happyReduction_425 happy_x_1
	 =  case happyOut135 happy_x_1 of { (HappyWrap135 happy_var_1) -> 
	happyIn133
		 (ExprHole happy_var_1
	)}

happyReduce_426 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_426 = happyReduce 6# 123# happyReduction_426
happyReduction_426 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut135 happy_x_3 of { (HappyWrap135 happy_var_3) -> 
	case happyOut135 happy_x_5 of { (HappyWrap135 happy_var_5) -> 
	happyIn133
		 (LambdaHole happy_var_3 happy_var_5
	) `HappyStk` happyRest}}

happyReduce_427 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_427 = happyReduce 6# 123# happyReduction_427
happyReduction_427 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_3 of { (TokSymbol SymUnderscore happy_var_3) -> 
	case happyOut135 happy_x_5 of { (HappyWrap135 happy_var_5) -> 
	happyIn133
		 (LambdaHole (Ranged (getRange happy_var_3) "_") happy_var_5
	) `HappyStk` happyRest}}

happyReduce_428 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_428 = happySpecReduce_1  124# happyReduction_428
happyReduction_428 happy_x_1
	 =  case happyOut135 happy_x_1 of { (HappyWrap135 happy_var_1) -> 
	happyIn134
		 (ExprHole happy_var_1
	)}

happyReduce_429 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_429 = happyReduce 4# 124# happyReduction_429
happyReduction_429 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut135 happy_x_2 of { (HappyWrap135 happy_var_2) -> 
	case happyOut135 happy_x_4 of { (HappyWrap135 happy_var_4) -> 
	happyIn134
		 (LambdaHole happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_430 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_430 = happyReduce 4# 124# happyReduction_430
happyReduction_430 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_3 of { (TokSymbol SymArrow happy_var_3) -> 
	case happyOut135 happy_x_4 of { (HappyWrap135 happy_var_4) -> 
	happyIn134
		 (LambdaHole (Ranged (getRange happy_var_3) "_") happy_var_4
	) `HappyStk` happyRest}}

happyReduce_431 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_431 = happySpecReduce_1  125# happyReduction_431
happyReduction_431 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	happyIn135
		 (Ranged (getRange $ fst happy_var_1) (stringToRawName $ snd happy_var_1)
	)}

happyReduce_432 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_432 = happySpecReduce_1  126# happyReduction_432
happyReduction_432 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	happyIn136
		 (Just (getRange happy_var_1)
	)}

happyReduce_433 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_433 = happySpecReduce_0  126# happyReduction_433
happyReduction_433  =  happyIn136
		 (Nothing
	)

happyReduce_434 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_434 = happyMonadReduce 5# 127# happyReduction_434
happyReduction_434 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut136 happy_x_1 of { (HappyWrap136 happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwImport happy_var_2) -> 
	case happyOut30 happy_x_3 of { (HappyWrap30 happy_var_3) -> 
	case happyOut138 happy_x_4 of { (HappyWrap138 happy_var_4) -> 
	case happyOut88 happy_x_5 of { (HappyWrap88 happy_var_5) -> 
	(
    let
    { doOpen = maybe DontOpen (const DoOpen) happy_var_1
    ; m   = happy_var_3
    ; es  = happy_var_4
    ; dir = happy_var_5
    ; r   = getRange (happy_var_1, happy_var_2, m, es, dir)
    ; mr  = getRange m
    ; unique = hashString $ prettyShow $ (Strict.Nothing :: Strict.Maybe ()) <$ r
         -- turn range into unique id, but delete file path
         -- which is absolute and messes up suite of failing tests
         -- (different hashs on different installations)
         -- TODO: Don't use (insecure) hashes in this way.
    ; fresh  = Name mr NotInScope [ Id $ stringToRawName $ ".#" ++ prettyShow m ++ "-" ++ show unique ]
    ; fresh' = Name mr NotInScope [ Id $ stringToRawName $ ".#" ++ prettyShow m ++ "-" ++ show (unique + 1) ]
    ; impStm asR = Import r m (Just (AsName (Right fresh) asR)) DontOpen defaultImportDir
    ; appStm m' es =
        Private r Inserted
          [ ModuleMacro r m'
             (SectionApp (getRange es) []
               (RawApp (getRange es) (Ident (QName fresh) : es)))
             doOpen dir
          ]
    ; (initArgs, last2Args) = splitAt (length es - 2) es
    ; parseAsClause = case last2Args of
      { [ Ident (QName (Name asR InScope [Id x]))
        , e
          -- Andreas, 2018-11-03, issue #3364, accept anything after 'as'
          -- but require it to be a 'Name' in the scope checker.
        ] | rawNameToString x == "as" -> Just . (asR,) $
          if | Ident (QName m') <- e -> Right m'
             | otherwise             -> Left e
      ; _ -> Nothing
      }
    } in
    case es of
      { [] -> return [Import r m Nothing doOpen dir]
      ; _ | Just (asR, m') <- parseAsClause ->
              if null initArgs then return
                 [ Import (getRange (m, asR, m', dir)) m
                     (Just (AsName m' asR)) doOpen dir
                 ]
              else return [ impStm asR, appStm (fromRight (const fresh') m') initArgs ]
          -- Andreas, 2017-05-13, issue #2579
          -- Nisse reports that importing with instantation but without open
          -- could be usefule for bringing instances into scope.
          -- Ulf, 2018-12-6: Not since fixes of #1913 and #2489 which require
          -- instances to be in scope.
          | DontOpen <- doOpen -> parseErrorRange happy_var_2 "An import statement with module instantiation is useless without either an `open' keyword or an `as` binding giving a name to the instantiated module."
          | otherwise -> return
              [ impStm noRange
              , appStm (noName $ beginningOf $ getRange m) es
              ]
      })}}}}})
	) (\r -> happyReturn (happyIn137 r))

happyReduce_435 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_435 = happyReduce 4# 127# happyReduction_435
happyReduction_435 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	case happyOut30 happy_x_2 of { (HappyWrap30 happy_var_2) -> 
	case happyOut138 happy_x_3 of { (HappyWrap138 happy_var_3) -> 
	case happyOut88 happy_x_4 of { (HappyWrap88 happy_var_4) -> 
	happyIn137
		 (let
    { m   = happy_var_2
    ; es  = happy_var_3
    ; dir = happy_var_4
    ; r   = getRange (happy_var_1, m, es, dir)
    } in
    [ case es of
      { []  -> Open r m dir
      ; _   -> Private r Inserted
                 [ ModuleMacro r (noName $ beginningOf $ getRange m)
                             (SectionApp (getRange (m , es)) [] (RawApp (fuseRange m es) (Ident m : es)))
                             DoOpen dir
                 ]
      }
    ]
	) `HappyStk` happyRest}}}}

happyReduce_436 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_436 = happyReduce 6# 127# happyReduction_436
happyReduction_436 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut30 happy_x_2 of { (HappyWrap30 happy_var_2) -> 
	case happyOut88 happy_x_6 of { (HappyWrap88 happy_var_6) -> 
	happyIn137
		 (let r = getRange happy_var_2 in
    [ Private r Inserted
      [ ModuleMacro r (noName $ beginningOf $ getRange happy_var_2) (RecordModuleInstance r happy_var_2) DoOpen happy_var_6
      ]
    ]
	) `HappyStk` happyRest}}

happyReduce_437 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_437 = happySpecReduce_0  128# happyReduction_437
happyReduction_437  =  happyIn138
		 ([]
	)

happyReduce_438 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_438 = happySpecReduce_2  128# happyReduction_438
happyReduction_438 happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { (HappyWrap54 happy_var_1) -> 
	case happyOut138 happy_x_2 of { (HappyWrap138 happy_var_2) -> 
	happyIn138
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_439 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_439 = happyReduce 4# 129# happyReduction_439
happyReduction_439 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut30 happy_x_1 of { (HappyWrap30 happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymEllipsis happy_var_3) -> 
	case happyOut21 happy_x_4 of { (HappyWrap21 happy_var_4) -> 
	happyIn139
		 ((\ts ->
                    if null ts then return $ RecordModuleInstance (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_1
                    else parseError "No bindings allowed for record module with non-canonical implicits" )
	) `HappyStk` happyRest}}}}

happyReduce_440 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_440 = happySpecReduce_2  129# happyReduction_440
happyReduction_440 happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_1 of { (HappyWrap30 happy_var_1) -> 
	case happyOut138 happy_x_2 of { (HappyWrap138 happy_var_2) -> 
	happyIn139
		 ((\ts -> return $ SectionApp (getRange (happy_var_1, happy_var_2)) ts (RawApp (fuseRange happy_var_1 happy_var_2) (Ident happy_var_1 : happy_var_2)) )
	)}}

happyReduce_441 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_441 = happyMonadReduce 6# 130# happyReduction_441
happyReduction_441 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut30 happy_x_2 of { (HappyWrap30 happy_var_2) -> 
	case happyOut81 happy_x_3 of { (HappyWrap81 happy_var_3) -> 
	case happyOut139 happy_x_5 of { (HappyWrap139 happy_var_5) -> 
	case happyOut88 happy_x_6 of { (HappyWrap88 happy_var_6) -> 
	( do { ma <- happy_var_5 (map addType happy_var_3)
                          ; name <- ensureUnqual happy_var_2
                          ; return $ ModuleMacro (getRange (happy_var_1, happy_var_2, ma, happy_var_6)) name ma DontOpen happy_var_6 })}}}}})
	) (\r -> happyReturn (happyIn140 r))

happyReduce_442 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_442 = happyMonadReduce 7# 130# happyReduction_442
happyReduction_442 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwModule happy_var_2) -> 
	case happyOut19 happy_x_3 of { (HappyWrap19 happy_var_3) -> 
	case happyOut81 happy_x_4 of { (HappyWrap81 happy_var_4) -> 
	case happyOut139 happy_x_6 of { (HappyWrap139 happy_var_6) -> 
	case happyOut88 happy_x_7 of { (HappyWrap88 happy_var_7) -> 
	( do {ma <- happy_var_6 (map addType happy_var_4); return $ ModuleMacro (getRange (happy_var_1, happy_var_2, happy_var_3, ma, happy_var_7)) happy_var_3 ma DoOpen happy_var_7 })}}}}}})
	) (\r -> happyReturn (happyIn140 r))

happyReduce_443 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_443 = happyReduce 5# 131# happyReduction_443
happyReduction_443 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut30 happy_x_2 of { (HappyWrap30 happy_var_2) -> 
	case happyOut81 happy_x_3 of { (HappyWrap81 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut184 happy_x_5 of { (HappyWrap184 happy_var_5) -> 
	happyIn141
		 (Module (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 (map addType happy_var_3) happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_444 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_444 = happyReduce 5# 131# happyReduction_444
happyReduction_444 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut142 happy_x_2 of { (HappyWrap142 happy_var_2) -> 
	case happyOut81 happy_x_3 of { (HappyWrap81 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut184 happy_x_5 of { (HappyWrap184 happy_var_5) -> 
	happyIn141
		 (Module (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) (QName happy_var_2) (map addType happy_var_3) happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_445 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_445 = happySpecReduce_1  132# happyReduction_445
happyReduction_445 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn142
		 (noName (getRange happy_var_1)
	)}

happyReduce_446 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_446 = happySpecReduce_1  133# happyReduction_446
happyReduction_446 happy_x_1
	 =  case happyOut186 happy_x_1 of { (HappyWrap186 happy_var_1) -> 
	happyIn143
		 (figureOutTopLevelModule happy_var_1
	)}

happyReduce_447 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_447 = happySpecReduce_1  134# happyReduction_447
happyReduction_447 happy_x_1
	 =  case happyOut145 happy_x_1 of { (HappyWrap145 happy_var_1) -> 
	happyIn144
		 (Pragma happy_var_1
	)}

happyReduce_448 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_448 = happySpecReduce_1  135# happyReduction_448
happyReduction_448 happy_x_1
	 =  case happyOut147 happy_x_1 of { (HappyWrap147 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_449 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_449 = happySpecReduce_1  135# happyReduction_449
happyReduction_449 happy_x_1
	 =  case happyOut148 happy_x_1 of { (HappyWrap148 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_450 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_450 = happySpecReduce_1  135# happyReduction_450
happyReduction_450 happy_x_1
	 =  case happyOut150 happy_x_1 of { (HappyWrap150 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_451 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_451 = happySpecReduce_1  135# happyReduction_451
happyReduction_451 happy_x_1
	 =  case happyOut149 happy_x_1 of { (HappyWrap149 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_452 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_452 = happySpecReduce_1  135# happyReduction_452
happyReduction_452 happy_x_1
	 =  case happyOut151 happy_x_1 of { (HappyWrap151 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_453 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_453 = happySpecReduce_1  135# happyReduction_453
happyReduction_453 happy_x_1
	 =  case happyOut154 happy_x_1 of { (HappyWrap154 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_454 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_454 = happySpecReduce_1  135# happyReduction_454
happyReduction_454 happy_x_1
	 =  case happyOut152 happy_x_1 of { (HappyWrap152 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_455 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_455 = happySpecReduce_1  135# happyReduction_455
happyReduction_455 happy_x_1
	 =  case happyOut153 happy_x_1 of { (HappyWrap153 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_456 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_456 = happySpecReduce_1  135# happyReduction_456
happyReduction_456 happy_x_1
	 =  case happyOut163 happy_x_1 of { (HappyWrap163 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_457 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_457 = happySpecReduce_1  135# happyReduction_457
happyReduction_457 happy_x_1
	 =  case happyOut159 happy_x_1 of { (HappyWrap159 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_458 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_458 = happySpecReduce_1  135# happyReduction_458
happyReduction_458 happy_x_1
	 =  case happyOut158 happy_x_1 of { (HappyWrap158 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_459 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_459 = happySpecReduce_1  135# happyReduction_459
happyReduction_459 happy_x_1
	 =  case happyOut157 happy_x_1 of { (HappyWrap157 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_460 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_460 = happySpecReduce_1  135# happyReduction_460
happyReduction_460 happy_x_1
	 =  case happyOut160 happy_x_1 of { (HappyWrap160 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_461 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_461 = happySpecReduce_1  135# happyReduction_461
happyReduction_461 happy_x_1
	 =  case happyOut167 happy_x_1 of { (HappyWrap167 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_462 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_462 = happySpecReduce_1  135# happyReduction_462
happyReduction_462 happy_x_1
	 =  case happyOut168 happy_x_1 of { (HappyWrap168 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_463 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_463 = happySpecReduce_1  135# happyReduction_463
happyReduction_463 happy_x_1
	 =  case happyOut161 happy_x_1 of { (HappyWrap161 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_464 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_464 = happySpecReduce_1  135# happyReduction_464
happyReduction_464 happy_x_1
	 =  case happyOut162 happy_x_1 of { (HappyWrap162 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_465 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_465 = happySpecReduce_1  135# happyReduction_465
happyReduction_465 happy_x_1
	 =  case happyOut155 happy_x_1 of { (HappyWrap155 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_466 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_466 = happySpecReduce_1  135# happyReduction_466
happyReduction_466 happy_x_1
	 =  case happyOut156 happy_x_1 of { (HappyWrap156 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_467 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_467 = happySpecReduce_1  135# happyReduction_467
happyReduction_467 happy_x_1
	 =  case happyOut164 happy_x_1 of { (HappyWrap164 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_468 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_468 = happySpecReduce_1  135# happyReduction_468
happyReduction_468 happy_x_1
	 =  case happyOut165 happy_x_1 of { (HappyWrap165 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_469 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_469 = happySpecReduce_1  135# happyReduction_469
happyReduction_469 happy_x_1
	 =  case happyOut166 happy_x_1 of { (HappyWrap166 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_470 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_470 = happySpecReduce_1  135# happyReduction_470
happyReduction_470 happy_x_1
	 =  case happyOut146 happy_x_1 of { (HappyWrap146 happy_var_1) -> 
	happyIn145
		 (happy_var_1
	)}

happyReduce_471 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_471 = happyReduce 4# 136# happyReduction_471
happyReduction_471 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwOPTIONS happy_var_2) -> 
	case happyOut36 happy_x_3 of { (HappyWrap36 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn146
		 (OptionsPragma (getRange (happy_var_1,happy_var_2,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_472 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_472 = happyReduce 5# 137# happyReduction_472
happyReduction_472 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwBUILTIN happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut40 happy_x_4 of { (HappyWrap40 happy_var_4) -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn147
		 (BuiltinPragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4,happy_var_5)) (mkRString happy_var_3) happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_473 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_473 = happyReduce 5# 137# happyReduction_473
happyReduction_473 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwBUILTIN happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokKeyword KwREWRITE happy_var_3) -> 
	case happyOut40 happy_x_4 of { (HappyWrap40 happy_var_4) -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn147
		 (BuiltinPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) (Ranged (getRange happy_var_3) "REWRITE") happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_474 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_474 = happyReduce 4# 138# happyReduction_474
happyReduction_474 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwREWRITE happy_var_2) -> 
	case happyOut41 happy_x_3 of { (HappyWrap41 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn148
		 (RewritePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) (getRange happy_var_2) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_475 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_475 = happyReduce 5# 139# happyReduction_475
happyReduction_475 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwFOREIGN happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut38 happy_x_4 of { (HappyWrap38 happy_var_4) -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn149
		 (ForeignPragma (getRange (happy_var_1, happy_var_2, fst happy_var_3, happy_var_5)) (mkRString happy_var_3) (recoverLayout happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_476 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_476 = happyReduce 6# 140# happyReduction_476
happyReduction_476 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILE happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut40 happy_x_4 of { (HappyWrap40 happy_var_4) -> 
	case happyOut36 happy_x_5 of { (HappyWrap36 happy_var_5) -> 
	case happyOutTok happy_x_6 of { (TokSymbol SymClosePragma happy_var_6) -> 
	happyIn150
		 (CompilePragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4,happy_var_6)) (mkRString happy_var_3) happy_var_4 (unwords happy_var_5)
	) `HappyStk` happyRest}}}}}}

happyReduce_477 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_477 = happyReduce 4# 141# happyReduction_477
happyReduction_477 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwSTATIC happy_var_2) -> 
	case happyOut40 happy_x_3 of { (HappyWrap40 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn151
		 (StaticPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_478 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_478 = happyReduce 4# 142# happyReduction_478
happyReduction_478 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwINLINE happy_var_2) -> 
	case happyOut40 happy_x_3 of { (HappyWrap40 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn152
		 (InlinePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) True happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_479 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_479 = happyReduce 4# 143# happyReduction_479
happyReduction_479 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNOINLINE happy_var_2) -> 
	case happyOut40 happy_x_3 of { (HappyWrap40 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn153
		 (InlinePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) False happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_480 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_480 = happyReduce 4# 144# happyReduction_480
happyReduction_480 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwINJECTIVE happy_var_2) -> 
	case happyOut40 happy_x_3 of { (HappyWrap40 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn154
		 (InjectivePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_481 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_481 = happyMonadReduce 5# 145# happyReduction_481
happyReduction_481 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut36 happy_x_4 of { (HappyWrap36 happy_var_4) -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	(
      let (r, s) = happy_var_3 in
      parseDisplayPragma (fuseRange happy_var_1 happy_var_5) (iStart r) (unwords (s : happy_var_4)))}}}})
	) (\r -> happyReturn (happyIn155 r))

happyReduce_482 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_482 = happyReduce 4# 146# happyReduction_482
happyReduction_482 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwETA happy_var_2) -> 
	case happyOut40 happy_x_3 of { (HappyWrap40 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn156
		 (EtaPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_483 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_483 = happySpecReduce_3  147# happyReduction_483
happyReduction_483 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNO_TERMINATION_CHECK happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn157
		 (TerminationCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3)) NoTerminationCheck
	)}}}

happyReduce_484 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_484 = happySpecReduce_3  148# happyReduction_484
happyReduction_484 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNON_TERMINATING happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn158
		 (TerminationCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3)) NonTerminating
	)}}}

happyReduce_485 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_485 = happySpecReduce_3  149# happyReduction_485
happyReduction_485 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwTERMINATING happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn159
		 (TerminationCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3)) Terminating
	)}}}

happyReduce_486 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_486 = happySpecReduce_3  150# happyReduction_486
happyReduction_486 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNON_COVERING happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn160
		 (NoCoverageCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_487 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_487 = happyReduce 4# 151# happyReduction_487
happyReduction_487 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwMEASURE happy_var_2) -> 
	case happyOut39 happy_x_3 of { (HappyWrap39 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn161
		 (let r = getRange (happy_var_1, happy_var_2, happy_var_3, happy_var_4) in
      TerminationCheckPragma r (TerminationMeasure r happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_488 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_488 = happySpecReduce_3  152# happyReduction_488
happyReduction_488 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCATCHALL happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn162
		 (CatchallPragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_489 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_489 = happySpecReduce_3  153# happyReduction_489
happyReduction_489 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwIMPOSSIBLE happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn163
		 (ImpossiblePragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_490 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_490 = happySpecReduce_3  154# happyReduction_490
happyReduction_490 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNO_POSITIVITY_CHECK happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn164
		 (NoPositivityCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_491 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_491 = happySpecReduce_3  155# happyReduction_491
happyReduction_491 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNO_UNIVERSE_CHECK happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn165
		 (NoUniverseCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_492 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_492 = happyReduce 5# 156# happyReduction_492
happyReduction_492 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwPOLARITY happy_var_2) -> 
	case happyOut39 happy_x_3 of { (HappyWrap39 happy_var_3) -> 
	case happyOut169 happy_x_4 of { (HappyWrap169 happy_var_4) -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn166
		 (let (rs, occs) = unzip (reverse happy_var_4) in
      PolarityPragma (getRange (happy_var_1,happy_var_2,happy_var_3,rs,happy_var_5)) happy_var_3 occs
	) `HappyStk` happyRest}}}}}

happyReduce_493 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_493 = happyMonadReduce 5# 157# happyReduction_493
happyReduction_493 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwWARNING_ON_USAGE happy_var_2) -> 
	case happyOut40 happy_x_3 of { (HappyWrap40 happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokLiteral happy_var_4) -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	(  case happy_var_4 of
        { LitString r str -> return $ WarningOnUsage (getRange (happy_var_1,happy_var_2,happy_var_3,r,happy_var_5)) happy_var_3 str
        ; _ -> parseError "Expected string literal"
        })}}}}})
	) (\r -> happyReturn (happyIn167 r))

happyReduce_494 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_494 = happyMonadReduce 4# 158# happyReduction_494
happyReduction_494 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwWARNING_ON_IMPORT happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokLiteral happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	(  case happy_var_3 of
        { LitString r str -> return $ WarningOnImport (getRange (happy_var_1,happy_var_2,r,happy_var_4)) str
        ; _ -> parseError "Expected string literal"
        })}}}})
	) (\r -> happyReturn (happyIn168 r))

happyReduce_495 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_495 = happySpecReduce_0  159# happyReduction_495
happyReduction_495  =  happyIn169
		 ([]
	)

happyReduce_496 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_496 = happySpecReduce_2  159# happyReduction_496
happyReduction_496 happy_x_2
	happy_x_1
	 =  case happyOut169 happy_x_1 of { (HappyWrap169 happy_var_1) -> 
	case happyOut170 happy_x_2 of { (HappyWrap170 happy_var_2) -> 
	happyIn169
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_497 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_497 = happyMonadReduce 1# 160# happyReduction_497
happyReduction_497 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	( polarity happy_var_1)})
	) (\r -> happyReturn (happyIn170 r))

happyReduce_498 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_498 = happySpecReduce_2  161# happyReduction_498
happyReduction_498 happy_x_2
	happy_x_1
	 =  happyIn171
		 ([]
	)

happyReduce_499 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_499 = happySpecReduce_1  161# happyReduction_499
happyReduction_499 happy_x_1
	 =  case happyOut172 happy_x_1 of { (HappyWrap172 happy_var_1) -> 
	happyIn171
		 (happy_var_1
	)}

happyReduce_500 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_500 = happySpecReduce_3  162# happyReduction_500
happyReduction_500 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_2 of { (HappyWrap173 happy_var_2) -> 
	happyIn172
		 (reverse happy_var_2
	)}

happyReduce_501 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_501 = happySpecReduce_3  163# happyReduction_501
happyReduction_501 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_1 of { (HappyWrap173 happy_var_1) -> 
	case happyOut107 happy_x_3 of { (HappyWrap107 happy_var_3) -> 
	happyIn173
		 (reverse happy_var_3 ++ happy_var_1
	)}}

happyReduce_502 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_502 = happySpecReduce_1  163# happyReduction_502
happyReduction_502 happy_x_1
	 =  case happyOut107 happy_x_1 of { (HappyWrap107 happy_var_1) -> 
	happyIn173
		 (reverse happy_var_1
	)}

happyReduce_503 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_503 = happySpecReduce_3  164# happyReduction_503
happyReduction_503 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut175 happy_x_2 of { (HappyWrap175 happy_var_2) -> 
	happyIn174
		 (reverse happy_var_2
	)}

happyReduce_504 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_504 = happySpecReduce_3  165# happyReduction_504
happyReduction_504 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut175 happy_x_1 of { (HappyWrap175 happy_var_1) -> 
	case happyOut108 happy_x_3 of { (HappyWrap108 happy_var_3) -> 
	happyIn175
		 (reverse happy_var_3 ++ happy_var_1
	)}}

happyReduce_505 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_505 = happySpecReduce_1  165# happyReduction_505
happyReduction_505 happy_x_1
	 =  case happyOut108 happy_x_1 of { (HappyWrap108 happy_var_1) -> 
	happyIn175
		 (reverse happy_var_1
	)}

happyReduce_506 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_506 = happySpecReduce_3  166# happyReduction_506
happyReduction_506 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut177 happy_x_2 of { (HappyWrap177 happy_var_2) -> 
	happyIn176
		 (reverse happy_var_2
	)}

happyReduce_507 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_507 = happySpecReduce_3  167# happyReduction_507
happyReduction_507 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut177 happy_x_1 of { (HappyWrap177 happy_var_1) -> 
	case happyOut108 happy_x_3 of { (HappyWrap108 happy_var_3) -> 
	happyIn177
		 (reverse happy_var_3 ++ happy_var_1
	)}}

happyReduce_508 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_508 = happySpecReduce_1  167# happyReduction_508
happyReduction_508 happy_x_1
	 =  case happyOut108 happy_x_1 of { (HappyWrap108 happy_var_1) -> 
	happyIn177
		 (reverse happy_var_1
	)}

happyReduce_509 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_509 = happySpecReduce_0  167# happyReduction_509
happyReduction_509  =  happyIn177
		 ([]
	)

happyReduce_510 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_510 = happyMonadReduce 3# 168# happyReduction_510
happyReduction_510 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut179 happy_x_2 of { (HappyWrap179 happy_var_2) -> 
	( ((,) `fmap` verifyRecordDirectives happy_var_2 <*> pure []))})
	) (\r -> happyReturn (happyIn178 r))

happyReduce_511 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_511 = happyMonadReduce 5# 168# happyReduction_511
happyReduction_511 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut179 happy_x_2 of { (HappyWrap179 happy_var_2) -> 
	case happyOut185 happy_x_4 of { (HappyWrap185 happy_var_4) -> 
	( ((,) `fmap` verifyRecordDirectives happy_var_2 <*> pure happy_var_4))}})
	) (\r -> happyReturn (happyIn178 r))

happyReduce_512 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_512 = happyMonadReduce 3# 168# happyReduction_512
happyReduction_512 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut185 happy_x_2 of { (HappyWrap185 happy_var_2) -> 
	( ((,) `fmap` verifyRecordDirectives [] <*> pure happy_var_2))})
	) (\r -> happyReturn (happyIn178 r))

happyReduce_513 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_513 = happySpecReduce_0  169# happyReduction_513
happyReduction_513  =  happyIn179
		 ([]
	)

happyReduce_514 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_514 = happySpecReduce_3  169# happyReduction_514
happyReduction_514 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut179 happy_x_1 of { (HappyWrap179 happy_var_1) -> 
	case happyOut180 happy_x_3 of { (HappyWrap180 happy_var_3) -> 
	happyIn179
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_515 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_515 = happySpecReduce_1  169# happyReduction_515
happyReduction_515 happy_x_1
	 =  case happyOut180 happy_x_1 of { (HappyWrap180 happy_var_1) -> 
	happyIn179
		 ([happy_var_1]
	)}

happyReduce_516 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_516 = happySpecReduce_1  170# happyReduction_516
happyReduction_516 happy_x_1
	 =  case happyOut115 happy_x_1 of { (HappyWrap115 happy_var_1) -> 
	happyIn180
		 (Constructor happy_var_1
	)}

happyReduce_517 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_517 = happySpecReduce_1  170# happyReduction_517
happyReduction_517 happy_x_1
	 =  case happyOut182 happy_x_1 of { (HappyWrap182 happy_var_1) -> 
	happyIn180
		 (Induction happy_var_1
	)}

happyReduce_518 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_518 = happySpecReduce_1  170# happyReduction_518
happyReduction_518 happy_x_1
	 =  case happyOut181 happy_x_1 of { (HappyWrap181 happy_var_1) -> 
	happyIn180
		 (Eta happy_var_1
	)}

happyReduce_519 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_519 = happySpecReduce_1  171# happyReduction_519
happyReduction_519 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwEta happy_var_1) -> 
	happyIn181
		 (Ranged (getRange happy_var_1) YesEta
	)}

happyReduce_520 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_520 = happySpecReduce_1  171# happyReduction_520
happyReduction_520 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNoEta happy_var_1) -> 
	happyIn181
		 (Ranged (getRange happy_var_1) NoEta
	)}

happyReduce_521 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_521 = happySpecReduce_1  172# happyReduction_521
happyReduction_521 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInductive happy_var_1) -> 
	happyIn182
		 (Ranged (getRange happy_var_1) Inductive
	)}

happyReduce_522 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_522 = happySpecReduce_1  172# happyReduction_522
happyReduction_522 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoInductive happy_var_1) -> 
	happyIn182
		 (Ranged (getRange happy_var_1) CoInductive
	)}

happyReduce_523 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_523 = happySpecReduce_3  173# happyReduction_523
happyReduction_523 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut185 happy_x_2 of { (HappyWrap185 happy_var_2) -> 
	happyIn183
		 (happy_var_2
	)}

happyReduce_524 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_524 = happySpecReduce_2  174# happyReduction_524
happyReduction_524 happy_x_2
	happy_x_1
	 =  happyIn184
		 ([]
	)

happyReduce_525 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_525 = happySpecReduce_1  174# happyReduction_525
happyReduction_525 happy_x_1
	 =  case happyOut183 happy_x_1 of { (HappyWrap183 happy_var_1) -> 
	happyIn184
		 (happy_var_1
	)}

happyReduce_526 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_526 = happySpecReduce_3  175# happyReduction_526
happyReduction_526 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut106 happy_x_1 of { (HappyWrap106 happy_var_1) -> 
	case happyOut185 happy_x_3 of { (HappyWrap185 happy_var_3) -> 
	happyIn185
		 (happy_var_1 ++ happy_var_3
	)}}

happyReduce_527 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_527 = happySpecReduce_2  175# happyReduction_527
happyReduction_527 happy_x_2
	happy_x_1
	 =  case happyOut106 happy_x_1 of { (HappyWrap106 happy_var_1) -> 
	happyIn185
		 (happy_var_1
	)}

happyReduce_528 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_528 = happySpecReduce_1  175# happyReduction_528
happyReduction_528 happy_x_1
	 =  case happyOut106 happy_x_1 of { (HappyWrap106 happy_var_1) -> 
	happyIn185
		 (happy_var_1
	)}

happyReduce_529 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_529 = happySpecReduce_0  176# happyReduction_529
happyReduction_529  =  happyIn186
		 ([]
	)

happyReduce_530 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_530 = happySpecReduce_1  176# happyReduction_530
happyReduction_530 happy_x_1
	 =  case happyOut185 happy_x_1 of { (HappyWrap185 happy_var_1) -> 
	happyIn186
		 (happy_var_1
	)}

happyNewToken action sts stk
	= lexer(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	TokEOF{} -> happyDoAction 104# tk action sts stk;
	TokKeyword KwAbstract happy_dollar_dollar -> cont 1#;
	TokKeyword KwCoData happy_dollar_dollar -> cont 2#;
	TokKeyword KwCoInductive happy_dollar_dollar -> cont 3#;
	TokKeyword KwConstructor happy_dollar_dollar -> cont 4#;
	TokKeyword KwData happy_dollar_dollar -> cont 5#;
	TokKeyword KwEta happy_dollar_dollar -> cont 6#;
	TokKeyword KwField happy_dollar_dollar -> cont 7#;
	TokKeyword KwForall happy_dollar_dollar -> cont 8#;
	TokKeyword KwVariable happy_dollar_dollar -> cont 9#;
	TokKeyword KwHiding happy_dollar_dollar -> cont 10#;
	TokKeyword KwImport happy_dollar_dollar -> cont 11#;
	TokKeyword KwIn happy_dollar_dollar -> cont 12#;
	TokKeyword KwInductive happy_dollar_dollar -> cont 13#;
	TokKeyword KwInfix happy_dollar_dollar -> cont 14#;
	TokKeyword KwInfixL happy_dollar_dollar -> cont 15#;
	TokKeyword KwInfixR happy_dollar_dollar -> cont 16#;
	TokKeyword KwInstance happy_dollar_dollar -> cont 17#;
	TokKeyword KwOverlap happy_dollar_dollar -> cont 18#;
	TokKeyword KwLet happy_dollar_dollar -> cont 19#;
	TokKeyword KwMacro happy_dollar_dollar -> cont 20#;
	TokKeyword KwModule happy_dollar_dollar -> cont 21#;
	TokKeyword KwMutual happy_dollar_dollar -> cont 22#;
	TokKeyword KwNoEta happy_dollar_dollar -> cont 23#;
	TokKeyword KwOpen happy_dollar_dollar -> cont 24#;
	TokKeyword KwPatternSyn happy_dollar_dollar -> cont 25#;
	TokKeyword KwPostulate happy_dollar_dollar -> cont 26#;
	TokKeyword KwPrimitive happy_dollar_dollar -> cont 27#;
	TokKeyword KwPrivate happy_dollar_dollar -> cont 28#;
	TokKeyword KwProp happy_dollar_dollar -> cont 29#;
	TokKeyword KwPublic happy_dollar_dollar -> cont 30#;
	TokKeyword KwQuote happy_dollar_dollar -> cont 31#;
	TokKeyword KwQuoteTerm happy_dollar_dollar -> cont 32#;
	TokKeyword KwRecord happy_dollar_dollar -> cont 33#;
	TokKeyword KwRenaming happy_dollar_dollar -> cont 34#;
	TokKeyword KwRewrite happy_dollar_dollar -> cont 35#;
	TokKeyword KwSet happy_dollar_dollar -> cont 36#;
	TokKeyword KwSyntax happy_dollar_dollar -> cont 37#;
	TokKeyword KwTactic happy_dollar_dollar -> cont 38#;
	TokKeyword KwTo happy_dollar_dollar -> cont 39#;
	TokKeyword KwUnquote happy_dollar_dollar -> cont 40#;
	TokKeyword KwUnquoteDecl happy_dollar_dollar -> cont 41#;
	TokKeyword KwUnquoteDef happy_dollar_dollar -> cont 42#;
	TokKeyword KwUsing happy_dollar_dollar -> cont 43#;
	TokKeyword KwWhere happy_dollar_dollar -> cont 44#;
	TokKeyword KwDo happy_dollar_dollar -> cont 45#;
	TokKeyword KwWith happy_dollar_dollar -> cont 46#;
	TokKeyword KwBUILTIN happy_dollar_dollar -> cont 47#;
	TokKeyword KwCATCHALL happy_dollar_dollar -> cont 48#;
	TokKeyword KwDISPLAY happy_dollar_dollar -> cont 49#;
	TokKeyword KwETA happy_dollar_dollar -> cont 50#;
	TokKeyword KwFOREIGN happy_dollar_dollar -> cont 51#;
	TokKeyword KwCOMPILE happy_dollar_dollar -> cont 52#;
	TokKeyword KwIMPOSSIBLE happy_dollar_dollar -> cont 53#;
	TokKeyword KwINJECTIVE happy_dollar_dollar -> cont 54#;
	TokKeyword KwINLINE happy_dollar_dollar -> cont 55#;
	TokKeyword KwNOINLINE happy_dollar_dollar -> cont 56#;
	TokKeyword KwMEASURE happy_dollar_dollar -> cont 57#;
	TokKeyword KwNO_TERMINATION_CHECK happy_dollar_dollar -> cont 58#;
	TokKeyword KwNO_POSITIVITY_CHECK happy_dollar_dollar -> cont 59#;
	TokKeyword KwNO_UNIVERSE_CHECK happy_dollar_dollar -> cont 60#;
	TokKeyword KwNON_TERMINATING happy_dollar_dollar -> cont 61#;
	TokKeyword KwNON_COVERING happy_dollar_dollar -> cont 62#;
	TokKeyword KwOPTIONS happy_dollar_dollar -> cont 63#;
	TokKeyword KwPOLARITY happy_dollar_dollar -> cont 64#;
	TokKeyword KwWARNING_ON_USAGE happy_dollar_dollar -> cont 65#;
	TokKeyword KwWARNING_ON_IMPORT happy_dollar_dollar -> cont 66#;
	TokKeyword KwREWRITE happy_dollar_dollar -> cont 67#;
	TokKeyword KwSTATIC happy_dollar_dollar -> cont 68#;
	TokKeyword KwTERMINATING happy_dollar_dollar -> cont 69#;
	TokSetN happy_dollar_dollar -> cont 70#;
	TokPropN happy_dollar_dollar -> cont 71#;
	TokTeX happy_dollar_dollar -> cont 72#;
	TokComment happy_dollar_dollar -> cont 73#;
	TokSymbol SymEllipsis happy_dollar_dollar -> cont 74#;
	TokSymbol SymDotDot happy_dollar_dollar -> cont 75#;
	TokSymbol SymDot happy_dollar_dollar -> cont 76#;
	TokSymbol SymSemi happy_dollar_dollar -> cont 77#;
	TokSymbol SymColon happy_dollar_dollar -> cont 78#;
	TokSymbol SymEqual happy_dollar_dollar -> cont 79#;
	TokSymbol SymUnderscore happy_dollar_dollar -> cont 80#;
	TokSymbol SymQuestionMark happy_dollar_dollar -> cont 81#;
	TokSymbol SymArrow happy_dollar_dollar -> cont 82#;
	TokSymbol SymLambda happy_dollar_dollar -> cont 83#;
	TokSymbol SymAs happy_dollar_dollar -> cont 84#;
	TokSymbol SymBar happy_dollar_dollar -> cont 85#;
	TokSymbol SymOpenParen happy_dollar_dollar -> cont 86#;
	TokSymbol SymCloseParen happy_dollar_dollar -> cont 87#;
	TokSymbol SymOpenIdiomBracket happy_dollar_dollar -> cont 88#;
	TokSymbol SymCloseIdiomBracket happy_dollar_dollar -> cont 89#;
	TokSymbol SymEmptyIdiomBracket happy_dollar_dollar -> cont 90#;
	TokSymbol SymDoubleOpenBrace happy_dollar_dollar -> cont 91#;
	TokSymbol SymDoubleCloseBrace happy_dollar_dollar -> cont 92#;
	TokSymbol SymOpenBrace happy_dollar_dollar -> cont 93#;
	TokSymbol SymCloseBrace happy_dollar_dollar -> cont 94#;
	TokSymbol SymOpenVirtualBrace happy_dollar_dollar -> cont 95#;
	TokSymbol SymCloseVirtualBrace happy_dollar_dollar -> cont 96#;
	TokSymbol SymVirtualSemi happy_dollar_dollar -> cont 97#;
	TokSymbol SymOpenPragma happy_dollar_dollar -> cont 98#;
	TokSymbol SymClosePragma happy_dollar_dollar -> cont 99#;
	TokId happy_dollar_dollar -> cont 100#;
	TokQId happy_dollar_dollar -> cont 101#;
	TokString happy_dollar_dollar -> cont 102#;
	TokLiteral happy_dollar_dollar -> cont 103#;
	_ -> happyError' (tk, [])
	})

happyError_ explist 104# tk = happyError' (tk, explist)
happyError_ explist _ tk = happyError' (tk, explist)

happyThen :: () => Parser a -> (a -> Parser b) -> Parser b
happyThen = (>>=)
happyReturn :: () => a -> Parser a
happyReturn = (return)
happyParse :: () => Happy_GHC_Exts.Int# -> Parser (HappyAbsSyn )

happyNewToken :: () => Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )

happyDoAction :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )

happyReduceArr :: () => Happy_Data_Array.Array Int (Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn ))

happyThen1 :: () => Parser a -> (a -> Parser b) -> Parser b
happyThen1 = happyThen
happyReturn1 :: () => a -> Parser a
happyReturn1 = happyReturn
happyError' :: () => ((Token), [String]) -> Parser a
happyError' tk = (\(tokens, explist) -> happyError) tk
tokensParser = happySomeParser where
 happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (let {(HappyWrap10 x') = happyOut10 x} in x'))

exprParser = happySomeParser where
 happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (let {(HappyWrap42 x') = happyOut42 x} in x'))

exprWhereParser = happySomeParser where
 happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (let {(HappyWrap105 x') = happyOut105 x} in x'))

moduleParser = happySomeParser where
 happySomeParser = happyThen (happyParse 3#) (\x -> happyReturn (let {(HappyWrap13 x') = happyOut13 x} in x'))

moduleNameParser = happySomeParser where
 happySomeParser = happyThen (happyParse 4#) (\x -> happyReturn (let {(HappyWrap30 x') = happyOut30 x} in x'))

funclauseParser = happySomeParser where
 happySomeParser = happyThen (happyParse 5#) (\x -> happyReturn (let {(HappyWrap109 x') = happyOut109 x} in x'))

holeContentParser = happySomeParser where
 happySomeParser = happyThen (happyParse 6#) (\x -> happyReturn (let {(HappyWrap103 x') = happyOut103 x} in x'))

happySeq = happyDontSeq


{--------------------------------------------------------------------------
    Parsers
 --------------------------------------------------------------------------}

-- | Parse the token stream. Used by the TeX compiler.
tokensParser :: Parser [Token]

-- | Parse an expression. Could be used in interactions.
exprParser :: Parser Expr

-- | Parse an expression followed by a where clause. Could be used in interactions.
exprWhereParser :: Parser ExprWhere

-- | Parse a module.
moduleParser :: Parser Module


{--------------------------------------------------------------------------
    Happy stuff
 --------------------------------------------------------------------------}

-- | Required by Happy.
happyError :: Parser a
happyError = parseError "Parse error"


{--------------------------------------------------------------------------
    Utility functions
 --------------------------------------------------------------------------}

-- | Grab leading OPTIONS pragmas.
takeOptionsPragmas :: [Declaration] -> ([Pragma], [Declaration])
takeOptionsPragmas = spanJust $ \ d -> case d of
  Pragma p@OptionsPragma{} -> Just p
  _                        -> Nothing

-- | Insert a top-level module if there is none.
--   Also fix-up for the case the declarations in the top-level module
--   are not indented (this is allowed as a special case).
figureOutTopLevelModule :: [Declaration] -> [Declaration]
figureOutTopLevelModule ds =
  case spanAllowedBeforeModule ds of
    -- Andreas 2016-02-01, issue #1388.
    -- We need to distinguish two additional cases.

    -- Case 1: Regular file layout: imports followed by one module. Nothing to do.
    (ds0, [ Module{} ]) -> ds

    -- Case 2: The declarations in the module are not indented.
    -- This is allowed for the top level module, and thus rectified here.
    (ds0, Module r m tel [] : ds2) -> ds0 ++ [Module r m tel ds2]

    -- Case 3: There is a module with indented declarations,
    -- followed by non-indented declarations.  This should be a
    -- parse error and be reported later (see @toAbstract TopLevel{}@),
    -- thus, we do not do anything here.
    (ds0, Module r m tel ds1 : ds2) -> ds  -- Gives parse error in scope checker.
    -- OLD code causing issue 1388:
    -- (ds0, Module r m tel ds1 : ds2) -> ds0 ++ [Module r m tel $ ds1 ++ ds2]

    -- Case 4: a top-level module declaration is missing.
    -- Andreas, 2017-01-01, issue #2229:
    -- Put everything (except OPTIONS pragmas) into an anonymous module.
    _ -> ds0 ++ [Module r (QName $ noName r) [] ds1]
      where
      (ds0, ds1) = (`span` ds) $ \case
        Pragma OptionsPragma{} -> True
        _ -> False
      -- Andreas, 2017-05-17, issue #2574.
      -- Since the module noName will act as jump target, it needs a range.
      -- We use the beginning of the file as beginning of the top level module.
      r = beginningOfFile $ getRange ds1

-- | Create a name from a string.

mkName :: (Interval, String) -> Parser Name
mkName (i, s) = do
    let xs = C.stringNameParts s
    mapM_ isValidId xs
    unless (alternating xs) $ parseError $ "a name cannot contain two consecutive underscores"
    return $ Name (getRange i) InScope xs
    where
        isValidId Hole   = return ()
        isValidId (Id y) = do
          let x = rawNameToString y
              err = "in the name " ++ s ++ ", the part " ++ x ++ " is not valid"
          case parse defaultParseFlags [0] (lexer return) x of
            ParseOk _ TokId{}  -> return ()
            ParseFailed{}      -> parseError err
            ParseOk _ TokEOF{} -> parseError err
            ParseOk _ t   -> parseError . ((err ++ " because it is ") ++) $ case t of
              TokId{}       -> __IMPOSSIBLE__
              TokQId{}      -> __IMPOSSIBLE__ -- "qualified"
              TokKeyword{}  -> "a keyword"
              TokLiteral{}  -> "a literal"
              TokSymbol s _ -> case s of
                SymDot               -> __IMPOSSIBLE__ -- "reserved"
                SymSemi              -> "used to separate declarations"
                SymVirtualSemi       -> __IMPOSSIBLE__
                SymBar               -> "used for with-arguments"
                SymColon             -> "part of declaration syntax"
                SymArrow             -> "the function arrow"
                SymEqual             -> "part of declaration syntax"
                SymLambda            -> "used for lambda-abstraction"
                SymUnderscore        -> "used for anonymous identifiers"
                SymQuestionMark      -> "a meta variable"
                SymAs                -> "used for as-patterns"
                SymOpenParen         -> "used to parenthesize expressions"
                SymCloseParen        -> "used to parenthesize expressions"
                SymOpenIdiomBracket  -> "an idiom bracket"
                SymCloseIdiomBracket -> "an idiom bracket"
                SymDoubleOpenBrace   -> "used for instance arguments"
                SymDoubleCloseBrace  -> "used for instance arguments"
                SymOpenBrace         -> "used for hidden arguments"
                SymCloseBrace        -> "used for hidden arguments"
                SymOpenVirtualBrace  -> __IMPOSSIBLE__
                SymCloseVirtualBrace -> __IMPOSSIBLE__
                SymOpenPragma        -> __IMPOSSIBLE__ -- "used for pragmas"
                SymClosePragma       -> __IMPOSSIBLE__ -- "used for pragmas"
                SymEllipsis          -> "used for function clauses"
                SymDotDot            -> __IMPOSSIBLE__ -- "a modality"
                SymEndComment        -> "the end-of-comment brace"
              TokString{}   -> __IMPOSSIBLE__
              TokSetN{}     -> "a type universe"
              TokPropN{}    -> "a prop universe"
              TokTeX{}      -> __IMPOSSIBLE__  -- used by the LaTeX backend only
              TokMarkup{}   -> __IMPOSSIBLE__  -- ditto
              TokComment{}  -> __IMPOSSIBLE__
              TokDummy{}    -> __IMPOSSIBLE__
              TokEOF{}      -> __IMPOSSIBLE__

        -- we know that there are no two Ids in a row
        alternating (Hole : Hole : _) = False
        alternating (_ : xs)          = alternating xs
        alternating []                = True

-- | Create a qualified name from a list of strings
mkQName :: [(Interval, String)] -> Parser QName
mkQName ss = do
    xs <- mapM mkName ss
    return $ foldr Qual (QName $ last xs) (init xs)

-- | Create a DomainFree binding from a name

mkDomainFree_ :: (NamedArg Binder -> NamedArg Binder) -> Maybe Pattern -> Name -> LamBinding
mkDomainFree_ f p n = DomainFree $ f $ defaultNamedArg $ Binder p $ mkBoundName_ n

mkRString :: (Interval, String) -> RString
mkRString (i, s) = Ranged (getRange i) s

-- | Create a qualified name from a string (used in pragmas).
--   Range of each name component is range of whole string.
--   TODO: precise ranges!

pragmaQName :: (Interval, String) -> Parser QName
pragmaQName (r, s) = do
  let ss = chopWhen (== '.') s
  mkQName $ map (r,) ss

mkNamedArg :: Maybe QName -> Either QName Range -> Parser (NamedArg BoundName)
mkNamedArg x y = do
  lbl <- case x of
           Nothing        -> return $ Just $ WithOrigin UserWritten $ unranged "_"
           Just (QName x) -> return $ Just $ WithOrigin UserWritten $ Ranged (getRange x) $ prettyShow x
           _              -> parseError "expected unqualified variable name"
  var <- case y of
           Left (QName y) -> return $ mkBoundName y noFixity'
           Right r        -> return $ mkBoundName (noName r) noFixity'
           _              -> parseError "expected unqualified variable name"
  return $ defaultArg $ Named lbl var

-- | Polarity parser.

polarity :: (Interval, String) -> Parser (Range, Occurrence)
polarity (i, s) =
  case s of
    "_"  -> ret Unused
    "++" -> ret StrictPos
    "+"  -> ret JustPos
    "-"  -> ret JustNeg
    "*"  -> ret Mixed
    _    -> parseError $ "Not a valid polarity: " ++ s
  where
  ret x = return (getRange i, x)

recoverLayout :: [(Interval, String)] -> String
recoverLayout [] = ""
recoverLayout xs@((i, _) : _) = go (iStart i) xs
  where
    c0 = posCol (iStart i)

    go cur [] = ""
    go cur ((i, s) : xs) = padding cur (iStart i) ++ s ++ go (iEnd i) xs

    padding Pn{ posLine = l1, posCol = c1 } Pn{ posLine = l2, posCol = c2 }
      | l1 < l2  = genericReplicate (l2 - l1) '\n' ++ genericReplicate (max 0 (c2 - c0)) ' '
      | l1 == l2 = genericReplicate (c2 - c1) ' '

ensureUnqual :: QName -> Parser Name
ensureUnqual (QName x) = return x
ensureUnqual q@Qual{}  = parseError' (rStart' $ getRange q) "Qualified name not allowed here"

-- | Match a particular name.
isName :: String -> (Interval, String) -> Parser ()
isName s (_,s')
    | s == s'   = return ()
    | otherwise = parseError $ "expected " ++ s ++ ", found " ++ s'

-- | Build a forall pi (forall x y z -> ...)
forallPi :: [LamBinding] -> Expr -> Expr
forallPi bs e = Pi (map addType bs) e

-- | Builds a 'RawApp' from 'Range' and 'Expr' list, unless the list
-- is a single expression.  In the latter case, just the 'Expr' is
-- returned.
rawAppUnlessSingleton :: Range -> [Expr] -> Expr
rawAppUnlessSingleton r = \case
  []  -> __IMPOSSIBLE__
  [e] -> e
  es  -> RawApp r es

-- | Converts lambda bindings to typed bindings.
addType :: LamBinding -> TypedBinding
addType (DomainFull b) = b
addType (DomainFree x) = TBind r [x] $ Underscore r Nothing
  where r = getRange x

-- | Interpret an expression as a list of names and (not parsed yet) as-patterns

exprAsTele :: Expr -> [Expr]
exprAsTele (RawApp _ es) = es
exprAsTele e             = [e]

exprAsNamesAndPatterns :: Expr -> Maybe [(Name, Maybe Expr)]
exprAsNamesAndPatterns = mapM exprAsNameAndPattern . exprAsTele

exprAsNameAndPattern :: Expr -> Maybe (Name, Maybe Expr)
exprAsNameAndPattern (Ident (QName x)) = Just (x, Nothing)
exprAsNameAndPattern (Underscore r _)  = Just (Name r InScope [Hole], Nothing)
exprAsNameAndPattern (As _ n e)        = Just (n, Just e)
exprAsNameAndPattern (Paren r e)       = Just (Name r InScope [Hole], Just e)
exprAsNameAndPattern _                 = Nothing

-- interpret an expression as name or list of hidden / instance names
exprAsNameOrHiddenNames :: Expr -> Maybe [NamedArg (Name, Maybe Expr)]
exprAsNameOrHiddenNames t = case t of
  HiddenArg _ (Named Nothing e) -> do
    nps <- exprAsNamesAndPatterns e
    pure $ map (hide . defaultNamedArg) nps
  InstanceArg _ (Named Nothing e) -> do
    nps <- exprAsNamesAndPatterns e
    pure $ map (makeInstance . defaultNamedArg) nps
  e -> (pure . defaultNamedArg) `fmap` exprAsNameAndPattern e

boundNamesOrAbsurd :: [Expr] -> Parser (Either [NamedArg Binder] [Expr])
boundNamesOrAbsurd es
  | any isAbsurd es = return $ Right es
  | otherwise       =
    case mapM exprAsNameAndPattern es of
        Nothing   -> parseError $ "expected sequence of bound identifiers"
        Just good -> fmap Left $ forM good $ \ (n, me) -> do
                       p <- traverse exprToPattern me
                       return (defaultNamedArg (Binder p (mkBoundName_ n)))

  where

    isAbsurd :: Expr -> Bool
    isAbsurd (Absurd _)                  = True
    isAbsurd (HiddenArg _ (Named _ e))   = isAbsurd e
    isAbsurd (InstanceArg _ (Named _ e)) = isAbsurd e
    isAbsurd (Paren _ e)                 = isAbsurd e
    isAbsurd (As _ _ e)                  = isAbsurd e
    isAbsurd (RawApp _ es)               = any isAbsurd es
    isAbsurd _                           = False

-- | Match a pattern-matching "assignment" statement @p <- e@
exprToAssignment :: Expr -> Parser (Maybe (Pattern, Range, Expr))
exprToAssignment (RawApp r es)
  | (es1, arr : es2) <- break isLeftArrow es =
    case filter isLeftArrow es2 of
      arr : _ -> parseError' (rStart' $ getRange arr) $ "Unexpected " ++ prettyShow arr
      [] -> Just <$> ((,,) <$> exprToPattern (RawApp (getRange es1) es1)
                           <*> pure (getRange arr)
                           <*> pure (RawApp (getRange es2) es2))
  where
    isLeftArrow (Ident (QName (Name _ _ [Id arr]))) = arr `elem` ["<-", "←"]
    isLeftArrow _ = False
exprToAssignment _ = pure Nothing

-- | Build a with-block
buildWithBlock :: [Either RewriteEqn [Expr]] -> Parser ([RewriteEqn], [Expr])
buildWithBlock rees = case groupByEither rees of
  (Left rs : rest) -> (rs,) <$> finalWith rest
  rest             -> ([],) <$> finalWith rest

  where

    finalWith :: [Either [RewriteEqn] [[Expr]]] -> Parser [Expr]
    finalWith []             = pure $ []
    finalWith [Right ees]    = pure $ concat ees
    finalWith (Right{} : tl) = parseError' (rStart' $ getRange tl)
      "Cannot use rewrite / pattern-matching with after a with-abstraction."

-- | Build a with-statement
buildWithStmt :: Expr -> Parser [Either RewriteEqn [Expr]]
buildWithStmt e = do
  es <- mapM buildSingleWithStmt $ fromWithApp e
  let ees = groupByEither es
  pure $ map (mapLeft (Invert ())) ees

buildSingleWithStmt :: Expr -> Parser (Either (Pattern, Expr) Expr)
buildSingleWithStmt e = do
  mpatexpr <- exprToAssignment e
  pure $ case mpatexpr of
    Just (pat, _, expr) -> Left (pat, expr)
    Nothing             -> Right e

fromWithApp :: Expr -> [Expr]
fromWithApp = \case
  WithApp _ e es -> e : es
  e              -> [e]

-- | Build a do-statement
defaultBuildDoStmt :: Expr -> [LamClause] -> Parser DoStmt
defaultBuildDoStmt e (_ : _) = parseError' (rStart' $ getRange e) "Only pattern matching do-statements can have where clauses."
defaultBuildDoStmt e []      = pure $ DoThen e

buildDoStmt :: Expr -> [LamClause] -> Parser DoStmt
buildDoStmt (RawApp r [e])     cs = buildDoStmt e cs
buildDoStmt (Let r ds Nothing) [] = return $ DoLet r ds
buildDoStmt e@(RawApp r es)    cs = do
  mpatexpr <- exprToAssignment e
  case mpatexpr of
    Just (pat, r, expr) -> pure $ DoBind r pat expr cs
    Nothing -> defaultBuildDoStmt e cs
buildDoStmt e cs = defaultBuildDoStmt e cs


mergeImportDirectives :: [ImportDirective] -> Parser ImportDirective
mergeImportDirectives is = do
  i <- foldl merge (return defaultImportDir) is
  verifyImportDirective i
  where
    merge mi i2 = do
      i1 <- mi
      let err = parseError' (rStart' $ getRange i2) "Cannot mix using and hiding module directives"
      return $ ImportDirective
        { importDirRange = fuseRange i1 i2
        , using          = mappend (using i1) (using i2)
        , hiding         = hiding i1 ++ hiding i2
        , impRenaming    = impRenaming i1 ++ impRenaming i2
        , publicOpen     = publicOpen i1 <|> publicOpen i2 }

-- | Check that an import directive doesn't contain repeated names
verifyImportDirective :: ImportDirective -> Parser ImportDirective
verifyImportDirective i =
    case filter ((>1) . length)
         $ group
         $ sort xs
    of
        []  -> return i
        yss -> parseErrorRange (head $ concat yss) $
                "Repeated name" ++ s ++ " in import directive: " ++
                concat (intersperse ", " $ map (prettyShow . head) yss)
            where
                s = case yss of
                        [_] -> ""
                        _   -> "s"
    where
        xs = names (using i) ++ hiding i ++ map renFrom (impRenaming i)
        names (Using xs)    = xs
        names UseEverything = []

data RecordDirective
   = Induction (Ranged Induction)
   | Constructor (Name, IsInstance)
   | Eta         (Ranged HasEta)
   deriving (Eq,Show)

verifyRecordDirectives :: [RecordDirective] -> Parser (Maybe (Ranged Induction), Maybe HasEta, Maybe (Name, IsInstance))
verifyRecordDirectives xs
  | null rs = return (ltm is, ltm es, ltm cs)
  | otherwise = parseErrorRange (head rs) $ "Repeated record directives at: \n" ++ intercalate "\n" (map prettyShow rs)
 where
  ltm :: [a] -> Maybe a
  ltm [] = Nothing
  ltm (x:xs) = Just x
  errorFromList [] = []
  errorFromList [x] = []
  errorFromList xs = map getRange xs
  rs = sort (concat ([errorFromList is, errorFromList es', errorFromList cs]))
  is = [ i | Induction i <- xs ]
  es' = [ i | Eta i <- xs ]
  es = map rangedThing es'
  cs = [ i | Constructor i <- xs ]


-- | Breaks up a string into substrings. Returns every maximal
-- subsequence of zero or more characters distinct from @'.'@.
--
-- > splitOnDots ""         == [""]
-- > splitOnDots "foo.bar"  == ["foo", "bar"]
-- > splitOnDots ".foo.bar" == ["", "foo", "bar"]
-- > splitOnDots "foo.bar." == ["foo", "bar", ""]
-- > splitOnDots "foo..bar" == ["foo", "", "bar"]
splitOnDots :: String -> [String]
splitOnDots ""        = [""]
splitOnDots ('.' : s) = [] : splitOnDots s
splitOnDots (c   : s) = case splitOnDots s of
  p : ps -> (c : p) : ps


-- | Returns 'True' iff the name is a valid Haskell (hierarchical)
-- module name.
validHaskellModuleName :: String -> Bool
validHaskellModuleName = all ok . splitOnDots
  where
  -- Checks if a dot-less module name is well-formed.
  ok :: String -> Bool
  ok []      = False
  ok (c : s) =
    isUpper c &&
    all (\c -> isLower c || c == '_' ||
               isUpper c ||
               generalCategory c == DecimalNumber ||
               c == '\'')
        s

{--------------------------------------------------------------------------
    Patterns
 --------------------------------------------------------------------------}

-- | Turn an expression into a left hand side.
exprToLHS :: Expr -> Parser ([RewriteEqn] -> [WithHiding Expr] -> LHS)
exprToLHS e = (\e rwr wth -> LHS e rwr wth NoEllipsis) <$> exprToPattern e

-- | Turn an expression into a pattern. Fails if the expression is not a
--   valid pattern.
exprToPattern :: Expr -> Parser Pattern
exprToPattern e = case C.isPattern e of
  Nothing -> parseErrorRange e $ "Not a valid pattern: " ++ prettyShow e
  Just p  -> pure p

opAppExprToPattern :: OpApp Expr -> Parser Pattern
opAppExprToPattern (SyntaxBindingLambda _ _ _) = parseError "Syntax binding lambda cannot appear in a pattern"
opAppExprToPattern (Ordinary e) = exprToPattern e

-- | Turn an expression into a name. Fails if the expression is not a
--   valid identifier.
exprToName :: Expr -> Parser Name
exprToName (Ident (QName x)) = return x
exprToName e = parseErrorRange e $ "Not a valid identifier: " ++ prettyShow e

stripSingletonRawApp :: Expr -> Expr
stripSingletonRawApp (RawApp _ [e]) = stripSingletonRawApp e
stripSingletonRawApp e = e

isEqual :: Expr -> Maybe (Expr, Expr)
isEqual e =
  case stripSingletonRawApp e of
    Equal _ a b -> Just (stripSingletonRawApp a, stripSingletonRawApp b)
    _           -> Nothing

-- | When given expression is @e1 = e2@, turn it into a named expression.
--   Call this inside an implicit argument @{e}@ or @{{e}}@, where
--   an equality must be a named argument (rather than a cubical partial match).
maybeNamed :: Expr -> Parser (Named_ Expr)
maybeNamed e =
  case isEqual e of
    Nothing       -> return $ unnamed e
    Just (e1, e2) -> do
      let succeed x = return $ named (WithOrigin UserWritten $ Ranged (getRange e1) x) e2
      case e1 of
        Ident (QName x) -> succeed $ nameToRawName x
        -- We could have the following, but names of arguments cannot be _.
        -- Underscore{}    -> succeed $ "_"
        _ -> parseErrorRange e $ "Not a valid named argument: " ++ prettyShow e

patternSynArgs :: [Either Hiding LamBinding] -> Parser [Arg Name]
patternSynArgs = mapM pSynArg
  where
    pSynArg Left{}                  = parseError "Absurd patterns are not allowed in pattern synonyms"
    pSynArg (Right DomainFull{})    = parseError "Unexpected type signature in pattern synonym argument"
    pSynArg (Right (DomainFree x))
      | let h = getHiding x, h `notElem` [Hidden, NotHidden]
         = parseError $ prettyShow h ++ " arguments not allowed to pattern synonyms"
      | not (isRelevant x) = parseError "Arguments to pattern synonyms must be relevant"
      | otherwise          = return $ fmap (boundName . binderName . namedThing) x

parsePanic s = parseError $ "Internal parser error: " ++ s ++ ". Please report this as a bug."

{- RHS or type signature -}

data RHSOrTypeSigs
 = JustRHS RHS
 | TypeSigsRHS Expr
 deriving Show

patternToNames :: Pattern -> Parser [(ArgInfo, Name)]
patternToNames p =
  case p of
    IdentP (QName i)         -> return [(defaultArgInfo, i)]
    WildP r                  -> return [(defaultArgInfo, C.noName r)]
    DotP _ (Ident (QName i)) -> return [(setRelevance Irrelevant defaultArgInfo, i)]
    RawAppP _ ps             -> concat <$> mapM patternToNames ps
    _                        -> parseError $
      "Illegal name in type signature: " ++ prettyShow p

funClauseOrTypeSigs :: [Attr] -> LHS -> RHSOrTypeSigs -> WhereClause -> Parser [Declaration]
funClauseOrTypeSigs attrs lhs mrhs wh = do
  -- traceShowM lhs
  case mrhs of
    JustRHS rhs   -> do
      unless (null attrs) $ parseErrorRange attrs $ "A function clause cannot have attributes"
      return [FunClause lhs rhs wh False]
    TypeSigsRHS e -> case wh of
      NoWhere -> case lhs of
        LHS p _ _ _ | hasEllipsis p -> parseError "The ellipsis ... cannot have a type signature"
        LHS _ _ (_:_) _ -> parseError "Illegal: with in type signature"
        LHS _ (_:_) _ _ -> parseError "Illegal: rewrite in type signature"
        LHS p _ _ _ | hasWithPatterns p -> parseError "Illegal: with patterns in type signature"
        LHS p [] [] _  -> forMM (patternToNames p) $ \ (info, x) -> do
          info <- applyAttrs attrs info
          return $ typeSig info (getTacticAttr attrs) x e
      _ -> parseError "A type signature cannot have a where clause"

parseDisplayPragma :: Range -> Position -> String -> Parser Pragma
parseDisplayPragma r pos s =
  case parsePosString pos defaultParseFlags [normal] funclauseParser s of
    ParseOk s [FunClause (LHS lhs [] [] _) (RHS rhs) NoWhere ca] | null (parseInp s) ->
      return $ DisplayPragma r lhs rhs
    _ -> parseError "Invalid DISPLAY pragma. Should have form {-# DISPLAY LHS = RHS #-}."

typeSig :: ArgInfo -> TacticAttribute -> Name -> Expr -> Declaration
typeSig i tac n e = TypeSig i tac n (Generalized e)

-- * Attributes

-- | Parsed attribute.

data Attr = Attr
  { attrRange :: Range       -- ^ Range includes the @.
  , attrName  :: String      -- ^ Concrete, user written attribute for error reporting.
  , theAttr   :: Attribute   -- ^ Parsed attribute.
  }

instance HasRange Attr where
  getRange = attrRange

instance SetRange Attr where
  setRange r (Attr _ x a) = Attr r x a

-- | Parse an attribute.
toAttribute :: Expr -> Parser Attr
toAttribute x = maybe failure (return . Attr (getRange x) y) $ exprToAttribute x
  where
  y = prettyShow x
  failure = parseErrorRange x $ "Unknown attribute: " ++ y

-- | Apply an attribute to thing (usually `Arg`).
--   This will fail if one of the attributes is already set
--   in the thing to something else than the default value.
applyAttr :: (LensAttribute a) => Attr -> a -> Parser a
applyAttr attr@(Attr r x a) = maybe failure return . setPristineAttribute a
  where
  failure = errorConflictingAttribute attr

-- | Apply attributes to thing (usually `Arg`).
--   Expects a reversed list of attributes.
--   This will fail if one of the attributes is already set
--   in the thing to something else than the default value.
applyAttrs :: (LensAttribute a) => [Attr] -> a -> Parser a
applyAttrs rattrs arg = do
  let attrs = reverse rattrs
  checkForUniqueAttribute (isJust . isQuantityAttribute ) attrs
  checkForUniqueAttribute (isJust . isRelevanceAttribute) attrs
  checkForUniqueAttribute (isJust . isTacticAttribute)    attrs
  foldM (flip applyAttr) arg attrs

-- | Set the tactic attribute of a binder
setTacticAttr :: [Attr] -> NamedArg Binder -> NamedArg Binder
setTacticAttr as = updateNamedArg $ fmap $ \ b ->
  case getTacticAttr as of
    Just t  -> b { bnameTactic = Just t }
    Nothing -> b

-- | Get the tactic attribute if present.
getTacticAttr :: [Attr] -> TacticAttribute
getTacticAttr as =
  case tacticAttributes [ a | Attr _ _ a <- as ] of
    [TacticAttribute e] -> Just e
    []                  -> Nothing
    _                   -> __IMPOSSIBLE__

-- | Report a parse error if two attributes in the list are of the same kind,
--   thus, present conflicting information.
checkForUniqueAttribute :: (Attribute -> Bool) -> [Attr] -> Parser ()
checkForUniqueAttribute p attrs = do
  let pAttrs = filter (p . theAttr) attrs
  when (length pAttrs >= 2) $
    errorConflictingAttributes pAttrs

-- | Report an attribute as conflicting (e.g., with an already set value).
errorConflictingAttribute :: Attr -> Parser a
errorConflictingAttribute a = parseErrorRange a $ "Conflicting attribute: " ++ attrName a

-- | Report attributes as conflicting (e.g., with each other).
--   Precondition: List not emtpy.
errorConflictingAttributes :: [Attr] -> Parser a
errorConflictingAttributes [a] = errorConflictingAttribute a
errorConflictingAttributes as  = parseErrorRange as $
  "Conflicting attributes: " ++ unwords (map attrName as)
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- $Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp $













-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif



















data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList








































infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is ERROR_TOK, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}
          case action of
                0#           -> {- nothing -}
                                     happyFail (happyExpListPerState ((Happy_GHC_Exts.I# (st)) :: Int)) i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}
                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}
                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = happyAdjustOffset (indexShortOffAddr happyActOffsets st)
         off_i  = (off Happy_GHC_Exts.+# i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st




indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#




{-# INLINE happyLt #-}
happyLt x y = LT(x,y)


readArrayBit arr bit =
    Bits.testBit (Happy_GHC_Exts.I# (indexShortOffAddr arr ((unbox_int bit) `Happy_GHC_Exts.iShiftRA#` 4#))) (bit `mod` 16)
  where unbox_int (Happy_GHC_Exts.I# x) = x






data HappyAddr = HappyA# Happy_GHC_Exts.Addr#


-----------------------------------------------------------------------------
-- HappyState data type (not arrays)













-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = happyAdjustOffset (indexShortOffAddr happyGotoOffsets st1)
             off_i = (off Happy_GHC_Exts.+# nt)
             new_state = indexShortOffAddr happyTable off_i




          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = happyAdjustOffset (indexShortOffAddr happyGotoOffsets st)
         off_i = (off Happy_GHC_Exts.+# nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (ERROR_TOK is the error token)

-- parse error if we are in recovery and we fail again
happyFail explist 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ explist i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  ERROR_TOK tk old_st CONS(HAPPYSTATE(action),sts) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        DO_ACTION(action,ERROR_TOK,tk,sts,(saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail explist i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ((Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.
