; Milawa - A Reflective Theorem Prover
; Copyright (C) 2005-2009 Kookamara LLC
;
; Contact:
;
;   Kookamara LLC
;   11410 Windermere Meadows
;   Austin, TX 78759, USA
;   http://www.kookamara.com/
;
; License: (An MIT/X11-style license)
;
;   Permission is hereby granted, free of charge, to any person obtaining a
;   copy of this software and associated documentation files (the "Software"),
;   to deal in the Software without restriction, including without limitation
;   the rights to use, copy, modify, merge, publish, distribute, sublicense,
;   and/or sell copies of the Software, and to permit persons to whom the
;   Software is furnished to do so, subject to the following conditions:
;
;   The above copyright notice and this permission notice shall be included in
;   all copies or substantial portions of the Software.
;
;   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
;   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
;   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
;   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
;   DEALINGS IN THE SOFTWARE.
;
; Original author: Jared Davis <jared@kookamara.com>

;; We run the tests generated by worse-termp-patch.lsp and stored in
;; /tmp/worse-than.log.
;;
;; Usage:
;;    ../modified-acl2 < worse-termp-tests.lsp
;;
;; We print a message after every 100,000 successful tests.  On my 2.8 GHz
;; Pentium D, I estimate about 12 minutes per gigabyte of testing text.

(include-book "worse-termp")

:q

(in-package "MILAWA")

(ACL2::defun milawa-objectp (x)
  (or (symbolp x)
      (natp x)
      (and (consp x)
           (milawa-objectp (car x))
           (milawa-objectp (cdr x)))))

(ACL2::defparameter *n* 0)

(ACL2::defun test-worse-than-fn (x y)
  (cond ((not (and (milawa-objectp x)
                   (milawa-objectp y)))
         nil)
        ((not (and (logic.term-structurep x)
                   (logic.term-structurep y)))
         (ACL2::er hard 'test-worse-than-fn "~x0 or ~x1 are not terms.~%" x y))
        ((not (equal (ACL2::worse-than x y)
                     (rw.worse-termp x y)))
         (ACL2::cw "Mismatch for (worse-than ~x0 ~x1)~%" x y))
        (t
         (ACL2::progn (ACL2::incf *n*)
                      (if (equal (ACL2::mod *n* 100000) 0)
                          (ACL2::cw "~x0 tests successfully executed~%" *n*))))))

(ACL2::defmacro test-worse-than (x y)
  `(test-worse-than-fn ',x ',y))

(ACL2::compile 'milawa-objectp)
(ACL2::compile 'test-worse-than-fn)

(ACL2::load "/tmp/worse-than.log")