;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;   acl2-transl.lisp    -- file to translate nif files to acl2 files       ;
;   Author : Philippe Georgelin                                        ;
;   Email : Philippe.Georgelin@st.com                       
;
; $Id: acl2-transl.lisp,v 1.19 2002/05/13 09:03:38 gp34 Exp $              
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "ACL2")

(include-book "utils")
(include-book "generates-functions")
(include-book "generates-theorems")


(defun cop-vhdl2acl2 (string channel state)
(declare (xargs :stobjs state 
		:mode :program)) 
  (fms ";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; File ~x0 
;; --  generated by vhdl-Acl2
;; $Date: 2002/05/13 09:03:38 $
;; P. Georgelin
;; Email: Philippe.Georgelin@st.com
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;~%~%"
(list (cons #\0 string))
channel
state
nil
))



(defun conc-stat-process-fn (list-conc i)
  (if (endp list-conc)
      nil
    `((,(make-name "" "conc-stat" (natural-to-string i))
       (
	,(car list-conc)
       )
       )
      ,@(conc-stat-process-fn (cdr list-conc) (1+ i)))))
    

(defun conc-stat-process (list-conc)
  (if (endp list-conc)
      nil
    (conc-stat-process-fn list-conc 0)))


;; for component : include file

(defun include_comp_file (list_conf channel state)
    (declare (xargs :stobjs state 
	       	:mode :program))
    (cond ((endp list_conf) state)
	  (t (let ((ent (nth 2 (car list_conf)))
		   (arch (nth 3 (car list_conf))))
	      (pprogn (fms "(ld ~x0)~%"
		          (list (cons #\0 (string-downcase (concatenate 'string
				              (string ent)
					      (string arch)
					      ".lisp"))))
				  channel state nil)
		       (fms "(ld ~x0)~%"
		          (list (cons #\0 (string-downcase (concatenate 'string
				              (string ent)
					      (string arch)
					      "-thm.lisp"))))
				  channel state nil)
		(include_comp_file (cdr list_conf) channel state))))))

	  
(defun create-definition-file (list string state) 
(declare (xargs :stobjs state 
		:guard (stringp string)
		:mode :program))

   (seq-mv ((process_list (cadr_assoc_keyword :process list))
	    (comb_process_list (cadr_assoc_keyword :comb_process list))
	    (concurrent-stat (cadr_assoc_keyword :concurrent_statement list))
	    ((channel state)
	              (open-output-channel string :object state)))
   (pprogn
 (cop-vhdl2acl2 string channel state)
 (fms "(in-package \"ACL2\")~%" nil channel state nil)
 (fms "(include-book ~x0)~%" 
       	 (list (cons #\0 (concatenate 'string 
                                      *nif2acl2_directory*
                                      "/utils"))) channel state nil)
		      
;; for components inside : name of component file
  (include_comp_file (cadr_assoc_keyword :list_of_configurations list) channel state)
		      

 (make-get-nth (cadr_assoc_keyword :entity_name list)
               (cadr_assoc_keyword :architecture_name list)
       	       (append (cadr_assoc_keyword :generic_parameters list)
		       (cadr_assoc_keyword :inputs_signals list)
		       )
       	       (cadr_assoc_keyword :local_signals list)
       	       (cadr_assoc_keyword :local_variables list)
       	       (cadr_assoc_keyword :outputs_signals list)
       	       (cadr_assoc_keyword :list_of_configurations list)
       	       channel state)

 (make-getst-putst (cadr_assoc_keyword :entity_name list)
		   (cadr_assoc_keyword :architecture_name list)
		   (append (cadr_assoc_keyword :generic_parameters list)
			   (cadr_assoc_keyword :inputs_signals list)
                           )
		   (cadr_assoc_keyword :local_signals list)
		   (cadr_assoc_keyword :local_variables list)
		   (cadr_assoc_keyword :outputs_signals list)
		   (cadr_assoc_keyword :list_of_configurations list)
		   channel
		   state)


#|
        (make-state-p (cadr_assoc_keyword :entity_name list)
		      (cadr_assoc_keyword :architecture_name list)
       		  (append (cadr_assoc_keyword :inputs_signals list)
			  (cadr_assoc_keyword :generic_parameters list)
       			  (cadr_assoc_keyword :local_signals list)
       			  (make-next 
       			   (cadr_assoc_keyword :local_signals list))
       			  (cadr_assoc_keyword :local_variables list)
       			  (cadr_assoc_keyword :outputs_signals list)
       			  (make-next 
       			   (cadr_assoc_keyword :outputs_signals list)))
       		  (append (cadr_assoc_keyword :inputs_type list)
			  (cadr_assoc_keyword :generic_parameters_type list)
       			  (cadr_assoc_keyword :local_signals_type list)
       			  (cadr_assoc_keyword :local_signals_type list)
       			  (cadr_assoc_keyword :local_variables_type list)			  
       			  (cadr_assoc_keyword :outputs_type list)
       			  (cadr_assoc_keyword :outputs_type list))
       		  channel
       		  state)
|#			  
 
           (make-make-state (cadr_assoc_keyword :entity_name list)
			    (cadr_assoc_keyword :architecture_name list)
       		     (append (cadr_assoc_keyword :inputs_signals list)
			     (cadr_assoc_keyword :local_signals list)
       			  (make-next
       			   (cadr_assoc_keyword :local_signals list))
       			  (cadr_assoc_keyword :local_variables list)
       			  (cadr_assoc_keyword :outputs_signals list)
       			  (make-next
       			   (cadr_assoc_keyword :outputs_signals list)))
       		     (append (cadr_assoc_keyword :inputs_type list)
       			     (cadr_assoc_keyword :local_signals_type list)			
       			     (cadr_assoc_keyword :local_signals_type list)
       			     (cadr_assoc_keyword :local_variables_type list)			  
       			     (cadr_assoc_keyword :outputs_type list)
       			     (cadr_assoc_keyword :outputs_type list))
		     (cadr_assoc_keyword :generic_parameters list)
		     (cadr_assoc_keyword :generic_parameters_default_value list)
       		     (cadr_assoc_keyword :list_of_configurations list)
       		     channel
       		     state)
	

	    (make-update-state (cadr_assoc_keyword :entity_name list)
			       (cadr_assoc_keyword :architecture_name list)
			       channel
			       state)

	    
	    (if (consp (cadr_assoc_keyword :list_of_functions list))
		
		(pprogn 
		

		(make-functions (cadr_assoc_keyword :list_of_functions list)
			      channel
			      (append (cadr_assoc_keyword :inputs_signals list)
				       (cadr_assoc_keyword :generic_parameters list)
				       (cadr_assoc_keyword :local_signals list)
				       (make-next 
					(cadr_assoc_keyword :local_signals list))
				       (cadr_assoc_keyword :local_variables list))

			       (append (cadr_assoc_keyword :inputs_type list)
				       (cadr_assoc_keyword :generic_parameters_type list)
				       (cadr_assoc_keyword :local_signals_type list)
				       (cadr_assoc_keyword :local_signals_type list)
				       (cadr_assoc_keyword :local_variables_type list))
			      state))

	      state)

	    (if (consp (cadr_assoc_keyword :for-statement list))
		
		(pprogn
		 
		 (make-for-loop (cadr_assoc_keyword :entity_name list)
				(cadr_assoc_keyword :architecture_name list)
				(cadr_assoc_keyword :for-statement list)
				channel
				(append (cadr_assoc_keyword :inputs_signals list)
				       (cadr_assoc_keyword :generic_parameters list)
				       (cadr_assoc_keyword :local_signals list)
				       (make-next 
					(cadr_assoc_keyword :local_signals list))
				       (cadr_assoc_keyword :local_variables list))

			       (append (cadr_assoc_keyword :inputs_type list)
				       (cadr_assoc_keyword :generic_parameters_type list)
				       (cadr_assoc_keyword :local_signals_type list)
				       (cadr_assoc_keyword :local_signals_type list)
				       (cadr_assoc_keyword :local_variables_type list))
				state))
	      state)
	    
	     
	    
	    

	    (process-functions (cadr_assoc_keyword :entity_name list)
			       (cadr_assoc_keyword :architecture_name list)
			       (append process_list
				       comb_process_list
				       (conc-stat-process concurrent-stat))
			       channel
			       (append (cadr_assoc_keyword :inputs_signals list)
				       (cadr_assoc_keyword :generic_parameters list)
				       (cadr_assoc_keyword :local_signals list)
				       (make-next 
					(cadr_assoc_keyword :local_signals list))
				       (cadr_assoc_keyword :local_variables list))

			       (append (cadr_assoc_keyword :inputs_type list)
				       (cadr_assoc_keyword :generic_parameters_type list)
				       (cadr_assoc_keyword :local_signals_type list)
				       (cadr_assoc_keyword :local_signals_type list)
				       (cadr_assoc_keyword :local_variables_type list))
				     state)
				 
	   

	    
			     

	    (make-update-signals (cadr_assoc_keyword :entity_name list)
				 (cadr_assoc_keyword :architecture_name list)
				 (append (cadr_assoc_keyword :local_signals list)
					 (cadr_assoc_keyword :outputs_signals list))
				 (cadr_assoc_keyword :list_of_components list)
				 (cadr_assoc_keyword :list_of_configurations list)
				 (cadr_assoc_keyword :list_of_links list)
				 channel
				 state)

	
	    (if (consp concurrent-stat)
	
		(make-rec-concurrent-stat (cadr_assoc_keyword :entity_name list)
					  (cadr_assoc_keyword :architecture_name list)
					  (conc-stat-process concurrent-stat)
				          channel
					  state)

	      state)


	    (make-rec-comb-process (cadr_assoc_keyword :entity_name list)
				   (cadr_assoc_keyword :architecture_name list)
				   comb_process_list
				   channel
				   state)
			     
	    
	    (if (consp concurrent-stat)

	    (make-cycle (cadr_assoc_keyword :entity_name list)
			(cadr_assoc_keyword :architecture_name list)
			process_list
			comb_process_list
		       	(cadr_assoc_keyword :list_of_configurations list)
			(len concurrent-stat)
			channel
			state)

	    (make-cycle (cadr_assoc_keyword :entity_name list)
			(cadr_assoc_keyword :architecture_name list)
			process_list
			comb_process_list
			(cadr_assoc_keyword :list_of_configurations list)
			nil
			channel
			state))

	    

	    (make-simul (cadr_assoc_keyword :entity_name list)
			(cadr_assoc_keyword :architecture_name list)
			channel
			state)

	    
	    (fms ":comp t" nil channel state nil)
	    (fms "~%;;; *** END OF FILE ***" nil channel state nil)

            (close-output-channel channel state))))

(defun create-theorem-file (list string state)
  (declare (xargs :stobjs state 
		  :guard (stringp string)
		  :mode :program))
  (let ((concurrent-stat (cadr_assoc_keyword :concurrent_statement list))
	(name_file string))

(mv-let (channel state)
        (open-output-channel name_file :object state)
      (pprogn
	(cop-vhdl2acl2 string channel state)
        (fms "(in-package \"ACL2\")~%" nil channel state nil)
	 (fms "(include-book ~x0)~%" 
       	 (list (cons #\0 (concatenate 'string 
                                      *nif2acl2_directory*
                                      "/utils"))) channel state nil)

	
	(make-lemma-putst (cadr_assoc_keyword :entity_name list)
			  (cadr_assoc_keyword :architecture_name list)
			  channel state)

	(make-rec-concurrent-stat-lemma (cadr_assoc_keyword :entity_name list)
					(cadr_assoc_keyword :architecture_name list)
				      (conc-stat-process concurrent-stat)
				      channel
				      state)

	
	(make-lemma-cycle (cadr_assoc_keyword :entity_name list)
			  (cadr_assoc_keyword :architecture_name list)
			  channel
			  state)
        
	(make-unfold-simul (cadr_assoc_keyword :entity_name list)
			   (cadr_assoc_keyword :architecture_name list)
			   channel
			   state)
			    		    
	(close-output-channel channel state)))))
