# Keep compatibility with 2.16 and older

icons_get_from_package() {
	if compatibility_level_is_at_least '2.28'; then
		warning_deprecated_function 'icons_get_from_package' 'content_inclusion_icons'
	elif compatibility_level_is_at_least '2.17'; then
		warning_deprecated_function 'icons_get_from_package' 'icons_inclusion'
	fi

	local package package_path path_game_data icon_source_directory_legacy
	package=$(current_package)
	package_path=$(package_path "$package")
	path_game_data=$(path_game_data)
	icon_source_directory_legacy="${package_path}${path_game_data}"

	# Get the archive inner path, falling back on a default value.
	local content_path_default icon_source_directory_new
	if [ -z "${CONTENT_PATH_DEFAULT:-}" ]; then
		local CONTENT_PATH_DEFAULT
		CONTENT_PATH_DEFAULT='.'
	fi
	content_path_default=$(content_path_default)
	icon_source_directory_new="${PLAYIT_WORKDIR}/gamedata/${content_path_default}"

	local application
	for application in "$@"; do
		local application_icons_list
		application_icons_list=$(application_icons_list "$application")
		if [ -z "$application_icons_list" ]; then
			continue
		fi
		local icon
		for icon in $application_icons_list; do
			local icon_path icon_full_path_legacy icon_full_path_new
			icon_path=$(icon_path "$icon")
			## Compute icon legacy path.
			icon_full_path_legacy="${icon_source_directory_legacy}/${icon_path}"
			## Compute icon expected path for new function.
			icon_full_path_new="${icon_source_directory_new}/${icon_path}"
			## Set compatibility link.
			icon_full_path_legacy_canonical=$(realpath --canonicalize-missing "$icon_full_path_legacy")
			icon_full_path_new_canonical=$(realpath --canonicalize-missing "$icon_full_path_new")
			if [ "$icon_full_path_legacy_canonical" != "$icon_full_path_new_canonical" ]; then
				mkdir --parents "$(dirname "$icon_full_path_new")"
				ln --symbolic "$icon_full_path_legacy" "$icon_full_path_new"
			fi
			## Call new function.
			icons_inclusion_single_icon "$package" "$application" "$icon"
			## Remove compatibility link.
			if [ "$icon_full_path_legacy_canonical" != "$icon_full_path_new_canonical" ]; then
				rm "$icon_full_path_new"
				## Do not try to delete "…/gamedata/.", rmdir would fail with "Invalid argument".
				if [ "$content_path_default" != '.' ]; then
					rmdir --parents --ignore-fail-on-non-empty "$(dirname "$icon_full_path_new")"
				fi
			fi
		done
	done
}

