# Keep compatibility with 2.18 and older

content_path_legacy() {
	local content_id
	content_id="$1"

	local content_path_legacy
	content_path_legacy=$(context_value "ARCHIVE_${content_id}_PATH")
	if [ -z "$content_path_legacy" ]; then
		## Return early if no path is set.
		return 0
	fi

	if compatibility_level_is_at_least '2.18'; then
		warning_deprecated_variable \
			"ARCHIVE_${content_id}_PATH" \
			"CONTENT_${content_id}_PATH"
	fi

	printf '%s' "$content_path_legacy"
}

content_files_legacy() {
	local content_id
	content_id="$1"

	local content_files_legacy
	content_files_legacy=$(context_value "ARCHIVE_${content_id}_FILES")
	if [ -z "$content_files_legacy" ]; then
		## Return early if no files list is set.
		return 0
	fi

	if compatibility_level_is_at_least '2.18'; then
		warning_deprecated_variable \
			"ARCHIVE_${content_id}_FILES" \
			"CONTENT_${content_id}_FILES"
	fi

	# Legacy variable could use spaces as a delimiter,
	# line breaks are expected instead.
	local file_pattern
	for file_pattern in $content_files_legacy; do
		printf '%s\n' "$file_pattern"
	done
}

content_inclusion_default_game_data_legacy() {
	local package
	package="$1"

	local package_suffix files_list
	package_suffix="${package#PKG_}"
	files_list=$(context_name "ARCHIVE_GAME_${package_suffix}_FILES")
	if [ -z "$files_list" ]; then
		## Return early if no files list is set.
		return 0
	fi

	local target_directory
	target_directory=$(path_game_data)
	content_inclusion "GAME_${package_suffix}" "$package" "$target_directory"
	local index
	for index in $(seq 0 9); do
		files_list=$(context_name "ARCHIVE_GAME${index}_${package_suffix}_FILES")
		if [ -z "$files_list" ]; then
			## Stop looping at the first unset files list.
			return 0
		fi
		content_inclusion "GAME${index}_${package_suffix}" "$package" "$target_directory"
	done
}

content_inclusion_default_game_documentation_legacy() {
	local package
	package="$1"

	local package_suffix files_list
	package_suffix="${package#PKG_}"
	files_list=$(context_name "ARCHIVE_DOC_${package_suffix}_FILES")
	if [ -z "$files_list" ]; then
		## Return early if no files list is set.
		return 0
	fi

	local target_directory
	target_directory=$(path_game_data)
	content_inclusion "DOC_${package_suffix}" "$package" "$target_directory"
	local index
	for index in $(seq 0 9); do
		files_list=$(context_name "ARCHIVE_DOC${index}_${package_suffix}_FILES")
		if [ -z "$files_list" ]; then
			## Stop looping at the first unset files list.
			return 0
		fi
		content_inclusion "DOC${index}_${package_suffix}" "$package" "$target_directory"
	done
}

