# WINE - Print the paths relative to the WINE prefix that should be diverted to persistent storage
# USAGE: wine_persistent_directories
# RETURN: A list of path to directories,
#         separated by line breaks.
wine_persistent_directories() {
	local persistent_directories
	persistent_directories=$(context_value 'WINE_PERSISTENT_DIRECTORIES')

	# Fall back on the default list of directories for the current game engine
	if [ -z "$persistent_directories" ]; then
		local game_engine
		game_engine=$(game_engine)
		case "$game_engine" in
			('unrealengine4')
				persistent_directories=$(unrealengine4_wine_persistent_directories_default)
			;;
		esac
	fi

	printf '%s' "$persistent_directories"
}

# WINE - Print the list of winetricks verbs that should be applied during the WINE prefix initialization.
# USAGE: wine_winetricks_verbs
# RETURN: A list of winetricks verbs,
#         the list can be empty.
wine_winetricks_verbs() {
	local winetricks_verbs
	winetricks_verbs=$(context_value 'WINE_WINETRICKS_VERBS')

	# Fall back on the legacy variable, for game scripts targeting ./play.it ≤ 2.25
	if \
		[ -z "$winetricks_verbs" ] && \
		! compatibility_level_is_at_least '2.26'
	then
		winetricks_verbs=$(context_value 'APP_WINETRICKS')
		if \
			[ -n "$winetricks_verbs" ] && \
			compatibility_level_is_at_least '2.25'
		then
			warning_deprecated_variable 'APP_WINETRICKS' 'WINE_WINETRICKS_VERBS'
		fi
	fi

	# Fall back on the default list of winetricks verbs for the current game engine
	if [ -z "$winetricks_verbs" ]; then
		local game_engine
		game_engine=$(game_engine)
		case "$game_engine" in
			('unrealengine4')
				winetricks_verbs=$(unrealengine4_wine_winetricks_verbs_default)
			;;
		esac
	fi

	# Append the verb used to set a virtual desktop, if required
	local virtual_desktop
	virtual_desktop=$(wine_virtual_desktop)
	case "$virtual_desktop" in
		('none') ;;
		('auto')
			winetricks_verbs="${winetricks_verbs:-} vd=\"\$(screen_resolution)\""
		;;
		(*)
			winetricks_verbs="${winetricks_verbs:-} vd=$virtual_desktop"
		;;
	esac

	printf '%s' "$winetricks_verbs"
}

